////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
// 20241104 - Translated from DPR source by A.K.                              //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Эта утилита служит шаблоном для разработки других утилит анализа данных.
Поместите описание утилиты в секции "Manual.Rus" и "Manual.Eng".
Поместите список аргументов "Name=Value" в секции "Arguments.Rus" и "Arguments.Eng".
Отредактируйте и откомпилируйте программу, используя интерфейс _CRWAPI.PAS.
[]
[Manual.Eng]
This utility may be used as template for data analysis tools.
Put user manual text to "Manual.Rus" and "Manual.Eng" sections.
Put uses arguments "Name=Value" to "Arguments.Rus" and "Arguments.Eng" sections.
Edit and compile application, using interface _CRWAPI.PAS.
[]
[Arguments.Rus]
Имя окна = Результат:"Шаблон утилиты анализа данных"
Заголовок = ^CЗаголовок^N^L  Y
Легенда = ^RX  ^N^CЛегенда
[]
[Arguments.Eng]
Caption = Result:"Template for data analysis"
Title = ^CTitle^N^L  Y
Legend = ^RX  ^N^CLegend
[]
}

library phos_t_pwo_t_fee_tab;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics,
 _crw_crwapi;

var FileBuffer:array[0..1024*256-1] of Char;

/////////////////////////////////////////////////////////
{$I _crw_plugin_declare.inc} // Declare CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:ICrwApi):Integer;     //
/////////////////////////////////////////////////////////
const
 swin = +1; // Source window reference
 twin = -1; // Target window reference
 cwin =  0; // Clipboard window reference
 nm   =  5; //
 nc   = 11; //
var
 F:Text; s:String;
 fTit:array[1..nc] of String[20];
 fDat:array[1..nc] of Double;
 cPWO:array[1..nm] of Integer;
 cFEE:array[1..nm] of Integer;
 tBase,tScale:Double;
 i,ne,nLine,nPoints,Index:Integer;
 pxy : TPoint2D;
 procedure Refreshment(Delta:Integer);
 const LastTicks : Cardinal = 0;
 begin
  if LastTicks=0 then LastTicks:=GetTickCount;
  if abs(GetTickCount-LastTicks) > Delta then begin
   with CrwApi,GuiApi do begin ApplicationProcessMessages; UpdateSystemConsole; end;
   LastTicks:=GetTickCount;
  end;
 end;
begin
 Result:=0;					
 with CrwApi,SysApi,GuiApi,DanApi do
 try
  RedirectStdIn(Input);				
  RedirectStdOut(Output);
  VerifyPluginDate(CrwApiEdition,Version);
  VerifyPluginType(Target,ForDataAnalysis);
  if not WindowExists(swin) 
  then Raise EDanApi.Create(RusEng('Не найдено окно - источник!',
                                   'Source window not found!'));
  if not WindowExists(twin) 
  then Raise EDanApi.Create(RusEng('Не найдено окно - приемник!',
                                   'Target window not found!'));
  //if CurvesCount[swin]=0 
  //then Raise EDanApi.Create(RusEng('Нет данных для обработки!',
  //                                 'No input data curves found!'));
  WindowRoi[twin]:=WindowRoi[swin];
  WindowCaption[twin]:=GetArgumentAsString(RusEng('Имя окна','Caption'));
  WindowTitle[twin]:=GetArgumentAsString(RusEng('Заголовок','Title'));
  WindowLegend[twin]:=GetArgumentAsString(RusEng('Легенда','Legend'));
  {}
  tBase:=DateTimeToMSec(2015,1,1,0,0,0,0);
  tScale:=1000*3600*24;
  {}
  Assign(F,'h:\Business-Trips\ALIDCSCOM252-Run2\Reports\phos-2018\T_PWO_T_FEE.TAB');
  SetTextBuf(F,FileBuffer,sizeof(FileBuffer));
  {$I+}
  nPoints:=0;
  Reset(F);
  try
   while not eof(F) do begin
    readln(F,s);
    inc(nPoints);
    //if nPoints=100 then break;
   end;
  finally
   Close(F);
  end;
  Dec(nPoints);
  Echo(Format('nPoints = %d',[nPoints]));
  if nPoints<1 then Exit;
  {$I+}
  nLine:=0;
  Index:=0;
  Reset(F);
  try
   while not eof(F) do begin
    if nLine=0 then begin
     readln(F,s);
     inc(nLine);
     Echo(s);
     for i:=1 to nc do fTit[i]:=ExtractWord(i,s,ScanSpaces);
     for i:=1 to nm do cPWO[i]:=CreateCurve(twin,fTit[0+i*2],0,$10,'');
     for i:=1 to nm do cFEE[i]:=CreateCurve(twin,fTit[1+i*2],0,$10,'');
     for i:=1 to nm do CurveLength[cPWO[i]]:=nPoints;
     for i:=1 to nm do CurveLength[cFEE[i]]:=nPoints;
     continue;
    end;
    readln(F,s);
    inc(nLine);
    ne:=0;
    for i:=1 to nc do if not Str2Real(ExtractWord(i,s,ScanSpaces),fDat[i]) then inc(ne);
    if ne>0 then begin
     Echo('Error line '+s);
     continue;
    end;
    if nLine<10 then echo(Format('%g %g %g %g %g %g %g %g %g',[fDat[1],fDat[2],fDat[3],fDat[4],fDat[5],fDat[6],fDat[7],fDat[8],fDat[9]]));
    if (nLine mod 1000) = 0 then Refreshment(100);
    for i:=1 to nm do begin
     pxy:=Point2D((fDat[1]-tBase)/tScale,fDat[0+i*2]);
     CurvePoint[cPWO[i],Index]:=pxy;
     pxy:=Point2D((fDat[1]-tBase)/tScale,fDat[1+i*2]);
     CurvePoint[cFEE[i],Index]:=pxy;
    end;
    inc(Index);
    if(Index=nPoints) then break;
   end;
  finally
   Close(F);
  end;
  Echo(Format('%d points, %d bugs',[nPoints,nPoints-Index]));
  if nPoints>Index then begin
   for i:=1 to nm do CurveLength[cPWO[i]]:=Index;
   for i:=1 to nm do CurveLength[cFEE[i]]:=Index;
  end;
  if SelectedCurve[swin]>0 then SelectedCurve[twin]:=1 else SelectedCurve[twin]:=0;
 except
  on E:Exception do begin
   if WindowExists(twin) then CurvesCount[twin]:=0;
   Echo(PluginName+RusEng(': ОШИБКА!',': ERROR!')); 
   if UsesBlaster then Voice('EXCEPTION');
   Echo(E.Message); Error(E.Message);
   Result:=-1;
  end;
 end;			
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_exports.inc} // Exports CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID;        //
/////////////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
 
 
