///////////////////////////////////////////////////////////////////////////
// Process data comes from CRW-DAQ via dat-file, plot histogram to GIF file
///////////////////////////////////////////////////////////////////////////

#ifdef __CINT__
gROOT->Reset();
#endif

#define BuffSize 512

///////////////////////////////////////////////
// Right Trim: delete all spaces in string tail 
///////////////////////////////////////////////
void rtrim(char *s) {
   for(int i=strlen(s); i>=0; i--) if(s[i]<=0x20) s[i]=0; else break;
}

//////////////////////////////////
// Skip all chars till end of line
//////////////////////////////////
void skipeoln(FILE *fp) {
   char Temp[BuffSize] = "";
   fgets(Temp,BuffSize-1,fp);
}

/////////////////////////////////////////////////////
// Plot histogram by data from *.dat file to GIF file
/////////////////////////////////////////////////////
void _root_hist_1d(char *datFile="", char *gifFile="") {
   //
   // Reset
   //
   #ifndef __CINT__
   gROOT->Reset();
   #endif
   //
   // Greeting. Check input args. If one empty, take from environment.
   //
   if(strlen(datFile)==0) datFile = (char *)gSystem->Getenv("datFile");
   if(strlen(gifFile)==0) gifFile = (char *)gSystem->Getenv("gifFile");
   printf("\nStart _root_hist_1d.C(\"%s\",\"%s\"):\n",datFile,gifFile);
   //
   // Open data file
   //
   FILE *fp = fopen(datFile,"r");
   if (!fp) { printf("File not found (%s)!",datFile); return; };
   //
   // Read Header -user defined parameters.
   //
   printf("Read data:\n");
   char Caption[BuffSize] = "";  fgets(Caption,255,fp);          rtrim(Caption);  printf("Caption=%s\n",Caption);
   char HistName[BuffSize] = ""; fgets(HistName,255,fp);         rtrim(HistName); printf("HistName=%s\n",HistName);
   char Formula[BuffSize] = "";  fgets(Formula,255,fp);          rtrim(Formula);  printf("Formula=%s\n",Formula);
   int NumBins = 0;         fscanf(fp," %d",&NumBins);      skipeoln(fp);    printf("NumBins=%d\n",NumBins);
   double RangeLeft = 0;    fscanf(fp," %lf",&RangeLeft);   skipeoln(fp);    printf("RangeLeft=%lg\n",RangeLeft);
   double RangeRight = 0;   fscanf(fp," %lf",&RangeRight);  skipeoln(fp);    printf("RangeRight=%lg\n",RangeRight);
   char FitWith[BuffSize] = "";  fgets(FitWith,255,fp);          rtrim(FitWith);  printf("FitWith=%s\n",FitWith);
   int FillColor = 0;       fscanf(fp," %d",&FillColor);    skipeoln(fp);    printf("FillColor=%d\n",FillColor);
   int FillStyle = 0;       fscanf(fp," %d",&FillStyle);    skipeoln(fp);    printf("FillStyle=%d\n",FillStyle);
   int ScreenWidth = 1280;  fscanf(fp," %d",&ScreenWidth);  skipeoln(fp);    printf("ScreenWidth=%d\n",ScreenWidth);
   int ScreenHeight = 900;  fscanf(fp," %d",&ScreenHeight); skipeoln(fp);    printf("ScreenHeight=%d\n",ScreenHeight);
   //
   // Create histogram, read and fill data
   //
   printf("Read data:\n");
   int NumPoints = 0;
   TH1F *h = new TH1F(HistName,Caption,NumBins,RangeLeft,RangeRight);
   while (!feof(fp)){
     double data;
     if(fscanf(fp," %lf",&data)==1) {
       h->Fill(data);
       NumPoints++;
       //printf("%d %lf\n",NumPoints, data); 
     }
   }
   printf("%d data point(s) read\n",NumPoints);
   //
   // Create canvas
   //
   char CanvasName[BuffSize] = "Canvas"; strcat(CanvasName,HistName);
   char CanvasTitle[BuffSize] = "Distribution of ";  strcat(CanvasTitle,HistName);
   TCanvas *c = new TCanvas(CanvasName, CanvasTitle, 0, 0, ScreenWidth, ScreenHeight);
   gStyle->SetCanvasColor(10);   
   gStyle->SetStatColor(10);
   gStyle->SetTitleColor(10);
   gStyle->SetStatX(1.00);   gStyle->SetStatY(1.00);
   gStyle->SetStatW(0.1);    gStyle->SetStatH(0.12);
   gStyle->SetTitleX(0.40);  gStyle->SetTitleY(0.99);
   gStyle->SetTitleW(0.80);  gStyle->SetTitleH(0.07);
   gStyle->SetOptFit(101);
   gStyle->SetOptDate(0);
   gStyle->SetOptStat(11111111);
   gStyle->SetPadBorderMode(0);
   gStyle->SetFrameBorderMode(0);
   c->GetFrame()->SetBorderSize(0);
   c->GetFrame()->SetBorderMode(0);
   gPad->Draw();
   //
   // Plot and save histogram
   //
   if(h) {
     if(strlen(FitWith)>0) h->Fit(FitWith);
     h->SetFillColor(FillColor);
     h->SetFillStyle(FillStyle);
     h->Draw();
     c->Draw();
     if(strlen(gifFile)) c->Print(gifFile);
   } else {
    printf("Could not create histogram!");
   }
   fclose(fp);
   printf("Done with _root_hist_1d.C.\n");
}

//////////////
// END OF FILE
//////////////
