//----------------------------------------------------------
// Consts
//----------------------------------------------------------

var ShowSliderMenu = null;
var SliderMenu = null;
var Page = null;
var IsVisibleMenu = false;

//----------------------------------------------------------
// Functions
//----------------------------------------------------------

function GetSliderMenu() {
	return SliderMenu ? SliderMenu : (SliderMenu = document.getElementById("slidermenu"));
}

function GetPage() {
	return Page ? Page : (Page = document.getElementById("page"));
}

function GetShowSliderMenu() {
	return ShowSliderMenu ? ShowSliderMenu : (ShowSliderMenu = document.getElementById("showslidermenu"));
}

function CalcShowSliderMenuPosition() {
	var showSliderMenu = GetShowSliderMenu();
	var page = GetPage();
	var left = page["getBoundingClientRect"] ? page.getBoundingClientRect().left : page.offsetLeft;
	showSliderMenu.style.left = left + 9 + "px";
	//showSliderMenu.style.top= (GetClientHeight() / 2 + GetScrollTop()) - 80 + "px";
}

function SpecifyEvents() {
	document.onmouseout = OnMouseOutDocument;
	//window.onscroll = OnScrollDocument;
	window.onresize = OnResizeWindow;
	GetShowSliderMenu().onmouseover = OnMouseOverShowSliderMenu;
	CalcShowSliderMenuPosition();
}

function HideMenu() {
	GetSliderMenu().style.left = "-10000px";
	GetShowSliderMenu().style.backgroundPosition = "0px 0px";
	IsVisibleMenu = false;
}

//----------------------------------------------------------
// HANDLES
//----------------------------------------------------------

/*function OnScrollDocument(e) {
	CalcShowSliderMenuPosition();
}
*/
function OnMouseOutDocument(e) {
	if (!IsVisibleMenu) {
		return;
	}
	if (!IsEventPositionWithinElementRect(e, GetSliderMenu())) {
		HideMenu();
	}
}

function OnResizeWindow(e) {
	CalcShowSliderMenuPosition();
}

function OnMouseOverShowSliderMenu(e) {
	this.style.backgroundPosition = "-16px 0px";
	var sliderMenu = GetSliderMenu();
	sliderMenu.style.left = this.offsetLeft + "px";
	sliderMenu.style.top = this.offsetTop + GetScrollTop() + "px";
	//debugger;
	if (!sliderMenu.innerHTML) {
		var framemenu = document.getElementById("framemenu");
		sliderMenu.innerHTML = framemenu.innerHTML;
		//"<div id=\"navigation\"><a href=\"documents.html\" title=\"Заголов страницы\"><div id=\"top\">top</div></a></div>";
	}
	IsVisibleMenu = true;
}

//----------------------------------------------------------
// MAIN
//----------------------------------------------------------
AddHandler(window, "load", SpecifyEvents);