//----------------------------------------------------------
// Consts
//----------------------------------------------------------
// Object's parameter names
var opnUrlParamName = "paramName";
var opnElementId = "elementId";
var opnElementPropertyName = "propertyName";
var opnWriteNegativeValue = "writeNegativeValue";

//----------------------------------------------------------
// Functions
//----------------------------------------------------------

function GetUrlParamsMapObj(AParamName, AElementId, AElementPropertyName, AWriteNegativeValue) {
	var obj = new Object();
	obj[opnUrlParamName] = AParamName;
	obj[opnElementId] = AElementId;
	obj[opnElementPropertyName] = (AElementPropertyName) ? AElementPropertyName : 'value';
	obj[opnWriteNegativeValue] = AWriteNegativeValue;
	return obj;
}

function GetUrlParams() {
	var searchText = location.search;
	if(searchText == '') {
		return null;
	}
	var params = new Array();
	var pairs = (searchText.substr(1)).split('&');
	for(var i=0; i < pairs.length; i++) {
		var pair = pairs[i].split('=');
		params[pair[0]] = pair[1];
	}
	return params;
}

function ReadUrlParamsIntoElements(paramsMap) {
	var params = GetUrlParams();
	if (params == null) {
		return;
	}
	var length = paramsMap.length;
	for (var i = 0; i < length; i++) {
		var currentItem = paramsMap[i];
		var paramName = currentItem[opnUrlParamName];
		var paramValue = params[paramName];
		if (paramValue != null) {
			var element = document.getElementById(currentItem[opnElementId]);
			if (paramValue == "false") {
				element[currentItem[opnElementPropertyName]] = false;
			} else if (element != null) {
				element[currentItem[opnElementPropertyName]] = decodeURIComponent(paramValue);
			}
		}
	}
}

function GetUrlWithParams(paramsMap) {
	var urlParams = "";
	var length = paramsMap.length;
	for (var i = 0; i < length; i++) {
		var currentItem = paramsMap[i];
		var paramName = currentItem[opnUrlParamName];
		var element = document.getElementById(currentItem[opnElementId]);
		if (element != null) {
			var paramValue = element[currentItem[opnElementPropertyName]];
			if (paramValue || currentItem[opnWriteNegativeValue]) {
				if (urlParams != "") {
					urlParams += "&";
				}
				urlParams += paramName + "=" + encodeURIComponent(paramValue);
			}
		}
	}
	var resultUrl = location.href.match(/^[^\?]+/)[0];
	if (urlParams) {
		resultUrl += "?" + urlParams;
	}
	return resultUrl;
}

function Encode(stringData) {
	stringData = "абвгд";
	alert(decodeURIComponent(encodeURIComponent(stringData)));
}
