#!/bin/bash

function man_to_html()(
 readonly mandir="/usr/share/man";
 function list_man_gz(){
  find $mandir -name '*.gz' | grep -e '/ru/' -e '/man/man';
 };
 function process_man_list(){
  local nl="$(list_man_gz| wc -l)";
  local pc="0"; local it=0;
  for item in $(list_man_gz); do
   let "pc=(it*100)/nl";
   echo "Processing $it = $pc% - $item";
   local sdir="$(dirname $item)";
   local tdir="${sdir/$mandir/$PWD}";
   if [[ ! -d $tdir ]]; then mkdir -p $tdir; fi;
   local tname="$tdir/$(basename $item .gz).html";
   zcat $item | pandoc --from man --to html --standalone -o $tname;
   let it++;
  done;
 };
 process_man_list;
);

man_to_html;
