---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

<a name="cross_about"></a>

# CrwDaq - рекомендации по кросс-платформенной разработке

Здесь приводятся рекомендации по кроссплатформенной разработке прикладного **ПО**
в пакете **crwdaq**, а также рекомендации по переводу прикладных **DAQ** конфигураций
старой версии пакета **Crw32** (работающей только под **Windows**)
в новую версию **crwdaq** (работающей под **Unix** и **Windows**).
Под кроссплатформенной разработкой понимается такой стиль разработки и программирования,
что созданные прикладные программы и конфигурации могут успешно выполняться
(в идеале - без каких-либо изменений) под разными операционными системами -
например, **Linux** и **Windows**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_common"></a>

## Общие сведения и соглашения

Напомним, что старая версия пакета, именуемая здесь **Crw32**, разрабатывалась в период
**2001-2023** на языке **Object Pascal** в среде **Delphi 5** для платформы **Win32**
и работает на всех версиях **Windows-XP/7/8/10/11**, как **32**, так и **64** битных.
В **2023** начата разработка новой версии пакета, именуемая далее **crwdaq**,
создаваемая на языке **Free Pascal** в среде **Lazarus**, и
ориентированная на **Linux** и **Windows**.

Пакет **[crwdaq](../../index.htm)** является кроссплатформенным.
Это значит, что пакет и разработанные в его среде прикладные программы
для систем сбора данных (**DAQ** = _data acquisition_) и управления,
для краткости именуемые далее **DAQ**-программами или **DAQ**-конфигурациями,
могут выполняться в разных операционных системах (**OS** = _Operation System_).


В настоящее время пакет **crwdaq** ориентируется на два семейства **OS**: **Unix** и **Windows**.

Семейство **OS Unix** - это (в первую очередь) различные версии операционных систем **GNU/Linux**.
**OS** семейства  **GNU/Linux** произошли от операционных систем **Unix** и наследуют их свойства,
поэтому обобщенно называются **Unix** совместимыми системами или просто **Unix** системами.
В первую очередь пакет ориентируется на **Astra Linux**, но возможно также его использование
на других дистрибутивах с пакетной базой **deb**, например **Debian** и **Ubuntu**.
При некоторой доработке возможно использование пакета **crwdaq** и на дистрибутивах
с пакетной базой **rpm**, однако это потребует определенных усилий по переработке
скриптов и инсталляторов.
При более существенной доработке пакета **crwdaq** возможно его использование в других
операционных системах **Unix**, таких как **Free BSD** или **MacOS**, однако практической
необходимости в этом не просматривается из-за малой распространенности этих систем.

Семейство **OS Windows** - это различные версии операционных систем с ядром **Windows NT** -
это **Windows-XP/7/8/10/11**. В первую очередь используются **32**-битная версия пакета **crwdaq**,
но она может запускаться как на **32**, так и на **64**-битных версиях **Windows**.

В плане аппаратной платформы пакет **crwdaq** в настоящее время ориентируется на **IBM PC** совместимые
компьютеры с архитектурой **x86**, разрядности (в основном) **64** бит или (реже) **32** бит.
Поддержка других аппаратных платформ возможна, но потребует доработки кода.
В настоящее время это не актуально ввиду отсутствия такой аппаратуры.

Пакет **crwdaq** разработан так, что фактически содержит в общем архиве (в рабочих каталогах)
как исходные файлы (программные коды), так и две версии исполняемых файлов - исполняемые файлы
**Unix** в формате **ELF** (_Executable and Linking Format_) и исполяемые файлы **Windows** в формате **`.exe`**.
Эти файлы генерируются из одного исходного кода и лежат рядом в одном каталоге.
При этом исполняемые файлы **Unix** не имеют расширения (но имеют флаг "исполняемый"),
а исполняемые файлы **Windows** имеют расширение **`.exe`**.
Например, основной исполняемый файл **crwdaq** под **Unix** может иметь имя
**`/opt/daqgroup/suite/crwdaq/crwdaq`**, а исполняемый файл **Windows** - имя
**`c:\opt\daqgroup\suite\crwdaq\crwdaq.exe`**.

При правильной разработке прикладного **ПО** конфигурации **DAQ**-системы должны
(в большинстве случаев) работать без изменений как в **Unix**, так и в **Windows** системах.
Для того, чтобы это обеспечить, следует соблюдать ряд правил, которые перечислены ниже.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_common"></a>

## Сводка правил кроссплатформенной разработки

Сначала перечислим краткую сводку основных правил кроссплатформенной разработки в пакете **crwdaq**.  
Более подробная расшифровка этих правил будет дана ниже, по каждой теме отдельно.  

- Используйте функции/константы **[идентификации](#cross_identify)** системы **[IsUnix](daqpascalapi.htm#isunix)**,
  **[IsWindows](daqpascalapi.htm#iswindows)** для определения текущей платформы.  
  Это позволяет делать логические "ветки" **`if IsUnix then …`** или **`if IsWindows then …`** для выполнения действий,  
  зависящих от текущей **OS**.  
- Используйте для текстов (файлов конфигураций, исходных кодов) только универсальную **[кодировку](#cross_encoding)** **UTF8**.  
  При необходимости перекодируйте файлы с другой кодировкой в **UTF8** с помощью утилиты **fixutf8**, входящей в пакет **[crwkit](../../../crwkit/index.htm)**.  
- Используйте в коде программ **[разделители строк](#cross_eol)** **[EOL](daqpascalapi.htm#eol)** вместо **[CRLF](daqpascalapi.htm#crlf)**
  (кроме особых случаев для протоколов обмена).  
- Используйте в программах **[PosEol](daqpascalapi.htm#poseol)** для поиска и обработки разделителей строк.  
- Следите за тем, чтобы разделители строк в файлах соответствовали текущей системе.  
  При необходимости корректируйте разделители строк утилитой **fixeol**, входящей в состав пакета **[crwkit](../../../crwkit/index.htm)**.  
  Файлы **(** **.cfg**, **.crc**, **.cal**, **.ini**, **.pas**, **.inc** **)** - довольно терпимы к использованию различных **EOL**.  
  Файлы **(** **.c**, **.h**, **.sml**, **.sh** **)** - напротив чувствительны к корректности **EOL**.  
  Предпочтительными для них являются разделители **LF**.  
- Используйте в программах **[PathSep](daqpascalapi.htm#pathsep)** для составления списков **[путей поиска](#cross_pathsep)** **PATH**.  
  Старайтесь избегать явного указания разделителей **` ; `** или **` : `**, которые не являются кроссплатформенными.  
- Используйте в программах **[PathDelim](daqpascalapi.htm#pathdelim)** для **[разделения](#cross_pathdelim)** компонентов имен файлов.  
  Старайтесь избегать явного указания разделителей **` \ `** или **` / `**, которые не являются кроссплатформенными.  
- В **Unix** используется разделитель каталогов в именах файлов **`/`**, в **Windows** - разделитель **`\`**.  
  В файлах конфигураций **(** **.cfg**, **.crc**, **.inc** **)** могут использоваться разделители обоих типов.  
  Они автоматически корректируются (адаптируются) при чтении файлов функцией **AdaptFileName(…)**.  
  Однако следует учитывать, что символ **`\`** в сценариях **.sh** может интерпретироваться как экранирующий символ,  
  поэтому использование разделителя **`/`** более предпочтительно.  
- Задавайте **[имена файлов](#cross_filename)** в **нижнем** регистре (кроме особых случаев).  
  Например, **test.cfg**, а не **Test.CFG**.  
- Не используйте пробелы и знаки препинания (спецсимволы) в именах файлов.  
- Используйте для сценариев расширения **(.cmd|.bat)** под **Windows** и **(.sh)** под **Unix**.  
  Кроссплатформенные конфигурации содержат одноименные сценарии **.cmd** и **.sh**, лежащие в одном каталоге.  
  Исполнительная система пакета выберет нужный сценарий **.cmd** или **.sh**, в зависимости от текущей платформы.  
- Поскольку пакет **crwdaq** кроссплатформенный, имена и пути файлов могут задаваться (например, в файлах конфигурации)  
  по правилам как **Unix**, так и **Windows**. Например, файл может быть задан в конфигурации как  
  **`File = Resource\DaqSite\DimServer\DimMonitor.lm9`**  - по правилам **Windows**, или  
  **`File = resource/daqsite/dimserver/dimmonitor.lm9`**  - по правилам **Unix**.  
  Для использования в конкретной системе имя файла требуется **адаптировать** (исправить) в соответствии с правилами  
  текущей **OS**, под которой запущен пакет.  
  Используйте функцию **[AdaptFileName](daqpascalapi.htm#adaptfilename)** для адаптации имен обычных файлов и каталогов.  
  Используйте функцию **[AdaptExeFileName](daqpascalapi.htm#adaptexefilename)** для адаптации имен исполняемых файлов и сценариев.  
  Используйте функцию **[AdaptDllFileName](daqpascalapi.htm#adaptdllfilename)** для адаптации имен динамически загружаемых библиотек.  
  Используйте функцию **[AdaptLnkFileName](daqpascalapi.htm#adaptlnkfilename)** для адаптации имен файлов ярлыков Рабочего Стола.  
- Для обработки имен файлов в кодах программ:  
    * первым используйте **ExpEnv(…)** , если нужна подстановка переменных окружения,  
    * затем  используйте **AdaptFileName(…)** для адаптации формата имени к текущей системе,  
      для исполняемых файлов используйте **AdaptExeFileName(…)** для адаптации формата имени,  
    * затем используйте (при необходимости) **DaqFileRef(…)** для перевода относительных путей в абсолютные.  
    * только после этого можно вызывать какие-либо функции для работы с файлами (проверка,чтение,запись,…).  
- Задавайте **[переменные окружения](#cross_environ)** в **верхнем** регистре (кроме особых случаев).  
  Например, **GetEnv('PATH')**, а не **GetEnv('Path')**.
- Не задирайте частоту и приоритет опроса потоков **DevicePolling** выше действительно необходимого.  
  Это позволит избежать избыточной нагрузки на процессор и повысить скорость работы системы.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_identify"></a>
<a name="cross_functions"></a>

## Обзор функций идентификации системы и поддержки кроссплатформенности

Кроссплатформенное программирование начинается с **идентификации** (определения) текущей ситемы и её параметров.  
После идентификации требуется набор средств для корректной обработки данных под разными платформами.  
Здесь перечислены функции **[DaqPascal](daqpascalapi.htm)**, позволяющие это делать.

При решении задачи идентификации следует различать **целевую платформу** (_target platform_) и **текущую платформу**
(_current platform_).
**Целевая платформа** - это платформа, под которую был скомпилирован код.
**Текущая платформа** - это платформа, под которой код работает сейчас.
В большинстве случаев целевая платформа совпадает с текущей (для которой она и создавалась).
Однако в случае запуска из-под эмуляторов (например, **wine**) или виртуальных машин целевая платформа
может отличаться от текущей. Это довольно тонкое различие, но иногда его (тоже) приходится учитывать.

### Функции идентификации

Функции/константы **[IsUnix](daqpascalapi.htm#isunix)**, **[IsLinux](daqpascalapi.htm#islinux)**,
**[IsWindows](daqpascalapi.htm#iswindows)** позволяют очень быстро определять целевую платформу
(под какую операционную систему был скомпилирован код пакета).
Это позволяет делать логические "ветки" **`if IsUnix then …`** или **`if IsWindows then …`**
для выполнения действий, зависящих от текущей/целевой **OS**.

Функция **[ParamStr](daqpascalapi.htm#paramstr)** и команда **`@paramstr …`** в консоли **DAQ**-устройств
содержит много идентифицирующей информации:

``` bash
# Вызов                                 Пример вывода                          Комментарий
@paramstr system id FpcTargetPlatform   x86_64-Linux                           Целевая платформа (CPU-OS)
@paramstr system id FpcTargetCpu        x86_64                                 Целевая платформа (CPU)
@paramstr system id FpcTargetOs         Linux                                  Целевая платформа (OS)
@paramstr system id FpcVersion          3.2.2                                  Версия FPC, на котором скомпилирован код
@paramstr system id LclVersion          2.2.6.0                                Версия LCL, т.е. библиотеки Lazarus
@paramstr system id WidgetSet           gtk2                                   Версия виджетов графической системы
@paramstr system id SystemVersion       Astra Linux CE 2.12.45 (Orel) x86_64   Версия текущей операционной системы
@paramstr system id WindowManageer      fly-wm                                 Название оконного менеджера
@paramstr system os Platform            Linux                                  Целевая OS
@paramstr system os Version             Linux y510p 5.15.0-33 generic …        Версия текущей системы, аналогично команде uname -a
@paramstr system os SysRoot             /                                      Корневой каталог
@paramstr system os ComSpec             /bin/bash                              Командный процессор
@paramstr system os Shell               /bin/bash                              Командный процессор
```

### Функции кроссплатформенного программирования

Функции **[EOL](daqpascalapi.htm#eol)**, **[PosEol](daqpascalapi.htm#poseol)**
позволяют определять и правильно обрабатывать разделители строк текста.

Функции **[PathSep](daqpascalapi.htm#pathsep)**, **[PathDelim](daqpascalapi.htm#pathdelim)**,
**[AddPathDelim](daqpascalapi.htm#addpathdelim)** позволяют правильно выполнять обработку разделителей
имен файлов и списков поиска.

Функции **[utf8_length](daqpascalapi.htm#utf8_length)**, **[utf8_copy](daqpascalapi.htm#utf8_copy)**,
**[utf8_ord](daqpascalapi.htm#utf8_ord)**, **[utf8_chr](daqpascalapi.htm#utf8_chr)**,
**[utf8_encode_ansi](daqpascalapi.htm#utf8_encode_ansi)**,
**[utf8_decode_ansi](daqpascalapi.htm#utf8_decode_ansi)**,
**[utf8_uppercase](daqpascalapi.htm#utf8_uppercase)**,
**[utf8_lowercase](daqpascalapi.htm#utf8_lowercase)**,
**[utf8_bom](daqpascalapi.htm#utf8_bom)** позволяют корректно обрабатывать строки **UTF8**.
Напомним, что в **DaqPascal** строки рассматриваются как **байтовые строки**, т.е. как массив байтов
(или **char** символов), без какой-либо обработки или кодировки.
Аналогично этому в библиотеке **crwlib** используются байтовые строки
типа **`LongString=RawByteString`**.
Использование байтовых строк (без кодировки) дает большие преимущества, т.к. позволяет хранить
в них любую (в том числе двоичную) информацию без риска её повреждения.
Но в некоторых (довольно редких) случаях необходимо учитывать, что строки заданы в кодировке **UTF8**.
Для этого и нужны функции **utf8_xxxx**.

Функции **[AdaptFileName](daqpascalapi.htm#adaptfilename)**, **[AdaptExeFileName](daqpascalapi.htm#adaptexefilename)**
позволяют **адаптировать** (подгонять, приспосабливать) имена файлов к текущей операционной системе.
Дело в том, что в кроссплатформенной системе имена файлов могут поступать из разных источников
(из программного кода, из конфигурационных файлов, из сети) и могут быть заданы по правилам
системы **Unix**, **Linux** или **Windows**, отличающейся от текущей системы.
Для работы с файлом его имя следует преобразовать (адаптировать) в соответствии с правилами текущей операционной системы.
Наконец, функция **[DaqFileRef](daqpascalapi.htm#daqfileref)** (и другие файловые функции) позволяет преобразовать
относительные имена файлов в абсолютные, посе чего их уже можно использовать для работы с файлами.

Перечисленные функции образуют программный "базис", на котром строится кроссплатформенное программирование.

### Утилиты для поддержки кроссплатформенного программирования

К перечисленным функциям добавляются утилиты из пакета  **[crwkit](../../../crwkit/index.htm)**, позволяющие преобразовывать файлы:  

- ![fixeol](../../../crwkit/add/src/fixeolex/fixeolzen.png) утилита **fixeol** - проверяет/исправляет разделители строк **EOL**,  
- ![fixutf8](../../../crwkit/add/src/fixutf8ex/fixutf8zen.png) утилита **fixutf8** - проверяет/исправляет кодировку строк **UTF8**,  
- ![filecase](../../../crwkit/add/src/filecase/filecasezen.png) утилита **filecase** - проверяет/исправляет регистр имен файлов.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_encoding"></a>

## Кодировка текста (UTF8)

В старой версии **Crw32** использовались кодировки **ASCII**, **CP1251** (ANSI), **CP866** (OEM).

В новой версии пакета **crwdaq** для **всех** текстов используется универсальная кодировка **UTF8**,
которая имеет код **65001** и задается в **Windows** командой **CHCP 65001**.
По этой причине при переводе **DAQ** конфигураций **Crw32** в **crwdaq** требуется перекодировка
всех текстов в **UTF8**.

Поскольку кодировка **UTF8** универсальна, она используется для всех текстовых файлов как в **Unix**,
так и в **Windows** версии пакета. Это удобно, т.к. не требуется отдельных версий **DAQ** конфигураций
для каждой системы.

Для конвертирования кодировок в пакет **[crwkit](../../../crwkit/index.htm)**
входит программа **fixutf8**, вызвать которую можно кнопкой
![fixutf8zen](../../../crwkit/add/src/fixutf8ex/fixutf8zen.png)
в программе **Double Commander**.

---

<a name="cross_eol"></a>

## Pазделители строк текста (EOL)

Для разделения строк текста в разных **OS** используются разные разделители:  
- **CRLF** = _chr(13),chr(10)_  в **Windows**,  
- **CR** = _chr(13)_ в **MacOS**,  
- **LF** = _chr(10)_ в **Unix**.  

Для кроссплатформенной разработки в программах (на языке **[DaqPascal](daqpascalapi.htm)**
или **Free Pascal** с использованием библиотеки **[crwlib](../../../crwlib/index.htm)**)
предусмотрен разделитель **EOL** (_end of line_),
который равен **CRLF** в **Windows** и **LF** в **Unix**.
Поэтому во всех случаях, кроме специально оговоренных (например, когда разделитель определяется
протоколом обмена с внешним устройством), настоятельно рекомендуется использовать **EOL** вместо
**CRLF** или **LF**.

Как показывает опыт, пакет **crwdaq** достаточно терпимо относится к разделителям в файлах.  
Например, разделители **CRLF** или **LF** одинаково допустимы в:  
- в конфигурационных файлах **.cfg**, мнемосхемах **.crc**, калибровках **.cal** и т.д.  
- в исходных файлах с кодом **Pascal** - **.pas**, **.inc** и т.д.  
- в файлах инициализации **.ini**, журналах **.log** и т.д.  

Однако строго должна соблюдаться корректность разделителей в следующих случаях:  
- разделители **LF** в файлах **.c**, **.h** кодов и заголовков программ **C/C++** для **gcc** под **Unix**,  
- разделитель **LF** в файлах **.sml** сценариев **SMI** (конечных автоматов),  
- разделитель **LF** в файлах **.sh** сценариев **bash**.  

При неверном задании разделителей в этих случаях возникает ошибка.

Для этих файлов предпочтительным разделителем является **LF**.
Например, файлы **.c** или **.sml** с разделителями **LF**
корректно компилируются под **Windows**, хотя с разделителем **CRLF**
под **Unix** они выдают ошибку при компиляции.
Поэтому, видимо, есть смысл всегда использовать **LF** для этих типов файлов.

Для конвертирования разделителей строк можно использовать программы
**unix2dos**, **dos2unix**, **fixeol**, входящие в состав репозитория,
либо пакета **crwkit** под **Linux**, либо пакета **UnixUtils** под **Windows**.

Для конвертирования разделителей в пакет **[crwkit](../../../crwkit/index.htm)**
входит также программа **fixeol**, вызвать которую можно кнопкой
![fixeolzen](../../../crwkit/add/src/fixeolex/fixeolzen.png)
в программе **Double Commander**.

Для поиска разделителей строк в текстах следует использовать специальную функцию
**[PosEol](daqpascalapi.htm#poseol)**, а не конструкции типа **Pos(EOL,s)** или **Pos(CRLF,s)**.
Это связано с тем, что в общем случае нельзя предугадать, какой тип разделителя строк поступит
на вход процедуры обработки. Устойчиво работающая кроссплатформенная программа должна справляться
с любым типом разделителя строк и не делать предположений о том, каким он будет.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_pathsep"></a>

## Разделители путей поиска (PathSep)

Системы **Unix** и **Windows** используют разные символы для разделения путей поиска **PATH**:  
- **Unix** использует разделитель **` : `**,  
- **Windows** использует разделитель **` ; `**.  

Для формирования путей поиска в программах используйте константу **[PathSep](daqpascalapi.htm#pathsep)** 
или **[PathSeparator](daqpascalapi.htm#pathseparator)**.  
Эта константа содержит правильный разделитель путей для текущей операционной системы.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_pathdelim"></a>

## Разделители имен каталогов и файлов (PathDelim)

Системы **Unix** и **Windows** используют разные символы для разделения компонентов имени файла (каталогов и файлов):  
- **Unix** использует разделитель **` / `**,  
- **Windows** использует разделитель **` \ `**.  

Для формирования путей поиска в программах используйте константу **[PathDelim](daqpascalapi.htm#pathdelim)** 
или **[DirectorySeparator](daqpascalapi.htm#directoryseparator)**.  
Эта константа содержит правильный разделитель для каталогов и имен файлов.

Для композиции (составления) имен каталогов и файлов используйте функцию **[AddPathDelim](daqpascalapi.htm#addpathdelim)**.  
Функция **[AddBackSlash](daqpascalapi.htm#addbackslash)** доступна, но считается устаревшей.

Функция **[AdaptFileName](daqpascalapi.htm#adaptfilename)** адаптирует (исправляет) имена файлов по правилам текущей системы,
поэтому её также можно использовать для коррекции разделителей каталогов и имен файлов.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_filename"></a>

## Соглашения об именах файлов и порядок обработки имен файлов

Имена файлов в **Unix** и **Windows** подчиняются похожим, но отличающимся правилам.

Под **Windows** имена файлов:  

- Не чувствительны к регистру символов.  
- Используют разделитель **`\`** для компонентов имени файла или каталога.  
- Могут содержать имя диска в имени файла - например, **`C:\Windows\System32`**.  
- Сценарии оболочки имеют расширение **`.bat`** или **`.cmd`**.  
- Исполняемые файлы имеют расширение **`.exe`**.  
- Динамические библиотеки имеют имена **`*.dll`**.  
- Ярлыки **Рабочего Стола** имеют имена **`*.lnk`**.  

Под **Unix** имена файлов:  

- Чувствительны к регистру символов.  
- Предпочтительными являются имена файлов в нижнем регистре.  
- Используют разделитель **`/`** для компонентов имени файла или каталога.  
- Полные пути начинаются с корневого каталога **`/`** и не могут содержать  
  имя диска в имени файла. Например **`/home/alex/.bashrc`**.  
- Сценарии оболочки имеют (по договоренности) расширение **`.sh`**.  
- Исполняемые файлы обычно не имеют расширения имени файла.  
- Динамические библиотеки имеют имена **`lib*.so`**.  
- Ярлыки **Рабочего Стола** имеют имена **`*.desktop`**.  

Поскольку пакет **crwdaq** является кроссплатформенным, имена файлов могут быть записаны
как по правилам **Unix**, так и по правилам **Windows**. Для правильного использования
имена файлов должны быть **адаптированы** (исправлены) в соответствии с правилами текущей
операционной системы.

Ключевыми функциями для адаптации имен файлов являются следующие функции:  

1. Функция **[AdaptFileName](daqpascalapi.htm#adaptfilename)** применяется для обычных файлов. Она:  
     - удаляет лишние (незначащие) пробелы;  
     - исправляет разделители **`\`**, **`/`**, заменяя их на **[PathDelim](daqpascalapi.htm#pathdelim)**;  
     - корректирует избыточные разделители **`\\`** или **`//`**, заменяя их одинарными разделителями;  
     - под **Unix** приводит имя к нижнему регистру (предпочтительному для имен файлов в **Unix**);  
     - под **Unix** удаляет ссылку на диск (типа **`C:`**), если она присутствует в мени файла.  

2. Функция **[AdaptExeFileName](daqpascalapi.htm#adaptexefilename)** применяется для исполняемых файлов. Она:  
     - делает всё то же, что **AdaptFileName**;  
     - под **Unix** убирает (очищает) расширение файла, если это **.exe** файл;  
     - под **Unix** заменяет расширение **.cmd**, **.bat** на **.sh**;  
     - под **Windows** заменяет расширение **.sh** на **.cmd**;  

3. Функция **[AdaptDllFileName](daqpascalapi.htm#adaptdllfilename)** применяется для файлов динамических библиотек. Она:  
     - делает всё то же, что **AdaptFileName**;  
     - под **Unix** заменяет расширение **.dll** на **.so** и добавляет префикс имени **lib**;  
     - под **Windows** заменяет расширение **.so** на **.dll** и убирает преффикс **lib**;  

4. Функция **[AdaptLnkFileName](daqpascalapi.htm#adaptlnkfilename)** применяется для файлов ярлыков **Рабочего Стола**. Она:  
     - делает всё то же, что **AdaptFileName**;  
     - под **Unix** заменяет расширение **.lnk** на **.desktop**;  
     - под **Windows** заменяет расширение **.desktop** на **.lnk**;  

5. Функция **[DaqFileRef](daqpascalapi.htm#daqfileref)** применяется для дополнительной (финальной) обработки имен файлов. Она:  
     - Выполняет подстановку маркеров **`~`** и **`~~`**, заменяя их на **`$HOME`** или **`$CRW_DAQ_SYS_HOME_DIR`** соответсвенно.
     - Переводит относительные имена в абсолютные пути, прибавляя (при необходимости) путь текущей **DAQ** конфигурации;  
     - Корректирует относительные ссылки **`./`**, **`../`**, чтобы привести имя файла к каноническому виду;  
     - Добавляет (при необходимости) расширение файла по умолчанию, если оно указано.  

Имена файлов обрабатывается поэтапно, в определенном порядке.  
Рассмотрим следующий пример.

Допустим, что имя файла считывается из файла **demo.cfg** с помощью функции
**[ReadIni](daqpascalapi.htm#readini)**. Предположим, что в файловой ссылке
используется переменная окружения **$CRW_DAQ_CONFIG_HOME_DIR**, так что в файле
содержится, например, параметр **FileName**:

``` ini
FileName = $CRW_DAQ_CONFIG_HOME_DIR/../data/params.ini  ; запись по правилам Unix
FileName = %CRW_DAQ_CONFIG_HOME_DIR%\..\Data\Params.ini ; запись по правилам Windows
```

Как правильно прочитать такой параметр? Это делается так:

1. Считываем параметр из файла: **`s:=ReadIni('FileName');`**.  
2. Делаем подстановку переменных окружения: **`s:=ExpEnv(s);`**.  
   Эта операция должна быть первой в цепочке обработки.  
3. Применяем операцию адаптации имени: **`s:=AdaptFileName(s);`**.  
   Эта операция приводит имя файла к правилам текущей операционной системы.  
4. Применяем функцию **DaqFileRef**: **`s:=DaqFileRef(s,'.ini');`**.  
   Эта функция выполняет дополнительную коррекцию и проверку имени файла,  
   например, преобразует относительные имена в абсолютные, а также приводит  
   имя к каноническому виду.  

Эту цепочку вычислений можно "свернуть" в один сложный вызов:  

``` pascal
s:=DaqFileRef(AdaptFileName(ExpEnv(ReadIni('FileName'))),'.ini');
```

Порядок в приведенной выше цепочке вычислений важен, т.к. имена в **Unix**
чувствительны к регистру. Если, например, выполнить вызов **ExpEnv**
после **AdaptFileName**, то будет ошибка, т.к. **AdaptFileName**
изменит регистр строки и ссылка на переменную окружения станет неверной.

Имена исполянемых файлов и сценариев оболочки обрабатываются особенным образом,
с помощью **AdaptExeFileName**.  
При этом (дополнительно) предполагается, что:

- Исполняемые файлы под каждую стистему, т.е. **.exe** файлы под **Windows**  
  и файлы без расширения под **Unix** должны лежать рядом, в одном каталоге.  
  Они должны выполнять одинаковые функции, каждый в своей системе.  
- Сценарии оболочки под каждую систему, т.е. **.cmd** файлы под **Windows**  
  и файлы **.sh** под **Unix** должны лежать рядом, в одном каталоге.  
  Они должны выполнять одинаковые функции, каждый в своей системе.  

Если указанные условия выполнены, то вызов типа  
**`s:=DaqFileRef(AdaptExeFileName(ExpEnv(ReadIni('FileName'))),'');`**  
вернет имя исполняемого файла или сценария оболочки, актуального для текущей **OS**.

Например, если конфигурационный файл содержит параметр

``` ini
ScriptName = ..\Utility\PreProcessor.cmd ; файл задан по правилам Windows
```
то вызов **`s:=DaqFileRef(AdaptExeFileName(ExpEnv(ReadIni('ScriptName'))),'');`**
в системе **Unix** возвратит имя типа **`…/utility/preprocessor.sh`**,
преобразованное по правилам **Unix**.

Таким образом, с помощью **AdaptExeFileName** в каждой операционной системе
с минимальными затратами на кодирование вычисляется имя исполняемого файла,
подходящего для этой системы.

Таким образом, при соблюдении приведенных выше простых соглашений обработка имен файлов
может быть выполена так, что программа будет работать на всех платформах одинаково,
при этом с минимальными усилиями в плане программных кодов.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_environ"></a>

## Соглашения об именах переменных окружения

Переменные окружения **как правило**  рекомендуется указывать **в верхнем регистре**.

В системе **Windows** имена переменных окружения не зависят от регистра,
поэтому вызовы **GetEnv('Path')** или **GetEnv('PATH')** эквивалентны.

Однако в системах **Unix** имена переменных окружения регистро-зависимы,
поэтому, например, вызов **GetEnv('PATH')** будет верен, а вызов **GetEnv('Path')** ошибочен.

В большинстве случаев **Unix** использует переменные окружения в верхнем регистре.  
Например, неполный список переменных окружения в сеансе **Astra Linux** может иметь такой вид:  

| Переменная   | Типичное значение (пример)   | Комментарий                                                   |
|--------------|------------------------------|---------------------------------------------------------------|
| **BASH_ENV** | /home/alex/.bashrc           | Файл с настройками командного процессора **bash**.            |
| **DESKTOP_SESSION** | fly                   | Имя сессии **Рабочего Стола**.                                |
| **DISPLAY**  | :0                           | Имя текущего графического монитора (экрана дисплея).          |
| **HOME**     | /home/alex                   | Домашний каталог текущего пользоввателя.                      |
| **LANG**     | ru_RU.UTF-8                  | Языковые настройки локали.                                    |
| **LOGNAME**  | alex                         | Имя пользователя, выполнившего вход **login**.                |
| **PATH**     | /usr/local/bin:/usr/bin:/bin | Список путей для поиска файлов.                               |
| **PWD**      | /home/alex                   | Текущий рабочий каталог.                                      |
| **SHELL**    | /bin/bash                    | Путь командного процессора.                                   |
| **TERM**     | xterm                        | Программа эмулятора терминала (консоль).                      |
| **TMPDIR**   | /tmp                         | Каталог временных файлов (для системы).                       |
| **USER**     | alex                         | Имя текущего пользователя.                                    |
| **XDG_CURRENT_DESKTOP** | fly               | Имя оконного менеджера.                                       |
| **XDG_RUNTIME_DIR** | /run/user/1000        | Каталог временных файлов (для сеанса).                        |
| **XDG_SESSION_DESKTOP** | fly               | Имя оконного менеджера (для сеанса).                          |
| **XDG_SESSION_ID** | 3                      | Идентификатор сеанса.                                         |
| **XDG_SESSION_TYPE** | x11                  | Тип сеанса (x11 = графический).                               |

Как легко заметить, переменные окружения указаны в верхнем регистре. Указание переменных окружения в нижнем
регистре возможно, но не типично для **Unix** систем, поэтому там, как правило, используются системные переменные
окружения в верхнем регистре. В то же время указание переменных окружения в верхнем регистре не будет ошибкой
и в случае системы **Windows**, т.к. так там регистр вообще не играет роли.

По указанной причине **как правило** переменные окружения рекомендуется указывать **в верхнем регистре**.

Из этого правила есть, однако, исключения.  
Например, в пакете **crwdaq** определяется целый ряд переменных в смешанном регистре:  
- **WantedWebBrowser** - предпочтительный обозреватель для **Web** сайтов,  
- **WantedLogViewer** - желательная программа просмотра **.log** журналов,  
- и т.д.  

В этом случае переменные окружения должны передаваться точно "**как есть**":

``` bash
@run $WantedLogViewer demo.log
@run $WantedWebBrowser help.htm
```

Использование переменных окружения пакета в смешанном регистре в данном случае оправданно, т.к. эти
переменные являются "локальными" для пакета (в том смысле что они используются только внутри пакета).
Использование смешанного регистра гарантирует, что переменные пакета не будут конфликтовать с системными
переменными окружения. Другими словами, использование смешанного регистра подчеркивает, что соответствующие
переменные окружения принадлежат пакету, а не являются общесистемными.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_convert"></a>

## Процедура перевода старых конфигураций Crw32 в конфигурации CrwDaq

В пакете **Crw32** было разработано множество прикладных **DAQ**-систем и был накоплен большой объем
программных кодов, конфигураций, мнемосхем и т.д.  
С появлением новой версии **CrwDaq** встает задача перевода этих конфигураций в новую версию.

Для этого предлагается следующая процедура:

- Скопировать конфигурацию **DAQ**-системы, разработанной в старом пакете **Crw32**, в нужное место.  
  Передполагается, кто конфигурация находится в отдельном каталоге, который копируется в новое место.  

- ![filecase](../../../crwkit/add/src/filecase/filecasezen.png) Утилитой **filecase**,
  входящей в состав нашей сборки **Double Commander**, перевести все файлы в нижной регистр.  
  Это можно сделать одним кликом для всей конфигурации (каталога), т.к. утилита поддерживает
  групповые операции с файлами, в том числе рекурсивные (включая подкаталоги).  

- ![fixutf8](../../../crwkit/add/src/fixutf8ex/fixutf8zen.png) Утилитой **fixutf8**
  проверить и исправить кодировку строк **UTF8** всех текстовых файлов.  
  Утилита поддерживает групповые операции, но не поддерживает рекурсию, поэтому её надо
  вызывать в каждом подкаталоге отдельно, выделив в нём все файлы и запустив процедуру обработки.
  Иногда утилита не справляется с автоматическим определением кодировки, поэтому отдельные файлы,
  возможно, придется переводить "ручками" (например, с помощью редактора текста **kate**).

- ![fixeol](../../../crwkit/add/src/fixeolex/fixeolzen.png) Утилитой **fixeol**
  проверить и исправить разделители строк **EOL** всех или некоторых текстовых файлов.  
  Утилита поддерживает групповые операции, но не поддерживает рекурсию, поэтому её надо
  вызывать в каждом подкаталоге отдельно, выделив в нём все файлы и запустив процедуру обработки.
  При этом следует учитывать, что файлы разных типов имеют разную степень "чувствительности" к
  правильности разделителей строк **EOL**.  
  Судя по опыту, файлы конфигураций **.cfg**, мнемосхем **.crc**, программных кодов **.pas**, **.inc**,
  калибровок **.cal**, а также файлы инициализации **.ini** обычно не чувствительны к корректности
  **EOL**. Например, файлы с разделителями **CRLF** обычно нормально работают в **Unix** и **Windows**.  
  Напротив, файлы кодов **C/C++** - **.c**, **.h**, файлы конечных автоматов **.sml**,
  сценарии **.sh** - чувствительны к правильности разделителей строк **EOL**.
  При неверном **EOL** они выдают ошибку при компиляции или исполнении.
  Поэтому для этих типов файлов коррекция **EOL** является **обязательной**.

- После коррекции регистра имен, кодировок и разделителей строк файлов,
  рекомендуется во всех программах **DaqPascal** заменить **CRLF** на **EOL**,
  а также задействовать **PosEol** для поиска и обработки разделителей строк,
  заменяя везде конструкции типа **Pos(CRLF,…)** и им подобные, которые явно
  используют тот или иной вид разделителей **CR** или **LF**.
  При этом рекомендуется использовать поиск и замену строк текста,
  чтобы автоматизировать процесс редактирования.

- Далее надо задействовать функции **AdaptFileName** или **AdaptExeFileName**,
  чтобы адаптировать имена файлов к текущей системе. Как правило, это связано с
  именами файлов, прочитанными из конфигураций **ReadIni(…)**, однако имена файлов
  могут также генерироваться (вычисляться) программно или поступать из каналов связи.  
  Типовым примером вызова для чтения обычного файла является:  
  **`s:=DaqFileRef(AdaptFileName(ExpEnv(ReadIni('FileName'))),'');`**  
  Типовым примером вызова для чтения исполняемого файла является:  
  **`s:=DaqFileRef(AdaptExeFileName(ExpEnv(ReadIni('FileName'))),'');`**  

- Обработка имен файлов идет в определенном порядке:

    1. Чтение или вычисление имени (ссылки) файла, например, **ReadIni**.  
       Этот вызов дает начальное значение имени файла, которое требуется обработать.  
    2. Применение (**если требуется**) подстановки переменных окружения **ExpEnv**.  
       Этот шаг требуется только если в файловой ссылке используются переменные окружения.  
    3. Применение **AdaptFileName** для обычных или **AdaptExeFileName** для исполняемых файлов.  
    4. Применение **DaqFileRef** для приведения имени файла к каноническому виду,  
       а также для перевода относительных имен файлов в абсолютные.  

- Если прикладная программа использует внешний исполняемый файл или сценарий оболочки,
  надо позаботиться о том, чтобы для каждой системы (**Unix** и **Windows**) в одной
  папке лежали одноименные исполняемые файлы (**ELF** файл без расширения для **Unix**,
  **.exe** файл для **Windows**) или сценарии оболочки (**.sh** файл для **Unix**,
  **.cmd** файл для **Windows**). Разумеется, эти одноименные программы и сценарии
  должны выполнять одинаковые функции (каждый в своей системе) и быть правильно
  подготовлены (например, в **Unix** иметь статусный флаг "исполняемый").
  При этом условии **AdaptExeFileName** сработает правильно и вернет верное имя
  исполняемого файла или сценария для текущей операционной системы.  
  Подробнее про сценарии см. **[тут](#cross_shell_scripts)**.

- Отдельные ветки (фрагменты) кода, зависящие от текущей операционной системы,
  организуются с помощью функций идентификации **IsUnix**, **IsWindows**.
  Как правило, большая часть кода одинакова для всех платформ
  и таких фрагментов бывает немного.

- При необходимости также корректируются **[шрифты](#cross_fonts)** для мнемосхем.  
  Рекомендуется всегда использовать шрифты семейства **ParaType**:
  **PT Mono**, **PT Sans**, **PT Serif** и другие.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_shell_scripts"></a>

## Процедура перевода сценариев .cmd/.bat в .sh

Сценарии оболочки операционной системы используются для решения вспомогательных задач
типа обработки файлов, запуска и остановки внешних программ и т.д. средствами командной
оболочки операционной системы. Обычно это **cmd.exe** в **Windows** или **bash** в **Unix**.

Сценарии оболочки операционной системы для кроссплатформенной **DAQ** конфигурации:

- должны иметь имя файла в нижнем регистре,  
- должны иметь разделитель **LF** в **Unix**, **CRLF** в **Windows**,  
- имеют расширение **.sh** в **Unix**; либо **.cmd** или **.bat** в **Windows**,  
- совпадают по пути (лежат в одном каталоге) и базовому имени (без расширения),  
- в **Unix** начинаются со строки **`#!/bin/bash`** и имеют права на чтение/исполнение **rx**,  
- в **Unix** имеют кодировку **UTF8**, в **Windows** могут иметь кодировку **UTF8**, **ANSI**, **OEM**.  

По соглашению, одноименные сценарии обработки **.cmd** или **.sh** выполняют в разных операционных системах (_примерно_)
одну и ту же работу (с учетом возможностей и правил каждой из систем) и (_желательно_) имеют одинаковый набор аргументов.

При соблюдении вышеописанных соглашений прикладной код может использовать функцию **AdaptExeFileName** для адаптации имени
файла при вызове сценария и получать в результате кроссплатформенный код.

Обычно первоначальный сценарий пишется и отлаживается в одной из систем (**Windows** или **Unix**) - в той, где это удобнее.
Затем остается перевести сценарий **.cmd** в **.sh** или наоборот.  

### Перевод сценария .cmd/.bat в .sh

Для перевода сценария **.cmd** в **.sh** используется, например, редактор **kate**.  
В ходе перевода большая часть работы выполняется путем нескольких итераций замены текста.  
Для замены иногда используется обычный текст **plain**, либо регулярные выражения **regexp**.  
При замене регистр **CS** _CaseSensitive_ учитывается (**+**), либо нет (**-**).  
Некоторая часть требует "ручной" работы, поскольку не поддается автоматизации.  

Таблица замен.

| Тип        | CS    | Шаблон                   | Замена                        | Комментарий                       |
|------------|-------|--------------------------|-------------------------------|-----------------------------------|
| **regexp** | **-** | **`^\s*@echo\s+off\s*`** | **`#!/bin/bash`**             | Эхо/интерпретатор.                |
| **regexp** | **-** | **`^:(\w+)\s*`**         | **`function \1(){`**          | Объявление функции/подпрограммы.  |
| **regexp** | **-** | **`^\s*goto\s+:EOF\s*`** | **`};`**                      | Завершение функции/подпрограммы.  |
| **regexp** | **-** | **`%(\w+)%_`**           | **`${\1}_`**                  | Подстановка переменной (первая).  |
| **regexp** | **-** | **`%(\w+)%(\w)`**        | **`${\1}\2`**                 | Подстановка переменной (вторая).  |
| **regexp** | **-** | **`%(\w+)%`**            | **`$\1`**                     | Подстановка переменной окружения. |
| **regexp** | **-** | **`\^$`**                | **`\`**                       | Замена символа **`^`** (первая).  |
| **regexp** | **-** | **`\^`**                 | Пустая стока                  | Замена символа **`^`** (вторая).  |
| **plain**  | **-** | **`%*`**                 | **`$*`**                      | Подстановка всех аргументов.      |
| **plain**  | **-** | **`%%`**                 | **`%`**                       | Замена удвоения процента.         |
| **regexp** | **-** | **`%~?(\d)`**            | **`$\1`**                     | Замена позиционных аргументов.    |
| **regexp** | **-** | **`^echo (.*)`**         | **` echo "\1";`**             | Замена **echo** (первая).         |
| **regexp** | **-** | **`^echo.`**             | **` echo "";`**               | Замена **echo** (вторая).         |
| **regexp** | **-** | **`set /a (.*)`**        | **`let "\1";`**               | Замена арифметического выражения. |
|            | **-** | **` `**                  | **` `**                       |                                   |
| **regexp** | **-** | **` `**                  | **` `**                       |                                   |
| **plain**  | **-** | **` `**                  | **` `**                       |                                   |
|            | **-** | **` `**                  | **` `**                       |                                   |

> При замене выражений надо быть внимательным.
  Их нельзя прменять "бездумно", надо следить за контекстом.
  В каждом случае есть свои "тонкости", которые невозможно предусмотреть в общем случае.
  Приведенные в таблице шаблоны следует рассматривать как минимальный набор, который облегчит перевод сценариев.
  Ну а в общем случае вам необходимо освоить технику регулярных выражений и действовать по обстоятельствам.


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cross_fonts"></a>

## Шрифты для кроссплатформенной разработки

Старый пакет **Crw32** работает под **Windows** и поэтому в мнемосхемах часто использовались
шрифты, штатно имеющиеся в этой системе.
Для кроссплатформенной разработки необходимо заменить эти шрифты на свободно распрространяемые
кроссплатформенные шрифты, которые доступны в разных системах.

Следует различать основные группы шрифтов:

- **Mono** - **моноширинные** шрифты, хорошо подходят для полей ввода-вывода, консолей, журналов и т.д.  
- **Sans** - **гладкие** шрифты (без засечек), хорошо подходят для отображения декоративного текста на экране.  
- **Serif** - **типографские** шрифты (с засечками), имитируют книжные шрифты, хорошо подходят для печати на бумаге.  
- **Narrow** - **узкие** шрифты для более компактного отображения длинных строк в ограниченном поле вывода.  

Также есть эффекты (атрибуты) шрифтов:

- **Regular** - **основной** (обычный, базовый) вид шрифта,  
- **Bold** - **жирный** шрифт для выделения текста,  
- **Italic** - **наклонный** шрифт для имитации рукописных надписей.  

### Рекомендуемые шрифты для кроссплатформенной разработки

Для кроссплатформенной разработки (для мнемосхем) **настоятельно рекомендуется** использовать
шрифты семейства **ParaType**:

<a name="fonts_paratype">Шрифты семейства <b>ParaType</b>:</a>

| Имя шрифта          | Назначение шрифта                                                                                         |
|---------------------|-----------------------------------------------------------------------------------------------------------|
| **PT Mono**         | Основной **моноширинный** шрифт для информационных надписей: полей ввода/вывода, консоли, журналов и т.д. |
| **PT Sans**         | Основной **гладкий** шрифт для декоративных надписей: меток, комментариев, справочных файлов и т.д.       |
| **PT Sans Narrow**  | Специальный **узкий** шрифт для длинных декоративных надписей при ограниченной длине поля вывода.         |
| **PT Sans Caption** | Специальный **широкий** шрифт для выделения жирных декоративных надписей (например, заголовков).          |
| **PT Serif**        | Основной шрифт **с засечками** для печатных документов.                                                   |
| **PT Astra Sans**   | Гладкий шрифт для документов, совместимый по размерам с **Times New Roman**.                              |
| **PT Astra Serif**  | Замена **Times New Roman**, основной шрифт для печатных документов.                                       |

Достоинства шрифтов семейства **ParaType**:

- свободно доступные, открытая лицензия,  
- фонт **PT Mono** является наилучшим фонтом для программного кода,  
  с хорошим различением похожих символов (типа **0** и **O**, **1** и **l**).  
- входят в репозиторий **Astra Linux**, установлены по умолчанию,  
- входят в сборку фонтов **crwdaq** и **crw32**, устанавливается одним кликом,  
- шрифты семейства **PT Astra** геометрически совместимы с **Times New Roman**,  
  что улучшает переносимость документов.  

По этим причинам рекомендуется всегда использовать шрифты семейства **ParaType**.

### Замена шрифтов для кроссплатформенной разработки

При переводе **DAQ** конфигураций **crw32** в **crwdaq** иногда ввозникает проблема замены шрифтов **Windows**,
которых нет под другими системами.

Для замены шрифтов **Windows** на кроссплатформенные рекомендуется использовать следующую таблицу.

<a name="fonts_replacement">Таблица замены шрифтов:</a>

| Шрифт Windows       | Рекомендуемая замена | Комментарий                                                                      |
|---------------------|----------------------|----------------------------------------------------------------------------------|
| **Terminal**        | **PT Mono Bold**     | Шрифт для ввода-вывода, информационных надписей.                                 |
| **Courier New**     | **PT Mono**          | Шрифт для ввода-вывода, информационных надписей.                                 |
| **Courier**         | **PT Mono**          | Шрифт для ввода-вывода, информационных надписей.                                 |
| **Lucida Console**  | **PT Mono**          | Шрифт для ввода-вывода, информационных надписей.                                 |
| **Arial**           | **PT Sans**          | Шрифт для декоративных надписей.                                                 |
| **Arial Black**     | **PT Sans Caption**  | Шрифт для жирных декоративных надписей.                                          |
| **Arial Narrow**    | **PT Sans Narrow**   | Шрифт для узких декоративных надписей.                                           |
| **Tahoma**          | **PT Sans**          | Шрифт для декоративных надписей.                                                 |
| **Verdana**         | **PT Sans**          | Шрифт для декоративных надписей и **HTML** документов.                           |
| **Ms Sans Serif**   | **PT Sans**          | Шрифт для декоративных надписей, диалогов.                                       |
| **Times New Roman** | **PT Astra Serif**   | Шрифт для печатных документов (основной).                                        |
| **Times New Roman** | **PT Astra Sans**    | Шрифт для документов (для вывода на экран).                                      |
|                     |                      |                                                                                  |

Здесь перечислены наиболее часто используемые шрифты.  
Другие шрифты заменяются по аналогии, с учетом их семейства и внешнего вида.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---
