﻿---

# Руководство по проектированию и стилю программирования в среде пакета CRW-DAQ

---

[[toc]]

---

## Аннотация

В данном документе содержатся рекомендации для членов команды (группы) **DaqGroup** -
разработчиков прикладных автоматизированных систем управления (**АСУ**) в среде
инструментального пакета **CRW-DAQ**[1,2,3]. Приведенные рекомендации служат
для унификации и стандартизации программного кода и интерфейса пользователя.

Данный документ составлен с учетом длительного опыта разработки прикладного кода **АСУ**
и многолетней практики программирования в среде пакета **CRW-DAQ**, а также
на основании советов, взятых из классической книги «Практика программирования» [4],
которую настоятельно рекомендуется прочитать вместе с данным документом.

Разработка и техническая поддержка **АСУ** в группе (**DaqGroup**) ведется коллективно.
Способность группы вести разработку и техническую поддержку разработанных **АСУ**
не должна критически зависеть от занятости и доступности (т. е. отпусков, командировок
или больничных) её участников. Каждый участник группы должен стремиться
к взаимозаменяемости, то есть способности «подхватить» разработку коллеги
или передать коллеге свой код для расширения его функционала или поддержки.
Каждый разработчик должен быть готов к работе с кодом, написанным
другим разработчиком или передаче своего кода коллеге. Именно поэтому очень важно
придерживаться принятых стандартов и рекомендаций, описанных в этом документе.
Это позволит сократить время, затрачиваемое на проектирование, разработку
и поддержку кода, повысит его читабельность, а также снизит вероятность ошибок.

Применяйте рекомендуемый стиль написания кода и соглашения о наименовании
(присвоении имен) при разработке прикладного программного обеспечения.
В этом случае вы получите единообразный вид исходного кода, и тогда
все участники группы смогут без труда с ним работать, а сам код станет
более простым и удобным в обслуживании.

---

## Немного философии: о важности эргономики

---

Программы, управляющие работой **АСУ** физических установок, читают не только
компьютеры, но и люди — программисты, инженеры, физики. Программы и алгоритмы
управления проектируют, пишут, читают, дополняют, редактируют и обсуждают люди,
специалисты с разной подготовкой и квалификацией. На заре развития компьютеров
главным свойством программ казалось их быстродействие. Но сегодня, когда
компьютеры имеют высокую производительность, зачастую важнее сосредоточить
внимание на других качествах программ — их ясности, простоте, читабельности,
гибкости, возможности технической поддержки и развития. Очень важно,
чтобы людям было удобно эти программы читать, понимать и обсуждать.

Пользуются созданными программами тоже люди с самой разной подготовкой
и квалификацией. Порой они работают с программами длительное время,
в напряженном режиме. Очень важно, чтобы управляющие программы были удобны
в использовании людьми — лаборантами, инженерами, физиками, операторами **АСУ**.

Поэтому очень важно учитывать при разработке соображения **эргономики** —
науке о «человеческом факторе» которая определяется как «*Научная дисциплина,
изучающая взаимодействие человека и других элементов системы, а также сфера
деятельности по применению теории, принципов, данных и методов этой науки
для обеспечения благополучия человека и оптимизации общей производительности
системы*» [6]. По классификатору **ВАК** — это специальность 19.00.03
«Психология труда, инженерная психология, эргономика». Эта наука учитывает
физиологические и психические свойства и особенности человека при его
взаимодействии с техническими средствами.

Например, людям легче двигать глазами вверх-вниз, чем вправо-влево. Поэтому
большие программы, которые приходится часто перелистывать, лучше делать не очень
«широкими» (т. е. избегать длинных строк текста), чтобы не приходилось слишком
часто «бегать глазами» вправо-влево. По этой же причине следует внимательно
относиться к правилам форматирования текста — отступам, комментариям,
стандартным конструкциям.

Кроме того, людям легче получать информацию небольшими порциями, чем одним
большим куском. Поэтому хорошо структурированные программы, разбитые
на небольшие, четко оформленные блоки (процедуры, функции) с интуитивно
понятными именами, читаются и понимаются легче, чем огромные «простыни»
неструктурированного текста.

Хорошее форматирование и структурирование программного кода — это далеко не мелочь.
При большом объеме кода и дефиците времени и людей, часто сопровождающим
создание **АСУ**, очень важно, чтобы разработчики могли быстро прочитать код
программы и понять его. Этого невозможно добиться без учета эргономики. Хорошее
форматирование и структурирование также резко снижает риск ошибок и трудоемкость
их поиска, а потому повышает надежность программ. Поэтому так важно выработать
для себя верный стиль кодирования (программирования) и привычку им постоянно пользоваться.
Став привычкой, хороший стиль кодирования поможет вам работать успешнее и эффективнее.

---

## Соглашения о наименовании (присвоении имен)

---

### Общие принципы наименования объектов

При именовании программных объектов (прикладных систем, файлов, тегов, кривых,
окон, переменных, процедур и функций) следует придерживаться некоторых общих
принципов, облегчающих создание и поддержку **АСУ**:

- Имена объектов должны быть (по возможности) самодокументированными,
  т. е. отражающими назначение и смысл именуемых объектов. Например,
  переменная ` BufferSize ` является самодокументированной,
  т. к. её имя отражает назначение (размер буфера), а переменная ` b123 ` -
  не является, т. к. её имя ничего не сообщает о назначении переменной.
  Самодокументированные программы (в которых имена типов, переменных, процедур
  и функций самодокументированы) легче читать и сопровождать, они требуют
  минимального количества комментариев и пояснений.
- Имена должны быть (по возможности) краткими. Например, переменную в предыдущем
  примере можно сократить до ` BufSize `. Для уменьшения длины имен можно
  использовать сокращения или аббревиатуры. Для сокращений используют разные
  способы, например, начальные фрагменты слов (` Buf ` вместо ` Buffer `),
  либо слова без согласных букв (` Bfr ` вместо ` Buffer `). В некоторых
  типичных случаях (например, переменные цикла ` i,j,k,… `) краткость имеет
  приоритет над другими соображениями.
- Имена должны быть (по возможности) легко произносимыми, так как иначе
  будет трудно обсуждать программный код с коллегами. Попробуйте произнести
  что-нибудь вроде ` Bfszkqw_1p2 `.
- Для конструирования имен можно использовать английские и русские слова или термины,
  а также распространенные аббревиатуры — лишь бы они были понятны разработчикам.
  При конструировании имен из слов следует использовать правильное (без ошибок)
  написание слов, т. к. грамматические ошибки создают избыточную неопределенность
  интерпретации и мешают пониманию кода.
- В именах, составленных из нескольких слов, рекомендуется выделять отдельные
  слова регистром (например, ` BufferSize `) или разделителем (например,
  ` buffer_size `). Это улучшает читабельность текста.
- Имена могут содержать латинские буквы, цифры и (возможно) разрешенные в текущем
  контексте знаки пунктуации (знак подчеркивания, точка, прямой или обратный слеш).
  Символы национальных алфавитов могут находиться в комментариях, но не рекомендуются
  в именах из-за их неоднозначной интерпретации в различных **ОС**
  (во избежание проблемы символьных кодировок).

В силу противоречивости требований к наименованию (трудно сделать имя
самодокументированным, легко произносимым и кратким одновременно), соглашения
по наименованию в прикладном коде обычно являются компромиссными. Тем не менее,
разработчик должен держать в голове все перечисленные принципы наименования,
сознательно отдавая предпочтение тому или иному критерию в зависимости от ситуации.

---

### Имя прикладной DAQ системы

Имя прикладной **DAQ** системы должно быть (по возможности) предельно кратким
(лучше всего не длиннее 3-4 символов), и (желательно) легко произносимым.
Краткость имени нужна потому, что оно часто используется как префикс в составных
именах, поэтому слишком длинное имя системы будет создавать проблемы.

Для именования драйверов какого-либо устройства обычно используется сокращенная
форма названия предприятия (фирмы) производителя, название и номер модели устройства
либо серии устройств, например:
- **INTEK** → НПП ИНСИТЕК (INSITEK),
  **ATECH** → AEROTECH,  **DOZA** → НПП ДОЗА,
  **MERA** → MERADAT — имена по названию предприятия,
- **TMC610** → TRINAMIC TMC-610,
  **E140** → L-Card E14-140 — по названию модели устройства,
- **ZUPDC** → TDK-Lambda ZUP series,
  **GENDC** — TDK-Lambda GENESYS series — по названию серии устройств.

Для именования систем управления для физических установок лучше всего использовать
аббревиатуры, отражающие назначение этих установок, например:
- **FAHT** → Fabric of Automated Hydrogen Targets,
- **VACS** → Vacuum Control System,
- **TRS** → Tritium Retention System.

Аббревиатуры можно строить с использованием английских переводов,
включая выражения "Система Управления" (Control System), например:
- **RTCS** → Система Управления Поворотным Столом (Rotating Table Control System),
- **ISCS** → Система Управления Источником Ионов (Ion Source Control System).

Также, для задания имени системы, допустимо использование транслитерации
русских слов или аббревиатур латинскими буквами:
- **SPVZK** → СПВЗК,
- **TIR** → ТИР,
- **EGP** → ЭГП.

Следует избегать трудно произносимых аббревиатур, т. к. названия систем
часто приходится обсуждать с коллегами вслух (например, по телефону),
а трудно произносимые аббревиатуры затрудняют общение.

---

### Имена кривых, тегов, устройств и окон DAQ систем

Обычно имена программных объектов DAQ системы, таких как кривые, теги,
устройства и окна имеют общий вид **составного** имени, разделенного точками:

    FFF.UUU.PPP…

где **FFF, UUU, PPP** — компоненты составного имени, а именно:
название физической установки (Facility), функционального узла (Unit)
и параметра (Parameter). Число компонент составного имени может быть
(при надобности) увеличено. Составные имена удобны в работе, т. к.
они легко интерпретируются и сочетают в себе краткость и емкость.

Название установки (**FFF**) — это фактически имя **DAQ** системы,
рекомендации к выбору которого приведены выше.

Имя узла (**UUU**) обычно характеризует принадлежность к какой-либо функциональной подсистеме, например:
- **MAIN** – подсистема (программа) обработки событий главного графического окна;
- **GAS** – подсистема, отвечающая за управление аппаратурой газовой арматуры (вентили, клапаны, насосы и пр.).

Имена устройств должны носить функциональный характер в зависимости от того,
для чего это устройство предназначено, например:
- **GAS.MVTOTC** – программа перевода величин из одной единицы в другую
  (в данном случае, из милливольт в температуру – mV to Celsius temperature)
  для газовой (GAS) подсистемы;
- **MAIN.CTRL** – управляющая программа для главного графического окна системы.

Для имен окон графиков кривых (plot) или таблиц (table), параметр **PPP**
указывает на тип данных, которые отображаются в этом окне,
а в конце имени добавляется слово **PLOT** или **TAB**, например:
- **GAS.PRES.PLOT** – окно-график с кривыми давления (pressure) газовой подсистемы;
- **GAS.TEMP.TAB** – окно-таблица для отображения температур (temperature) газовой подсистемы.

В именах тегов и кривых, однородные параметры могут объединяться в группы
с номерами, например датчики температуры:
- **GAS.TC1** — термопара (ThermoCouple) №1;
- **GAS.TC2** — термопара (ThermoCouple) №2.

Бывает, что канал управления и канал измерения имеют одинаковое название,
например уставка напряжения и контроль напряжения на выходе источника питания.
В таком случае стоит разделить каналы по действию (**SET** - уставка,
**MON** - мониторинг, контроль). Кроме того, так можно группировать и другие
параметры одного устройства или одной подсистемы, например:
- **G1.SET.V** — уставка (**SET** - setpoint) выходного напряжения (**V** - voltage) источника питания G1;
- **G1.SET.C** — уставка выходного тока (**C** - current) источника питания G1;
- **G1.SET.OVP** — уставка защиты от перенапряжения (**OVP** - overvoltage protection);
- **G1.SET.OCP** — уставка защиты от перегрузки по току (**OCP** - overcurrent protection);
- **G1.MON.V** — мониторинг (**MON** - monitoring) выходного напряжения;
- **G1.MON.C** — мониторинг выходного тока;
- **G1.MON.POW** — мониторинг выходной мощности (**POW** - power) источника питания G1.

Часто в имени кривых и тегов указываются единицы измерения, особенно,
если они используются в калибровочных преобразованиях из одной единицы в другую.
Это позволяет отличать показания датчиков, выраженных в разных единицах измерения.
Например, для датчика давления это может выглядеть так:
- **GAS.PS1\.MV** — датчик давления №1 (Pressure Sensor), милливольты (mV);
- **GAS.PS1\.MA** — датчик давления №1, миллиамперы (mA);
- **GAS.PS1.MBAR** — датчик давления №1, миллибары (mbar).

Имена кривых, тегов, устройств и окон в конфигурационных файлах обычно пишутся
в верхнем регистре (заглавными буквами), за редким исключением, например AdamTraffic.
Строго говоря, это неважно, т. к. обычно имена не чувствительны к регистру.
Однако по многим соображениям (например, поиск и/или замена имен в файлах)
лучше использовать верхний регистр.

Для драйверов устройств, название узла **UUU** (Unit) в именах не обязательно,
если этот драйвер работает автономно и не встраивается в качестве подсистемы в другую систему.
Однако, если такой драйвер работает с несколькими устройствами, например драйвер **Modbus**,
то узел **UUU** используется в качестве идентификатора для каждого устройства.
Если драйвер будет включен в состав системы управления как подсистема, то имя
основной системы будет **FFF**, а имя драйвера **UUU**. Конечно, можно и не добавлять
имя системы, в составе которой будет работать драйвер, а включить его как есть.
Но при реализации системы управления как распределенная сетевая система, например
по протоколу **DIM** [5], принадлежность драйвера к конкретной системе нужно
определять обязательно, чтобы не было конфликтов имен в сети **DIM**.
Хорошей практикой является наличие генератора конфигурации для драйвера,
в котором предусмотрена возможность добавлять префикс имен кривых, тегов
и прочих объектов. Такой генератор обычно реализуется в виде пакетного (batch)
командного файла (*.bat, *.cmd). Программный код **DaqPascal** при этом
должен быть реализован без привязки к каким-либо конкретным именам
(конкретизировать имена можно через секцию в файле конфигурации).

---

### Имена файлов DAQ систем

Имена файлов должны четко определять их принадлежность к конкретной системе,
подсистеме или функциональному узлу (например, драйверу). Кроме того, используя
файловое разделение объектов в системе или подсистеме (данные, устройства, окна и пр.)
следует определять в имени файла и его содержимое, например:

- `fff_uuu_init.cfg` — файл с описанием задач Cron-сервера,
- `fff_uuu_tags.cfg` — файл с описанием структуры данных (тегов и кривых),
- `fff_uuu_ctrl.cfg` — файл с описанием программных устройств и окон,
- `fff_uuu_datsrv.cfg` — файл со списком кривых для сервера сохранения данных,
- `fff_uuu_custom.cfg` — файл со списком тегов, загружаемых при старте системы.

Имена файлов следует задавать в нижнем регистре, а также применять правила
именования объектов (тегов, кривых и пр.), с учетом того, что в именах
файлов вместо точек используется символ подчеркивания:

`fff_uuu_ppp.ext`

В некоторых случаях, например для программ-серверов или их конфигураций,
допустимо использование таких имен:

`UniHeat.cfg`  
`AdamTraffic.cfg`

---

### Имена переменных в программном коде DaqPascal

Имена переменных должны быть краткими, понятными и простыми.
Переменные, которые хранят ссылку на тег (то есть связанные с тегом),
или на другие программные объекты, необходимо записывать в верхнем регистре,
чтобы в коде отличать их от обычных переменных. Такие переменные должны сохранять
структуру имени связанного с ними объекта, например:
- **EGP.VACS.VM1\.BT**    — имя тега в конфигурационном файле;
- **EGP.VACS.VM1.BT.tag** — имя переменной в программном коде.

В некоторых случаях, если система имеет сложное составное имя из нескольких префиксов
систем и подсистем, допускается упрощение имени переменной и отсекания префиксов
до некоторого разумного уровня, при котором принадлежность переменной к объекту
или подсистеме сохраняется. В примере ниже, несмотря на отсутствие основного префикса
(**SCE.BACC**) в имени переменной, можно определить, что переменная связана с тегом
(**tag**), является кнопкой (**BT**) для управления пневматическим вентилем (**VP1**)
в первой секции (**SEC1**) вакуумной системы (**VACS**) бустера (**BSTR**):
- **SCE.BACC.BSTR.VACS.SEC1.VP1\.BT** — имя тега в конфигурационном файле;
- **BSTR.VACS.SEC1.VP1.BT.tag** — имя переменной в программном коде.

Те же правила необходимо применять для имен констант, которые хранят номер
цифрового или аналогового входа/выхода, заданного в конфигурации устройства.
Например, если в конфигурации присутствуют подобные конструкции:

```
Link AnalogOutput  0 with curve EGP.ISCS.HVPS.G6.SET.V history 5000
Link AnalogInput   0 with curve EGP.ISCS.HVPS.G6.MON.V
Link DigitalOutput 0 with curve EGP.ISCS.ADAM.P1.DOS history 1000
Link DigitalInput  0 with curve EGP.EACS.ADAM.A2.DIS bit 0
```

…то константы в программном коде должны быть объявлены по следующим правилам:
имя кривой в верхнем регистре, точки заменяются на знак подчеркивания,
а в начале имени указывается тип входа или выхода в нижнем регистре
(ai_ - AnalogInput, ao_ - AnalogOutput, di_ - DigitalInput, do_ - DigitalOutput):

``` pascal
ao_ISCS_HVPS_G6_SET_V = 0;
ai_ISCS_HVPS_G6_MON_V = 0;
do_ISCS_ADAM_P1_DOS = 0;
di_EACS_ADAM_A2_DIS = 0;
```

Описанные правила важны именно для связанных с какими-либо объектами (теги,
кривые и пр.) переменных. Для остальных следует придерживаться общих принципов
наименования объектов, описанных выше.

---

## Рекомендуемый стиль программирования в DaqPascal

---

### Стиль отступа при оформлении логических блоков

В качестве символа отступа используется одиночный пробел (single space) – « ».
Использовать более длинный отступ (например, 2 или 4 пробела) не рекомендуется.
При длинных отступах строки кода сложной программы получаются избыточно длинными
(широкими) и код становится трудно читать, т. к. приходится часто прокручивать
текст вправо-влево. Кроме того, в компиляторе **DaqPascal**, имеется ограничение
на длину строки программного кода, при превышении которого компилятор выдает ошибку
(текущее ограничение - до 240 символов).

Не следует использовать в качестве отступов символы табуляции, так как ширина
табуляции зависит от текущих настроек редактора. Из-за этого на разных
компьютерах или при использовании разных редакторов выравнивание текста
может меняться и выглядеть неправильно.

При форматировании вложенных блоков надо следить за тем, чтобы отступы
соответствовали вложенности блоков (**begin…end**), то есть чтобы каждый
открывающий оператор (**begin, if, while** и т. д.) имел такой же отступ,
что и закрывающий его оператор (**end**). Например:

``` pascal
procedure Print(Message:String);
begin
 if (Message<>’’) then begin
  Writeln(Message);
 end;
end;
```

Приведенное выше правило отступов улучшает читабельность и понимание структуры
программы, т. к. сразу видно, где начинается и кончается каждый блок кода.
Это также способствует снижению риска ошибок в структуре алгоритмов
из-за нарушений порядка вложенности блоков кода. Такие ошибки бывает очень трудно
обнаружить, если код отформатирован с нарушением отступов.

---

### Стиль оформления операторов ветвления if-then-else и логических блоков begin..end

При оформлении условных операторов ветвления рекомендуется придерживаться следующего стиля:

``` pascal
if (condition) then (operator1) else (operator2);
```

Если при такой записи длина строки получается слишком большой или если нужно
явно выделить конструкцию ***if-then-else***, ее следует писать так:

``` pascal
if (condition)
then (operator1)
else (operator2);
```

**Не следует** оформлять такие конструкции подобным образом:

``` pascal
if (condition)
then
 (operator1)
else
 (operator2);

или

if (condition) then
 (operator1)
else
 (operator2);
```

Оформленные в таком виде конструкции не соответствуют принятым правилам
использования отступов.

Допустимая форма записи конструкции ***if-then-else***:

``` pascal
if (condition1) then
if (condition2) then (operator2) else (operator3);
```

Оформление каскада ***else-if*** для реализации многовариантного выбора
следует выполнять в таком виде:

``` pascal
if (condition1) then (operator1) else
if (condition2) then (operator2) else
...
if (conditionN) then (operatorN) else (operatorN+1);
```

В данном случае приоритет отдается вертикальному выравниванию, однако может
несколько ухудшаться понимание кода при длинных строках, так как операторы
**if** можно воспринимать, как независимые друг от друга. С другой стороны,
выравнивание по операторам **if** задает четкую структуру каскада, которая
легче воспринимается визуально (когда условия и операторы следуют один под другим).

Кроме того, приоритет вертикальному выравниванию отдается по той причине,
что в системах управления, зачастую работа идет с большим количеством
переменных, связанных с какими-либо объектами (теги, сенсоры, кривые и пр.)
и в такой форме записи упрощается групповое редактирование подобных строк.

Оформление логических блоков, ограниченных ключевыми словами **begin**
и **end** следует выполнять в таком стиле:

``` pascal
if (condition) then begin
 (body);
end;
```

``` pascal
if (condition) then begin
 (body);
end else begin
 (body);
end;
```

Форма записи, представленная ниже, не очень компактна,
зато очень легко поддается тиражированию при добавлении новых ветвлений:

``` pascal
if (condition1) then begin
 (body);
end else
if (condition2) then begin
 (body);
end else
...
if (conditionN) then begin
 (body);
end else (def_operator);
```

---

### Комментарии и стиль оформления комментариев

Комментарии предназначены для того, чтобы программу было легче читать и понимать.
Но от них мало толку, если они попросту дублируют то, что и так ясно из текста
программы, противоречат содержанию кода или отвлекают читателя излишним описанием.
Лучшие комментарии — это те, которые помогают лучше понять код, давая либо краткое
описание самых существенных деталей, либо расширенное представление
о выполняемых операциях [4].

**Не повторяйте очевидное**. В комментариях не должна повторяться информация,
очевидная из самого текста программы — такие комментарии его просто загромождают.

**Комментируйте функции и глобальные данные**. Следует комментировать функции,
глобальные переменные, определения констант и поля структур данных.
Комментарий перед определением функции служит удачным введением
к чтению самого кода функции. Как раз для таких случаев, можно выделить
несколько правил оформления комментариев:

- Комментарии глобальных или значимых функций следует оформлять фигурными
  скобками в несколько строк. Комментарии глобальных, но вспомогательных
  функций или комментарии вложенных функций оформляются в несколько строк
  (обычно три) с использованием двух символов "слеш". Например:

``` pascal
{
Комментарий·для·глобальных·или·значимых·процедур/функций
}

//
//·Комментарий·для·вложенных·процедур/функций
//
```

**He противоречьте коду**. Большинство комментариев соответствует коду в
момент его написания, но по мере исправления ошибок и доработки программы
содержание комментариев отклоняться от исходного текста, если их не обновлять.
Поэтому следите за актуальностью написанных комментариев.

**Проясняйте, а не запутывайте**. Комментарии должны делать трудные места
программы более понятными, а не создавать дополнительные препятствия для понимания.

По большому счету, аккуратно и логично написанная программа в комментариях
не нуждается, однако, следует учитывать тот факт, что разработка программ
в пакете CRW-DAQ ведется коллективом разработчиков, у которых может быть
разный уровень подготовки. Вот именно для того, чтобы облегчить чтение
и поддержку кода при командной разработке, следует писать комментарии,
соблюдая приведенные правила.

---

### Прочие рекомендации по улучшению читаемости кода

- Не следует использовать пробелы при оформлении логических и арифметических операций.
  Так строка выглядит компактней, цельной и не создает впечатление разорванного текста,
  например:

``` pascal
if (a>b) then c:=a+b;
```

…вместо такой записи:

``` pascal
if ( a > b ) then c := a + b;
```

- При объявлении функций или процедур, список параметров разного типа,
  разделенных точкой с запятой, следует разделять пробелом:

``` pascal
function func(i,j:Integer; r,t:Real; s:String):Integer;

procedure proc(i,j:Integer; r,t:Real; s:String);
```

- При вызове функций или процедур с параметрами, аргументы следует указывать
  без пробелов (за исключением случаев, описанных в следующем пункте):

``` pascal
a:=func(i,j,r,m,s);

proc(i,j,r,m,s);
```

- Для лучшей читаемости кода, при множественных вызовах одной процедуры или функции
  с разными аргументами, следует делать выравнивание текста по аргументам, например:

``` pascal
InitTag(first.tag, 'first', 1); // First  tag
InitTag(second.tag,'second',2); // Second tag
InitTag(third.tag, 'third', 3); // Third  tag
```

- Не следует объявлять глобальные переменные для использования их в качестве
  временного хранения значений или для организации циклов в процедурах и функциях.
  Делайте это локально в секции объявления переменных той процедуры или функции,
  где они требуются.

- Тип переменных при объявлении рекомендуется записывать с заглавной буквы,
  например:

``` pascal
AlarmList : Integer;
AlarmTime : Real;
```

---

## Рекомендации по проектированию графического интерфейса пользователя

---

Графический интерфейс — это одна из наиболее важных частей системы управления,
необходимая для организации взаимодействия пользователя с этой системой.
Чем лучше спроектирован интерфейс, тем проще и удобнее будет взаимодействие
с системой.

Графический интерфейс должен быть ясным, а не следовать визуальным трендам.
Особенно это актуально, если речь идёт о системе управления сложной установкой.
Графический интерфейс должен иметь важные визуальные подсказки. Подсказки,
которые говорят людям, куда они могут кликнуть, а куда ввести новое число.  
Отделяйте кнопки от полей ввода и вывода, используя правильный визуальный
элемент. Индикатор отображения бинарного состояния не должен быть выполнен
в виде чекбокса — пользователь постоянно будет пытаться кликнуть на него,
чтобы изменить его состояние. Не вводите его в заблуждение. Стремитесь
разрабатывать чистый сбалансированный, простой и понятный интерфейс,
и он будет не только красивым, но еще с ним будет приятно работать.

Используйте стандартные элементы интерфейса, шрифты и палитры цветов, чтобы
унифицировать внешний вид мнемосхем и придать им единообразный стиль.
Применяя описанные ниже рекомендации при разработке графических интерфейсов,
пользователю не придется переучиваться и привыкать к интерфейсу систем,
написанных разными разработчиками.

### Типографика

**ParaType (PT)** – это основной шрифт в пакете **CRW-DAQ**. Использование
основного шрифта обеспечивает удобочитаемость, четкость и согласованность
текста на мнемосхемах прикладных систем. Семейство шрифтов **PT** входит
в состав пакета, а также доступно для инсталляции в виде установочного
файла **install-daqgroup-fonts.exe**, входящего в состав дистрибутива.

При проектировании интерфейсов придерживайтесь следующих рекомендаций
по использованию шрифтов **PT**:

- **PT Mono** используйте для числовых полей (LED) измеренных данных,
  а также для всех полей ввода и вывода;
- **PT Sans** используйте для написания поясняющих надписей (label) на мнемосхемах;
- **PT Sans Narrow** используйте для длинных надписей и для экономии
  места на мнемосхемах и в строковых полях.

Подчеркнуть наиболее важную информацию на мнемосхеме можно при помощи
**толщины**, **размера**{.bigger} и **цвета**{.red} шрифта.

### Цвет

Использование цвета — это отличный способ передать информацию о состоянии
элемента, отобразить реакцию на действие пользователя, визуализировать данные.
При беглом взгляде на экран компьютера с запущенной системой управления,
оператор должен однозначно определить состояние системы в целом или состояние
отдельных ее частей только по цвету отображаемых элементов.

#### Основные цвета

В **CRW-DAQ** имеется ряд стандартных цветов, которые рекомендуется использовать
в прикладных системах. Применение стандартных цветов позволяет точно
и однозначно определить предназначение каждого поля на мнемосхеме
и дает понять текущее состояние системы.

<b class="bgsilver solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Silver (RGB: C0C0C0){.bgsilver}

Серебристый (*silver*) или светло-серый цвет является основным цветом для фона мнемосхем.
Также он применяется в следующих случаях:
- Неактивное поле ввода или вывода, например, при выключенном опросе или измерении;
- Поле вывода информационных данных или данных, не содержащих потенциально важную информацию;
- Кнопка в обычном или выключенном состоянии.

<b class="bggray solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Gray (RGB: 808080){.white .bggray}

Серый (*gray*) цвет является акцентным цветом для серебристого и применяется для
разделителей или границ элементов, например:
- Разделитель заголовка системы от основного поля мнемосхемы;
- Разделитель любых данных на мнемосхеме;
- Выделение нескольких элементов интерфейса в один блок или группу;
- Границы полей ввода/вывода или любых других полей.

<b class="bgaqua solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Aqua (RGB: 00FFFF){.bgaqua}

Цвет морской волны (*aqua*) или голубой цвет фона применяется к полям вывода
измеренных данных, например: ток, напряжение, температура, давление и прочее.
Следует отметить, что цвет фона **Aqua** применяется только в том случае, если
измеренные данные имеют важное значение для пользователя и должны привлекать внимание.
В остальных случаях для таких полей рекомендуется использовать цвет **Silver**.

<b class="bgblue solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Blue (RGB: 0000FF){.bgblue .fgyellow}

<b class="bgnavy solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Navy (RGB: 0000FF){.bgnavy .fgyellow}

Синий (*blue*) и темно-синий (*navy*) цвета используются для информирующих
надписей или для фона нейтральных (информационных) сообщений,
к которым не применимо понятие "уровня опасности".

<b class="bgyellow solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Yellow (RGB: FFFF00){.bgyellow}

Сценарий использования желтого цвета (*yellow*) достаточно разнообразен.
Желтый цвет часто используют для обозначения переходного (временного) состояния
объектов, чтобы предупредить оператора об изменении важных параметров объектов.
Если рассматривать его в качестве сигнального цвета, то он прежде всего обозначает
возможную опасность, опасную ситуацию или предупреждает о возможной опасности.
Его следует применять в следующих случаях:
- Превышение предупредительной пороговой уставки измеренного сигнала,
  например объемной активности или давления;
- Промежуточное состояние какого-либо элемента, например промежуточное состояние вентиля,
  когда он открывается или закрывается;
- Промежуточное значение сигнала при его установке по линейному изменению (ramp),
  например плавное изменение значения тока на выходе источника питания;
- Ошибки приемо-передачи, происходящие в настоящий момент, например таймауты при
  опросе устройства драйвером;
- Низкая частота опроса устройства программой-драйвером.

<b class="bglime solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Lime (RGB: 00FF00){.bglime}

Зеленый или лимонный цвет применяется в следующих случаях:
- Нормальная работа оборудования, например состояние опроса с хорошей частотой
  и без ошибок связи;
- Нормальное или допустимое значение измерения, например значение объемной
  активности в допустимых пределах, ниже предупредительной пороговой уставки;
- Активное состояние какого-либо элемента, например: открытый вентиль,
  включенный выход источника питания и прочее.

<b class="bggreen solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Green (RGB: 00FF00){.bggreen .fgwhite}

<b class="bgteal solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Teal (RGB: 00FF00){.bgteal .fgwhite}

Темно-зеленый (*green*) и циановый (*teal*) цвет используются для информирующих
надписей, а также для фона индикаторов объектов, находящихся в нейтральном,
неактивном состоянии.

<b class="bgred solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Red (RGB: FF0000){.white .bgred}

Красный цвет применяется в основном для информирования об ошибках, аварийных
или опасных ситуациях. Использовать красный цвет не по назначению недопустимо.
Применяйте красный цвет в следующих случаях:
- Действия при аварийных ситуациях, например: кнопка аварийной остановки,
  аварийного выключения и прочее;
- Превышение аварийной пороговой уставки измеренного сигнала, например
  объемной активности или давления;
- Ошибки в работе оборудования. Некоторые устройства имеют возможность регистрировать
  ошибки во время работы, которые можно фиксировать драйвером этого устройства.
- Разрыв связи (refuse) при опросе какого-либо устройства драйвером.

<b class="bgmaroon solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
Maroon (RGB: 800000){.white .bgmaroon}

Бордовый цвет применяется к цвету шрифта для имени системы при ее наличии на мнемосхеме.

<b class="bgwhite solid bdblack border2px">&nbsp;&nbsp;&nbsp;&nbsp;</b>
White (RGB: FFFFFF){.bgwhite}

Белый цвет применяется к полям ввода данных, т.е параметрам, которые можно редактировать.

#### Дополнительные цвета

Кроме стандартных цветов, при проектировании пользовательского интерфейса можно
использовать нестандартные цвета. Для задания таких цветов рекомендуется
использовать именованные цветовые константы палитр Windows, Web (HTML)
и X11 (Linux), встроенных в пакет CRW-DAQ.

---

## Список обозначений

---

| Обозначение | Расшифровка                           |
|-------------|---------------------------------------|
| ОС          | Операционная система                  |
| OS          | Operation system                      |
| АСУ         | Автоматизированная система управления |
| DAQ         | Data AcQuisition (сбор данных)        |

---

## Список источников

---

1. А.В.Курякин, Ю.И.Виноградов. Программа для автоматизации физических измерений
   и экспериментальных установок (CRW-DAQ). // Свидетельство РФ об официальной
   регистрации программы для ЭВМ № 2006612848 от 10.08.2006 г. Сайт программы: http://crw-daq.su.
2. А.В.Курякин. Автоматизация физических экспериментов на тритиевых комплексах
   исследовательских установок «ТРИТОН», «АКУЛИНА» и «ПРОМЕТЕЙ». Автореферат диссертации
   на соискание степени кандидата физико-математических наук, Саров, 2010.
   http://ftp.jinr.ru/dissertation/Kuryakin.pdf.
3. А.В.Курякин, Ю.И.Виноградов. Программное обеспечение автоматизированных измерительных
   систем в области тритиевых технологий. // ВАНТ, серия «Термоядерный синтез», 2008 г., выпуск 2, с.80-90.
4. Б.Керниган, Р.Пайк. Практика программирования. http://bioinformatics.ru/Books/kernigan.html
5. Distributed Information Management system (DIM). https://dim.web.cern.ch/
6. Что такое эргономика. https://iea.cc/what-is-ergonomics/

---

> Guide on design and programming style for CRW-DAQ users.
> DaqGroup (S.Filchagin, A.Kuryakin, N.Gurin, et al).
