#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## Fix HTML files.                                       ##
## 1) Replace 'charset=iso_8859-1' to 'charset=utf-8'    ##
## 2) Replace 'href="REF"' to 'href="ref"'               ##
## 3) Replace 'src="REF"' to 'src="ref"'                 ##
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

function find_htm(){
 find $1 -type f -name '*.htm*';
};

function validate_charset_htm(){
 find_htm | xargs -l sed 's/charset=iso_8859-1/charset=utf-8/' -i;
};

function validate_href_htm(){
 find_htm | xargs -l sed -E 's/( href)="(.*)"/\1="\L\2"/i' -i;
};

function validate_src_htm(){
 find_htm | xargs -l sed -E 's/( src)="(.*)"/\1="\L\2"/i' -i;
};

################
# main function.
################
function main(){
 if pushd $scriptHOME; then
  validate_charset_htm $PWD;
  validate_href_htm    $PWD;
  validate_src_htm     $PWD;
 fi;
 popd;
};

main "$@";

#############
# END OF FILE
#############
