#!/bin/bash

###################################################
# Copyright (c) 2023 Alex Kuryakin daqgroup@mail.ru
###################################################
# update crwdaq_[1-5].desktop by crwdaq_0.desktop.
###################################################

################################
# Current script identification.
################################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";
readonly sample="crwdaq_1.desktop";

function fatal(){
 1>&2 echo "$2";
 exit $1;
};

function update_crwdaq_desktop_files(){
 if [ -e $scriptHOME/$sample ]; then
  for n in $(seq 2 6); do
   local m=0; let "m=$n-1";
   local f="$scriptHOME/${sample/1/$n}";
   cat $scriptHOME/$sample | sed "s/_0/_$m/" | sed "s/ 1/ $n/" > $f;
  done;
 else
  fatal 1 "Error: could not find $sample";
 fi;
};

update_crwdaq_desktop_files;
