program tab2ini;   // Convert GOST tables to INI and CAL
{$APPTYPE CONSOLE} // ! Declare application type as CONSOLE.
{$I _sysdef}       // ! By CRW conventions, include _SYSDEF compiler options.
uses               // ! By CRW conventions, ShareMem should be FIRST USES UNIT.
 ShareMem,         // ! Also borlndmm.dll, giveio.sys should present in path.
 SysUtils,Windows,Math, // Some standard Delphi  units...
 _alloc,_str,_pio,_fio, // Some standard CRW-DAQ units...
 _sort,_task;

const
 weight_norm = 1;    // normal weight
 weight_zero = 1;    // zero weight
 smooth      = 20;   // smoothing spline
 numpts      = 10;   // number of points

var
 tabtext,initext,caltext:TText;
 line,step,zero,maxline,i,mmod,pmod,np,nm,nc:Integer;
 id,tip,mix,alt,obs,src,tabfile,inifile,calfile,tz,ta,tb,uz,ua,ub:String;

 function weight(t:Integer):Integer;
 begin
  if t=0 then Result:=weight_zero else Result:=weight_norm;
 end;

 procedure DeleteFiles(const arg:String);
 begin
  if ExtractWord(1,arg,ScanSpaces)='' then Exit;
  if FileExists(ExtractWord(1,arg,ScanSpaces)) then FileErase(ExtractWord(1,arg,ScanSpaces));
  DeleteFiles(SkipWords(1,arg,ScanSpaces));
 end;

 procedure sort_kng(Data:TText; kng:Integer; uniq:Boolean=True);
 var gap,i,j:Integer; Count:Integer;
  function Compare(Data:TText; a,b:Integer):Integer;
  var na,nb:Integer;
  begin
   na:=StrToIntDef(ExtractWord(kng,Data[a],ScanSpaces),-1000000);
   nb:=StrToIntDef(ExtractWord(kng,Data[b],ScanSpaces),-1000000);
   Result:=na-nb;
  end;
  procedure SwapData(Data:TText; a,b:Integer);
  var s:String;
  begin
   s:=Data[a]; Data[a]:=Data[b]; Data[b]:=s;
  end;
 begin
  Count:=Data.Count;
  if Count<2 then Exit;
  gap:=Count shr 1;
  while gap>0 do begin
   i:=gap;
   while i<Data.Count do begin
    j:=i-gap;
    while (j>=0) and (Compare(Data,j+gap,j)<0) do begin
     SwapData(Data,j+gap,j);
     dec(j,gap);
    end;
    inc(i);
   end;
   gap:=gap shr 1;
  end;
  if uniq then
  for i:=Data.Count-2 downto 0 do
  if SameText(Data[i],Data[i+1]) then Data.DelLn(i+1);
 end;
 
 procedure ProcessTab(initext,caltext:TText; s:String);
 var T,iter,nmod:Integer; relerr:String;
 begin
  s:=ReplaceString(s,',','.');
  s:=ReplaceString(s,'','-');
  if ExtractWord(1,s,ScanSpaces) = '' then Exit;
  if ExtractWord(2,s,ScanSpaces) = '' then Exit;
  if line > maxline then Exit;
  T:=StrToInt(ExtractWord(1,s,ScanSpaces));
  if T <  0 then nmod:=mmod else nmod:=pmod;
  if T <  0 then step:=-1;
  if T >  0 then step:=+1;
  if T =  0 then Inc(zero);
  if zero = 2 then step:=+1;
  if T =  0 then if step = 0 then step:=+1;
  iter:=0;
  while iter <= 10 do begin
   if ExtractWord(2,s,ScanSpaces) = '' then Break;
   relerr:='1';
   if T = 0 then relerr:='0';
   tb:=d2s(T);
   ub:=ExtractWord(2,s,ScanSpaces);
   if T = 0 then tz:=tb;
   if T = 0 then uz:=ub;
   if line = 0 then ta:=tb;
   if line = 0 then ua:=ub;
   if line = 0 then initext.AddLn(Format('%-4s %-7s %-6s %6s',['Data','Celsius','mV','RelErr']));
                    initext.AddLn(Format('%-4s %-7s %-6s %6s',['',     tb,        ub, relerr]));
   if abs(T) mod nmod = 0 then caltext.Addln(Format('%-4s %-6s %-6s %-6s %s',['', ub, tb, d2s(weight(StrToInt(tb))), '0']));
   Inc(T,step);
   Inc(iter);
   Inc(line);
   s:=SkipWords(1,s,ScanSpaces);
  end;
 end;

 procedure PrintIniHead(initext:TText);
 begin
  initext.Text:=Format('[]',[])+CRLF
               +Format(';*******************************************************************************',[])+CRLF
               +Format(';** ThermoCouple type:    %s (%s)',[tip,mix])+CRLF
               +Format(';** Actual/Obsolete id:   %s / %s',[id,obs])+CRLF
               +Format(';** Alternative names:    %s',[alt])+CRLF
               +Format(';** Reference source:     %s',[src])+CRLF
               +Format(';*******************************************************************************',[])+CRLF
               +Format(';** Data table contains:',[])+CRLF
               +Format(';** Celsius - thermocouple temperature, %sC',[#$B0])+CRLF
               +Format(';** mV      - thermoelectric voltage, milliVolts',[])+CRLF
               +Format(';** RelErr  - relative error of this point, 0 = interpolation',[])+CRLF
               +Format(';*******************************************************************************',[])+CRLF
               +Format('[]',[])+CRLF
               +Format('[ThermoCoupleList]',[])+CRLF
               +Format('ThermoCouple = %s',[id])+CRLF
               +Format('[]',[])+CRLF
               +Format('[%s]',[id])+CRLF
               +Format('FitMethod = Spline ; Use smoothing spline to fit',[])+CRLF
               +Format('Smooth = %g        ; Smooth parametr for spline',[smooth*1.0])+CRLF
               +initext.Text;
 end;

 procedure PrintIniTail(initext:TText);
 begin
  initext.Text:=initext.Text
               +Format('End Data',[])+CRLF
               +Format('[]',[])+CRLF;
 end;

 procedure PrintCalibrTC(caltext:TText);
 begin
  caltext.Text:=caltext.Text
               +Format('%-4s %-6s %-6s %-6s %s',['',    ua,     ta,     d2s(weight(StrToInt(ta))),     '0'])+CRLF
               +Format('%-4s %-6s %-6s %-6s %s',['',    uz,     tz,     d2s(weight(StrToInt(tz))),     '0'])+CRLF
               +Format('%-4s %-6s %-6s %-6s %s',['',    ub,     tb,     d2s(weight(StrToInt(tb))),     '0'])+CRLF;
  sort_kng(caltext,2);
  inc(nc,caltext.Count);
  caltext.Text:=Format('[U(mV)-T(C) calibration]',[])+CRLF
               +Format('FitMethod = Polynom',[])+CRLF
               +Format('TransformX = Line',[])+CRLF
               +Format('TransformY = %s',[id])+CRLF
               +Format('Power = 1',[])+CRLF
               +Format('Center = 0',[])+CRLF
               +Format('Scale = 1',[])+CRLF
               +Format('Fixed = 1',[])+CRLF
               +Format('Coeff[0] = 0',[])+CRLF
               +Format('Coeff[1] = 1',[])+CRLF
               +Format('Bounds = %s %s',[ua,ub])+CRLF
               +Format('%-4s %-6s %-6s %-6s %s',['Data','U(mV)','T(C)','Weight','Tcj(C)'])+CRLF
               +caltext.Text
               +Format('End Data',[])+CRLF
               +Format('Notice Text',[])+CRLF
               +Format('Standard calibration of thermocouple type %s (%s) %s',[tip,mix,alt])+CRLF
               +Format('Reference source: %s',[src])+CRLF
               +Format('Configuration example:',[])+CRLF
               +Format('Link AnalogInput  0 with curve ThermoCoupleVoltage(mV)',[])+CRLF
               +Format('Link AnalogInput  1 with curve TemperatureColdJunction(C)',[])+CRLF
               +Format('Link AnalogOutput 0 with curve TemperatureThermoCouple(C) history 100',[])+CRLF
               +Format('Calibration#0 = ~~\Resource\DaqSite\StdLib\Calibr\%s U(mV) T(C) Tcj(C) Line %s %s %s',[ExtractFileNameExt(calfile),id,ua,ub])+CRLF
               +Format('End Notice Text',[]);
 end;

 procedure Execute(cmd:String);
 var tid:Integer;
 begin
  tid:=task_init(cmd);
  task_wait(tid,-1);
  task_free(tid);
 end;

 function findmod(n:Integer; factor:array of Integer):Integer; overload;
 var i:Integer;
 begin
  Result:=1000000;
  if n<10 then Result:=10 else
  for i:=High(factor) downto Low(factor) do
  if n*10>=Round(factor[i]*numpts) then begin Result:=factor[i]; break; end;
 end;
 function findmod(n:Integer):Integer; overload;
 begin
  Result:=findmod(n,[10,20,25,50,100,200,250,500,1000]);
 end;

begin
 tabtext:=NewText; initext:=NewText; caltext:=NewText;
 try
  //CheckArguments
  if ParamStr(1)='' then Exit;
  if not FileExists(ParamStr(1)) then Exit;
  id:=ParamStr(2);
  tip:=ParamStr(3);
  mix:=ParamStr(4);
  alt:=ParamStr(5);
  obs:=ParamStr(6);
  src:=ParamStr(7);

  //InitVariables
  tz:='0';
  ta:='0';
  tb:='0';
  uz:='0.000';
  ua:='0.000';
  ub:='0.000';
  line:=0;
  step:=0;
  zero:=0;
  mmod:=10000;
  pmod:=10000;
  maxline:=1000000;
  tabfile:=ParamStr(1);
  inifile:=ForceExtension(tabfile,'.INI');
  calfile:=ForceExtension(tabfile,'.CAL');
  //InitializeFiles
  DeleteFiles(inifile+' '+calfile+' '+ReplaceString(calfile,'GOST_TC_','CALC_TC_')+' tab2ini.map tab2ini.cfg');
  tabtext.ReadFile(tabfile);
  np:=0; nm:=0; nc:=0;
  for i:=0 to tabtext.Count-1 do tabtext[i]:=ReplaceString(tabtext[i],',','.');
  for i:=0 to tabtext.Count-1 do tabtext[i]:=ReplaceString(tabtext[i],'','-');
  for i:=0 to tabtext.Count-1 do if StrToIntDef(ExtractWord(1,tabtext[i],ScanSpaces),0)<0 then inc(nm); 
  for i:=0 to tabtext.Count-1 do if StrToIntDef(ExtractWord(1,tabtext[i],ScanSpaces),0)>0 then inc(np);
  mmod:=findmod(nm);
  pmod:=findmod(np);
  for i:=0 to tabtext.Count-1 do ProcessTab(initext,caltext,tabtext[i]);
  Sort_kng(initext,1);
  PrintIniHead(initext);
  PrintIniTail(initext);
  PrintCalibrTC(caltext);
  initext.WriteFile(inifile);
  caltext.WriteFile(calfile);
  for i:=0 to caltext.Count-1 do caltext[i]:=ReplaceString(caltext[i],'GOST_TC_','CALC_TC_');
  caltext.WriteFile(ReplaceString(calfile,'GOST_TC_','CALC_TC_'));
  Execute('unix filecase /u '+inifile);
  Execute('unix filecase /u '+calfile);
  writeln(tabfile,' ',nm,' ',np,' ',mmod,' ',pmod,' ',nc);
 except
  on E:Exception do writeln(E.Message);
 end;
 Kill(tabtext); Kill(initext); Kill(caltext);
end.
