@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:Main
:SetVariables
set HomeDir=%~dp0
for %%i in ("%~dp0.") do set HomeDir=%%~fi
for %%i in ("%~dp0..") do set RootDir=%%~fi
set RootDimSendCommand=%RootDir%\dim\bin\dim_send_command.exe
set RootDimBridge=%RootDir%\dim\bin\dimbridge.exe
set RootDimTree=%RootDir%\dim\bin\dimtree.exe
set RootDimStat=%RootDir%\dim\bin\dimstat.exe
set HomeDimStatGui=%HomeDir%\dimStatGui.lm9
set HomeDimMonitor=%HomeDir%\DimMonitor.lm9
set RootDns=%RootDir%\dim\bin\dns.exe
set RootDid=%RootDir%\dim\bin\did.exe
set RootDim=%RootDir%\dim\bin\dim.dll
set CommonDir=%CommonProgramFiles%\CRW-DAQ\Resource\DimSite
set CommonDimSendCommand=%CommonDir%\dim\bin\dim_send_command.exe
set CommonDimBridge=%CommonDir%\dim\bin\dimbridge.exe
set CommonDimTree=%CommonDir%\dim\bin\dimtree.exe
set CommonDns=%CommonDir%\dim\bin\dns.exe
set CommonDid=%CommonDir%\dim\bin\did.exe
set CommonDim=%CommonDir%\dim\bin\dim.dll
set dnsquery=unix window-command --process dns.exe --class ConsoleWindowClass --print --ign --rex --title .*\dim\bin\dns.exe.*
set dnsquery=unix window-command --process dns.exe --class ConsoleWindowClass --print
set /a ExitCode=0
:CheckArguments
if /I "%~1" == ""            ( call :Help    "%~f0"                        & goto :DoneArguments )
if /I "%~1" == "-h"          ( call :Help    "%~f0"                        & goto :DoneArguments )
if /I "%~1" == "--help"      ( call :Help    "%~f0"                        & goto :DoneArguments )
if /I "%~1" == "--version"   ( call :Version "%~f0"                        & goto :DoneArguments )
if /I "%~1" == "copy"        ( call :CopyDim                               & goto :DoneArguments )
if /I "%~1" == "dns"         ( call :OnDns         %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "did"         ( call :OnDid         %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "tree"        ( call :OnDimTree     %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "dimtree"     ( call :OnDimTree     %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "ports"       ( call :OnDimPorts    %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "dimports"    ( call :OnDimPorts    %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "readme"      ( call :OnReadmeHtm   %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "readme.htm"  ( call :OnReadmeHtm   %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "gui"         ( call :OnDimGui      %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "dimgui"      ( call :OnDimGui      %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "check"       ( call :OnCheckDll    %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "checkdll"    ( call :OnCheckDll    %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "send"        ( call :OnCommand     %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "sendcmd"     ( call :OnCommand     %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "command"     ( call :OnCommand     %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "dimstat"     ( call :OnDimStat     %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "dimstatgui"  ( call :OnDimStatGui  %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "dimstatcli"  ( call :OnDimStatCli  %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "dimmonitor"  ( call :OnDimMonitor  %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "monitor"     ( call :OnDimMonitor  %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "index"       ( call :OnIndexHtml   %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "index.html"  ( call :OnIndexHtml   %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
if /I "%~1" == "homewebsite" ( call :OnHomeWebSite %2 %3 %4 %5 %6 %7 %8 %9 & goto :DoneArguments )
:DoneArguments
goto :Quit
goto :EOF

:Version
echo %~n1 version 1.0.
goto :EOF

:Help
call :Version %1
echo DIM management and control command tool
echo Copyright ^(c^) 2016-2021 Alexey Kuryakin kouriakine@mail.ru
echo.
echo Usage:
echo  %~n1 [opts] args
echo.
echo Options and arguments:
echo.
echo  %~n1 --version      Show version
echo  %~n1 -h,--help      Show help screen
echo  %~n1 copy           Copy local DIM to %CommonProgramFiles%
echo  %~n1 dns oper       Make "oper" operation with DNS.EXE window
echo    oper = exec/open/show/hide/show0..show9/close/stop/quit/kill/state/status
echo  %~n1 did open       Open/exec DID.EXE window
echo  %~n1 tree    open   Open/exec DIMTREE.EXE window
echo  %~n1 dimtree open   Open/exec DIMTREE.EXE window
echo  %~n1 ports    opt   Operate DIM ports Firewall rules
echo  %~n1 dimports opt   Operate DIM ports Firewall rules
echo    opt = show/add/delete DIM TCP/IP rules
echo  %~n1 readme         Open readme.htm help file
echo  %~n1 readme.htm     Open readme.htm help file
echo  %~n1 gui            Open DIM GUI Control window
echo  %~n1 dimgui         Open DIM GUI Control window
echo  %~n1 dimstatcli     Open DimStat utility CLI window
echo  %~n1 dimstatgui     Open DimStat utility GUI window
echo  %~n1 dimstat arg    Exec DimStat utility with arguments (arg)
echo  %~n1 dimmonitor     Run  DimMonitor utility GUI
echo  %~n1 monitor        Run  DimMonitor utility GUI
echo  %~n1 index          Open index.html help file
echo  %~n1 index.html     Open index.html help file
echo  %~n1 homewebsite    Open DIM Home Web Site ^(dim.web.cern.ch^)
echo  %~n1 check          Check _dim.pas external links from dim.dll
echo  %~n1 checkdll       Check _dim.pas external links from dim.dll
echo  %~n1 command args   call dim_send_command cmnd_name [data] [-dns dns_node] [-s] [-i]
echo  %~n1 sendcmd args   call dim_send_command cmnd_name [data] [-dns dns_node] [-s] [-i]
echo  %~n1 send    args   call dim_send_command cmnd_name [data] [-dns dns_node] [-s] [-i]
echo.
echo Example:
echo.
echo  %~n1 copy            = Copy local DIM to %CommonProgramFiles%
echo  %~n1 dns open show   = Open and show DNS.EXE
echo  %~n1 dns exec hide   = Execute and hide DNS.EXE
echo  %~n1 dns show7       = Minimize DNS window
echo  %~n1 dns hide        = Hide     DNS window
echo  %~n1 dns state       = Check DNS.EXE state (status) - running/stopped
echo  %~n1 dns close       = Close    DNS window
echo  %~n1 did exec        = Execute  DID program
echo  %~n1 dimtree open    = Execute  DIMTREE program
echo  %~n1 dimports add    = Add      DIM ports Firewall rules
echo  %~n1 dimports delete = Delete   DIM ports Firewall rules
echo  %~n1 dimports show   = Show     DIM ports Firewall rules
echo.
goto :EOF

:OnDim
if "%~1" == "" goto :EOF
if /I "%~1" == "copy" call :CopyDim
shift /1 & goto :OnDim
goto :EOF

:CopyDim
if /I "%RootDir%" == "%CommonDir%" ( echo Cold not copy to same directory & goto :EOF )
call :XCopy "%RootDir%\*" "%CommonDir%"
goto :EOF

:XCopy
call xcopy /D /S /V /C /I /F /H /R /Y "%~f1" "%~f2" || set /a ExitCode=1
goto :EOF

:CheckCopyDim
call fc /B "%RootDim%" "%CommonDim%" 1>nul 2>nul || call :CopyDim
call fc /B "%RootDns%" "%CommonDns%" 1>nul 2>nul || call :CopyDim
goto :EOF

:OnDid
if "%~1" == "" goto :EOF
if /I "%~1" == "open"  call :ExecDidExe
if /I "%~1" == "exec"  call :ExecDidExe
shift /1 & goto :OnDid
goto :EOF

:OnDimTree
if "%~1" == "" goto :EOF
if /I "%~1" == "open"  call :ExecDimTreeExe
if /I "%~1" == "exec"  call :ExecDimTreeExe
shift /1 & goto :OnDimTree
goto :EOF

:OnDimPorts
if "%~1" == "" goto :EOF
call "%HomeDir%\DimPorts.cmd" %*
goto :EOF

:OnReadmeHtm
start "readme.htm" "%RootDir%\readme.htm" %* || set /a ExitCode=1
goto :EOF

:OnDimGui
call "%HomeDir%\DimGui.cmd" %* || set /a ExitCode=1
goto :EOF

:OnCommand
call "%CommonDimSendCommand%" %* || set /a ExitCode=1
goto :EOF

:OnDimStat
start "%RootDimStat%" "%RootDimStat%" %* || set /a ExitCode=1
goto :EOF

:OnDimStatCli
start "%RootDimStat%" cmd /d /k "%RootDimStat%" %* || set /a ExitCode=1
goto :EOF

:OnDimStatGui
start "%HomeDimStatGui%" "%HomeDimStatGui%" %* || set /a ExitCode=1
goto :EOF

:OnDimMonitor
start "%HomeDimMonitor%" "%HomeDimMonitor%" %* || set /a ExitCode=1
goto :EOF

:OnIndexHtml
start "dim.web.cern.ch" "%RootDir%\dim.web.cern.ch\index.html" %* || set /a ExitCode=1
goto :EOF

:OnHomeWebSite
start "dim.web.cern.ch" "https://dim.web.cern.ch/" %* || set /a ExitCode=1
goto :EOF

:OnDns
if "%~1" == "" goto :EOF
if /I "%~1" == "open"   call :OpenDnsExe
if /I "%~1" == "exec"   call :ExecDnsExe
if /I "%~1" == "show"   call :MakeDnsExe --show1
if /I "%~1" == "hide"   call :MakeDnsExe --show0
if /I "%~1" == "show0"  call :MakeDnsExe --show0
if /I "%~1" == "show1"  call :MakeDnsExe --show1
if /I "%~1" == "show2"  call :MakeDnsExe --show2
if /I "%~1" == "show3"  call :MakeDnsExe --show3
if /I "%~1" == "show4"  call :MakeDnsExe --show4
if /I "%~1" == "show5"  call :MakeDnsExe --show5
if /I "%~1" == "show6"  call :MakeDnsExe --show6
if /I "%~1" == "show7"  call :MakeDnsExe --show7
if /I "%~1" == "show8"  call :MakeDnsExe --show8
if /I "%~1" == "show9"  call :MakeDnsExe --show9
if /I "%~1" == "close"  call :MakeDnsExe --close
if /I "%~1" == "stop"   call :MakeDnsExe --close
if /I "%~1" == "quit"   call :MakeDnsExe --quit
if /I "%~1" == "kill"   call :MakeDnsExe --kill
if /I "%~1" == "status" call :TestDnsStatus
if /I "%~1" == "state"  call :TestDnsStatus
shift /1 & goto :OnDns
goto :EOF

:CheckDnsStatus
set /a pid=0
for /f "tokens=* delims=" %%i in ('call %dnsquery% 2^>nul') do call :ExtractDnsPid %%i
if "%pid%" == "0" ( echo dns.exe is stopped & exit /b 1 )
echo dns.exe is running with PID %pid% & exit /b 0
goto :EOF

:ExtractDnsPid
if "%~3" == "ConsoleWindowClass" if /I "%~8" == "dns.exe" set /a "pid=%~5"
goto :EOF

:TestDnsStatus
call :CheckDnsStatus || set /a ExitCode=1
goto :EOF

:StartOnlyOneShow
if "%~1" == "" goto :EOF
if not exist "%~f1" goto :EOF
for /f "tokens=1" %%i in ('tasklist /nh') do if /i "%%i" == "%~nx1" ( echo %~nx1 is already running. & goto :EOF )
pushd "%~dp1" && ( call unix grun "%~f1" %2 %3 %4 %5 %6 %7 %8 %9 || set /a ExitCode=1 )
popd
goto :EOF

:StartOnlyOneHide
if "%~1" == "" goto :EOF
if not exist "%~f1" goto :EOF
for /f "tokens=1" %%i in ('tasklist /nh') do if /i "%%i" == "%~nx1" ( echo %~nx1 is already running. & goto :EOF )
pushd "%~dp1" && ( call unix grun -h "%~f1" %2 %3 %4 %5 %6 %7 %8 %9 || set /a ExitCode=1 )
popd
goto :EOF

:ExecDnsExe
call :CheckCopyDim
call :StartOnlyOneHide "%CommonDns%" -d
goto :EOF

:OpenDnsExe
call :CheckCopyDim
call :StartOnlyOneShow "%CommonDns%" -d
goto :EOF

:MakeDnsExe
call %dnsquery% %* || set /a ExitCode=1
goto :EOF

:ExecDidExe
call :CheckCopyDim
if not defined DIM_DNS_NODE set DIM_DNS_NODE=localhost
for /f "delims=" %%i in ('unix inputbox -c "Set DIM_DNS_NODE for DID.EXE:" -m "DID.EXE required DIM_DNS_NODE environment variable." -m " " -m "Please enter the DIM_DNS_NODE value:" -d "%DIM_DNS_NODE%" -n DIM_DNS_NODE') do set "%%i"
start "DID" "%CommonDid%" || set /a ExitCode=1
goto :EOF

:ExecDimTreeExe
call :CheckCopyDim
start "DimTree" "%CommonDimTree%" || set /a ExitCode=1
goto :EOF

:OnCheckDll
set /a ngood=0
set /a nfail=0
call :CheckDll "%~dp0..\dim_dcc\_dim.pas" "%~dp0..\dim\bin\dim.dll"
echo.
echo Check _dim.pas external links with dim.dll results:
echo GOOD: %ngood%   FAIL: %nfail%
goto :EOF

:CheckDll
::type %1 | unix grep external | unix sed 's/.*name \''//' | unix sed 's/\''.*//'
for /f "usebackq delims=" %%i in (`type %1 ^| unix grep external ^| unix sed 's/.*name \''//' ^| unix sed 's/\''.*//'`) do call :CheckItem %%i %2
goto :EOF

:CheckItem
::for /f "delims=" %%j in ('unix strings -n 7 %2 ^| unix grep %1') do if "%%~j" == "%~1" goto :CheckGood
for /f "delims=" %%j in ('unix pexports %2 ^| unix grep %1') do if "%%~j" == "%~1" goto :CheckGood
:CheckFail
set /a nfail+=1
echo FAIL: %1
goto :EOF
:CheckGood
set /a ngood+=1
echo GOOD: %1
goto :EOF

:SetErrorLevel
exit /b %1
goto :EOF

:EchoStdErr
1>&2 echo %*
goto :EOF

:Quit
:: Set command exit code
call :EchoStdErr ExitCode=%ExitCode%
exit /b %ExitCode%
