#include <stdio.h>
#include <windows.h>
#include <dim_common.h>
#include <dic.h>

#include "dim_queue.c"

queueHead *dicinfoQueue = NULL; // Queue for info services.

int nolink = -1;                // Marker or "NO LINK" event.

int dicinfoid[3]={0,0,0};
int diccmndid[3]={0,0,0};

long loopcount=0;
unsigned long tickcount=0;

unsigned long tick;
unsigned long lasttick1=0;

void dic_handler(dim_long *tag, int *buffer, int *size)
{
    // Handle disconnection by nolink marker.
    if((*size==sizeof(nolink))&&(*buffer==nolink)) {
     printf("Disconnected tag[%d]\n",*tag);
     return;
    };
    // Take data and push it to queue.
    if((*tag != 0) && (buffer != NULL ) && (size > 0)){
        queue_push(dicinfoQueue,*tag,buffer,*size);
    };
};

main()
{
    queue_tester();
    dicinfoQueue = queue_init();
    dicinfoid[1] = dic_info_service("LOOPCOUNT", "L:1", 10, 0, 0,  dic_handler, 1, &nolink, sizeof(nolink));
    dicinfoid[2] = dic_info_service("TICKCOUNT", "L:1", 10, 0, 0,  dic_handler, 2, &nolink, sizeof(nolink));
    //
    // Main polling loop
    //
    while(1)
    {
        tick=GetTickCount();
        if (tick-lasttick1>=1000){
         loopcount++;
         char cmnd[80];
         strcpy(cmnd,"Sent command 1");
         dic_cmnd_service("SERV_CMND1", cmnd, strlen(cmnd)+1);
         strcpy(cmnd,"Sent command 2");
         dic_cmnd_service("SERV_CMND2", cmnd, strlen(cmnd)+1);
         lasttick1=tick;
        };
        //
        // Handle queue
        //
        while(queue_pop(dicinfoQueue)){
         queueNode *node = queue_node(dicinfoQueue);
         unsigned long data = *node->data.L;
         printf("Data[%d] received[%d]: %d\n",node->tag,node->size,data);
        };
        //
        // Yield  CPU
        //
        Sleep(1);
    };
};
