////////////////////////////////////////////////////////////////////////////////
//                                                                            //
// Copyright (c) 2022 Alexey Kuryakin kouriakine@mail.ru under MIT license.   //
//                                                                            //
// Purpose:                                                                   //
//  DataBase API constants. Derived from ADO etc.                             //
//                                                                            //
// History:                                                                   //
//  20221031 - 1st release                                                    //
//  20221119 - AdoFieldTypeToString                                           //
////////////////////////////////////////////////////////////////////////////////

unit _dbcon; // DataBase Constants

interface

////////////////////////////////////////////////////////////////////////////////
// ADO constants derived from AdoInt.pas with next command:
// type "c:\Program Files\Borland\Delphi5\Source\Vcl\adoint.pas" ^
//   | unix grep -i -e '^\s*ad[_a-zA-Z][_a-zA-Z0-9]*\s*=\s*[\$0-9\-]'  ^
//   | unix gawk '{printf " %%-30s %%s %%-10s\n", $1, $2, $3 }' ^
//   | unix u2d
////////////////////////////////////////////////////////////////////////////////

///////////////////////
// AdoInt.pas constants
///////////////////////
const
 ///////////////////////////////// CursorTypeEnum constants
 adOpenUnspecified              = -1;
 adOpenForwardOnly              = $00000000;
 adOpenKeyset                   = $00000001;
 adOpenDynamic                  = $00000002;
 adOpenStatic                   = $00000003;
 //////////////////////////////// CursorOptionEnum constants
 adHoldRecords                  = $00000100;
 adMovePrevious                 = $00000200;
 adAddNew                       = $01000400;
 adDelete                       = $01000800;
 adUpdate                       = $01008000;
 adBookmark                     = $00002000;
 adApproxPosition               = $00004000;
 adUpdateBatch                  = $00010000;
 adResync                       = $00020000;
 adNotify                       = $00040000;
 adFind                         = $00080000;
 adSeek                         = $00400000;
 adIndex                        = $00800000;
 //////////////////////////////// LockTypeEnum constants
 adLockUnspecified              = -1;
 adLockReadOnly                 = $00000001;
 adLockPessimistic              = $00000002;
 adLockOptimistic               = $00000003;
 adLockBatchOptimistic          = $00000004;
 //////////////////// ExecuteOptionEnum constants
 adOptionUnspecified            = -1;
 adAsyncExecute                 = $00000010;
 adAsyncFetch                   = $00000020;
 adAsyncFetchNonBlocking        = $00000040;
 adExecuteNoRecords             = $00000080;
 //////////////////////////////// ConnectOptionEnum constants
 adConnectUnspecified           = -1;
 adAsyncConnect                 = $00000010;
 //////////////////////////////// ObjectStateEnum constants
 adStateClosed                  = $00000000;
 adStateOpen                    = $00000001;
 adStateConnecting              = $00000002;
 adStateExecuting               = $00000004;
 adStateFetching                = $00000008;
 /////////////////////////////// CursorLocationEnum constants
 adUseNone                      = $00000001;
 adUseServer                    = $00000002;
 adUseClient                    = $00000003;
 adUseClientBatch               = $00000003;
 //////////////////////////////// DataTypeEnum constants
 adEmpty                        = $00000000;
 adTinyInt                      = $00000010;
 adSmallInt                     = $00000002;
 adInteger                      = $00000003;
 adBigInt                       = $00000014;
 adUnsignedTinyInt              = $00000011;
 adUnsignedSmallInt             = $00000012;
 adUnsignedInt                  = $00000013;
 adUnsignedBigInt               = $00000015;
 adSingle                       = $00000004;
 adDouble                       = $00000005;
 adCurrency                     = $00000006;
 adDecimal                      = $0000000E;
 adNumeric                      = $00000083;
 adBoolean                      = $0000000B;
 adError                        = $0000000A;
 adUserDefined                  = $00000084;
 adVariant                      = $0000000C;
 adIDispatch                    = $00000009;
 adIUnknown                     = $0000000D;
 adGUID                         = $00000048;
 adDate                         = $00000007;
 adDBDate                       = $00000085;
 adDBTime                       = $00000086;
 adDBTimeStamp                  = $00000087;
 adBSTR                         = $00000008;
 adChar                         = $00000081;
 adVarChar                      = $000000C8;
 adLongVarChar                  = $000000C9;
 adWChar                        = $00000082;
 adVarWChar                     = $000000CA;
 adLongVarWChar                 = $000000CB;
 adBinary                       = $00000080;
 adVarBinary                    = $000000CC;
 adLongVarBinary                = $000000CD;
 adChapter                      = $00000088;
 adFileTime                     = $00000040;
 adDBFileTime                   = $00000089;
 adPropVariant                  = $0000008A;
 adVarNumeric                   = $0000008B;
 adArray                        = $00002000;
 //////////////////////////////// FieldAttributeEnum constants
 adFldUnspecified               = -1;
 adFldMayDefer                  = $00000002;
 adFldUpdatable                 = $00000004;
 adFldUnknownUpdatable          = $00000008;
 adFldFixed                     = $00000010;
 adFldIsNullable                = $00000020;
 adFldMayBeNull                 = $00000040;
 adFldLong                      = $00000080;
 adFldRowID                     = $00000100;
 adFldRowVersion                = $00000200;
 adFldCacheDeferred             = $00001000;
 adFldNegativeScale             = $00004000;
 adFldKeyColumn                 = $00008000;
 //////////////////////////////// EditModeEnum constants
 adEditNone                     = $00000000;
 adEditInProgress               = $00000001;
 adEditAdd                      = $00000002;
 adEditDelete                   = $00000004;
 //////////////////////////////// RecordStatusEnum constants
 adRecOK                        = $00000000;
 adRecNew                       = $00000001;
 adRecModified                  = $00000002;
 adRecDeleted                   = $00000004;
 adRecUnmodified                = $00000008;
 adRecInvalid                   = $00000010;
 adRecMultipleChanges           = $00000040;
 adRecPendingChanges            = $00000080;
 adRecCanceled                  = $00000100;
 adRecCantRelease               = $00000400;
 adRecConcurrencyViolation      = $00000800;
 adRecIntegrityViolation        = $00001000;
 adRecMaxChangesExceeded        = $00002000;
 adRecObjectOpen                = $00004000;
 adRecOutOfMemory               = $00008000;
 adRecPermissionDenied          = $00010000;
 adRecSchemaViolation           = $00020000;
 adRecDBDeleted                 = $00040000;
 //////////////////////////////// GetRowsOptionEnum constants
 adGetRowsRest                  = -1;
 //////////////////////////////// PositionEnum constants
 adPosUnknown                   = -1;       
 adPosBOF                       = $FFFFFFFE;
 adPosEOF                       = $FFFFFFFD;
 //////////////////////////////// BookmarkEnum constants
 adBookmarkCurrent              = $00000000;
 adBookmarkFirst                = $00000001;
 adBookmarkLast                 = $00000002;
 //////////////////////////////// MarshalOptionsEnum constants
 adMarshalAll                   = $00000000;
 adMarshalModifiedOnly          = $00000001;
 //////////////////////////////// AffectEnum constants
 adAffectCurrent                = $00000001;
 adAffectGroup                  = $00000002;
 adAffectAll                    = $00000003;
 adAffectAllChapters            = $00000004;
 //////////////////////////////// ResyncEnum constants
 adResyncUnderlyingValues       = $00000001;
 adResyncAllValues              = $00000002;
 //////////////////////////////// CompareEnum constants
 adCompareLessThan              = $00000000;
 adCompareEqual                 = $00000001;
 adCompareGreaterThan           = $00000002;
 adCompareNotEqual              = $00000003;
 adCompareNotComparable         = $00000004;
 //////////////////////////////// FilterGroupEnum constants
 adFilterNone                   = $00000000;
 adFilterPendingRecords         = $00000001;
 adFilterAffectedRecords        = $00000002;
 adFilterFetchedRecords         = $00000003;
 adFilterPredicate              = $00000004;
 adFilterConflictingRecords     = $00000005;
 //////////////////////////////// SearchDirectionEnum constants
 adSearchForward                = $00000001;
 adSearchBackward               = -1;
 //////////////////////////////// PersistFormatEnum constants
 adPersistADTG                  = $00000000;
 adPersistXML                   = $00000001;
 //////////////////////////////// StringFormatEnum constants
 adClipString                   = $00000002;
 //////////////////////////////// ConnectPromptEnum constants
 adPromptAlways                 = $00000001;
 adPromptComplete               = $00000002;
 adPromptCompleteRequired       = $00000003;
 adPromptNever                  = $00000004;
 //////////////////////////////// ConnectModeEnum constants
 adModeUnknown                  = $00000000;
 adModeRead                     = $00000001;
 adModeWrite                    = $00000002;
 adModeReadWrite                = $00000003;
 adModeShareDenyRead            = $00000004;
 adModeShareDenyWrite           = $00000008;
 adModeShareExclusive           = $0000000C;
 adModeShareDenyNone            = $00000010;
 //////////////////////////////// IsolationLevelEnum constants
 adXactUnspecified              = -1;
 adXactChaos                    = $00000010;
 adXactReadUncommitted          = $00000100;
 adXactBrowse                   = $00000100;
 adXactCursorStability          = $00001000;
 adXactReadCommitted            = $00001000;
 adXactRepeatableRead           = $00010000;
 adXactSerializable             = $00100000;
 adXactIsolated                 = $00100000;
 //////////////////////////////// XactAttributeEnum constants
 adXactCommitRetaining          = $00020000;
 adXactAbortRetaining           = $00040000;
 adXactAsyncPhaseOne            = $00080000;
 adXactSyncPhaseOne             = $00100000;
 //////////////////////////////// PropertyAttributesEnum constants
 adPropNotSupported             = $00000000;
 adPropRequired                 = $00000001;
 adPropOptional                 = $00000002;
 adPropRead                     = $00000200;
 adPropWrite                    = $00000400;
 //////////////////////////////// ErrorValueEnum constants
 adErrInvalidArgument           = $00000BB9;
 adErrNoCurrentRecord           = $00000BCD;
 adErrIllegalOperation          = $00000C93;
 adErrInTransaction             = $00000CAE;
 adErrFeatureNotAvailable       = $00000CB3;
 adErrItemNotFound              = $00000CC1;
 adErrObjectInCollection        = $00000D27;
 adErrObjectNotSet              = $00000D5C;
 adErrDataConversion            = $00000D5D;
 adErrObjectClosed              = $00000E78;
 adErrObjectOpen                = $00000E79;
 adErrProviderNotFound          = $00000E7A;
 adErrBoundToCommand            = $00000E7B;
 adErrInvalidParamInfo          = $00000E7C;
 adErrInvalidConnection         = $00000E7D;
 adErrNotReentrant              = $00000E7E;
 adErrStillExecuting            = $00000E7F;
 adErrOperationCancelled        = $00000E80;
 adErrStillConnecting           = $00000E81;
 adErrNotExecuting              = $00000E83;
 adErrUnsafeOperation           = $00000E84;
 //////////////////////////////// ParameterAttributesEnum constants
 adParamSigned                  = $00000010;
 adParamNullable                = $00000040;
 adParamLong                    = $00000080;
 //////////////////////////////// ParameterDirectionEnum constants
 adParamUnknown                 = $00000000;
 adParamInput                   = $00000001;
 adParamOutput                  = $00000002;
 adParamInputOutput             = $00000003;
 adParamReturnValue             = $00000004;
 //////////////////////////////// CommandTypeEnum constants
 adCmdUnspecified               = -1;       
 adCmdUnknown                   = $00000008;
 adCmdText                      = $00000001;
 adCmdTable                     = $00000002;
 adCmdStoredProc                = $00000004;
 adCmdFile                      = $00000100;
 adCmdTableDirect               = $00000200;
 //////////////////////////////// EventStatusEnum constants
 adStatusOK                     = $00000001;
 adStatusErrorsOccurred         = $00000002;
 adStatusCantDeny               = $00000003;
 adStatusCancel                 = $00000004;
 adStatusUnwantedEvent          = $00000005;
 //////////////////////////////// EventReasonEnum constants
 adRsnAddNew                    = $00000001;
 adRsnDelete                    = $00000002;
 adRsnUpdate                    = $00000003;
 adRsnUndoUpdate                = $00000004;
 adRsnUndoAddNew                = $00000005;
 adRsnUndoDelete                = $00000006;
 adRsnRequery                   = $00000007;
 adRsnResynch                   = $00000008;
 adRsnClose                     = $00000009;
 adRsnMove                      = $0000000A;
 adRsnFirstChange               = $0000000B;
 adRsnMoveFirst                 = $0000000C;
 adRsnMoveNext                  = $0000000D;
 adRsnMovePrevious              = $0000000E;
 adRsnMoveLast                  = $0000000F;
 //////////////////////////////// SchemaEnum constants
 adSchemaProviderSpecific       = -1;       
 adSchemaAsserts                = $00000000;
 adSchemaCatalogs               = $00000001;
 adSchemaCharacterSets          = $00000002;
 adSchemaCollations             = $00000003;
 adSchemaColumns                = $00000004;
 adSchemaCheckConstraints       = $00000005;
 adSchemaConstraintColumnUsage  = $00000006;
 adSchemaConstraintTableUsage   = $00000007;
 adSchemaKeyColumnUsage         = $00000008;
 adSchemaReferentialConstraints = $00000009;
 adSchemaTableConstraints       = $0000000A;
 adSchemaColumnsDomainUsage     = $0000000B;
 adSchemaIndexes                = $0000000C;
 adSchemaColumnPrivileges       = $0000000D;
 adSchemaTablePrivileges        = $0000000E;
 adSchemaUsagePrivileges        = $0000000F;
 adSchemaProcedures             = $00000010;
 adSchemaSchemata               = $00000011;
 adSchemaSQLLanguages           = $00000012;
 adSchemaStatistics             = $00000013;
 adSchemaTables                 = $00000014;
 adSchemaTranslations           = $00000015;
 adSchemaProviderTypes          = $00000016;
 adSchemaViews                  = $00000017;
 adSchemaViewColumnUsage        = $00000018;
 adSchemaViewTableUsage         = $00000019;
 adSchemaProcedureParameters    = $0000001A;
 adSchemaForeignKeys            = $0000001B;
 adSchemaPrimaryKeys            = $0000001C;
 adSchemaProcedureColumns       = $0000001D;
 adSchemaDBInfoKeywords         = $0000001E;
 adSchemaDBInfoLiterals         = $0000001F;
 adSchemaCubes                  = $00000020;
 adSchemaDimensions             = $00000021;
 adSchemaHierarchies            = $00000022;
 adSchemaLevels                 = $00000023;
 adSchemaMeasures               = $00000024;
 adSchemaProperties             = $00000025;
 adSchemaMembers                = $00000026;
 adSchemaTrustees               = $00000027;
 //////////////////////////////// SeekEnum constants
 adSeekFirstEQ                  = $00000001;
 adSeekLastEQ                   = $00000002;
 adSeekAfterEQ                  = $00000004;
 adSeekAfter                    = $00000008;
 adSeekBeforeEQ                 = $00000010;
 adSeekBefore                   = $00000020;
 //////////////////////////////// ADCPROP_UPDATECRITERIA_ENUM constants
 adCriteriaKey                  = $00000000;
 adCriteriaAllCols              = $00000001;
 adCriteriaUpdCols              = $00000002;
 adCriteriaTimeStamp            = $00000003;
 //////////////////////////////// ADCPROP_ASYNCTHREADPRIORITY_ENUM constants
 adPriorityLowest               = $00000001;
 adPriorityBelowNormal          = $00000002;
 adPriorityNormal               = $00000003;
 adPriorityAboveNormal          = $00000004;
 adPriorityHighest              = $00000005;
 //////////////////////////////// CEResyncEnum constants
 adResyncNone                   = $00000000;
 adResyncAutoIncrement          = $00000001;
 adResyncConflicts              = $00000002;
 adResyncUpdates                = $00000004;
 adResyncInserts                = $00000008;
 adResyncAll                    = $0000000F;
 //////////////////////////////// ADCPROP_AUTORECALC_ENUM constants
 adRecalcUpFront                = $00000000;
 adRecalcAlways                 = $00000001;

function AdoFieldTypeToString(FieldType:Integer):String;

implementation

 // Converts an ADO native types into string related.
function AdoFieldTypeToString(FieldType:Integer):String;
begin
 case FieldType of
  adChar             : Result := 'Char';
  adVarChar          : Result := 'VarChar';
  adBSTR             : Result := 'BSTR';
  adWChar            : Result := 'WChar';
  adVarWChar         : Result := 'VarWChar';
  adBoolean          : Result := 'Boolean';
  adTinyInt          : Result := 'TinyInt';
  adUnsignedTinyInt  : Result := 'UnsignedTinyInt';
  adSmallInt         : Result := 'SmallInt';
  adUnsignedSmallInt : Result := 'UnsignedSmallInt';
  adInteger          : Result := 'Integer';
  adUnsignedInt      : Result := 'UnsignedInt';
  adBigInt           : Result := 'BigInt';
  adUnsignedBigInt   : Result := 'UnsignedBigInt';
  adSingle           : Result := 'Single';
  adDouble           : Result := 'Double';
  adDecimal          : Result := 'Decimal';
  adNumeric          : Result := 'Numeric';
  adVarNumeric       : Result := 'VarNumeric';
  adCurrency         : Result := 'Currency';
  adDBDate           : Result := 'DBDate';
  adDBTime           : Result := 'DBTime';
  adDate             : Result := 'Date';
  adDBTimeStamp      : Result := 'DBTimeStamp';
  adFileTime         : Result := 'FileTime';
  adLongVarChar      : Result := 'LongVarChar';
  adLongVarWChar     : Result := 'LongVarWChar';
  adBinary           : Result := 'Binary';
  adVarBinary        : Result := 'VarBinary';
  adLongVarBinary    : Result := 'LongVarBinary';
  adGUID             : Result := 'GUID';
  adEmpty            : Result := 'Empty';
  adError            : Result := 'Error';
  adArray            : Result := 'Array';
  adChapter          : Result := 'Chapter';
  adIDispatch        : Result := 'IDispatch';
  adIUnknown         : Result := 'IUnknown';
  adPropVariant      : Result := 'PropVariant';
  adUserDefined      : Result := 'UserDefined';
  adVariant          : Result := 'Variant';
  else                 Result := 'Unknown';
 end;
end;

end.
