 {
 ***********************************************************************
 Daq Pascal application program uniheater_select.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 ***********************************************************************
 Программа управляемого выбора (select) каналов для UniHeater.
 Программа копирует данные из AnalogInput(k) в AnalogOutput(i),
 где k=значение тега XXXi, а XXX - значение SelectorPrefix из CFG файла.
 UsesSmoothing=1/0, если надо/не надо использовать сглаживание на входе.
 ***********************************************************************
 20211215 Alexey Kuryakin
 ***********************************************************************
 }
program uniheater_select;        { UniHeater channel selector       }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 nMax              = 255;        { Max. number of outputs to select }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 AoMax             : Integer;    { Max index of AnalogOutputs       }
 SelectorPrefix    : String;     { Selector prefix: TNUM_, PNUM_    }
 tagChNum          : array [0..nmax] of Integer; { Selector tags    }
 UsesSmoothing     : Boolean;    { Uses smoothing or not            }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Clear UniHeater...
 }
 procedure UniHeater_Clear;
 var i:Integer;
 begin
  SelectorPrefix:='';
  for i:=0 to nMax do tagChNum[i]:=0;
 end;
 {
 Initialize UniHeater...
 }
 procedure UniHeater_Init;
 var i,n:Integer;
 begin
  AoMax:=NumAOs-1;
  if (AoMax>nMax) then AoMax:=nMax;
  SelectorPrefix:=ReadIni('SelectorPrefix');
  Success('SelectorPrefix = '+SelectorPrefix);
  UsesSmoothing:=(Val(ReadIni('UsesSmoothing'))<>0);
  n:=0;
  for i:=0 to nMax do begin
   tagChNum[i]:=0;
   if (Length(SelectorPrefix)>0) then tagChNum[i]:=FindTag(SelectorPrefix+Str(i));
   if (TypeTag(tagChNum[i])<>1) then tagChNum[i]:=0;
   if (RefAo(i)=_nil) then tagChNum[i]:=0;
   if (tagChNum[i]<>0) then n:=n+1;
  end;
  if (n=0)
  then Trouble('No channels to select!')
  else Success(Str(n)+' channels to be selected.');
 end;
 {
 Finalize UniHeater...
 }
 procedure UniHeater_Free;
 var i:Integer;
 begin
  for i:=0 to nMax do tagChNum[i]:=0;
 end;
 {
 Poll UniHeater...
 }
 procedure UniHeater_Poll;
 var i,k,nais:Integer; b:Boolean; x,y:Real;
 begin
  nais:=NumAis;
  for i:=0 to AoMax do
  if (tagChNum[i]<>0) then begin
   k:=iGetTag(tagChNum[i]);
   if (k>=0) then
   if (k<nais) then
   if (GetAi_N(k)>0) then begin
    x:=GetAi_Xn(k);
    if UsesSmoothing then y:=GetAi(k,x) else y:=GetAi_Yn(k);
    b:=PutAo(i,x,y);
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  UniHeater_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  UniHeater_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  UniHeater_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  UniHeater_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
