---

[[toc]]

---

# Библиотека StdMenuTools

Библиотека **[StdMenuTools](_fun_stdmenutools.inc)** служит
для добавления стандартных (часто используемых) функций меню **Инструменты**.

---

## Включение библиотеки StdMenuTools

Библиотека не использует (дополнительные) константы и переменные.

Для её включения надо добавить в секции процедур и функций код включения файла:

``` pascal
 {$I _fun_StdMenuTools}          { Standard Menu Tools  functions,  }
```

При этом импортируются функции:

### procedure MenuConsolesStarter;

Процедура запускает "**Меню выбора консольных окон …**".  
Обычно вызывается из меню **Инструменты**.

### procedure MenuConsolesHandler;

Процедура обработки "**Меню выбора консольных окон …**".  
Обычно вызывается в секции обработки результатов редактирования.

### procedure MenuEditProgramStarter;

Процедура запускает "**Открыть программу для редактирования …**".  
Обычно вызывается из меню **Инструменты**.

### procedure MenuEditProgramHandler;

Процедура обработки "**Открыть программу для редактирования …**".  
Обычно вызывается в секции обработки результатов редактирования.

### procedure MenuDeviceRestartStarter;

Процедура запускает "**Перезапустить устройство …**".  
Обычно вызывается из меню **Инструменты**.

### procedure MenuDeviceRestartHandler;

Процедура обработки "**Перезапустить устройство …**".  
Обычно вызывается в секции обработки результатов редактирования.

### function  HasUserAccessLevelTip(aLevel,aCmd:String; aMode,aDelay:Integer):Boolean;

Функция проверки уровня доступа **aLevel** (из набора **Lock**,**Guest**,**User**,**Root**) для команды **aCmd**.  
При отказе в доступе выдается сообщение

- **aMode bit 0** - в консоль устройства,  
- **aMode bit 1** - в главную консоль пакета,  
- **aMode bit 2** - всплывающее сообщение с задержкой **aDelay** ms,  

---

## Использование библиотеки StdMenuTools

Для использования библиотеки помимо её включения надо сделать следующее:

1. Определить переменные - команды в секции определения переменных:

``` pascal
 cmd_MenuConsolesOpen : Integer; { @MenuConsolesOpen                }
 cmd_MenuEditProgramOpen : Integer; { @MenuEditProgramOpen          }
 cmd_MenuDeviceRestartOpen : Integer; { @MenuDeviceRestartOpen      }
```

2. Включить в пункты меню **MenuToolsStarter** фрагмент кода:

``` pascal
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть Консольное Окно …');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@MenuConsolesOpen');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Отредактировать Программу …');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@MenuEditProgramOpen');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезапустить Устройство …');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@MenuDeviceRestartOpen');
```

3. Включить в секции обработки редактирования (после вызова **MenuToolsHandler**) фрагмент кода:

``` pascal
   {
   Menu CONSOLES
   }
   MenuConsolesHandler;
   {
   Menu EDITPROGRAM
   }
   MenuEditProgramHandler;
   {
   Menu DEVICERESTART
   }
   MenuDeviceRestartHandler;
```

4. Включить в коде **InitApplication** код регистрации команд:

``` pascal
  cmd_MenuConsolesOpen:=RegisterStdInCmd('@MenuConsolesOpen','');
  cmd_MenuEditProgramOpen:=RegisterStdInCmd('@MenuEditProgramOpen','');
  cmd_MenuDeviceRestartOpen:=RegisterStdInCmd('@MenuDeviceRestartOpen','');
```

5. Включить в цепочку обработки команд фрагмент кода:

``` pascal
   {
   @MenuConsolesOpen
   }
   if (cmdid=cmd_MenuConsolesOpen) then begin
    MenuConsolesStarter;
    Data:='';
   end else
   {
   @MenuEditProgramOpen
   }
   if (cmdid=cmd_MenuEditProgramOpen) then begin
    if HasUserAccessLevelTip('root',cmd,7,7000) then MenuEditProgramStarter;
    Data:='';
   end else
   {
   @MenuDeviceRestartOpen
   }
   if (cmdid=cmd_MenuDeviceRestartOpen) then begin 
    if HasUserAccessLevelTip('root',cmd,7,7000) then MenuDeviceRestartStarter;
    Data:='';
   end else
```

---

## Пример кода использующего библиотеку StdMenuTools

Смотрите например **[wj300a_main_ctrl.pas](../../../../demo/demo_wj300a/daqpas/wj300a_main_ctrl.pas)**.

---
