 {
 Standard routines for Webs:
 function  WEB_Encrypt(Data,Key:String):String;
 function  WEB_Decrypt(Data,Key:String):String;
 function  WEB_EncryptCookie(Data:String):String;
 function  WEB_DecryptCookie(Data:String):String;
 function  WEB_EncryptAccess(Data:String):String;
 function  WEB_DecryptAccess(Data:String):String;
 function  GrantAccessWeb(User,Host,IP,Password:String):Integer;
 function  WebAccessGranted(Mode:Integer):Integer;
 procedure WEB_Clear;
 procedure WEB_Init;
 procedure WEB_Free;
 function  WEB_StrEscape(s:String):String;
 function  WEB_StrUnescape(s:String):String;
 procedure WEB_Reply(s:String);
 procedure WEB_ReplyText(t:Integer);
 procedure WEB_ReplyEscape(s:String);
 procedure WEB_ReplyTextEscape(t:Integer);
 procedure WEB_ReplyEnd;
 procedure WEB_InitHtmlReply;
 procedure WEB_InitJsonReply;
 function  WEB_GetQueryItem(Name:String; var Item:String):Boolean;
 function  WEB_GetCookieItem(Name:String; var Item:String):Boolean;
 function  WEB_GetContentItem(Name:String; var Item:String):Boolean;
 function  WEB_IsQueryItem(Name,Value:String):Boolean;
 function  WEB_IsCookieItem(Name,Value:String):Boolean;
 function  WEB_IsContentItem(Name,Value:String):Boolean;
 function  WEB_IsRequestMethod(InList:String):Boolean;
 procedure WEB_CopyJsLibrary(Name:String);
 procedure WEB_KillJsLibrary(Name:String);
 procedure WEB_CopyCssLibrary(Name:String);
 procedure WEB_KillCssLibrary(Name:String);
 function  WEB_FormDataPosted:Boolean;
 procedure WEB_MetaContentType(Data:String);
 procedure WEB_MetaRefresh(Period:Integer; Link:String);
 procedure WEB_MetaSetCookie(Name,Data:String);
 procedure WEB_LinkStyleSheet(NameCss:String);
 procedure WEB_AddJavaScript(ScriptName:String);
 procedure WEB_NoScriptWarning(msg:String);
 function  WEB_CheckRequest(Msg:String):Integer;
 function  WEB_ReadJsFromPas(txt:Integer;Section:String):Integer;
 function  WEB_ReadJsFromCfg(txt:Integer;Section:String):Integer;
 procedure JSON_Flush;
 procedure JSON_Write(Data:String);
 procedure JSON_BeginPage;
 procedure JSON_EndPage;
 procedure JSON_AddKey(Key:String);
 procedure JSON_AddKeyStr(Key,Value:String;Separator:Char);
 procedure JSON_AddKeyNum(Key:String;Value:Real;Separator:Char);
 procedure JSON_AddStr(Value:String;Separator:Char);
 procedure JSON_AddNum(Value:Real;Separator:Char);
 procedure JSON_BeginArray;
 procedure JSON_EndArray(Separator:Char);
 procedure JSON_BeginObject;
 procedure JSON_EndObject(Separator:Char);
 procedure ClearStdWebs;
 procedure InitStdWebs;
 procedure FreeStdWebs;
 procedure PollStdWebs;
 }
 {
 Encrypt/decrypt WEB data (password, access table) by WEB.CryptKind method.
 0=CURRENT,1=Blowfish,2=Gost,3=RC2,4=RC4,5=RC5,6=RC6,7=BASE64,8=HEX,9=NONE.
 }
 function WEB_Encrypt(Data,Key:String):String;
 begin
  Cryptographer(Data,Key,True,WEB.CryptKind);
  WEB_Encrypt:=Data;
 end;
 function WEB_Decrypt(Data,Key:String):String;
 begin
  Cryptographer(Data,Key,False,WEB.CryptKind);
  WEB_Decrypt:=Data;
 end;
 function WEB_EncryptCookie(Data:String):String;
 begin
  WEB_EncryptCookie:=WEB_Encrypt(Data,'WEB-Cookie');
 end;
 function WEB_DecryptCookie(Data:String):String;
 begin
  WEB_DecryptCookie:=WEB_Decrypt(Data,'WEB-Cookie');
 end;
 function WEB_EncryptAccess(Data:String):String;
 begin
  WEB_EncryptAccess:=WEB_Encrypt(Data,'WEB-Access');
 end;
 function WEB_DecryptAccess(Data:String):String;
 begin
  WEB_DecryptAccess:=WEB_Decrypt(Data,'WEB-Access');
 end;
 {
 WEB-based grant access function.
 Check if given (User,Host,IP,Password) have access rights.
 Return 0/1/2/3=Deny/Guest/User/Root access level.
 Device should contain "TrustedUsers = [TrustedUsers]" declaration.
 [TrustedUsers] ; Access right table. Use: * = any; . = current
 ;----------------------------------------------------------------
 ;web-x      username    remote_host     remote_addr password
 ;----------------------------------------------------------------
 web-root    root        *               *           expert
 web-user    user        *               *           operator
 web-guest   guest       *               *           *
 ;----------------------------------------------------------------
 []
 }
 function GrantAccessWeb(User,Host,IP,Password:String):Integer;
 var i:Integer; w1,w2,w3,w4,w5:String; g,g1,g2,g3,g4,g5:Integer;
 begin
  g:=acc_Deny;
  w1:='';w2:='';w3:='';w4:='';w5:='';
  if text_NumLn(WEB.TrustedUsers)=0 then begin
   if Length(ReadIni('TrustedUsers'))>0 then begin
    i:=ReadIniSection(WEB.TrustedUsers,16,'',ReadIni('TrustedUsers'));
    for i:=text_numln(WEB.TrustedUsers)-1 downto 0 do
    if IsEmptyStr(text_getln(WEB.TrustedUsers,i))
    then bNul(text_delln(WEB.TrustedUsers,i));
    if text_numln(WEB.TrustedUsers)=0
    then Trouble('TrustedUsers section is empty!');
   end else Trouble('TrustedUsers is not specified!');
  end;
  for i:=0 to text_numln(WEB.TrustedUsers)-1 do
  if WordCount(text_getln(WEB.TrustedUsers,i))=5 then begin
   w1:=ExtractWord(1,text_getln(WEB.TrustedUsers,i));
   g1:=WordIndex(w1,acc_webList);
   if g1>acc_Deny then begin
    w2:=ExtractWord(2,text_getln(WEB.TrustedUsers,i));
    if w2='.' then w2:=ParamStr('UserName');
    g2:=Ord(IsSameText(w2,'*') or IsSameText(w2,User));
    if g2>acc_Deny then begin
     w3:=ExtractWord(3,text_getln(WEB.TrustedUsers,i));
     if w3='.' then w3:=ParamStr('HostName');
     g3:=Ord(IsSameText(w3,'*') or IsSameText(w3,Host));
     if g3>acc_Deny then begin
      w4:=ExtractWord(4,text_getln(WEB.TrustedUsers,i));
      if w4='.' then w4:=ParamStr('IPAddress');
      g4:=Ord(IsSameText(w4,'*') or IsSameText(w4,IP)
           or IsSameText('[::ffff:'+w4+']',IP)
           or IsSameText('::ffff:'+w4,IP));
      if g4>acc_Deny then begin
       w5:=ExtractWord(5,text_getln(WEB.TrustedUsers,i));
       g5:=Ord(IsSameText(w5,'*') or (w5=Password) or
              (Trim(WEB_DecryptAccess(w5))=Password));
      end;
     end;
    end;
   end;
   g:=iMax(g,g1*g2*g3*g4*g5);
  end;
  w1:='';w2:='';w3:='';w4:='';w5:='';
  GrantAccessWeb:=g;
 end;
 {
 Grant access for HTTP request.
 Mode bits are:
 1 - Get username & password from Cookie items.
 }
 function WebAccessGranted(Mode:Integer):Integer;
 begin
  if HasFlags(Mode,1) then begin
   {get username&password from cookies}
   if GetStringVar(WEB.CookieItems,'RemoteUserName',WEB.UserName)
   then WEB.UserName:=Trim(WEB_DecryptCookie(WEB.UserName));
   if GetStringVar(WEB.CookieItems,'RemotePassword',WEB.Password)
   then WEB.Password:=Trim(WEB_DecryptCookie(WEB.Password));
  end;
  WebAccessGranted:=GrantAccessWeb(WEB.UserName,WEB.RemoteHost,WEB.RemoteAddr,WEB.Password);
 end;
 {
 Clear WEB table.
 }
 procedure WEB_Clear;
 begin
  if not Starting then begin
   ClearText(WEB.QueryItems);
   ClearText(WEB.CookieItems);
   ClearText(WEB.ContentItems);
  end;
  WEB.Sender:=0;
  WEB.ReqTime:=0;
  WEB.Request:=0;
  WEB.Reply:=0;
  WEB.QueryCount:=0;
  WEB.CookieCount:=0;
  WEB.ContentCount:=0;
  WEB.GatewayInterface:='';
  WEB.RequestMethod:='';
  WEB.QueryString:='';
  WEB.Content:='';
  WEB.ContentLength:=0;
  WEB.ContentType:='';
  WEB.ServerName:='';
  WEB.ServerPort:=0;
  WEB.ServerProtocol:='';
  WEB.ServerSoftware:='';
  WEB.RemoteHost:='';
  WEB.RemoteAddr:='';
  WEB.ScriptName:='';
  WEB.PathInfo:='';
  WEB.PathTranslated:='';
  WEB.WebSrvName:='';
  WEB.WebSrvSite:='';
  WEB.WebSrvRoot:='';
  WEB.WebSrvPort:=0;
  WEB.WebSrvIndex:='';
  WEB.UserName:='';
  WEB.Password:='';
  WEB.DateTime:='';
  WEB.CustomStr:='';
 end;
 {
 Initialize WEB server.
 }
 procedure WEB_Init;
 begin
  WEB_Clear;
  WEB.CryptKind:=7; { 0=CURRENT,1=Blowfish,2=Gost,3=RC2,4=RC4,5=RC5,6=RC6,7=BASE64,8=HEX,9=NONE. }
  WEB.QueryItems:=text_New;
  WEB.CookieItems:=text_New;
  WEB.ContentItems:=text_New;
  WEB.TrustedUsers:=text_New;
 end;
 {
 Finalize WEB server.
 }
 procedure WEB_Free;
 begin
  WEB_Clear;
  bNul(text_Free(WEB.QueryItems));
  bNul(text_Free(WEB.CookieItems));
  bNul(text_Free(WEB.ContentItems));
  bNul(text_Free(WEB.TrustedUsers));
  WEB.QueryItems:=0;
  WEB.CookieItems:=0;
  WEB.ContentItems:=0;
  WEB.TrustedUsers:=0;
 end;
 {
 Escape string, i.e. replace <,>,& to &lt;,&gt;,&amp;.
 }
 function WEB_StrEscape(s:String):String;
 begin
  if Length(s)>0 then begin
   s:=StrReplace(s,Dump('<'),'&lt;',3);
   s:=StrReplace(s,Dump('>'),'&gt;',3);
   s:=StrReplace(s,Dump('&'),'&amp;',3);
  end;
  WEB_StrEscape:=s;
 end;
 {
 Unescape string, i.e. replace &lt;,&gt;,&amp; to <,>,&.
 }
 function WEB_StrUnescape(s:String):String;
 begin
  if Length(s)>0 then begin
   s:=StrReplace(s,'&lt;',Dump('<'),3);
   s:=StrReplace(s,'&gt;',Dump('>'),3);
   s:=StrReplace(s,'&amp;',Dump('&'),3);
  end;
  WEB_StrUnescape:=s;
 end;
 {
 Add string to WEB.Reply text.
 }
 procedure WEB_Reply(s:String);
 begin
  bNul(text_Addln(WEB.Reply,s));
 end;
 {
 Add text t to WEB.Reply text.
 }
 procedure WEB_ReplyText(t:Integer);
 var i:Integer;
 begin
  if t<>0 then for i:=0 to text_NumLn(t)-1 do bNul(text_Addln(WEB.Reply,text_GetLn(t,i)));
 end;
 {
 Add escaped string to WEB.Reply text.
 }
 procedure WEB_ReplyEscape(s:String);
 begin
  bNul(text_Addln(WEB.Reply,WEB_StrEscape(s)));
 end;
 {
 Add text t to WEB.Reply text.
 }
 procedure WEB_ReplyTextEscape(t:Integer);
 var i:Integer;
 begin
  if t<>0 then for i:=0 to text_NumLn(t)-1 do bNul(text_Addln(WEB.Reply,WEB_StrEscape(text_GetLn(t,i))));
 end;
 {
 Add "end of reply" marker to WEB.Reply text.
 }
 procedure WEB_ReplyEnd;
 begin
  WEB_Reply(Dump(0));
 end;
 {
 Init HTTP headers for HTML content type.
 }
 procedure WEB_InitHtmlReply;
 begin
  ClearText(WEB.Reply);
  WEB_Reply('Content-Type: text/html; charset=UTF-8');
  WEB_Reply('Cache-Control: no-cache, no-store, must-revalidate');
  WEB_Reply('Pragma: no-cache');
  WEB_Reply('');
 end;
 {
 Init HTTP headers for JSON content type, instead of default HTML.
 }
 procedure WEB_InitJsonReply;
 begin
  ClearText(WEB.Reply);
  WEB_Reply('Content-Type: application/json; charset=UTF-8');
  WEB_Reply('Cache-Control: no-cache, no-store, must-revalidate');
  WEB_Reply('Pragma: no-cache');
  WEB_Reply('');
 end;
 {
 Get HTTP query item by name.
 }
 function WEB_GetQueryItem(Name:String; var Item:String):Boolean;
 begin
  WEB_GetQueryItem:=GetStringVar(WEB.QueryItems,Name,Item);
 end;
 {
 Get HTTP cookie item by name.
 }
 function WEB_GetCookieItem(Name:String; var Item:String):Boolean;
 begin
  WEB_GetCookieItem:=GetStringVar(WEB.CookieItems,Name,Item);
 end;
 {
 Get HTTP content item by name.
 }
 function WEB_GetContentItem(Name:String; var Item:String):Boolean;
 begin
  WEB_GetContentItem:=GetStringVar(WEB.ContentItems,Name,Item);
 end;
 {
 Test if HTTP query item Name is Value.
 }
 function WEB_IsQueryItem(Name,Value:String):Boolean;
 begin
  if WEB_GetQueryItem(Name,Name)
  then WEB_IsQueryItem:=IsSameText(Name,Value)
  else WEB_IsQueryItem:=False;
 end;
 {
 Test if HTTP cookie item Name is Value.
 }
 function WEB_IsCookieItem(Name,Value:String):Boolean;
 begin
  if WEB_GetCookieItem(Name,Name)
  then WEB_IsCookieItem:=IsSameText(Name,Value)
  else WEB_IsCookieItem:=False;
 end;
 {
 Test if HTTP content item Name is Value.
 }
 function WEB_IsContentItem(Name,Value:String):Boolean;
 begin
  if WEB_GetContentItem(Name,Name)
  then WEB_IsContentItem:=IsSameText(Name,Value)
  else WEB_IsContentItem:=False;
 end;
 {
 Check if WEB request method is in List, for example,
 if WEB_IsRequestMethod('Get,Post') then ViewPage else ErrorPage;
 }
 function WEB_IsRequestMethod(InList:String):Boolean;
 begin
  WEB_IsRequestMethod:=(WordIndex(WEB.RequestMethod,InList)>0);
 end;
 {
 Copy JavaScript library from Resource to local site.
 Special name Dump('.') means all existing libraries.
 }
 procedure WEB_CopyJsLibrary(Name:String);
 var code:Integer; src,dst:String;
 begin
  src:=''; dst:='';
  if not IsEmptyStr(Name) then begin
   src:=DaqFileRef(AdaptFileName('~~\Resource\Tools\JavaScript\'+Name),'');
   dst:=DaqFileRef(AdaptFileName('..\Utility\JavaScript\'+Name),'');
   if IsWindows and DirExists(src) and MkDir(dst) then begin
    code:=ExecuteProcessSafe(GetComSpec,'/c xcopy /Y /V /C /I /S /H /D "'+src+'" "'+dst+'"','Display=0',3000);
    if (code=0) then Success('copy '+src+' -> '+dst) else Problem('copy '+src+' -> '+dst);
   end;
   if IsUnix and DirExists(src) and MkDir(dst) then begin
    code:=ExecuteProcessSafe('cp','-frv '+src+' '+dst+'/..','Display=0',3000);
    if (code=0) then Success('copy '+src+' -> '+dst) else Problem('copy '+src+' -> '+dst);
   end;
  end;
  src:=''; dst:='';
 end;
 {
 Kill (remove) local copy of JavaScript library.
 Special name Dump('.') means all existing libraries.
 }
 procedure WEB_KillJsLibrary(Name:String);
 var code:Integer; dst:String;
 begin
  dst:='';
  if not IsEmptyStr(Name) then begin
   dst:=DaqFileRef(AdaptFileName('..\Utility\JavaScript\'+Name),'');
   if IsWindows and DirExists(dst) then begin
    code:=ExecuteProcessSafe(GetComSpec,'/c rmdir /S /Q "'+dst+'"','Display=0',3000);
    if (code=0) then Success('delete '+dst) else Problem('delete '+dst);
   end;
   if IsUnix and DirExists(dst) then begin
    code:=ExecuteProcessSafe('rm','-fr '+dst,'Display=0',3000);
    if (code=0) then Success('delete '+dst) else Problem('delete '+dst);
   end;
  end;
  dst:='';
 end;
 {
 Copy StyleSheet library from Resource to local site.
 Special name Dump('.') means all existing libraries.
 }
 procedure WEB_CopyCssLibrary(Name:String);
 var code:Integer; src,dst:String;
 begin
  src:=''; dst:='';
  if not IsEmptyStr(Name) then begin
   src:=DaqFileRef(AdaptFileName('~~\Resource\Tools\StyleSheet\'+Name),'');
   dst:=DaqFileRef(AdaptFileName('..\Utility\StyleSheet\'+Name),'');
   if IsWindows and DirExists(src) and MkDir(dst) then begin
    code:=ExecuteProcessSafe(GetComSpec,'/c xcopy /Y /V /C /I /S /H /D "'+src+'" "'+dst+'"','Display=0',3000);
    if (code=0) then Success('copy '+src+' -> '+dst) else Problem('copy '+src+' -> '+dst);
   end;
   if IsUnix and DirExists(src) and MkDir(dst) then begin
    code:=ExecuteProcessSafe('cp','-frv '+src+' '+dst+'/..','Display=0',3000);
    if (code=0) then Success('copy '+src+' -> '+dst) else Problem('copy '+src+' -> '+dst);
   end;
  end;
  src:=''; dst:='';
 end;
 {
 Kill (remove) local copy of StyleSheet library.
 Special name Dump('.') means all existing libraries.
 }
 procedure WEB_KillCssLibrary(Name:String);
 var code:Integer; dst:String;
 begin
  dst:='';
  if not IsEmptyStr(Name) then begin
   dst:=DaqFileRef(AdaptFileName('..\Utility\StyleSheet\'+Name),'');
   if IsWindows and DirExists(dst) then begin
    code:=ExecuteProcessSafe(GetComSpec,'/c rmdir /S /Q "'+dst+'"','Display=0',3000);
    if (code=0) then Success('delete '+dst) else Problem('delete '+dst);
   end;
   if IsUnix and DirExists(dst) then begin
    code:=ExecuteProcessSafe('rm','-fr '+dst,'Display=0',3000);
    if (code=0) then Success('delete '+dst) else Problem('delete '+dst);
   end;
  end;
  dst:='';
 end;
 {
 Return true if some data posted from HTML form.
 }
 function WEB_FormDataPosted:Boolean;
 begin
  WEB_FormDataPosted:=IsSameText(WEB.RequestMethod,'Post') and 
                      IsSameText(WEB.ContentType,'application/x-www-form-urlencoded');
 end;
 {
 Set meta tags to set Content-Type.
 }
 procedure WEB_MetaContentType(Data:String);
 begin
  Data:=TrimDef(Data,'text/html; charset=utf-8');
  WEB_Reply('<meta http-equiv="Content-Type" content="'+Data+'" />');
 end;
 {
 Set meta tags to refresh site.
 }
 procedure WEB_MetaRefresh(Period:Integer; Link:String);
 begin
  WEB_Reply('<meta http-equiv="Cache-Control" content="no-cache">');
  WEB_Reply('<meta http-equiv="Pragma" content="no-cache">');
  if Period>=0 then begin
   if Length(Link)>0 then Link:=','+Link;
   WEB_Reply('<meta http-equiv="Refresh" content="'+Str(Period)+Link+'">');
  end;
 end;
 {
 Set meta tag Set-Cookie Name=Value.
 }
 procedure WEB_MetaSetCookie(Name,Data:String);
 begin
  if Length(Name)>0 then // It's obsolete and will ignored in HTML5.
  WEB_Reply('<meta http-equiv="Set-Cookie" content="'+Name+'='+Data+'">');
  if Length(Name)>0 then // See https://learn.javascript.ru/cookie
  WEB_Reply('<script>document.cookie="'+Name+'='+Data+'";</script>');
 end; 
 {
 Set meta Style - link to CSS file.
 }
 procedure WEB_LinkStyleSheet(NameCss:String);
 begin
  if Length(NameCss)>0 then
  WEB_Reply('<link rel="StyleSheet" href="'+NameCss+'" type="text/css">');
 end;
 {
 Add Java Script (js) link to header.
 }
 procedure WEB_AddJavaScript(ScriptName:String);
 begin
  WEB_Reply('<script language="javascript" type="text/javascript" src="'
           +ScriptName+'"></script>');
 end;
 {
 Show warning on Java Script disabled.
 }
 procedure WEB_NoScriptWarning(msg:String);
 begin
  WEB_Reply('<noscript>');
  if IsSameText(msg,'en') then begin
   WEB_Reply('<div style="background:yellow; width:100%; text-align:center;">');
   WEB_Reply('<span class="huge red bold">Attansion!</span><br>');
   WEB_Reply('<span class="huge blue bold">Java Script disabled!</span><br>');
   WEB_Reply('<span class="huge black bold">Enable Java Script!</span><br>');
   WEB_Reply('</div>');
  end else
  if IsSameText(msg,'ru') or (Length(msg)=0) then begin
   WEB_Reply('<div style="background:yellow; width:100%; text-align:center;">');
   WEB_Reply('<span class="huge red bold">Внимание!</span><br>');
   WEB_Reply('<span class="huge blue bold">Отключен Java Script!</span><br>');
   WEB_Reply('<span class="huge black bold">Включите Java Script!</span><br>');
   WEB_Reply('</div>');
  end else
  if Length(msg)>0 then WEB_Reply(msg);
  WEB_Reply('</noscript>');
 end;
 {
 Check @HTTP_REQUEST_ACCEPTED=ArgList message.
 ArgList is Sender,RequestTime,RequestText,ReplyText.
 Client should analyse RequestText, and put HTML page
 to ReplyText. Last line of ReplyText should be dump(0).
 Return status code is:
  HTTP_REQUEST_OK
  HTTP_REQUEST_NO 
  HTTP_REQUEST_BAD
 }
 function WEB_CheckRequest(Msg:String):Integer;
 var cmd,arg:String; i,j,p,Status:Integer;
 begin
  cmd:='';
  arg:='';
  WEB_Clear;
  Msg:=Trim(Msg);
  Status:=HTTP_REQUEST_NO;
  if IsSameText(ExtractWord(1,Msg),HTTP_REQUEST_ACCEPTED_CMD) then begin
   WEB.Sender:=RefFind('Device '+ExtractWord(2,Msg));
   WEB.ReqTime:=rVal(ExtractWord(3,Msg));
   WEB.Request:=Val(ExtractWord(4,Msg));
   WEB.Reply:=Val(ExtractWord(5,Msg));
   if IsSameText(RefInfo(WEB.Sender,'Type'),'Device') and
      IsSameText(RefInfo(WEB.Request,'Type'),'Text') and
      IsSameText(RefInfo(WEB.Reply,'Type'),'Text') and
      not IsNaN(WEB.ReqTime) and not IsInf(WEB.ReqTime)
   then begin
    WEB.DateTime:=GetDateTime(mSecNow);
    for i:=0 to text_NumLn(WEB.Request)-1 do begin
     p:=Pos('=',text_GetLn(WEB.Request,i));
     cmd:=Copy(text_GetLn(WEB.Request,i),1,p-1);
     arg:=Copy(text_GetLn(WEB.Request,i),p+1);
     if IsSameText(cmd,'QUERY.COUNT') then begin
      WEB.QueryCount:=Val(arg);
      for j:=0 to WEB.QueryCount-1 do bNul(text_Addln(WEB.QueryItems,''));
     end;
     for j:=0 to WEB.QueryCount-1 do
     if IsSameText(cmd,'QUERY.ITEM'+Str(j)) then bNul(text_PutLn(WEB.QueryItems,j,arg));
     if IsSameText(cmd,'COOKIE.COUNT') then begin
      WEB.CookieCount:=Val(arg);
      for j:=0 to WEB.CookieCount-1 do bNul(text_Addln(WEB.CookieItems,''));
     end;
     for j:=0 to WEB.CookieCount-1 do
     if IsSameText(cmd,'COOKIE.ITEM'+Str(j)) then bNul(text_PutLn(WEB.CookieItems,j,arg));
     if IsSameText(cmd,'CONTENT.COUNT') then begin
      WEB.ContentCount:=Val(arg);
      for j:=0 to WEB.ContentCount-1 do bNul(text_Addln(WEB.ContentItems,''));
     end;
     for j:=0 to WEB.ContentCount-1 do
     if IsSameText(cmd,'CONTENT.ITEM'+Str(j)) then bNul(text_PutLn(WEB.ContentItems,j,arg));
     if IsSameText(cmd,'GATEWAY_INTERFACE') then WEB.GatewayInterface:=arg;
     if IsSameText(cmd,'QUERY_STRING') then WEB.QueryString:=arg;
     if IsSameText(cmd,'REQUEST_METHOD') then WEB.RequestMethod:=arg;
     if IsSameText(cmd,'CONTENT') then WEB.Content:=arg;
     if IsSameText(cmd,'CONTENT_LENGTH') then WEB.ContentLength:=Val(arg);
     if IsSameText(cmd,'CONTENT_TYPE') then WEB.ContentType:=arg;
     if IsSameText(cmd,'SERVER_NAME') then WEB.ServerName:=arg;
     if IsSameText(cmd,'SERVER_PORT') then WEB.ServerPort:=Val(arg);
     if IsSameText(cmd,'SERVER_PROTOCOL') then WEB.ServerProtocol:=arg;
     if IsSameText(cmd,'SERVER_SOFTWARE') then WEB.ServerSoftware:=arg;
     if IsSameText(cmd,'REMOTE_HOST') then WEB.RemoteHost:=arg;
     if IsSameText(cmd,'REMOTE_ADDR') then WEB.RemoteAddr:=arg;
     if IsSameText(cmd,'SCRIPT_NAME') then WEB.ScriptName:=arg;
     if IsSameText(cmd,'PATH_INFO') then WEB.PathInfo:=arg;
     if IsSameText(cmd,'PATH_TRANSLATED') then WEB.PathTranslated:=arg;
     if IsSameText(cmd,'WEBSRV.NAME') then WEB.WebSrvName:=arg;
     if IsSameText(cmd,'WEBSRV.SITE') then WEB.WebSrvSite:=arg;
     if IsSameText(cmd,'WEBSRV.ROOT') then WEB.WebSrvRoot:=arg;
     if IsSameText(cmd,'WEBSRV.PORT') then WEB.WebSrvPort:=Val(arg);
     if IsSameText(cmd,'WEBSRV.INDEX') then WEB.WebSrvIndex:=arg;
    end;
    if DebugFlagEnabled(dfViewImp) then begin
     ViewImp('CGI: QUERY.COUNT='+Str(WEB.QueryCount));
     for j:=0 to WEB.QueryCount-1 do ViewImp('QUERY.ITEM'+Str(j)+'='+text_GetLn(WEB.QueryItems,j));
     ViewImp('CGI: COOKIE.COUNT='+Str(WEB.CookieCount));
     for j:=0 to WEB.CookieCount-1 do ViewImp('COOKIE.ITEM'+Str(j)+'='+text_GetLn(WEB.CookieItems,j));
     ViewImp('CGI: CONTENT.COUNT='+Str(WEB.ContentCount));
     for j:=0 to WEB.ContentCount do ViewImp('CONTENT.ITEM'+Str(j)+'='+text_GetLn(WEB.ContentItems,j));
     ViewImp('CGI: GATEWAY_INTERFACE='+WEB.GatewayInterface);
     ViewImp('CGI: QUERY_STRING='+WEB.QueryString);
     ViewImp('CGI: REQUEST_METHOD='+WEB.RequestMethod);
     ViewImp('CGI: CONTENT='+WEB.Content);
     ViewImp('CGI: CONTENT_LENGTH='+Str(WEB.ContentLength));
     ViewImp('CGI: CONTENT_TYPE='+WEB.ContentType);
     ViewImp('CGI: SERVER_NAME='+WEB.ServerName);
     ViewImp('CGI: SERVER_PORT='+Str(WEB.ServerPort));
     ViewImp('CGI: SERVER_PROTOCOL='+WEB.ServerProtocol);
     ViewImp('CGI: SERVER_SOFTWARE='+WEB.ServerSoftware);
     ViewImp('CGI: REMOTE_HOST='+WEB.RemoteHost);
     ViewImp('CGI: REMOTE_ADDR='+WEB.RemoteAddr);
     ViewImp('CGI: SCRIPT_NAME='+WEB.ScriptName);
     ViewImp('CGI: PATH_INFO='+WEB.PathInfo);
     ViewImp('CGI: PATH_TRANSLATED='+WEB.PathTranslated);
     ViewImp('CGI: WEBSRV.NAME='+WEB.WebSrvName);
     ViewImp('CGI: WEBSRV.SITE='+WEB.WebSrvSite);
     ViewImp('CGI: WEBSRV.ROOT='+WEB.WebSrvRoot);
     ViewImp('CGI: WEBSRV.PORT='+Str(WEB.WebSrvPort));
     ViewImp('CGI: WEBSRV.INDEX='+WEB.WebSrvIndex);
     ViewImp('CGI: DATETIME='+WEB.DateTime);
    end;
    {
    Now WEB structure ready to use
    We should use Request information, add HTML
    page text and dump(0) as end-marker to Reply.
    }
    Status:=HTTP_REQUEST_OK;
   end else Status:=HTTP_REQUEST_BAD;
  end;
  cmd:='';
  arg:='';
  WEB_CheckRequest:=Status;
 end;
 {
 Read JavaScript embedded into DaqPascal source file section.
 }
 function WEB_ReadJsFromPas(txt:Integer;Section:String):Integer;
 begin
  WEB_ReadJsFromPas:=ReadIniSection(txt,0,DaqFileRef(AdaptFileName(ReadIni('ProgramSource')),'.pas'),Section);
 end;
 {
 Read JavaScript embedded into DaqConfig source file section.
 }
 function WEB_ReadJsFromCfg(txt:Integer;Section:String):Integer;
 begin
  WEB_ReadJsFromCfg:=ReadIniSection(txt,0,ParamStr('DaqConfigFile'),Section);
 end;
 {
 Flush and clear JSON buffer;
 }
 procedure JSON_Flush;
 begin
  if Length(JSON_Buffer)>0 then WEB_Reply(JSON_Buffer);
  JSON_Buffer:=_Space;
 end;
 {
 Write Data to JSON buffer. Flush if needed.
 }
 procedure JSON_Write(Data:String);
 begin
  JSON_Buffer:=JSON_Buffer+Data;
  if Length(JSON_Buffer)>JSON_BufferMax then JSON_Flush;
 end;
 {
 Begin JSON web page;
 }
 procedure JSON_BeginPage;
 begin
  JSON_Buffer:='';
  WEB_InitJsonReply;
  JSON_Write(Dump('{'));
  JSON_Flush;
 end;
 {
 End JSON web page;
 }
 procedure JSON_EndPage;
 begin
  JSON_Flush; JSON_Buffer:='';
  JSON_Write(Dump('}'));
  JSON_Flush; JSON_Buffer:='';
  WEB_ReplyEnd;
 end;
 {
 Add key as "Key": (the value is expected).
 }
 procedure JSON_AddKey(Key:String);
 begin
  JSON_Write('"'+Key+'": ');
 end;
 {
 Add pair key: string as "Key": "Value" and Separator, _Comma or _Space.
 }
 procedure JSON_AddKeyStr(Key,Value:String;Separator:Char);
 begin
  if Separator=_Comma
  then JSON_Write('"'+Key+'": "'+Value+'"'+Separator+_Space)
  else JSON_Write('"'+Key+'": "'+Value+'"'+_Space);
 end;
 {
 Add pair key: number as "Name": Value and Separator, _Comma or _Space.
 }
 procedure JSON_AddKeyNum(Key:String;Value:Real;Separator:Char);
 begin
  if Separator=_Comma
  then JSON_Write('"'+Key+'": '+Str(Value)+Separator+_Space)
  else JSON_Write('"'+Key+'": '+Str(Value)+_Space);
 end;
 {
 Add string "Value" and Separator, _Comma  or _Space.
 }
 procedure JSON_AddStr(Value:String;Separator:Char);
 begin
  if Separator=_Comma
  then JSON_Write('"'+Value+'"'+Separator+_Space)
  else JSON_Write('"'+Value+'"'+_Space);
 end;
 {
 Add numerical Value and separator, _Comma or _Space.
 }
 procedure JSON_AddNum(Value:Real;Separator:Char);
 begin
  if Separator=_Comma
  then JSON_Write(Str(Value)+Separator+_Space)
  else JSON_Write(Str(Value)+_Space);
 end;
 {
 Begin array as [ .
 }
 procedure JSON_BeginArray;
 begin
  JSON_Write('[ ');
 end;
 {
 End array as ] and Separator, _Comma or _Space.
 }
 procedure JSON_EndArray(Separator:Char);
 begin
  if Separator=_Comma
  then JSON_Write(Dump(']')+Separator+_Space)
  else JSON_Write(Dump(']')+_Space);
 end;
 (*
 Begin object as { .
 *)
 procedure JSON_BeginObject;
 begin
  JSON_Write('{ ');
 end;
 (*
 End object as } and Separator, _Comma or _Space.
 *)
 procedure JSON_EndObject(Separator:Char);
 begin
  if Separator=_Comma
  then JSON_Write(Dump('}')+Separator+_Space)
  else JSON_Write(Dump('}')+_Space);
 end;
 {
 Clear standard Webs.
 }
 procedure ClearStdWebs;
 begin
  WEB_Clear;
  JSON_Buffer:='';
 end;
 {
 Initialize standard Webs.
 }
 procedure InitStdWebs;
 begin
  WEB_Init;
  JSON_Buffer:='';
  JSON_BufferMax:=64;
  ShouldPollStdWebs:=false;
 end;
 {
 Finalize standard Webs.
 }
 procedure FreeStdWebs;
 begin
  JSON_Buffer:='';
  WEB_Free;
 end;
 {
 Poll standard Webs.
 }
 procedure PollStdWebs;
 begin
 end;
