 {
 procedure MenuConsolesStarter;
 procedure MenuConsolesHandler;
 procedure MenuEditProgramStarter;
 procedure MenuEditProgramHandler;
 procedure MenuDeviceRestartStarter;
 procedure MenuDeviceRestartHandler;
 function  HasUserAccessLevelTip(aLevel,aCmd:String; aMode,aDelay:Integer):Boolean;
 }
 {
 Menu CONSOLES Starter to start editing
 }
 procedure MenuConsolesStarter;
 var n,i,dev:Integer;
 begin
  i:=0;
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню выбора консольных окон …');
   n:=n+EditAddInputLn('Выберите консольное окно:');
   //////////////////////////////////////////
   repeat
    dev:=DeviceListEnum(i);
    if IsSameText(ParamStr('DEVICEMODEL '+Str(i)),'Program') then begin
     n:=n+EditAddInputLn('КОНСОЛЬ '+RefInfo(dev,'Name'));
     n:=n+EditAddConfirm('');
     n:=n+EditAddCommand('@OpenConsole '+RefInfo(dev,'Name'));
    end;
    i:=i+1;
   until dev=0;
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CONSOLES'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu CONSOLES handler to handle editing
 }
 procedure MenuConsolesHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CONSOLES'));
 end;
 {
 Menu EDITPROGRAM Starter to start editing
 }
 procedure MenuEditProgramStarter;
 var n,i,dev:Integer;
 begin
  i:=0;
  if EditStateReady then begin
   n:=0+EditAddOpening('Открыть программу для редактирования …');
   n:=n+EditAddInputLn('Выберите программу:');
   //////////////////////////////////////////
   repeat
    dev:=DeviceListEnum(i);
    if IsSameText(ParamStr('DEVICEMODEL '+Str(i)),'Program') then begin
     n:=n+EditAddInputLn('Редактировать '+RefInfo(dev,'Name'));
     n:=n+EditAddConfirm('');
     n:=n+EditAddCommand('@SysEval @system @daq openeditor '+RefInfo(dev,'Name'));
    end;
    i:=i+1;
   until dev=0;
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_EDITPROGRAM'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu EDITPROGRAM handler to handle editing
 }
 procedure MenuEditProgramHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_EDITPROGRAM'));
 end;
 {
 Menu DEVICERESTART Starter to start editing
 }
 procedure MenuDeviceRestartStarter;
 var n,i,dev:Integer;
 begin
  i:=0;
  if EditStateReady then begin
   n:=0+EditAddOpening('Перезапустить устройство …');
   n:=n+EditAddInputLn('Выберите устройство для перезапуска:');
   //////////////////////////////////////////
   repeat
    dev:=DeviceListEnum(i);
    if IsSameText(ParamStr('DEVICEMODEL '+Str(i)),'Program') then begin
     n:=n+EditAddInputLn('Перезапустить '+RefInfo(dev,'Name'));
     n:=n+EditAddConfirm(EditGetLastInputLn);
     n:=n+EditAddCommand('@SysEval @system @async @compile device '+RefInfo(dev,'Name'));
    end;
    i:=i+1;
   until dev=0;
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_DEVICERESTART'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu DEVICERESTART handler to handle editing
 }
 procedure MenuDeviceRestartHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_DEVICERESTART'));
 end;
 {
 Check is User has access level and show tooltip.
 }
 function HasUserAccessLevelTip(aLevel,aCmd:String; aMode,aDelay:Integer):Boolean;
 var cond:Boolean; msg,tip:String;
  procedure Cleanup;
  begin
   msg:=''; tip:='';
  end;
 begin
  Cleanup;
  cond:=False;
  if guard_check(aLevel)>=0 then cond:=True else begin
    msg:=RusEngStr('Запрещено для текущего уровня доступа ','Denied for current access level ')+ParamStr('Guard')+'!';
   if not IsEmptyStr(aCmd) then msg:=Trim(aCmd)+' - '+msg;
   if HasFlags(aMode,1) then Problem(msg);
   if HasFlags(aMode,2) then rNul(eval('@system @async @silent @echo '+GetDateTime(mSecNow)+' => '+DevName+' : '+msg));
   if HasFlags(aMode,4) and (aDelay>0) then begin
    tip:='guid guard:'+Str(getpid)
        +' text '+AnsiQuotedStr(msg,QuoteMark)
        +' preset stdDeny delay '+Str(aDelay);
   end;
   if (tip<>'') then ShowTooltip(tip);
  end;
  HasUserAccessLevelTip:=cond;
  Cleanup;
 end;
