 {
 Standard routines for Errors:
 function  Starting:Boolean;
 function  Stopping:Boolean;
 function  Polling:Boolean;
 procedure PostStartingDevMsg;
 procedure PostStoppingDevMsg;
 function  CompareGuards(g1,g2:String):Integer;
 procedure cNul(c:Char);
 procedure bNul(b:Boolean);
 procedure iNul(i:Integer);
 procedure rNul(r:Real);
 procedure sNul(s:String);
 function  IsRefTag(ref:Integer):Boolean;
 function  IsRefCurve(ref:Integer):Boolean;
 function  IsRefDevice(ref:Integer):Boolean;
 function  IsRefWindow(ref:Integer):Boolean;
 function  IsRefTimer(ref:Integer):Boolean;
 function  IsRefText(ref:Integer):Boolean;
 function  IsRefTask(ref:Integer):Boolean;
 function  IsRefPipe(ref:Integer):Boolean;
 function  IsRefTcp(ref:Integer):Boolean;
 function  IsRefCom(ref:Integer):Boolean;
 function  CheckStdErrors:Boolean;
 procedure ClearStdErrors;
 procedure InitStdErrors;
 procedure FreeStdErrors;
 procedure PollStdErrors;
 }
 {
 Return True on initialization run.
 }
 function Starting:Boolean;
 begin
  Starting:=(RunCount=1);
 end;
 {
 Return True on finalization run.
 }
 function Stopping:Boolean;
 begin
  Stopping:=IsInf(RunCount);
 end;
 {
 Return True on normal polling run.
 }
 function Polling:Boolean;
 begin
  Polling:=Ok;
 end;
 {
 Compare guard levels.
 -1 if g1 less then  g2
  0 if g1 equavalent g2
 +1 if g1 more then  g2
 }
 function CompareGuards(g1,g2:String):Integer;
 const GuardList='LOCK,GUEST,USER,ROOT';
 var p,p1,p2:Integer;
 begin
  p1:=Pos(UpCaseStr(Trim(g1)),GuardList);
  p2:=Pos(UpCaseStr(Trim(g2)),GuardList);
  if (p1=0) or (p2=0) then p:=-1 else p:=Sign(p2-p1);
  CompareGuards:=p;
 end;
 {
 Post StartingDevMsg to device console.
 }
 procedure PostStartingDevMsg;
 var devMySelf:Integer; b:Boolean;
 begin
  if Starting then begin
   devMySelf:=RefFind('Device '+DevName);
   if devMySelf<>0 then
   if Length(Trim(StartingDevMsg))>0
   then b:=DevPost(devMySelf,Trim(StartingDevMsg)+EOL)>0;
  end;
 end;
 {
 Post StoppingDevMsg to device console.
 }
 procedure PostStoppingDevMsg;
 var devMySelf:Integer; b:Boolean;
 begin
  if Stopping then begin
   devMySelf:=RefFind('Device '+DevName);
   if devMySelf<>0 then
   if Length(Trim(StoppingDevMsg))>0
   then b:=DevPost(devMySelf,Trim(StoppingDevMsg)+EOL)>0;
  end;
 end;
 {
 Char's "Nul device".    Use cNul(Caller) instead of c:=Caller; with temporary c.
 }
 procedure cNul(c:Char);
 begin
 end;
 {
 Boolean's "Nul device". Use bNul(Caller) instead of b:=Caller; with temporary b.
 }
 procedure bNul(b:Boolean);
 begin
 end;
 {
 Integer's "Nul device". Use iNul(Caller) instead of i:=Caller; with temporary i.
 }
 procedure iNul(i:Integer);
 begin
 end;
 {
 Real's "Nul device".    Use rNul(Caller) instead of r:=Caller; with temporary r.
 }
 procedure rNul(r:Real);
 begin
 end;
 {
 String's "Nul device".  Use sNul(Caller) instead of s:=Caller; with temporary s.
 }
 procedure sNul(s:String);
 begin
 end;
 {
 Check if reference (ref) is Tag/Curve/Device/Window/Timer/Text/Task/Pipe/Tcp/Com.
 }
 function IsRefTag(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefTag:=(TypeTag(ref)>0) else IsRefTag:=False;
 end;
 function IsRefCurve(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefCurve:=IsSameText(RefInfo(ref,'Type'),'Curve') else IsRefCurve:=False;
 end;
 function IsRefDevice(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefDevice:=IsSameText(RefInfo(ref,'Type'),'Device') else IsRefDevice:=False;
 end;
 function IsRefWindow(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefWindow:=IsSameText(RefInfo(ref,'Type'),'Window') else IsRefWindow:=False;
 end;
 function IsRefTimer(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefTimer:=IsSameText(RefInfo(ref,'Type'),'Timer') else IsRefTimer:=False;
 end;
 function IsRefText(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefText:=IsSameText(RefInfo(ref,'Type'),'Text') else IsRefText:=False;
 end;
 function IsRefTask(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefTask:=IsSameText(RefInfo(ref,'Type'),'Task') else IsRefTask:=False;
 end;
 function IsRefPipe(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefPipe:=IsSameText(RefInfo(ref,'Type'),'Pipe') else IsRefPipe:=False;
 end;
 function IsRefTcp(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefTcp:=IsSameText(RefInfo(ref,'Type'),'Tcp') else IsRefTcp:=False;
 end;
 function IsRefCom(ref:Integer):Boolean;
 begin
  if ref<>0 then IsRefCom:=IsSameText(RefInfo(ref,'Type'),'Com') else IsRefCom:=False;
 end;
 {
 Check status of standard Errors.
 }
 function CheckStdErrors:Boolean;
 begin
  if Errors<>0 then bNul(FixError(ErrorCode));
  CheckStdErrors:=(Errors=0);
  Ok:=(Errors=0);
 end;
 {
 Clear standard Errors.
 }
 procedure ClearStdErrors;
 begin
  PostMortalWill:='';
  StartingDevMsg:='';
  StoppingDevMsg:='';
 end;
 {
 Initialize standard Errors.
 }
 procedure InitStdErrors;
 begin
  Ok:=False;
  Errors:=0;
  ErrorCode:=RegisterErr(DevName);
  FixDevErrCount:=GetErrCount(-1);
  FixStackAvail:=StackAvail;
  FixMaxAvail:=MaxAvail;
  FixmSecNow:=mSecNow;
  FatalMaxAvail:=128;
  if FatalMaxAvail<(FixMaxAvail div 16)
  then FatalMaxAvail:=FixMaxAvail div 16;
  FixVitalBugs:=GetErrCount(VitalErrCode);
  FixHangsBugs:=GetErrCount(HangsErrCode);
  FatalVitalBugs:=128;
  FatalHangsBugs:=1;
  RunCountHolder:=0;
  ShouldPollStdErrors:=true;
 end;
 {
 Finalize standard Errors.
 }
 procedure FreeStdErrors;
 begin
  Ok:=False;
  Errors:=0;
 end;
 {
 Poll standard Errors.
 }
 procedure PollStdErrors;
 var
  Terminations:Integer;
  procedure PostMortalAction(Will:String);
  var p:Integer;
  begin
   Will:=Trim(Will);
   if Length(Will)>0 then begin
    Will:=StringReplace(Will,'%CRW_DAQ_SYS_SESSION_NB%',GetEnv('CRW_DAQ_SYS_SESSION_NB'),3);
    Will:=StringReplace(Will,'%CRW_DAQ_SYS_EXE_PID%',GetEnv('CRW_DAQ_SYS_EXE_PID'),3);
    Will:=StringReplace(Will,'%CRW_DAQ_SYS_TITLE%',GetEnv('CRW_DAQ_SYS_TITLE'),3);
    Will:=StringReplace(Will,'%date%',StrTimeFmt('yyyy.mm.dd',msecnow),3);
    Will:=StringReplace(Will,'%time%',StrTimeFmt('hh:nn:ss',msecnow),3);
    Will:=StringReplace(Will,'%DeviceName%',DevName,3);
    Will:=StringReplace(Will,'$DeviceName$',DevName,3);
    Will:=Trim(AdjustLineBreaks(Will));
    p:=Pos(EOL,Will);
    if p>0 then begin
     if p>1 then PostMortalAction(Copy(Will,1,p-1));
     if Length(Will)>p+Length(EOL) then PostMortalAction(Copy(Will,p+Length(EOL)));
    end else begin
     if Pos('&',Will)=1 then rNul(DevPostMsg(Will+EOL)) else
     if IsLexeme(Will,lex_AtCall) then rNul(Eval(Will));
    end;
   end;
  end;
  procedure WritelnEcho(Msg:String);
  begin
   Writeln(Msg);
   bNul(Echo(Msg));
  end;
  procedure DyingCry(Msg:String);
  begin
   WritelnEcho(DevName+' ! '+Msg);
  end;
  procedure AbnormalTermination;
  begin
   if Length(PostMortalWill)>0 then PostMortalAction(PostMortalWill);
   DyingCry('Please restart the program (@compile device &), or restart DAQ system.');
   DyingCry('**********************************************************************');
   DyingCry('Abnormal termination. Please restart the device or restart DAQ system.');
   DyingCry('**********************************************************************');
   bNul(FixError(RegisterErr(DevName+' abnormal termination.')));
   bNul(FixError(ErrorCode));
   if SysLogNotable(sev_Abort)
   then iNul(SysLogNote(sev_Abort,'Abnormal program termination.'));
   Ok:=False;
  end;
 begin
  Terminations:=0;
  RunCountHolder:=RunCount;
  {
  Terminate execution in case of possible string leaks.
  }
  if FatalMaxAvail>0 then
  if MaxAvail<=FatalMaxAvail then begin
   DyingCry('Program terminated because of string manager problems: MaxAvail = '+Str(MaxAvail)+_Dot);
   DyingCry('Maybe: 1)String leaks 2)Small Compiler.stabmax 3)Big Compiler.stabmin.');
   Terminations:=Terminations+1;
  end;
  {
  Terminate execution in case of possible program exceptions.
  }
  if FatalVitalBugs>0 then
  if GetErrCount(VitalErrCode)-FixVitalBugs>=FatalVitalBugs then begin
   DyingCry('Program terminated because too many exceptions occured: Counter = '
              +Str(GetErrCount(VitalErrCode)-FixVitalBugs)+_Dot);
   DyingCry('Some fatal error(s) occured, like out of range, divizion by zero, etc.');
   Terminations:=Terminations+1;
  end;
  {
  Terminate execution in case of possible program hanging.
  }
  if FatalHangsBugs>0 then
  if GetErrCount(HangsErrCode)-FixHangsBugs>=FatalHangsBugs then begin
   DyingCry('Program terminated because too many watchdog DEADLINEs: Counter = '
              +Str(GetErrCount(HangsErrCode)-FixHangsBugs)+_Dot);
   DyingCry('Some fatal error(s) occured, like infinite while loop, long waits etc.');
   Terminations:=Terminations+1;
  end;
  {
  Apply termination if one happened.
  }
  if Terminations>0 then AbnormalTermination;
 end;
