 {
 Functions for NetPfeiffer.
 function pfeiffer_get_tag(tag:Integer;def:Real):Real;
 function pfeiffer_set_tag(tag:Integer; val:Real):Boolean;
 function pfeiffer_inc_tag(tag:Integer; inc:Real):Boolean;
 procedure pfeiffer_fixerror(tag,code:Integer; msg:String);
 function pfeiffer_is_except(par:Integer):Boolean;
 function pfeiffer_un_except(par:Integer):Integer;
 function pfeiffer_as_except(par:Integer; isOn:Boolean):Integer;
 function pfeiffer_addr_ok(addr:Integer):Boolean;
 function pfeiffer_decode_answer(adu:String; var adr,par:Integer; var dat:String):Integer;
 function pfeiffer_encode_adu(tid,pid,adr,par:Integer; dat:String):String;
 function pfeiffer_decode_pdu(dir:Char; par:Integer; dat:String; var len:Integer; var raw:String):Integer;
 function pfeiffer_proxy_poll(cmd:String; ref,cid,tot,port,adr,par:Integer; dat:String):String;
 function pfeiffer_proxy_nice(cmd:String; ref,cid,tim,port,adr,par:Integer; dat:String; wid:Integer):String;
 function pfeiffer_proxy_reply(cmd,arg:String; var ref,cid,tim,port,adr,par:Integer; var dat:String):Boolean;
 procedure ClearNetPfeiffer;
 procedure InitNetPfeiffer;
 procedure FreeNetPfeiffer;
 procedure PollNetPfeiffer;
 }
 
 {
 Calculationg checksum modulo 256 (decimal)
 Math Mod 256
 }
 function pfeiffer_CalcCheckSum(s:String):String;
 var i:Integer;cs:String;
 begin
  cs:=''; 
  for i:=1 to Length(s) do cs:=str(val(cs)+Ord(StrFetch(s,i)));
  cs:=str((256+(val(cs) mod 256)) mod 256);
  if Length(cs)<>3 then cs:=LeftPad(cs,3,'0');
  pfeiffer_CalcCheckSum:=cs;
  cs:='';
 end;
 
 {
 Append checksum to data string s.
 }
 function pfeiffer_AppendCheckSum(s:String):String;
 var cs:String;
 begin
  cs:=''; 
  if Length(s)>0 then begin
   s:=s+pfeiffer_CalcCheckSum(s);
  end;
  pfeiffer_AppendCheckSum:=s;
  cs:=''; 
 end;
 {
 Append checksum and CR to data string s.
 }
 function pfeiffer_AppendCheckSumCR(s:String):String;
 begin
  pfeiffer_AppendCheckSumCR:=pfeiffer_AppendCheckSum(s)+Chr(13);
 end;
 
 {
 Format from command answer
 Return integer
 }
 function pfeiffer_FormatAnsToBool(s:String):integer;
 var b,l:integer;
 begin
  b:=0;
  l:=val(s);
  if l<>0 then b:=1;
  pfeiffer_FormatAnsToBool:=b; b:=0;
 end;
 
 {
 Format to command answer
 Return protocol boolean string
 }
 function pfeiffer_FormatBoolToAns(i:integer):string;
 var s:string;
 begin
  s:='';
  if i = 1 then
   s:='111111'
  else
   s:='000000';
  pfeiffer_FormatBoolToAns:=s; s:='';
 end;
 
 {
 Format command answer
 Fixed 0000,00
 Return real
 }
 function pfeiffer_FormatAnsToReal(s:String):real;
 var r:real;
 // 717 комманда присылает ответ не по протоколу, всего 3 символа вместо 6
 begin
  if length(s)=3 then
   r:=val(s)
  else 
   r:=val(s)/100;
  pfeiffer_FormatAnsToReal:=r; r:=0;
 end;
 
 {
 Format to command answer
 Fixed 0000,00
 Return protocol real string
 }
 function pfeiffer_FormatRealToAns(r:Real):String;
 var s:string;
 begin
  s:='';
  r:=r*100;
  s:=str(r);
  s:=LeftPad(s,6,'0');
  pfeiffer_FormatRealToAns:=s; s:='';
 end;
 
 {
 Format to command answer
 Return protocol integer string
 }
 function pfeiffer_FormatIntToAns(i:integer):String;
 var s:string;
 begin
  s:='';
  s:=str(i);
  s:=LeftPad(s,6,'0');
  pfeiffer_FormatIntToAns:=s; s:='';
 end;
 
 {
 Format command answer
 Return expo
 
 1.2E-2 corresponds to 1,2x10^-2
 0005E8 corresponds to 5x10^8
 }
 function pfeiffer_FormatAnsToExpo(s:String):real;
 var i,k:integer;r:real;
 begin
  for i:=1 to Length(s) do 
   if strFetch(s,i)='E' then k:=i;
  r:=rval(copy(s,1,k-1))*power(10,val(copy(s,k+1,Length(s)-k)));
  
  pfeiffer_FormatAnsToExpo:=r; i:=0;
 end;
 
 {
 Check if data string s has valid checksum.
 }
 function pfeiffer_HasValidCheckSum(s:String):Boolean;
 var l,c1,c2:Integer;
 begin
  c1:=0; c2:=0;
  l:=Length(s);
  if (l>1) then begin
   c1:=val(pfeiffer_CalcCheckSum(Copy(s,1,l-4)));
   c2:=val(Copy(s,l-2,3));
  end;
  pfeiffer_HasValidCheckSum:=(c1=c2) and (l>1);
 end;
 
 {
 Get integer or real tag value or default.
 }
 function pfeiffer_get_tag(tag:Integer; def:Real):Real;
 begin
  if TypeTag(tag)=1 then pfeiffer_get_tag:=iGetTag(tag) else
  if TypeTag(tag)=2 then pfeiffer_get_tag:=rGetTag(tag) else
  pfeiffer_get_tag:=def;
 end;
 
 {
 Set integer or real tag value.
 }
 function pfeiffer_set_tag(tag:Integer; val:Real):Boolean;
 begin
  if TypeTag(tag)=1 then pfeiffer_set_tag:=iSetTag(tag,Round(val)) else
  if TypeTag(tag)=2 then pfeiffer_set_tag:=rSetTag(tag,val) else
  pfeiffer_set_tag:=False;
 end;
 
 {
 Increment integer or real tag value. Uses for error counting.
 }
 function pfeiffer_inc_tag(tag:Integer; inc:Real):Boolean;
 begin
  if TypeTag(tag)=1 then pfeiffer_inc_tag:=iSetTag(tag,iGetTag(tag)+Round(inc)) else
  if TypeTag(tag)=2 then pfeiffer_inc_tag:=rSetTag(tag,rGetTag(tag)+inc) else
  pfeiffer_inc_tag:=False;
 end;
 
 {
 Fix Pfeiffer error: increment tag & code & print message.
 }
 procedure pfeiffer_fixerror(tag,code:Integer; msg:String);
 begin
  if not pfeiffer_inc_tag(tag,1) then
  if code<>0 then bNul(FixError(code));
  if Length(msg)>0 then Problem(msg);
 end;

 {
 Return true only if Pfeiffer function id (par) contains exception bit.
 }
 function pfeiffer_is_except(par:Integer):Boolean;
 begin
  pfeiffer_is_except:=HasFlags(par,pfeiffer_er_Except);
 end;
 
 {
 Unset exception bit, i.e. return Pfeiffer function id (par) without exception bit.
 }
 function pfeiffer_un_except(par:Integer):Integer;
 begin
  pfeiffer_un_except:=iAnd(par,iNot(pfeiffer_er_Except));
  { pfeiffer_un_except:=par; }
 end;
 
 {
 Assign exception bit, i.e. return Pfeiffer function id (par) with exception bit set ON.
 }
 function pfeiffer_as_except(par:Integer; isOn:Boolean):Integer;
 begin
  if isOn
  then pfeiffer_as_except:=iOr(par,pfeiffer_er_Except)
  else pfeiffer_as_except:=iAnd(par,iNot(pfeiffer_er_Except));
 end;
 
 {
 Check if device address is OK.
 }
 function pfeiffer_addr_ok(addr:Integer):Boolean;
 begin
  pfeiffer_addr_ok:=((addr>=pfeiffer_MinUnitId) and (addr<=pfeiffer_MaxUnitId));
 end;
 
 {
 Decode Pfeiffer RTU message. Return Length(PDU=par+dat) or 0.
 }
 function pfeiffer_decode_answer(s:String;var adr,par,len:Integer; var dat:String):Integer;
 var r:String;l:Integer;
 begin
  pfeiffer_errno:=pfeiffer_er_OK;                      // Clear error code
  
  l:=val(Copy(s,9,2));
  r:=pfeiffer_ERROR_ARG;
  if (Length(s)>32) then r:=pfeiffer_ERROR_LEN else  
  if (Copy(s,11,6)='NO_DEF')  then r:=pfeiffer_ERROR_DEF else
  if (Copy(s,11,6)='_RANGE')  then r:=pfeiffer_ERROR_RAN else 
  if (Copy(s,11,6)='_LOGIC')  then r:=pfeiffer_ERROR_LOG else
  if not pfeiffer_HasValidCheckSum(s) then r:=pfeiffer_ERROR_CRC else begin 
   l:=val(Copy(s,9,2));
   r:=copy(s,11,l);        // LengthValue as string
   adr:=val(copy(s,1,3));
   par:=val(copy(s,6,3));
   len:=val(copy(s,9,2));
  end;
  dat:=r; r:='';
  pfeiffer_decode_answer:=Length(dat); 
 end;
 
 {
 Encode Pfeiffer ADU message for given unit adr, function par and data (dat).
 Arguments:
  tid  - (in) transaction id
  pid  - (in) protocol id, should be 1
  adr  - (in) unit id, i.e. Pfeiffer module address, 1..247
  par  - (in) Pfeiffer function id, 1,2,3,4,5,6,15,16
  dat  - (in) PDU data; PDU=(par+dat)
 Return ADU (application data unit) message ready to send.
 Also sets pfeiffer_errno value on errors.
 }
 function pfeiffer_encode_adu(adr,par,len:Integer; dat:String):String;
 var action,request: string;
 begin
  len:=2;
  dat:=copy(dat,3,length(dat));
  if dat='=?' then action:='00' else action:='10';
  request:=pfeiffer_AppendCheckSumCR(LeftPad(str(adr),3,'0')+action+LeftPad(str(par),3,'0')+LeftPad(str(len),2,'0')+dat);
  pfeiffer_encode_adu:=request;
 end;
 
 {
 Decode PDU=(par+dat) header.
 Arguments:
  dir   = (in)     I/O  direction: 'R' = Request, 'A' = Answer (response).
  par   = (in)     Pfeiffer function identifier
  dat   = (in)     PDU data; PDU=Chr(par)+dat
  len = (in/out) lenity of coils/inputs/registers if required or 0
 Return : Positive PDU length or Negative/Zero error code.
          Expected to be: count=length(raw) if returned positive result.
          Expected to be: PDU length = Length(Chr(par)+dat) = Length(dat)+1.
 Also sets pfeiffer_errno value on errors.
 }
 function pfeiffer_decode_pdu(dir:Char; par:Integer; dat:String; var len:Integer):Integer;
 var pdulen,datlen:Integer;
 begin
  pfeiffer_errno:=pfeiffer_er_OK;
  pdulen:=0; datlen:=Length(dat);
  pdulen:=len;
  if length(str(par))>3 then pdulen:=-pfeiffer_er_ILLFUN;
  if copy(dat,3,length(dat))<>'=?' then
   if (datlen<>len) then pdulen:=-pfeiffer_er_ILLVAL;
  
  pfeiffer_decode_pdu:=pdulen;
 end;

 {
 Encode command to send to &PfeifferProxy or reply to driver.
 cmd  - (in)  command name, expected @Pfeiffer.Poll, @Pfeiffer.Reply, @Pfeiffer.Refuse, @Pfeiffer.Timeout or empty string.
 ref  - (in)  sender device reference, usually driver's devMySelf
 cid  - (in)  command id, any user defined number
 tot  - (in)  timeout, ms
 port - (in)  logical port
 adr  - (in)  unit id
 par  - (in)  function id
 len  - (in)  data lenght
 dat  - (in)  PDU data; PDU=(par+dat)
 Return formatted data ready to send to &PfeifferProxy.
 }
 function pfeiffer_proxy_poll(cmd:String;ref,cid,tot,port,adr,par,len:Integer; dat:String):String;
 begin
  if Length(cmd)=0 then cmd:='@Pfeiffer.Poll';
  pfeiffer_proxy_poll:=cmd+' '+Str(ref)+' '+Str(cid)+' '+Str(tot)+' '
                           +Str(port)+' '+Str(adr)+' '+Str(par)+' '+Str(len)+' $$'+dat;
 end;
 
 {
 Nice (human-readable) format to print &PfeifferProxy messages.
 If wid>0, use $HEX_ENCODE(dat)...; if wid<0 use Trim(dat)...
 }
 function pfeiffer_proxy_nice(cmd:String; ref,cid,tim,port,adr:Integer;par,len:Integer; dat:String; wid:Integer):String;
 begin
  if wid<0 then if length(dat)>abs(wid)
  then dat:=Copy(dat,1,abs(wid))+'...';
  if wid>0 then if length(dat)<=wid
  then dat:='$$'+dat
  else dat:='$$'+Copy(dat,1,wid div 2)+'...';
  pfeiffer_proxy_nice:=cmd+' '+RefInfo(ref,'Name')+' '+Str(cid)+' '+Str(tim)
                        +' '+Str(port)+' '+Str(adr)+' '+Str(par)+' '+Str(len)+' '+dat;
 end;
 
 {
 Decode Reply/Timeout/Refuse message received from &PfeifferProxy.
 cmd  - (in)  Should be @Pfeiffer.Poll or @Pfeiffer.Timeout or @Pfeiffer.Refuse
 arg  - (in)  command argument list[7]: ref cid tim port adr par $$dat
 ref  - (out) sender device reference, expected &PfeifferProxy
 cid  - (out) command id, any user defined number
 tim  - (out) response time, ms
 port - (out) logical port
 adr  - (out) unit id
 par  - (out) function id
 dat  - (out) PDU data; PDU=(par+dat)
 Return true if message looks acceptable to use.
 Also sets pfeiffer_errno value on errors.
 }
 function pfeiffer_proxy_reply(cmd,arg:String;var ref,cid,tim,port,adr,par,len:Integer;var dat:String):Boolean;
 var p,cmdid:Integer;
 begin
  ref:=0;
  cmdid:=HashList_GetLink(StdIn_CmdHashTab,cmd);
  if (cmdid=cmd_NetPfeifferPoll) then begin
   p:=pos(' $$',arg);
   if p>0 then begin
    dat:=Copy(arg,p+1);
    arg:=Copy(arg,1,p-1);
    ref:=Val(ExtractWord(1,arg));  if ref=0 then ref:=RefFind('Device '+ExtractWord(1,arg));
    cid:=Val(ExtractWord(2,arg));  if ref=0 then pfeiffer_errno:=pfeiffer_er_BADREF;
    tim:=Val(ExtractWord(3,arg));  if tim<=0 then begin ref:=0; pfeiffer_errno:=pfeiffer_er_ILLVAL; end;
    port:=Val(ExtractWord(4,arg)); if port<1 then begin ref:=0; pfeiffer_errno:=pfeiffer_er_ILLVAL; end;
    adr:=Val(ExtractWord(5,arg));  if not pfeiffer_addr_ok(adr) then begin ref:=0; pfeiffer_errno:=pfeiffer_er_BADUID; end;
    par:=Val(ExtractWord(6,arg));
    len:=Val(ExtractWord(7,arg));
    if Length(dat)=0 then begin ref:=0; pfeiffer_errno:=pfeiffer_er_ILLVAL; end;
   end;
  end else
  if (cmdid=cmd_NetPfeifferReply) then begin
   p:=pos(' $$',arg);
   if p>0 then begin
    dat:=Copy(arg,p+1);
    arg:=Copy(arg,1,p-1);
    ref:=Val(ExtractWord(1,arg));  if ref=0 then ref:=RefFind('Device '+ExtractWord(1,arg));
    cid:=Val(ExtractWord(2,arg));  if ref=0 then pfeiffer_errno:=pfeiffer_er_BADREF;
    tim:=Val(ExtractWord(3,arg));  if tim<0 then begin ref:=0; pfeiffer_errno:=pfeiffer_er_ILLVAL; end;
    port:=Val(ExtractWord(4,arg)); if port<1 then begin ref:=0; pfeiffer_errno:=pfeiffer_er_ILLVAL; end;
    adr:=Val(ExtractWord(5,arg));  if not pfeiffer_addr_ok(adr) then begin ref:=0; pfeiffer_errno:=pfeiffer_er_BADUID; end;
    par:=Val(ExtractWord(6,arg));
    len:=Val(ExtractWord(7,arg));
    if Length(dat)=0 then begin ref:=0; pfeiffer_errno:=pfeiffer_er_ILLVAL;  end;
   end;
  end else
  if (cmdid=cmd_NetPfeifferTimeout) then begin
   p:=pos(' $$',arg);
   if p>0 then begin
    dat:=Copy(arg,p+1);
    arg:=Copy(arg,1,p-1);
    ref:=Val(ExtractWord(1,arg));  if ref=0 then ref:=RefFind('Device '+ExtractWord(1,arg));
    cid:=Val(ExtractWord(2,arg));  if ref=0 then pfeiffer_errno:=pfeiffer_er_BADREF;
    tim:=Val(ExtractWord(3,arg));  if tim<0 then begin ref:=0; pfeiffer_errno:=pfeiffer_er_ILLVAL; end;
    port:=Val(ExtractWord(4,arg)); if port<1 then begin ref:=0; pfeiffer_errno:=pfeiffer_er_ILLVAL; end;
    adr:=Val(ExtractWord(5,arg));  if not pfeiffer_addr_ok(adr) then begin ref:=0; pfeiffer_errno:=pfeiffer_er_BADUID; end;
    par:=Val(ExtractWord(6,arg));
    if Length(dat)=0 then begin ref:=0; pfeiffer_errno:=pfeiffer_er_ILLVAL; end;
   end;
  end else
  if (cmdid=cmd_NetPfeifferRefuse) then begin
   ref:=Val(ExtractWord(1,arg));   if ref=0 then ref:=RefFind('Device '+ExtractWord(1,arg));
   cid:=Val(ExtractWord(2,arg));   if ref=0 then pfeiffer_errno:=pfeiffer_er_BADREF;
   tim:=Val(ExtractWord(3,arg));
   port:=Val(ExtractWord(4,arg));
   adr:=Val(ExtractWord(5,arg));
   par:=Val(ExtractWord(6,arg));
   dat:=Trim(SkipWords(6,arg));
  end else
  pfeiffer_errno:=pfeiffer_er_BADCMD;
  
  if not IsRefDevice(ref) then begin ref:=0; pfeiffer_errno:=pfeiffer_er_BADREF; end;
  if ref=0  then begin cid:=0; tim:=0; port:=0; adr:=0; par:=0; dat:=''; end;
  pfeiffer_proxy_reply:=(ref<>0);
 end;

 {
 Clear NetPfeiffer.
 }
 procedure ClearNetPfeiffer;
 begin
 end;
 
 {
 Initialize NetPfeiffer.
 }
 procedure InitNetPfeiffer;
 begin
  pfeiffer_errno:=pfeiffer_er_OK;
  InitDevice(devPfeifferProxy, PfeifferProxy, 1);
  cmd_NetPfeifferPoll    := RegisterStdInCmd('@Pfeiffer.Poll',    '');
  cmd_NetPfeifferReply   := RegisterStdInCmd('@Pfeiffer.Reply',   '');
  cmd_NetPfeifferTimeout := RegisterStdInCmd('@Pfeiffer.Timeout', '');
  cmd_NetPfeifferRefuse  := RegisterStdInCmd('@Pfeiffer.Refuse',  '');
 end;
 
 {
 Finalize NetPfeiffer.
 }
 procedure FreeNetPfeiffer;
 begin
 end;
 
 {
 Poll NetPfeiffer.
 }
 procedure PollNetPfeiffer;
 begin
 end;
 