 {
 Constants for NetModbus.
 }
 //
 // Reference source:
 // 1) MODBUS Application Protocol Specification V1.1b.
 // 2) MODBUS Messaging on TCP/IP Implementation Guide V1.0b.
 // 3) MODBUS over serial line specification and implementation guide V1.02.
 //
 modbus_MinUnitId = 1;              // Minimal Unit Id (device address) by specifation
 modbus_MaxUnitId = 247;            // Maximal Unit Id (device address) by specifation
 modbus_MaxPduLen = 253;            // Maximal length of PDU block (PDU = protocol data unit)
 modbus_MaxTcpLen = 260;            // Maximal length of TCP   ADU frame (ADU = application data unit)
 modbus_MaxRtuLen = 256;            // Maximal length of RTU   ADU frame
 modbus_MaxAscLen = 513;            // Maximal length of ASCII ADU frame
 modbus_MaxCSGet  = 2000;           // Maximal Coil    Status   items per one read  $07D0, F1
 modbus_MaxISGet  = 2000;           // Maximal Input   Status   items per one read  $07D0, F2
 modbus_MaxIRGet  = 125;            // Maximal Input   Register items per one read  $007D, F3
 modbus_MaxHRGet  = 125;            // Maximal Holding Register items per one read  $007D, F4
 modbus_MaxCSPut  = 1968;           // Maximal Coil    Status   items per one write $07B0, F15
 modbus_MaxHRPut  = 123;            // Maximal Holding Register items per one write $007B, F16
 modbus_0xFF00    = 65280;          // Magic number to switch on  single coil $FF00
 modbus_sc_on     = modbus_0xFF00;  // Magic number to switch on  single coil
 modbus_sc_off    = 0;              // Magic number to switch off single coil
 modbus_fn_ReadCS = 1;              // MODBUS function: Read Coil Statuses
 modbus_fn_ReadIS = 2;              // MODBUS function: Read Input Statuses
 modbus_fn_ReadHR = 3;              // MODBUS function: Read Holding Registers
 modbus_fn_ReadIR = 4;              // MODBUS function: Read Input Registers
 modbus_fn_WritSC = 5;              // MODBUS function: Write Single Coil
 modbus_fn_WritSR = 6;              // MODBUS function: Write Single Register
 modbus_fn_ReadES = 7;              // MODBUS function: Read Exception Status
 modbus_fn_Diagn  = 8;              // MODBUS function: Diagnostics
 modbus_fn_EvCnt  = 11;             // MODBUS function: Get Comm Event Counter
 modbus_fn_EvLog  = 12;             // MODBUS function: Get Comm Event Log
 modbus_fn_WritMC = 15;             // MODBUS function: Write Multitle Coils
 modbus_fn_WritMR = 16;             // MODBUS function: Write Multiple Registers
 modbus_fn_RepSID = 17;             // MODBUS function: Report Slave ID
 modbus_fn_ReadFR = 20;             // MODBUS function: Read File Record
 modbus_fn_WritFR = 21;             // MODBUS function: Write File Record
 modbus_fn_MaskWR = 22;             // MODBUS function: Mask Write Register
 modbus_fn_ReWrMR = 23;             // MODBUS function: Read-Write Multiple Regs
 modbus_fn_ReadFQ = 24;             // MODBUS function: Read FIFO Queue
 modbus_fn_Escape = 43;             // MODBUS function: Encapsul.Interf.Transp.
 modbus_er_OK     = 0;              // MODBUS error code: OK, no errors
 modbus_er_ILLFUN = 1;              // MODBUS error code: ILLEGAL FUNCTION
 modbus_er_ILLADR = 2;              // MODBUS error code: ILLEGAL DATA ADDRESS
 modbus_er_ILLVAL = 3;              // MODBUS error code: ILLEGAL DATA VALUE
 modbus_er_EXCEPT = 128;            // MODBUS error code: exception mask
 //
 // Addon constants
 //
 modbus_er_BADLEN = 256;            // MODBUS error code: ADU/PDU length is not looks valid
 modbus_er_BADCRC = 257;            // MODBUS error code: CRC/LRC checksum is not valid
 modbus_er_BADUID = 258;            // MODBUS error code: Unit ID is not valid
 modbus_er_BADCMD = 259;            // MODBUS error code: Bad command id
 modbus_er_BADREF = 260;            // MODBUS error code: Bad reference
 modbus_MaxWord   = 65535;          // Maximal value for 16-bit word
 modbus_pr_IP     = 1;              // MODBUS protocol: IP
 modbus_pr_RTU    = 2;              // MODBUS protocol: RTU
 modbus_pr_ASCII  = 3;              // MODBUS protocol: ASCII
 modbus_pr_NAMES  = 'IP,RTU,ASCII'; // MODBUS protocol names
 modbus_pr_ALIAS  = 'TCP,RTU,ASC';  // MODBUS protocol alias names
 modbus_sw_native = 0;              // Swap mode: native machine byte order, no swapping applied
 modbus_sw_normal = 7;              // Swap mode: normal (high to low) network byte order, machine depended
 ModbusProxy      = '&ModbusProxy'; // Device name of &ModbusProxy server
