 {
 *********************************************************************
 Назначение: Интерфейс для вызова DLL из DAQ Pascal.
 Пример конфигурирования:
 [DeviceList]
 &DRIVER = device software program
 [&DRIVER]
 ProgramSource	= ~~/resource/daqsite/stdlib/daqpas/_dllwrap.pas
 DLL_FILE_PATH	= ..\daqpas\driver.dll   ; DLL plugin file path
 .....                                   ; Other information
 *********************************************************************
 }
program _dllwrap;
var
 hDll:Integer; { Ссылка на DLL }
 {
 Процедура освобождения DLL
 }
 procedure DLL_FREE(var hDll:Integer);
 var b:Boolean;
 begin
  if hDll<>0 then begin
   b:=daqdllcall(hDll,Daq_Cmd_Free);
   b:=daqdllfree(hDll);
   hDll:=0;
  end;
 end;
 {
 Процедура пытается загрузить DLL с заданным именем файла.
 Возвращает ненулевую ссылку DLL или ноль при ошибке.
 }
 function DLL_INIT(DllPath:String):Integer;
 var b:Boolean; hDll:Integer;
 begin
  hDll:=daqdllinit(DllPath);
  writeln(DevName+' : DLL_FILE_PATH = '+DllPath);
  if hDll<>0 then if not daqdllcall(hDll,Daq_Cmd_Init) then DLL_FREE(hDll);
  if hDll=0 then begin
   DllPath:=ExtractFileName(DllPath)+ExtractFileExt(DllPath);
   b:=fixerror(registererr('Fail load '+DllPath+' !'));
  end;
  DLL_INIT:=hDll;
 end;
 {
 Процедура опроса DLL.
 }
 procedure DLL_POLL(hDll:Integer);
 var b:Boolean;
 begin
  if hDll<>0 then b:=daqdllcall(hDll,Daq_Cmd_Poll);
 end;
 {
 Получить имя DLL файла по имени параметра конфигурации.
 }
 function DLL_FILE_PATH:String;
 var s:String;
 begin
  s:=ReadIni('DLL_FILE_PATH');
  s:=AdaptDllFileName(s);
  s:=DaqFileRef(s,'');
  DLL_FILE_PATH:=s;
  s:='';
 end;
begin
 {
 При старте загружаем DLL
 }
 if runcount=1 then hDll:=DLL_INIT(DLL_FILE_PATH) else
 {
 При останове удаляем DLL
 }
 if isinf(runcount) then DLL_FREE(hDll) else
 {
 В цикле опроса вызываем DLL
 }
 if hDll<>0 then DLL_POLL(hDll);
end.
