﻿---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Библиотечная программа _dllhost.pas

Программа - владелец (_host_) для загрузки и вызова динамической библиотеки **DLL**
(_dll = dynamic load library_) в цикле опроса **DAQ**-системы.

## Назначение программы

Программа **[_dllhost.pas](_dllhost.pas)** - это библиотечная программа - владелец
для загрузки, выгрузки и вызова (опроса) **DAQ** - **[плагинов](../../../manual/crwdaq-plugin.htm#crwdaq_plugin_daq)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Алгоритм работы программы

Программа работает в рамках алгоритма стандартной библиотеки.

Программа делает следующее:

- При старте **DAQ**-системы вызывает **[STD_DLL_INIT](../../../manual/daqpascalapi.htm#std_dll_init)**
  для загрузки и инициализации библиотеки плагина **`*.dll`** или **`lib*.so`**.  
  Имя библиотеки считывается из **INI** параметра **DLL_FILE_PATH**.

- При завершении **DAQ**-системы автоматически вызывается
  **[STD_DLL_FREE](../../../manual/daqpascalapi.htm#std_dll_free)**
  для завершения (выгрузки) библиотеки.  

- В каждом цикле опроса **DAQ**-системы автоматически вызывается
  **[STD_DLL_POLL](../../../manual/daqpascalapi.htm#std_dll_poll)**
  для выполнения команды опроса плагина **DAQ_CMD_POLL**.  
  Плагин выполняет необходимую работу в цикле опроса по этому вызову.  

Программа **`_dllhost.pas`** минималистична - она не делает ничего кроме обслуживания вызова
динамической библиотеки плагина **`*.dll`** или **`lib*.so`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Подключение программы _dllhost.pas

Для подключения **`_dllhost.pas`** надо включить в конфигурацию примерно такой текст:

``` ini
[DeviceList]
&DEMO.DLLHOST = device software program
[&DEMO.DLLHOST]
Comment       = Host for plugin DLL.
InquiryPeriod = 1
DevicePolling = 100, tpNormal
ProgramSource = ~~\resource\daqsite\stdlib\daqpas\_dllhost.pas ; Program source file
DLL_FILE_PATH = ..\daqpas\demo_plugin\demo_plugin.dll          ; Plugin DLL file path
StdIn_EnablePoll = 1 ; Enable StdIn polling in DaqPascal code, otherwise do it in plugin code
OpenConsole   = 2
DebugFlags    = 3
[]
```

Параметр **`ProgramSource`** ссылается на стандартное расположение программы **`_dllhost.pas`**.  
Параметр **`DLL_FILE_PATH`** указывает на файл динамической библиотеки **`*.dll`** или **`lib*.so`**.  
Параметр **`StdIn_EnablePoll`** задает флаг обработки консольного ввода **StdIn** стандартным кодом **DaqPascal**.  
Если этот флаг сброшен, стандартная обработка отключается и плагин сам должен обрабатывать ввод **StdIn**.  
Остальные параметры - обычные для всех программных устройств.  


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

> Желаем успешного использования программы **`_dllhost.pas`**!

---
