 {
 ***********************************************************************
 Daq Pascal application program _DEWTORH.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Reset                 - reset all channels.
| @Reset n               - reset channel number n.
| @Clear                 - clear all AO curves connected.
| @Clear n               - clear AO[n] curve connected.
|********************************************************
[]
 ***********************************************************************
 Description:
  Humidity calculator to convert dewpoint to %RH and PPMv.
 Configuration:
  AI[3*n+0] - Input  dewpoint temperature [°C].
  AI[3*n+1] - Input  air      temperature [°C].
  AI[3*n+2] - Input  air      pressure    [mBar].
  AO[3*n+0] - Output vapor    pressure    [mBar].
  AO[3*n+1] - Output relative humidity    [%RH].
  AO[3*n+2] - Output volume   moisture    [PPMv].
  where  n=0..NumChans-1, NumChans=min(AnalogInputs div 3,AnalogOutputs div 3)
 Tags:
  tagGate or tagGateN   (N=0..NumAis-1) - Integer gate tag(s).
  Gate tags may be passed, by default Gate=1.
 Example:
  [DeviceList]
  &DewToRH = device software program
  [&DewToRH]
  Comment       = Dewpoint to humidity converter
  InquiryPeriod = 1
  DevicePolling = 10, tpNormal
  ProgramSource = ~~\Resource\DaqSite\StdLib\DaqPas\_dewtorh.pas
  OpenConsole   = 2
  DebugFlags    = 15
  AnalogInputs  = 6                                             ; Число каналов * 3
  Link AnalogInput  0 with curve DewpointTemperature1           ; Температура точки росы [°C]
  Link AnalogInput  1 with curve AirTemperature1                ; Температура воздуха    [°C]
  Link AnalogInput  2 with curve AirPressure1                   ; Давление воздуха       [mBar]
  Link AnalogInput  3 with curve DewpointTemperature2
  Link AnalogInput  4 with curve AirTemperature2
  Link AnalogInput  5 with curve AirPressure2
  AnalogOutputs = 6                                             ; Число каналов * 3
  Link AnalogOutput  0 with curve VaporPressure1    history 100 ; Давление водяного пара  [mBar]
  Link AnalogOutput  1 with curve RelativeHumidity1 history 100 ; Относительная влажность [%RH]
  Link AnalogOutput  2 with curve VolumeMoisture1   history 100 ; Объемная влажность      [PPMv]
  Link AnalogOutput  3 with curve VaporPressure2    history 100
  Link AnalogOutput  4 with curve RelativeHumidity2 history 100
  Link AnalogOutput  5 with curve VolumeMoisture2   history 100
  tagGate           = HUMIDITY_GATE ; Тег разрешения
  AutoReset         = 0             ; Автоматический сброс
  defAirTemperature = 21            ; Температура воздуха по умолчанию
  defAirPressure    = 1013.25       ; Давление    воздуха по умолчанию
  nFormula          = 0             ; Номер формулы для расчета давления насыщенного пара
  mFactor           = 0             ; Номер формулы для расчета поправочного фактора
  []
 ***********************************************************************
 }
program _DewToRH;                { Dewpoint To Relative Humidity    }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_PhysLibrary}           { Physics Library constants        }
 MaxNumChans       = 1024;       { Maximum number of channels       }
 AisPerChan        = 3;          { Analog inputs  per channel       }
 AosPerChan        = 3;          { Analog outputs per channel       }
 defAirTemperature = 21;         { Default air temperature [°C]     }
 defAirPressure    = 1013.25;    { Default air pressure    [mBar]   }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_PhysLibrary}           { Physics Library variables        }
 NumChans          : Integer;    { Current number of channels       }
 nFormula          : Integer;    { Which formula for humidity uses  }
 mFactor           : Integer;    { Which formula for e-factor uses  }
 LastX             : array[0..MaxNumChans] of Real;    { X marker   }
 tagGate           : array[0..MaxNumChans] of Integer; { Gate tags  }
 LastGate          : array[0..MaxNumChans] of Integer; { Last value }
 AutoReset         : Boolean;    { Auto reset on Gate front         }
 defAirTemp        : Real;       { Default air temperature [°C]     }
 defAirPres        : Real;       { Default air pressure    [mBar]   }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_PhysLibrary}           { Physics Library functions        }
 
 {
 Clear AO curves corresponded to channel n or all AO curves if n<0.
 }
 procedure DEWTORH_Clear(n:Integer);
 var chan,crv,i:Integer;
 begin
  for chan:=0 to NumChans-1 do
  if (n=chan) or (n<0) then begin
   for i:=0 to AosPerChan-1 do begin
    crv:=RefAo(chan*AosPerChan+i);
    if crv<>0 then begin
     bNul(CrvLock(crv));
     bNul(CrvDel(crv,1,CrvLen(crv))>0);
     bNul(CrvUnlock(crv));
    end;
   end;
  end;
 end;
 {
 Reset channel n or all channels if n<0.
 Reset includes AO clear & LastX marker.
 }
 procedure DEWTORH_Reset(n:Integer);
 var chan,crv,i:Integer;
 begin
  for chan:=0 to NumChans-1 do
  if (n=chan) or (n<0) then begin
   LastX[chan]:=_MinusInf;
   for i:=0 to AisPerChan-1 do begin
    crv:=RefAi(chan*AisPerChan+i);
    if crv<>0 then begin
     bNul(CrvLock(crv));
     if CrvLen(crv)>0 then LastX[chan]:=Max(LastX[chan],CrvX(crv,CrvLen(crv)));
     bNul(CrvUnLock(crv));
    end;
   end;
  end;
  DEWTORH_Clear(n);
 end;
 {
 Initialize tag from INI file nick names.
 For example InitTagByNick(tagGate,'tagGate1 tagGate',1)
 will seach for Integer tag ReadIni('tagGate1'), then ReadIni('tagGate').
 }
 procedure InitTagByNicks(var tag:Integer; nicks:String; typ:Integer);
 var i:Integer;
 begin
  tag:=0;
  for i:=1 to WordCount(nicks) do
  if TypeTag(tag)=0 then begin
   tag:=FindTag(ReadIni(ExtractWord(i,nicks)));
   if (typ<>0) and (TypeTag(tag)<>abs(typ)) then tag:=0;
   if (typ<>0) and (TypeTag(tag)>0) then Success('Init tag '+NameTag(tag)+' by nick '+ExtractWord(i,nicks));
  end;
  if TypeTag(tag)=0 then begin
   if typ>0 then Trouble('Can`t init tag by nicks:'+nicks);
   if typ<0 then Problem('Can`t init tag by nicks:'+nicks);
  end;
 end;
 {
 Initialize.
 }
 procedure DEWTORH_Init;
 var chan:Integer;
 begin
  NumChans:=iMin(MaxNumChans,iMin(NumAis div AisPerChan,NumAos div AosPerChan));
  defAirTemp:=rValDef(ReadIni('defAirTemperature'),defAirTemperature);
  defAirPres:=rValDef(ReadIni('defAirPressure'),defAirPressure);
  nFormula:=iValDef(ReadIni('nFormula'),0);
  AutoReset:=(Val(ReadIni('AutoReset'))=1);
  mFactor:=iValDef(ReadIni('mFactor'),0);
  for chan:=0 to NumChans-1 do begin
   InitTagByNicks(tagGate[chan],'tagGate'+Str(chan)+' tagGate',-1);
   LastGate[chan]:=0;
  end;
  DEWTORH_Reset(-1);
  Success('defAirTemperature = '+Str(defAirTemperature));
  Success('defAirPressure    = '+Str(defAirPressure));
  Success('AutoReset         = '+Str(Ord(AutoReset)));
  Success('NumChans          = '+Str(NumChans));
  Success('nFormula          = '+Str(nFormula));
  Success('mFactor           = '+Str(mFactor));
 end;
 {
 Polling.
 }
 procedure DEWTORH_Poll;
 var chan,tag,Gate,ntd,nta,npa,npv,nrh,npm,nf,mf:Integer;
     x,td,ta,pa,pv,rh,pm:Real;
 begin
  for chan:=0 to NumChans-1 do begin
   tag:=tagGate[chan]; if TypeTag(tag)=1 then Gate:=iGetTag(tag) else Gate:=1;
   if LastGate[chan]<>Ord(Gate<>0) then begin
    if Gate<>0 then if AutoReset then DEWTORH_Reset(-1);
    LastGate[chan]:=Ord(Gate<>0);
   end;
   if Gate<>0 then begin
    ntd:=chan*AisPerChan+0; // temperature dewpoint [°C]
    nta:=chan*AisPerChan+1; // temperature air      [°C]
    npa:=chan*AisPerChan+2; // pressure    air      [mBar]
    npv:=chan*AosPerChan+0; // pressure    vapor    [mBar]
    nrh:=chan*AosPerChan+1; // relative    humidity [%RH]
    npm:=chan*AosPerChan+2; // moisture    volume   [PPMv]
    if GetAi_N(ntd)>0 then begin
     x:=GetAi_XN(ntd);
     if x>LastX[chan] then begin
      LastX[chan]:=x;
      td:=GetAi(ntd,x);
      if GetAi_N(nta)>0 then ta:=GetAi_YN(nta) else ta:=defAirTemp;
      if GetAi_N(npa)>0 then pa:=GetAi_YN(npa) else pa:=defAirPres;
      nf:=vapor_nFormula(nFormula,ta);     // Choose formula for vapor pressure
      mf:=vapor_mFactor(mFactor,ta);       // Choose formula for vapor factor
      pv:=vapor_pressure(td,pa,nf,mf);     // Calculate vapor pressure, mBar
      rh:=dewpoint_to_rh(td,ta,pa,nf,mf);  // Calculate relative humidity, %RH
      pm:=dewpoint_to_ppmv(td,pa,nf,mf);   // Calculate volume moisture, ppm(v)
      UpdateAo(npv,x,pv);
      UpdateAo(nrh,x,rh);
      UpdateAo(npm,x,pm);
      if iAnd(DebugFlags,dfDetails)>0 then begin
       Details('Chan='+Str(chan)
              +', Td='+Str(td)
              +', Ta='+Str(ta)
              +', Pa='+Str(pa)
              +', Pv='+Str(pv)
              +', RH='+Str(rh)
              +', Pm='+Str(pm));
      end;
     end;
    end;
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearPhysLibrary;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  InitPhysLibrary;
  DEWTORH_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreePhysLibrary;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollPhysLibrary;
  DEWTORH_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Reset
   @Reset 1
   }
   if IsSameText(cmd,'@Reset') then begin
    n:=iValDef(arg,-1); DEWTORH_Reset(n);
    Success(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @Clear
   @Clear 1
   }
   if IsSameText(cmd,'@Clear') then begin
    n:=iValDef(arg,-1); DEWTORH_Clear(n);
    Success(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @TestHumidityCalc 10 21 1013.25
   }
   if IsSameText(cmd,'@TestHumidityCalc') then begin
    TestHumidityCalc(arg);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
