 {
 ***********************************************************************
 Daq Pascal application program I7053_drv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Poll Flag - Enable Polling 
| (Flag = 1+2+4+8+16+32+64+128 - Read: DO+WDS+WDT+PODO+WDDO+CONF+VERS+NAME)
| @InvertDIData - Invert Digital Inputs Data
| @SetCfg NNTTCCFF - Set Configuration
| NN=New Address(0 to FF), TT - Must be 40, CC - BaudRate,
| FF - 00 (No CheckSum) or 40 (With CheckSum)
| @ReadCfg - Read Module Configuration
| @ReadVer - Read Firmware Version
| @ReadName - Read Module Name
| @SetName NAME - Set Module Name (NAME = Name, Maximum Length = 6)
| @ReadDI - Read Digital Input Data
| @ReadCntDI Channel - Read Counter Value of Channel (Channel - 1 to 16)
| @RstCntDI Channel - Reset Counter Value of Channel (Channel - 1 to 16)
| @ReadWDStatus - Read WatchDog Status
| @ReadWDTimeout - Read WatchDog WatchDog Timeout
| @SetWDStatus T Enabled - Set WatchDog Status (T - Timeout 0.1 - 25.5 s, Enbaled - 0 or 1)
| @RstWDStatus - Reset WatchDog Status
| @MenuTools - Open Menu Tools
|********************************************************
[]
 }
program I7053_drv;
const
 {------------------------------}{ Declare uses program constants:                }
 {$I _con_StdLibrary}            { Include all Standard constants,                }
 {------------------------------}{ And add User defined constants:                }
 {$I _con_NetRS485}              { Include RS485Proxy   constants.  }
 cm_SetModuleConf     = 1;       { ID CMD: Set Module Configuration               }
 cm_SetModuleName     = 2;       { ID CMD: Read Module Configuration              }
 cm_HostIsOk          = 3;       { ID CMD: Read Firmware Version                  }
 cm_SetWDTStatus      = 4;       { ID CMD: Read Module Name                       }
 cm_RstWDTStatus      = 5;       { ID CMD: Set Module Name                        }
 cm_ReadModuleConf    = 6;       { ID CMD: Read Digital Inputs                    }
 cm_ReadFirmwarVer    = 7;       { ID CMD: Read Counter Value Digital Input 1      }
 cm_ReadModuleName    = 8;       { ID CMD: Read Counter Value Digital Input 2      }
 cm_ReadDigitalInp    = 9;       { ID CMD: Read Counter Value Digital Input 3      }
 cm_ReadCntDigitInp1  = 10;       { ID CMD: Read Counter Value Digital Input 4      }
 cm_ReadCntDigitInp2  = 11;      { ID CMD: Read Counter Value Digital Input 5      }
 cm_ReadCntDigitInp3  = 12;      { ID CMD: Read Counter Value Digital Input 6      }
 cm_ReadCntDigitInp4  = 13;      { ID CMD: Read Counter Value Digital Input 7      }
 cm_ReadCntDigitInp5  = 14;      { ID CMD: Read Counter Value Digital Input 8      }
 cm_ReadCntDigitInp6  = 15;      { ID CMD: Read Counter Value Digital Input 9      }
 cm_ReadCntDigitInp7  = 16;      { ID CMD: Read Counter Value Digital Input 10     }
 cm_ReadCntDigitInp8  = 17;      { ID CMD: Read Counter Value Digital Input 11     }
 cm_ReadCntDigitInp9  = 18;      { ID CMD: Read Counter Value Digital Input 12     }
 cm_ReadCntDigitInp10 = 19;      { ID CMD: Read Counter Value Digital Input 13     }
 cm_ReadCntDigitInp11 = 20;      { ID CMD: Read Counter Value Digital Input 14     }
 cm_ReadCntDigitInp12 = 21;      { ID CMD: Read Counter Value Digital Input 15     }
 cm_ReadCntDigitInp13 = 22;      { ID CMD: Read Counter Value Digital Input 16     }
 cm_ReadCntDigitInp14 = 23;      { ID CMD: Reset Digital Input                    }
 cm_ReadCntDigitInp15 = 24;      { ID CMD: Read WatchDog Status                   }
 cm_ReadCntDigitInp16 = 25;      { ID CMD: Read WatchDog Timeout and enabling     }
 cm_RstCntDigitInp    = 26;      { ID CMD: Set WatchDog Timout and enabling       }
 cm_ReadWDTStatus     = 27;      { ID CMD: Reset WatchDog Status if events        }
 cm_ReadWDTimeOut     = 28;      { ID CMD: Host is Ok                             }
 MaxCmdNum            = 28;      { Maximal count of commands                      }
 do_state             = 0;       { DO : State                                     }
 do_didata            = 1;       { DO : Digital Inputs Data                       }
 do_cnt_di1           = 2;       { DO : Counter Value Digital Input 1             }
 do_cnt_di2           = 3;       { DO : Counter Value Digital Input 2             }
 do_cnt_di3           = 4;       { DO : Counter Value Digital Input 3             }
 do_cnt_di4           = 5;       { DO : Counter Value Digital Input 4             }
 do_cnt_di5           = 6;       { DO : Counter Value Digital Input 5             }
 do_cnt_di6           = 7;       { DO : Counter Value Digital Input 6             }
 do_cnt_di7           = 8;       { DO : Counter Value Digital Input 7             }
 do_cnt_di8           = 9;       { DO : Counter Value Digital Input 8             }
 do_cnt_di9           = 10;      { DO : Counter Value Digital Input 9             }
 do_cnt_di10          = 11;      { DO : Counter Value Digital Input 10            }
 do_cnt_di11          = 12;      { DO : Counter Value Digital Input 11            }
 do_cnt_di12          = 13;      { DO : Counter Value Digital Input 12            }
 do_cnt_di13          = 14;      { DO : Counter Value Digital Input 13            }
 do_cnt_di14          = 15;      { DO : Counter Value Digital Input 14            }
 do_cnt_di15          = 16;      { DO : Counter Value Digital Input 15            }
 do_cnt_di16          = 17;      { DO : Counter Value Digital Input 16            }
 do_rx                = 18;      { DO : Recieve rate                              }
 do_tx                = 19;      { DO : Transmite rate                            }
 stt_Disable          = 0;       { Status flag: Disable                           }
 stt_Work             = 1;       { Status flag: Work                              }
 stt_TimeOut          = 2;       { Status flag: TimeOut                           }
 stt_Refused          = 3;       { Status flag: Refused                           }
 stt_WatchDog         = 4;       { Status flag: WatchDog event                    }
 stt_Simulator        = 5;       { Status flag: Simulator                         }
 MaxChannelNum        = 16;      { Device Channel Number                          }
 MaxValDIData         = 65535;   { Max Value Digital Inputs Data                  }
 defTypeCode          = 64;      { Default Device Type                            }
 defBaudRate          = 10;      { Default Baudrate                               }
 defDataFormat        = 3;       { Default Data Format                            }
 bit_cm_ReadDigitalInp    = 0;
 bit_cm_ReadWDTStatus     = 1;
 bit_cm_ReadWDTimeOut     = 2;
 bit_cm_ReadModuleConf    = 3;
 bit_cm_ReadFirmwarVer    = 4;
 bit_cm_ReadModuleName    = 5;
 bit_cm_ReadCntDigitInp1  = 6;
 bit_cm_ReadCntDigitInp2  = 7;
 bit_cm_ReadCntDigitInp3  = 8;
 bit_cm_ReadCntDigitInp4  = 9;
 bit_cm_ReadCntDigitInp5  = 10;
 bit_cm_ReadCntDigitInp6  = 11;
 bit_cm_ReadCntDigitInp7  = 12;
 bit_cm_ReadCntDigitInp8  = 13;
 bit_cm_ReadCntDigitInp9  = 14;
 bit_cm_ReadCntDigitInp10 = 15;
 bit_cm_ReadCntDigitInp11 = 16;
 bit_cm_ReadCntDigitInp12 = 17;
 bit_cm_ReadCntDigitInp13 = 18;
 bit_cm_ReadCntDigitInp14 = 19;
 bit_cm_ReadCntDigitInp15 = 20;
 bit_cm_ReadCntDigitInp16 = 21;
 le_req = '0D';
 
type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 
var
 {------------------------------}{ Declare uses program variables:      }
 {$I _var_StdLibrary}            { Include all Standard variables,      }
 {------------------------------}{ And add User defined variables:      }
 {$I _var_NetRS485}              { Include RS485Proxy   variables.  }
 cmd_DimCmdMy      : Integer;    { System Command @DIMCMDMY             }
 cmd_DimTagUpdate  : Integer;    { System Command @DimTagUpdate         }
 cmd_RsReply       : Integer;    { Command @RS485.Reply             }
 cmd_RsPoll        : Integer;    { Command @RS485.Poll              }
 cmd_RsRefuse      : Integer;    { Command @RS485.Refuse            }
 cmd_RsTimeout     : Integer;    { Command @RS485.Timeout           }
 cmd_RsClrSumm     : Integer;    { Command @ClearRS485Sum           }
 cmd_Poll          : Integer;    { Console Command @Poll flag           }
 cmd_InvertDIData  : Integer;    { Console Command @InvertDIData        }
 cmd_SetCfg        : Integer;    { Console Command @SetCfg NNTTCCFF     }
 cmd_ReadCfg       : Integer;    { Console Command @ReadCfg             }
 cmd_ReadVer       : Integer;    { Console Command @ReadVer             }
 cmd_ReadName      : Integer;    { Console Command @ReadName            }
 cmd_SetName       : Integer;    { Console Command @SetName NAME        }
 cmd_ReadDI        : Integer;    { Console Command @ReadDI              }
 cmd_ReadCntDI     : Integer;    { Console Command @ReadCntDI           }
 cmd_RstCntDI      : Integer;    { Console Command @RstCntDI            }
 cmd_ReadWDStatus  : Integer;    { Console Command @ReadWDStatus        }
 cmd_ReadWDTimeout : Integer;    { Console Command @ReadWDTimeout       }
 cmd_SetWDStatus   : Integer;    { Console Command @SetWDStatus T En    }
 cmd_RstWDStatus   : Integer;    { Console Command @RstWDStatus         }
 cmd_MenuTools     : Integer;    { Console Command @MenuTools           }
 I7053             : record      { I7053 Data                           }
  Simulator         : Boolean;   { Simulator Mode                       }
  WDReconnect       : Boolean;   { WatchDog AutoReconnect               }
  InvertedData      : Boolean;   { Iverted Digital Inputs Data          }
  isCheckSum        :Boolean;
  ChNumber          : Integer;   { Channel Number                       }
  ChState           : Boolean;   { Channel State                        }
  StartPoll         : Integer;
  SERVMODE          : TTagRef;   { Tag: Dim Server Mode?                }
  POLL              : TTagRef;   { Tag: Flags for Poll                  }
  POLL_NOTIFY       : TTagRef;   { Tag: Notify for action confirm       }
  RX                : TTagRef;   { Tag: Recieve rate data               }
  TX                : TTagRef;   { Tag: Transmite rate data             }
  STATE             : TTagRef;   { Tag: State of device                 }
  DIDATA            : TTagRef;   { Tag: Digital Outputs data            }
  INVERT            : TTagRef;   { Tag: Invert Digital Inputs Data      }
  DI                : array[1..MaxChannelNum] of TTagRef;{ Tags: Digital Input 1..16 }
  CNT               : record
   DI               : array[1..MaxChannelNum] of TTagRef;{ Tags: Counter Digital Input 1..16 }
  end;
  NAME              : TTagRef;   { Tag: Name of device                  }
  VERSION           : TTagRef;   { Tag: Firmware Version of device      }
  ADDRESS           : TTagRef;   { Tag: Address of device               }
  BAUDRATE          : TTagRef;   { Tag: Baudrate of device              }
  CHECKSUM          : TTagRef;   { Tag: Checksum Enabled?               }
  PARITY            : TTagRef;   { Tag: Parity parameter                }
  WDTIMEOUT         : TTagRef;   { Tag: WatchDog TimeOut                }
  WDSTATUS          : TTagRef;   { Tag: WatchDog Status                 }
  WDENDIS           : TTagRef;   { Tag: Enable/Disable WatchDog button  }
  CmdTab         : Record
   Num            : Integer;      { Current running command number         }
   Enabled        : array [1..MaxCmdNum] of Boolean; { Enable polling      }
   CmdChar        : array [1..MaxCmdNum] of Char;
   CmdMode        : array [1..MaxCmdNum] of String;
   Acronym        : array [1..MaxCmdNum] of String;  { Accronym of command }
   OpData         : array [1..MaxCmdNum] of String;  { Operation Data      }
   PollCnt        : Integer;
  end;
  RS485             : Record
   Port              : Integer;       { Logical Port on &RS485Proxy         }
   UnitId            : Integer;       { Modbus unit id                       }
   Timeout           : Integer;       { Modbus timeout, ms                   }
   Polling           : Integer;       { Modbus polling period, ms            }
   Deadline          : Integer;       { Modbus deadline time, ms             }
   DelayOnStart      : Integer;       { Command cycle delay on start         }
   Poll              : record
    ref               : Integer;          { Last sent device reference           }
    cid               : Integer;          { Last sent command id                 }
    tim               : Real;             { Last polling time, ms                }
    port              : Integer;          { Last polling port                    }
    uid               : Integer;          { Last polling unit id                 }
    dat               : String;           { Last sent data         }
    Summ              : record
     Rx                : Integer;
     Tx                : Integer;
    end;
    Rate              : record
     Rx                : Integer;
     Tx                : Integer;
    end;
   end;
  end;                         
  WatchdogTime   : Real;         { Watchdog deadline time, sec          }
  HostIsOkPeriod : Integer;      { Watchdog HostIsOk period, ms         }
  TypeCode       : Integer;      { Type code of module                  }
  NewBaudRate    : Integer;      { BaudRate  of module                  }
  DataFormat     : Integer;      { Data format of module                }
  PollConfirm    : Boolean;      { Poll Dialog is Action?               }
  EnableWD       : Integer;      { Enable WatchDog for send             }
  TimeoutWD      : Real;         { TimeOut WatchDog for send            }
 end;

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetRS485}              { Include RS485Proxy   functions.  }
 
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Prefix for DIM @remote commands.
 }
 function DimRemote:String;
 var CanRemote:Boolean;
 begin
  CanRemote:=DIM_IsServerMode or DIM_IsClientMode;
  if (DIM_GuiClickTag=0) then CanRemote:=false;
  if (devDimSrv=0) then CanRemote:=false;
  if CanRemote
  then DimRemote:='@remote '
  else DimRemote:='';
 end;
 {
 Clear Strings
 }
 Procedure I7053_ClearStrings;
 var i:Integer;
 begin
  I7053.RS485.Poll.dat:='';
  for i:=1 to MaxCmdNum do begin
   I7053.CmdTab.Acronym[i]:='';
   I7053.CmdTab.OpData[i]:='';
   I7053.CmdTab.CmdMode[i]:='';
  end;
 end;
 {
 Clear Data
 }
 Procedure I7053_Clear;
 var i:Integer;
 begin
  I7053.RS485.Port        :=0;
  I7053.RS485.UnitId      :=0;
  I7053.RS485.Timeout     :=0;
  I7053.RS485.Polling     :=0;
  I7053.RS485.Deadline    :=0;
  I7053.RS485.DelayOnStart:=0;
  I7053.RS485.Poll.ref    :=0;
  I7053.RS485.Poll.cid    :=0;
  I7053.RS485.Poll.tim    :=0;
  I7053.RS485.Poll.port   :=0;
  I7053.RS485.Poll.uid    :=0;
  I7053.RS485.Poll.Rate.Rx:=0;
  I7053.RS485.Poll.Rate.Tx:=0;
  I7053.RS485.Poll.Summ.Rx:=0;
  I7053.RS485.Poll.Summ.Tx:=0;
  I7053.CmdTab.Num        :=0;
  for i:=1 to MaxCmdNum do begin
   I7053.CmdTab.Enabled[i]:=false;
  end;
  I7053.HostIsOkPeriod:=0;
 end;
 {
 Initialize tag refreshment value.
 }
 procedure I7053_FillTag(tag:Integer; InitVal:Real);
 var i:Integer;
  procedure Process(var R:TTagRef);
  begin
   if (R.tag=tag) then bNul(ShouldRefresh(R.val,InitVal)>0);
  end;
 begin
  if (TypeTag(tag)>0) then begin
   Process(I7053.POLL);
   Process(I7053.RX);
   Process(I7053.TX);
   Process(I7053.STATE);
   Process(I7053.DIDATA);
   for i:=1 to MaxChannelNum do begin
    Process(I7053.DI[i]);
    Process(I7053.CNT.DI[i]);
   end;
   Process(I7053.INVERT);
   Process(I7053.NAME);
   Process(I7053.VERSION);
   Process(I7053.ADDRESS);
   Process(I7053.BAUDRATE);
   Process(I7053.CHECKSUM);
   Process(I7053.PARITY);
   Process(I7053.WDTIMEOUT);
   Process(I7053.WDSTATUS);
   Process(I7053.WDENDIS);
  end;
 end;
 {
 I7053 tag Initialization
 }
 procedure I7053_FillTags(InitVal:Real);
 var i:Integer;
 begin
  I7053.POLL.val     :=InitVal;
  I7053.RX.val       :=InitVal;
  I7053.TX.val       :=InitVal;
  I7053.STATE.val    :=InitVal;
  I7053.DIDATA.val   :=InitVal;
  for i:=1 to MaxChannelNum do begin
   I7053.DI[i].val      :=InitVal;
   I7053.CNT.DI[i].val  :=InitVal;
  end;
  I7053.INVERT.val     :=InitVal;
  I7053.NAME.val     :=InitVal;
  I7053.VERSION.val  :=InitVal;
  I7053.ADDRESS.val  :=InitVal;
  I7053.BAUDRATE.val :=InitVal;
  I7053.CHECKSUM.val :=InitVal;
  I7053.PARITY.val   :=InitVal;
  I7053.WDTIMEOUT.val:=InitVal;
  I7053.WDSTATUS.val :=InitVal;
  I7053.WDENDIS.val  :=InitVal;
 end;
 procedure I7053_InitTags(Prefix:String; InitVal:Real);
 var i:Integer;
 begin
  if not IsEmptyStr(Prefix) then begin
   DIM_GuiClickInit(Prefix+'.DIMGUICLICK');
   InitTag(I7053.SERVMODE.tag ,Prefix+'.SERVMODE' ,1);
   InitTag(I7053.POLL_NOTIFY.tag, Prefix+'.POLL.NOTIFY' ,1);
   InitTag(I7053.POLL.tag     ,Prefix+'.POLL'     ,1);
   InitTag(I7053.RX.tag       ,Prefix+'.RX'       ,1);
   InitTag(I7053.TX.tag       ,Prefix+'.TX'       ,1);
   InitTag(I7053.STATE.tag    ,Prefix+'.STATE'    ,1);
   InitTag(I7053.DIDATA.tag   ,Prefix+'.DIDATA'   ,1);
   for i:=1 to MaxChannelNum do begin
    InitTag(I7053.DI[i].tag     ,Prefix+'.DI'+str(i)    ,1);
    InitTag(I7053.CNT.DI[i].tag ,Prefix+'.CNT.DI'+str(i),1);
   end;
   InitTag(I7053.INVERT.tag   ,Prefix+'.INVERT'   ,1);
   InitTag(I7053.NAME.tag     ,Prefix+'.NAME'     ,3);
   InitTag(I7053.VERSION.tag  ,Prefix+'.VERSION'  ,3);
   InitTag(I7053.ADDRESS.tag  ,Prefix+'.ADDRESS'  ,1);
   InitTag(I7053.BAUDRATE.tag ,Prefix+'.BAUDRATE' ,1);
   InitTag(I7053.CHECKSUM.tag ,Prefix+'.CHECKSUM' ,1);
   InitTag(I7053.PARITY.tag   ,Prefix+'.PARITY'   ,1);
   InitTag(I7053.WDTIMEOUT.tag,Prefix+'.WDTIMEOUT',2);
   InitTag(I7053.WDSTATUS.tag ,Prefix+'.WDSTATUS' ,1);
   InitTag(I7053.WDENDIS.tag  ,Prefix+'.WDENDIS'  ,1);
   I7053_FillTags(InitVal);
  end;
 end;
 {
 Allowed Success/Trouble/ViewImp/ViewExp/Details.
 }
 function AllowedSuccess:Boolean; begin AllowedSuccess:=iAnd(dfSuccess,DebugFlags)>0; end;
 function AllowedTrouble:Boolean; begin AllowedTrouble:=iAnd(dfTrouble,DebugFlags)>0; end;
 function AllowedViewExp:Boolean; begin AllowedViewExp:=iAnd(dfViewExp,DebugFlags)>0; end;
 function AllowedViewImp:Boolean; begin AllowedViewImp:=iAnd(dfViewImp,DebugFlags)>0; end;
 function AllowedDetails:Boolean; begin AllowedDetails:=iAnd(dfDetails,DebugFlags)>0; end;
 {
 Enable command with given command identifier.
 }
 procedure I7053_EnableCmdId(CmdId:Integer; Enabled:Boolean);
 begin
  if CmdId<=MaxCmdNum then I7053.CmdTab.Enabled[CmdId]:=Enabled;
 end;
 {
 Initialization Command Table
 }
 Procedure I7053_InitCmdItem(CmdId,Enabled:Integer; CmdChar:Char; CmdMode,OpData,Comment:String);
 begin
  I7053.CmdTab.Enabled[CmdId]:=Enabled>0;
  I7053.CmdTab.CmdChar[CmdId]:=CmdChar;
  I7053.CmdTab.CmdMode[CmdId]:=CmdMode;
  if CmdId<>cm_HostIsOk 
  then I7053.CmdTab.Acronym[CmdId]:=CmdChar+HexB(I7053.RS485.UnitId)+CmdMode
  else I7053.CmdTab.Acronym[CmdId]:=CmdChar+CmdMode;
  I7053.CmdTab.OpData[CmdId]:=OpData;
  Details('Command Id: '+str(CmdId)+' - '+I7053.CmdTab.Acronym[CmdId]+' - '+Comment);
 end;
 {
 Reset command table.
 }
 procedure I7053_InitCmdTable;
 begin
  //                CMD ID           Enabled  CmdChar   CmdMode              OpData  Comment
  I7053_InitCmdItem(cm_SetModuleConf    ,  0 ,   '%'     , ''                  ,'','Set Module Configuration');           //ans !AA
  I7053_InitCmdItem(cm_SetModuleName    ,  0 ,   '~'     , stringofchar('O',1) ,'','Set Module Name');                    //ans !AA
  I7053_InitCmdItem(cm_HostIsOk         ,  0 ,   '~'     , '**'                ,'','HostIsOk Notification');              //no ans
  I7053_InitCmdItem(cm_SetWDTStatus     ,  0 ,   '~'     , stringofchar('3',1) ,'','Set WatchDog Timeout Status');        //ans !AA
  I7053_InitCmdItem(cm_RstWDTStatus     ,  0 ,   '~'     , stringofchar('1',1) ,'','Reset WatchDog TimeOut Status');      //ans !AA
  I7053_InitCmdItem(cm_ReadModuleConf   ,  1 ,   '$'     , stringofchar('2',1) ,'','Read Module Configuration');          //ans !AANNCCFF
  I7053_InitCmdItem(cm_ReadFirmwarVer   ,  1 ,   '$'     , stringofchar('F',1) ,'','Read Firmware Version');              //ans !AAdata
  I7053_InitCmdItem(cm_ReadModuleName   ,  1 ,   '$'     , stringofchar('M',1) ,'','Read Module Name');                   //ans !AAdata
  I7053_InitCmdItem(cm_ReadDigitalInp   ,  1 ,   '@'     , ''                  ,'','Read Digital Inputs');                //ans >data
  I7053_InitCmdItem(cm_ReadCntDigitInp1 ,  1 ,   '#'     , stringofchar('0',1) ,'','Read Counter Value Digital Input 1'); //ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp2 ,  1 ,   '#'     , stringofchar('1',1) ,'','Read Counter Value Digital Input 2'); //ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp3 ,  1 ,   '#'     , stringofchar('2',1) ,'','Read Counter Value Digital Input 3'); //ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp4 ,  1 ,   '#'     , stringofchar('3',1) ,'','Read Counter Value Digital Input 4'); //ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp5 ,  1 ,   '#'     , stringofchar('4',1) ,'','Read Counter Value Digital Input 5'); //ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp6 ,  1 ,   '#'     , stringofchar('5',1) ,'','Read Counter Value Digital Input 6'); //ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp7 ,  1 ,   '#'     , stringofchar('6',1) ,'','Read Counter Value Digital Input 7'); //ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp8 ,  1 ,   '#'     , stringofchar('7',1) ,'','Read Counter Value Digital Input 8'); //ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp9 ,  1 ,   '#'     , stringofchar('8',1) ,'','Read Counter Value Digital Input 9'); //ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp10,  1 ,   '#'     , stringofchar('9',1) ,'','Read Counter Value Digital Input 10');//ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp11,  1 ,   '#'     , stringofchar('A',1) ,'','Read Counter Value Digital Input 11');//ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp12,  1 ,   '#'     , stringofchar('B',1) ,'','Read Counter Value Digital Input 12');//ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp13,  1 ,   '#'     , stringofchar('C',1) ,'','Read Counter Value Digital Input 13');//ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp14,  1 ,   '#'     , stringofchar('D',1) ,'','Read Counter Value Digital Input 14');//ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp15,  1 ,   '#'     , stringofchar('E',1) ,'','Read Counter Value Digital Input 15');//ans !AAdata
  I7053_InitCmdItem(cm_ReadCntDigitInp16,  1 ,   '#'     , stringofchar('F',1) ,'','Read Counter Value Digital Input 16');//ans !AAdata
  I7053_InitCmdItem(cm_RstCntDigitInp   ,  0 ,   '$'     , stringofchar('C',1) ,'','Reset Counter Value Digital Input');  //ans !AA
  I7053_InitCmdItem(cm_ReadWDTStatus    ,  1 ,   '~'     , stringofchar('0',1) ,'','Read WatchDog Status');               //ans !AASS
  I7053_InitCmdItem(cm_ReadWDTimeOut    ,  1 ,   '~'     , stringofchar('2',1) ,'','Read WatchDog TimeOut Value');        //ans !AAVV
  I7053.CmdTab.PollCnt:=0;
 end;
 {
 Initialize I7053 parameters
 }
 Procedure I7053_Init;
 var r:Real;
 begin
  I7053_Clear;
  I7053_ClearStrings;
  I7053_InitTags(ReadIni('tagPrefix'),-MaxReal);
  I7053.Simulator:=iValDef(ReadIni('Simulator'),0)>0;
  I7053.WDReconnect:=iValDef(ReadIni('WDReconnect'),0)>0;
  I7053.isChecksum:=iValDef(ReadIni('Checksum'),0)>0;
  I7053.InvertedData:=iValDef(ReadIni('InvertedData'),0)>0;
  if not I7053.Simulator then begin
   I7053.RS485.Port        :=iValDef(ReadIni('RS485Port'),1);
   I7053.RS485.UnitId      :=iValDef(ReadIni('RS485UnitId'),1);
   I7053.RS485.Timeout     :=iValDef(ReadIni('RS485Timeout'),250);
   I7053.RS485.Polling     :=iValDef(ReadIni('RS485Polling'),10);
   I7053.RS485.Deadline    :=iValDef(ReadIni('RS485Deadline'),60000);
   I7053.RS485.DelayOnStart:=iValDef(ReadIni('DelayOnStart'),1000);
   r:=Max(0,Min(25.5,rValDef(ReadIni('WatchdogTime'),0)));
   bNul(rSetTag(I7053.WDTIMEOUT.tag,r));
   Success('WatchdogTime = '+Str(rGetTag(I7053.WDTIMEOUT.tag)));
  end else begin
   bNul(sSetTag(I7053.NAME.tag,'Simula'));
   bNul(sSetTag(I7053.VERSION.tag,'SimVer'));
   bNul(iSetTag(I7053.BAUDRATE.tag,3));
  end;
  I7053_InitCmdTable;
  {
  Initialize variables...
  }
  I7053.TypeCode:=defTypeCode;
  I7053.NewBaudRate:=defBaudRate;
  I7053.DataFormat:=defDataFormat;
  {
  Register console commands...
  }
  cmd_DimTagUpdate:= RegisterStdInCmd('@DimTagUpdate','');
  cmd_DimCmdMy    := RegisterStdInCmd('@DIMCMDMY','');
  cmd_RsReply     := RegisterStdInCmd('@RS485.Reply'   ,'');
  cmd_RsPoll      := RegisterStdInCmd('@RS485.Poll'    ,'');
  cmd_RsRefuse    := RegisterStdInCmd('@RS485.Refuse'  ,'');
  cmd_RsTimeout   := RegisterStdInCmd('@RS485.Timeout' ,'');
  cmd_RsClrSumm   := RegisterStdInCmd('@ClearRS485Sum' ,'');
  cmd_Poll         :=RegisterStdInCmd('@Poll','');
  cmd_InvertDIData :=RegisterStdInCmd('@InvertDIData','');
  cmd_SetCfg       :=RegisterStdInCmd('@SetCfg','');
  cmd_ReadCfg      :=RegisterStdInCmd('@ReadCfg','');
  cmd_ReadVer      :=RegisterStdInCmd('@ReadVer','');
  cmd_ReadName     :=RegisterStdInCmd('@ReadName','');
  cmd_SetName      :=RegisterStdInCmd('@SetName','');
  cmd_ReadDI       :=RegisterStdInCmd('@ReadDI','');
  cmd_ReadCntDI    :=RegisterStdInCmd('@ReadCntDI','');
  cmd_RstCntDI     :=RegisterStdInCmd('@RstCntDI','');
  cmd_ReadWDStatus :=RegisterStdInCmd('@ReadWDStatus','');
  cmd_ReadWDTimeout:=RegisterStdInCmd('@ReadWDTimeout','');
  cmd_SetWDStatus  :=RegisterStdInCmd('@SetWDStatus','');
  cmd_RstWDStatus  :=RegisterStdInCmd('@RstWDStatus','');
  cmd_MenuTools    :=RegisterStdInCmd('@MenuTools','');
  bNul(iSetTag(I7053.ADDRESS.tag,I7053.RS485.UnitId));
  bNul(iSetTag(I7053.INVERT.tag,ord(I7053.InvertedData)));
  if DIM_IsServerMode then bNul(iSetTag(I7053.SERVMODE.tag,0)) else
  if DIM_IsClientMode then bNul(iSetTag(I7053.SERVMODE.tag,1));
 end;
 {
 Command cycle routines.
 }
 function IsValidCmdNum(Num:Integer):Boolean;
 begin
  IsValidCmdNum:=(1<=Num) and (Num<=MaxCmdNum);
 end;
 function ValidateCmdNum(Num:Integer):Integer;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then ValidateCmdNum:=Num
  else ValidateCmdNum:=1;
 end;
 function IsEnabledCmdNum(Num:Integer):Boolean;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then IsEnabledCmdNum:=I7053.CmdTab.Enabled[Num]
  else IsEnabledCmdNum:=False;
 end;
 function NextEnabledCmdNum(Num:Integer):Integer;
 var i:Integer; oldNum:Integer;
 begin
  i:=0;
  oldNum:=Num;
  while (i<=MaxCmdNum) do begin
   Num:=ValidateCmdNum(Num+1);
   if IsEnabledCmdNum(Num)
   then i:=MaxCmdNum+1
   else i:=i+1;
  end;
  if Num<=oldNum then I7053.CmdTab.PollCnt:=I7053.CmdTab.PollCnt+1;
  NextEnabledCmdNum:=Num;
 end;
 {
 Find the current Proxy device to send @RS485.Poll message.
 }
 function devTheProxy:Integer;
 begin
  //if I7053.Simulator                // In simulation mode
  //then devTheProxy:=devMySelf       // send messages to himself
  //else devTheProxy:=devModbusProxy; // otherwise use &ModbusProxy
  devTheProxy:=devRS485Proxy;
 end;
 {
 Check if communication port is opened or not.
 As long as we use Proxy device, check Port number & device reference.
 }
 function IsPortOpened:Boolean;
 begin
  IsPortOpened:=(I7053.RS485.Port>0) and (devTheProxy<>0);
 end;
 {
 Assign RS485 last sent polling request record.
 }
 procedure AssignRS485Poll(ref,cid:Integer; tim:Real; port,uid:Integer; dat:String);
 begin
  I7053.RS485.Poll.ref:=ref;     I7053.RS485.Poll.cid:=cid;     I7053.RS485.Poll.tim:=tim;
  I7053.RS485.Poll.port:=port;   I7053.RS485.Poll.uid:=uid;     I7053.RS485.Poll.dat:=dat;
 end;
 {
 Clear RS485 polling request to be ready for next polling.
 }
 procedure ClearRS485Poll;
 begin
  I7053.RS485.Poll.cid:=0;
  I7053.RS485.Poll.dat:='';
 end;
 {
 Clear RS485 pollrate
 }
 procedure ClearRS485Rate;
 begin
  I7053.RS485.Poll.Rate.Rx:=0;
  I7053.RS485.Poll.Rate.Tx:=0;
 end;
 //
 // Increment summ and rate counters.
 //
 procedure IncSummRate(var summ,rate:Integer);
 begin
  summ:=summ+1; rate:=rate+1;
 end;
 //
 // Format error message with with error counter increment.
 // Usage is like: Trouble(GotBug(...)); Problem(GotBug(...));
 //
 function GotBug(msg:String):String;
 begin
  GotBug:=msg;
 end;
 {
 Validating Type Code
 I7053 Type Code: $40 (hex)
 }
 function isValidTypeCode(TT:Integer):boolean;
 begin
  isValidTypeCode:=eq(TT,64);
 end;
 function ValidateTypeCode(TT:Integer):Integer;
 begin
  ValidateTypeCode:=I7053.TypeCode;
  if isValidTypeCode(TT) then ValidateTypeCode:=TT else Problem('Invalid Type Code: '+HexB(TT));
 end;
 {
 Validating BaudRate
 I7053 BaudRate: $03-$0A (hex)
 }
 function isValidBaudrate(CC:Integer):boolean;
 begin
  isValidBaudrate:=(ge(CC,3) and le(CC,10));
 end;
 function ValidateBaudRate(CC:Integer):Integer;
 begin
  ValidateBaudRate:=I7053.NewBaudRate;
  if isValidBaudrate(CC) then ValidateBaudRate:=CC else Problem('Invalid BaudRate: '+HexB(CC));
 end;
 {
 Validating DataFormat
 I7053 DataFormat: $00,$40 (hex)
 }
 function isValidDataFormat(FF:integer):boolean;
 begin
  isValidDataFormat:=(eq(FF,67) or eq(FF,3) or eq(FF,131) or eq(FF,195));
 end;
 function ValidateDataFormat(FF:Integer):Integer;
 begin
  ValidateDataFormat:=I7053.DataFormat;
  if isValidDataFormat(FF) then ValidateDataFormat:=FF else Problem('Invalid DataFormat: '+HexB(FF));
 end;
 {
 EnablePoll
 }
 Procedure CalcHostIsOkPeriod;
 begin
  I7053.HostIsOkPeriod:=Ord(iGetTag(I7053.WDSTATUS.tag)=1)*Round(rGetTag(I7053.WDTIMEOUT.tag)*1000*0.5);
 end;
 Procedure PollEnable(cmd,bit:Integer);
 begin
  I7053_EnableCmdId(cmd,iGetTagBitState(I7053.POLL.tag,bit));
 end;
 Procedure I7053_EnablePoll(flag:Integer);//flag 1+2+4+8+16+32+64+128
 begin
  I7053_EnableCmdId(cm_ReadDigitalInp    ,iGetBitState(flag,bit_cm_ReadDigitalInp   )); //flag 1
  I7053_EnableCmdId(cm_ReadWDTStatus     ,iGetBitState(flag,bit_cm_ReadWDTStatus    )); //flag 2
  I7053_EnableCmdId(cm_ReadWDTimeOut     ,iGetBitState(flag,bit_cm_ReadWDTimeOut    )); //flag 4
  I7053_EnableCmdId(cm_ReadModuleConf    ,iGetBitState(flag,bit_cm_ReadModuleConf   )); //flag 8
  I7053_EnableCmdId(cm_ReadFirmwarVer    ,iGetBitState(flag,bit_cm_ReadFirmwarVer   )); //flag 16
  I7053_EnableCmdId(cm_ReadModuleName    ,iGetBitState(flag,bit_cm_ReadModuleName   )); //flag 32
  I7053_EnableCmdId(cm_ReadCntDigitInp1  ,iGetBitState(flag,bit_cm_ReadCntDigitInp1 )); //flag 64
  I7053_EnableCmdId(cm_ReadCntDigitInp2  ,iGetBitState(flag,bit_cm_ReadCntDigitInp2 )); //flag 128
  I7053_EnableCmdId(cm_ReadCntDigitInp3  ,iGetBitState(flag,bit_cm_ReadCntDigitInp3 )); //flag 256
  I7053_EnableCmdId(cm_ReadCntDigitInp4  ,iGetBitState(flag,bit_cm_ReadCntDigitInp4 )); //flag 512
  I7053_EnableCmdId(cm_ReadCntDigitInp5  ,iGetBitState(flag,bit_cm_ReadCntDigitInp5 )); //flag 1024
  I7053_EnableCmdId(cm_ReadCntDigitInp6  ,iGetBitState(flag,bit_cm_ReadCntDigitInp6 )); //flag 2048
  I7053_EnableCmdId(cm_ReadCntDigitInp7  ,iGetBitState(flag,bit_cm_ReadCntDigitInp7 )); //flag 4096
  I7053_EnableCmdId(cm_ReadCntDigitInp8  ,iGetBitState(flag,bit_cm_ReadCntDigitInp8 )); //flag 8192
  I7053_EnableCmdId(cm_ReadCntDigitInp9  ,iGetBitState(flag,bit_cm_ReadCntDigitInp9 )); //flag 16384
  I7053_EnableCmdId(cm_ReadCntDigitInp10 ,iGetBitState(flag,bit_cm_ReadCntDigitInp10)); //flag 32768
  I7053_EnableCmdId(cm_ReadCntDigitInp11 ,iGetBitState(flag,bit_cm_ReadCntDigitInp11)); //flag 65536
  I7053_EnableCmdId(cm_ReadCntDigitInp12 ,iGetBitState(flag,bit_cm_ReadCntDigitInp12)); //flag 131072
  I7053_EnableCmdId(cm_ReadCntDigitInp13 ,iGetBitState(flag,bit_cm_ReadCntDigitInp13)); //flag 262144
  I7053_EnableCmdId(cm_ReadCntDigitInp14 ,iGetBitState(flag,bit_cm_ReadCntDigitInp14)); //flag 524288
  I7053_EnableCmdId(cm_ReadCntDigitInp15 ,iGetBitState(flag,bit_cm_ReadCntDigitInp15)); //flag 1048576
  I7053_EnableCmdId(cm_ReadCntDigitInp16 ,iGetBitState(flag,bit_cm_ReadCntDigitInp16)); //flag 2097152
 end;
 {
 Update data curves & tags
 }
 Procedure UpdateModuleConfig(cfg:String);
 begin
  if AllowedSuccess then Success('ModuleConfig: '+cfg);
  I7053.TypeCode:=ValidateTypeCode(Val('$'+Copy(cfg,3,2)));
  if AllowedSuccess then Success('TypeCode: '  +HexB(I7053.TypeCode));
  I7053.NewBaudRate:=ValidateBaudRate(Val('$'+Copy(cfg,5,2)));
  bNul(iSetTag(I7053.BAUDRATE.tag,I7053.NewBaudRate));
  if AllowedSuccess then Success('BaudRate: '  +HexB(I7053.NewBaudRate));
  I7053.DataFormat:=ValidateDataFormat(Val('$'+Copy(cfg,7,2)));
  bNul(iSetTagBitState(I7053.CHECKSUM.tag,0,isbit(I7053.DataFormat,6)));
  if AllowedSuccess then Success('DataFormat: '+HexB(I7053.DataFormat));
  PollEnable(cm_ReadModuleConf,3);
 end;
 procedure UpdateModuleVersion(ver:String);
 begin
  if AllowedSuccess then Success('FirmwareVersion: '+ver);
  bNul(sSetTag(I7053.VERSION.tag,ver));
 end;
 procedure UpdateModuleName(name:String);
 begin
  if AllowedSuccess then Success('ModuleName: '+name);
  bNul(sSetTag(I7053.NAME.tag,name));
 end;
 procedure UpdateDigitalInputsData(digi:String);
 begin
  if AllowedSuccess then Success('DigitalInputs: '+digi);
  if iGetTag(I7053.INVERT.tag)=1 then bNul(iSetTag(I7053.DIDATA.tag,MaxValDIData-val('$'+digi))) else bNul(iSetTag(I7053.DIDATA.tag,val('$'+digi)));
  UpdateDo(do_didata,time,iGetTag(I7053.DIDATA.tag));
 end;
 procedure UpdateWDStatus(wds:String);
 begin
  if AllowedSuccess then Success('WatchDogStatus: '+wds);
  if iGetBitState(val('$'+wds),2) then begin
   bNul(iSetTag(I7053.WDSTATUS.tag,2));
   if iGetBitState(val('$'+wds),7) then bNul(iSetTag(I7053.WDENDIS.tag,1));
  end else begin
   if iGetBitState(val('$'+wds),7) then begin
    bNul(iSetTag(I7053.WDSTATUS.tag,1));
    bNul(iSetTag(I7053.WDENDIS.tag,1));
   end else begin
    bNul(iSetTag(I7053.WDENDIS.tag,0));
    bNul(iSetTag(I7053.WDSTATUS.tag,0));
   end;
  end;
  CalcHostIsOkPeriod;
 end;
 procedure UpdateWDTimeout(wdt:String);
 begin
  if AllowedSuccess then Success('WatchDogTimeout: '+wdt);
  if not (iGetTag(I7053.WDSTATUS.tag)=2) then bNul(iSetTag(I7053.WDSTATUS.tag,val(copy(wdt,1,1))));
  bNul(rSetTag(I7053.WDTIMEOUT.tag,(rval('$'+copy(wdt,2,2))/10)));
  CalcHostIsOkPeriod;
 end;
 procedure UpdateDigitalInputs;
 var i:Integer;
 begin
  for i:=1 to MaxChannelNum do bNul(iSetTag(I7053.DI[i].tag, Ord(iGetTagBitState(I7053.DIDATA.tag,i-1))));
 end;
 procedure UpdateCounterValue(chnum:Integer;cnt:String);
 begin
  if AllowedSuccess then Success('Counter Value Digital Input '+str(chnum)+ ' : '+cnt);
  bNul(iSetTag(I7053.CNT.DI[chnum].tag,val(cnt)));
  if (chnum>0) and (chnum<=16) then begin
   case chnum of
    1:UpdateDo(do_cnt_di1,time,iGetTag(I7053.DI[chnum].tag));
    2:UpdateDo(do_cnt_di2,time,iGetTag(I7053.DI[chnum].tag));
    3:UpdateDo(do_cnt_di3,time,iGetTag(I7053.DI[chnum].tag));
    4:UpdateDo(do_cnt_di4,time,iGetTag(I7053.DI[chnum].tag));
    5:UpdateDo(do_cnt_di5,time,iGetTag(I7053.DI[chnum].tag));
    6:UpdateDo(do_cnt_di6,time,iGetTag(I7053.DI[chnum].tag));
    7:UpdateDo(do_cnt_di7,time,iGetTag(I7053.DI[chnum].tag));
    8:UpdateDo(do_cnt_di8,time,iGetTag(I7053.DI[chnum].tag));
    9:UpdateDo(do_cnt_di9,time,iGetTag(I7053.DI[chnum].tag));
    10:UpdateDo(do_cnt_di10,time,iGetTag(I7053.DI[chnum].tag));
    11:UpdateDo(do_cnt_di11,time,iGetTag(I7053.DI[chnum].tag));
    12:UpdateDo(do_cnt_di12,time,iGetTag(I7053.DI[chnum].tag));
    13:UpdateDo(do_cnt_di13,time,iGetTag(I7053.DI[chnum].tag));
    14:UpdateDo(do_cnt_di14,time,iGetTag(I7053.DI[chnum].tag));
    15:UpdateDo(do_cnt_di15,time,iGetTag(I7053.DI[chnum].tag));
    16:UpdateDo(do_cnt_di16,time,iGetTag(I7053.DI[chnum].tag));
   end;
  end else Trouble(GotBug('Bad channel : "'+str(chnum)+'" on comand Counter Value Digital Input'));
 end;
 {
 Handle "Answer received"...
 }
 function CalcCheckSum(dat:String):String;
 var i,sum:integer;
 begin
   sum:=0;
   for i:=1 to length(dat) do sum:=sum+ord(strfetch(dat,i));
   CalcCheckSum:=HexB(sum);
 end;
 function isCorrectChecksum(dat:String; var checkdat:String):boolean;
 var tempchecksum,tempdat:String;
 begin
  tempchecksum:='';tempdat:='';checkdat:='';
  isCorrectChecksum:=false;
  tempdat:=trim(dat);
  if I7053.isCheckSum then begin
   tempchecksum:=copy(dat,length(tempdat)-1);
   tempdat:=copy(dat,1,length(tempdat)-2);
   if CalcCheckSum(tempdat)=tempchecksum then begin
    isCorrectChecksum:=true;
    checkdat:=tempdat;
   end else begin
    Trouble(GotBug('Bad checksum: "'+tempchecksum+'" in answer '+tempdat));
    checkdat:='';
   end;
  end else begin
   isCorrectChecksum:=true;
   checkdat:=tempdat;
  end;
 end;
 function CheckData(cid:Integer; dat:String; var ans:String):Boolean;
 var res:Boolean;tempdat:String;
 begin
  res:=false;
  ans:='';tempdat:='';
  if IsEmptyStr(dat) then begin
   if cid<>cm_HostIsOk then Trouble(GotBug('Answer is empty')) else begin
    res:=true;
   end;
  end else begin
   if StrFetch(dat,1)='?' then Trouble(GotBug('Bad answer : "'+dat+'" on comand '+I7053.CmdTab.Acronym[cid])) else begin
    if isCorrectChecksum(dat,tempdat) then begin
     if (cid=cm_ReadDigitalInp) then begin
       if StrFetch(tempdat,1)='>' then begin
         ans:=tempdat;
         res:=true;
       end else Trouble(GotBug('Bad answer : "'+tempdat+'" on comand '+I7053.CmdTab.Acronym[cid]));
     end else begin
       if StrFetch(tempdat,1)='!' then begin
         ans:=tempdat;
         res:=true;
       end else Trouble(GotBug('Bad answer : "'+tempdat+'" on comand '+I7053.CmdTab.Acronym[cid]));
     end;
    end;
   end;
  end;
  CheckData:=res;
  tempdat:='';
 end;
 procedure I7053_OnCommand(cid:Integer; dat:String);
 var v:Real; ans,hexadr:String;
 begin
  ans:='';hexadr:='';
  if CheckData(cid,dat,ans) then begin
   // Set Module Config
   if cid=cm_SetModuleConf then begin
    hexadr:=copy(ans,2,2);
    I7053.RS485.UnitId:=val('$'+hexadr);
    bNul(iSetTag(I7053.ADDRESS.tag,I7053.RS485.UnitId));
    I7053_EnableCmdId(cid,False);
    I7053_EnableCmdId(cm_ReadModuleConf,True);
   end else
   // Read Module Configuration
   if cid=cm_ReadModuleConf then begin
    UpdateModuleConfig(Copy(ans,2));
   end else
   // Read Firmware Version
   if cid=cm_ReadFirmwarVer then begin
    UpdateModuleVersion(Copy(ans,4));
    PollEnable(cid,bit_cm_ReadFirmwarVer);
   end else
   // Read Module Name
   if cid=cm_ReadModuleName then begin
    UpdateModuleName(Copy(ans,4));
    PollEnable(cid,bit_cm_ReadModuleName);
   end else
   // Set Module Name
   if cid=cm_SetModuleName then begin
    I7053_EnableCmdId(cid,False);
    I7053_EnableCmdId(cm_ReadModuleName,True);
   end else
   // Read Digital Inputs
   if cid=cm_ReadDigitalInp then begin
    UpdateDigitalInputsData(copy(ans,2)); 
    UpdateDigitalInputs;
    PollEnable(cid,bit_cm_ReadDigitalInp);
   end else
   // Host is Ok notification
   if (cid=cm_HostIsOk) then begin
   end else
   // Read Counter Value Digital Input 1
   if (cid=cm_ReadCntDigitInp1) then begin
    UpdateCounterValue(1,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp1);
   end else
   // Read Counter Value Digital Input 2
   if (cid=cm_ReadCntDigitInp2) then begin
    UpdateCounterValue(2,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp2);
   end else
   // Read Counter Value Digital Input 3
   if (cid=cm_ReadCntDigitInp3) then begin
    UpdateCounterValue(3,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp3);
   end else
   // Read Counter Value Digital Input 4
   if (cid=cm_ReadCntDigitInp4) then begin
    UpdateCounterValue(4,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp4);
   end else
   // Read Counter Value Digital Input 5
   if (cid=cm_ReadCntDigitInp5) then begin
    UpdateCounterValue(5,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp5);
   end else
   // Read Counter Value Digital Input 6
   if (cid=cm_ReadCntDigitInp6) then begin
    UpdateCounterValue(6,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp6);
   end else
   // Read Counter Value Digital Input 7
   if (cid=cm_ReadCntDigitInp7) then begin
    UpdateCounterValue(7,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp7);
   end else
   // Read Counter Value Digital Input 8
   if (cid=cm_ReadCntDigitInp8) then begin
    UpdateCounterValue(8,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp8);
   end else
   // Read Counter Value Digital Input 9
   if (cid=cm_ReadCntDigitInp9) then begin
    UpdateCounterValue(9,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp9);
   end else
   // Read Counter Value Digital Input 10
   if (cid=cm_ReadCntDigitInp10) then begin
    UpdateCounterValue(10,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp10);
   end else
   // Read Counter Value Digital Input 11
   if (cid=cm_ReadCntDigitInp11) then begin
    UpdateCounterValue(11,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp11);
   end else
   // Read Counter Value Digital Input 12
   if (cid=cm_ReadCntDigitInp12) then begin
    UpdateCounterValue(12,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp12);
   end else
   // Read Counter Value Digital Input 13
   if (cid=cm_ReadCntDigitInp13) then begin
    UpdateCounterValue(13,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp13);
   end else
   // Read Counter Value Digital Input 14
   if (cid=cm_ReadCntDigitInp14) then begin
    UpdateCounterValue(14,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp14);
   end else
   // Read Counter Value Digital Input 15
   if (cid=cm_ReadCntDigitInp15) then begin
    UpdateCounterValue(15,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp15);
   end else
   // Read Counter Value Digital Input 16
   if (cid=cm_ReadCntDigitInp16) then begin
    UpdateCounterValue(16,Copy(ans,4));
    PollEnable(cid,bit_cm_ReadCntDigitInp16);
   end else
   // Reset Counter Value Digital Input 1..16
   if (cid=cm_RstCntDigitInp) then begin
    I7053_EnableCmdId(cm_RstCntDigitInp, False);
    I7053_EnableCmdId(cm_ReadCntDigitInp1, True);
    I7053_EnableCmdId(cm_ReadCntDigitInp2, True);
    I7053_EnableCmdId(cm_ReadCntDigitInp3, True);
    I7053_EnableCmdId(cm_ReadCntDigitInp4, True);
    I7053_EnableCmdId(cm_ReadCntDigitInp5, True);
    I7053_EnableCmdId(cm_ReadCntDigitInp6, True);
    I7053_EnableCmdId(cm_ReadCntDigitInp7, True);
    I7053_EnableCmdId(cm_ReadCntDigitInp8, True);
    I7053_EnableCmdId(cm_ReadCntDigitInp9, True);
    I7053_EnableCmdId(cm_ReadCntDigitInp10,True);
    I7053_EnableCmdId(cm_ReadCntDigitInp11,True);
    I7053_EnableCmdId(cm_ReadCntDigitInp12,True);
    I7053_EnableCmdId(cm_ReadCntDigitInp13,True);
    I7053_EnableCmdId(cm_ReadCntDigitInp14,True);
    I7053_EnableCmdId(cm_ReadCntDigitInp15,True);
    I7053_EnableCmdId(cm_ReadCntDigitInp16,True);
   end else
   // Read WatchDog Status
   if cid=cm_ReadWDTStatus then begin
    UpdateWDStatus(copy(ans,4));
    PollEnable(cid,bit_cm_ReadWDTStatus);
   end else
   // Read WatchDog Timeout
   if cid=cm_ReadWDTimeOut then begin
    UpdateWDTimeout(copy(ans,4));
    PollEnable(cid,bit_cm_ReadWDTimeOut);
   end else
   // Set WatchDog Status
   if cid=cm_SetWDTStatus then begin
    I7053_EnableCmdId(cid,False);
    I7053_EnableCmdId(cm_ReadWDTStatus,true);
    I7053_EnableCmdId(cm_ReadWDTimeOut,true);
   end else
   // Reset WatchDog Status
   if cid=cm_RstWDTStatus then begin
    I7053_EnableCmdId(cid,False);
    I7053_EnableCmdId(cm_ReadWDTStatus,true);
    I7053_EnableCmdId(cm_ReadWDTimeOut,true);
   end;
  end;
  ans:='';hexadr:='';
 end;
 {
 WatchDog AutoReconnect
 }
 procedure I7053_WDAutoReconnect;
 begin
  DevPostCmdLocal('@RstWDStatus');
  DevPostCmdLocal('@SetWDStatus '+str(rGetTag(I7053.WDTIMEOUT.tag))+' 1');
 end;
 {
 Update State of Device
 }
 procedure UpdateState;
 begin
  if I7053.Simulator then bNul(iSetTag(I7053.STATE.tag,stt_Simulator))
  else begin
   if iGetTag(I7053.WDSTATUS.tag)=2 then begin 
    bNul(iSetTag(I7053.STATE.tag,stt_WatchDog));
    UpdateDO(do_state,time,stt_WatchDog);
    Trouble('Watchdog in device '+DevName);
    if I7053.WDReconnect then I7053_WDAutoReconnect;
   end else if iGetTag(I7053.RX.tag)>0 then begin
    bNul(iSetTag(I7053.STATE.tag,stt_Work));
    UpdateDO(do_state,time,stt_Work);
   end;
  end;
 end;
 {
 DIM Update tag
 }
 procedure UpdateDimTag(tag:Integer);
 var v:Real;
 begin
  if DIM_IsServerMode then
  if (TypeTag(tag)>0) then begin
   v:=GetStampOfTag(tag,_NaN);
   if not IsNan(v) then I7053_FillTag(tag,v);
   DIM_UpdateTag(tag,'');
  end;
 end;
 procedure DimRefreshTag(var R:TTagRef);
 var tag:Integer; v:Real;
 begin
  tag:=R.tag; v:=GetStampOfTag(tag,_NaN);
  if not IsNaN(v) then if ShouldRefresh(R.val,v)>0 then UpdateDimTag(tag);
 end;
 Procedure I7053_DIM_UpdateTag;
 var i:Integer;
 begin
  if DIM_IsServerMode then begin
   // Enforce update each 10 sec
   if SysTimer_Pulse(10000)>0 then I7053_FillTags(-MaxReal);
   DimRefreshTag(I7053.POLL);
   DimRefreshTag(I7053.RX);
   DimRefreshTag(I7053.TX);
   DimRefreshTag(I7053.STATE);
   DimRefreshTag(I7053.DIDATA);
   for i:=1 to MaxChannelNum do begin
    DimRefreshTag(I7053.DI[i]);
    DimRefreshTag(I7053.CNT.DI[i]);
   end;
   DimRefreshTag(I7053.NAME);
   DimRefreshTag(I7053.VERSION);
   DimRefreshTag(I7053.ADDRESS);
   DimRefreshTag(I7053.BAUDRATE);
   DimRefreshTag(I7053.CHECKSUM);
   DimRefreshTag(I7053.PARITY);
   DimRefreshTag(I7053.WDTIMEOUT);
   DimRefreshTag(I7053.WDSTATUS);
   DimRefreshTag(I7053.WDENDIS);
  end;
 end;
 {
 Finalize I7053 device.
 }
 procedure I7053_Free;
 begin
 end;
 {
 Data handler on @RS485.Reply event. Process reply comes from RS485 device.
 }
 procedure I7053_OnReply(ref,cid,tim,port,uid:Integer; dat:String);
 var p:Integer;
 begin
  if not IsValidCmdNum(cid) then Trouble(GotBug('Bad reply command '+Str(cid))) else
  if (port<>I7053.RS485.Poll.port) then Trouble(GotBug('Bad reply port '+Str(port))) else
  if (uid<>I7053.RS485.Poll.uid) then Trouble(GotBug('Bad reply unit id '+Str(uid))) else
  if (cid<>I7053.RS485.Poll.cid) then Trouble(GotBug('Bad reply command id '+Str(cid))) else
  if (ref<>I7053.RS485.Poll.ref) then Trouble(GotBug('Bad reply device '+RefInfo(ref,'Name'))) else
  if Length(dat)=0 then Trouble(GotBug('Bad reply answer')) else begin
   IncSummRate(I7053.RS485.Poll.Summ.Rx,I7053.RS485.Poll.Rate.Rx);
   p:=pos('$$',dat);
   dat:=copy(dat,p+2);
   I7053_OnCommand(cid,dat);
  end;
 end;
 {
 Prepare data for send
 }
 Procedure I7053_PrepareData(cid:Integer; var dat:String);
 begin
  dat:=I7053.CmdTab.Acronym[cid];
  if Length(I7053.CmdTab.OpData[cid])>0 then begin
   dat:=dat+I7053.CmdTab.OpData[cid];
   I7053.CmdTab.OpData[cid]:='';
  end;
  if cid=cm_HostIsOk then begin
   I7053_EnableCmdId(cm_HostIsOk,false);
  end;
  if I7053.isChecksum then dat:=dat+CalcCheckSum(dat);
  dat:=RS485_insert_le(dat,le_req);
 end;
 {
 I7053 Polling
 }
 Procedure I7053_Poll;
  Procedure PollRS485Proxy(cid:Integer; var num:Integer);
  var dev,ref,tot,port,uid:Integer; dat:String;
  begin
   dat:='';
   dev:=devTheProxy; ref:=devMySelf; tot:=I7053.RS485.Timeout; port:=I7053.RS485.Port; uid:=I7053.RS485.UnitId;
   if cid=cm_HostIsOk then tot:=0;
   I7053_PrepareData(cid,dat);
   if DevPost(dev,RS485_proxy_poll('@RS485.Poll',ref,cid,tot,port,uid,dat))>0 then begin
    if DebugFlagEnabled(dfViewExp) then ViewExp('COM: '+RS485_proxy_nice('@RS485.Poll',ref,cid,tot,port,uid,dat,32));
    AssignRS485Poll(dev,cid,mSecNow,port,uid,dat);
    IncSummRate(I7053.RS485.Poll.Summ.Tx,I7053.RS485.Poll.Rate.Tx);
   end else begin
    Trouble(GotBug('Fail to send command '+Str(cid)));
    ClearRS485Poll;
   end;
   if cid=cm_HostIsOk then ClearRS485Poll;
   num:=cid;
   dat:='';
  end;
 begin
  if IsPortOpened and not DIM_IsClientMode then begin
   if IsValidCmdNum(I7053.RS485.Poll.cid) then begin
    //
    // Request in progress, waiting @RS485Proxy.Reply/@RS485Proxy.Refuse/@RS485Proxy.Timeout.
    // Handle Deadline if was no responce for too long time: repeat polling again.
    //
    if iGetTag(I7053.POLL.tag)<>0 then begin
     if (mSecNow>I7053.RS485.Poll.tim+I7053.RS485.Deadline) then begin
      Trouble(GotBug('Deadline detected, repeat polling again...'));
      PollRS485Proxy(I7053.RS485.Poll.cid,I7053.CmdTab.Num);
     end;
    end else if iGetTag(I7053.POLL.tag)=0 then begin
     UpdateDo(do_state,time,stt_Disable);
     bNul(iSetTag(I7053.STATE.tag,stt_Disable));
    end;
   end else begin
    //
    // If request is cleared, send new @RS485Proxy.Poll request by timer.
    //
    if iGetTag(I7053.POLL.tag)<>0 then begin
     if (mSecNow>=I7053.RS485.Poll.tim+I7053.RS485.Polling) then begin
      PollRS485Proxy(NextEnabledCmdNum(I7053.CmdTab.Num),I7053.CmdTab.Num);
     end;
    end else begin 
     UpdateDo(do_state,time,stt_Disable);
     bNul(iSetTag(I7053.STATE.tag,stt_Disable));
    end;
   end;
   //
   // Update Poll Rate.
   //
   if SysTimer_Pulse(1000)>0 then begin
    bNul(iSetTag(I7053.RX.tag,I7053.RS485.Poll.Rate.Rx));
    bNul(iSetTag(I7053.TX.tag,I7053.RS485.Poll.Rate.Tx));
    UpdateDo(do_rx,time,I7053.RS485.Poll.Rate.Rx);
    UpdateDo(do_tx,time,I7053.RS485.Poll.Rate.Tx);
    Details('PollRate: Rx='+Str(I7053.RS485.Poll.Rate.Rx)
                   +'  Tx='+Str(I7053.RS485.Poll.Rate.Tx));
    ClearRS485Rate;
   end;
   if (I7053.HostIsOkPeriod>0) and (iGetTag(I7053.WDENDIS.tag)>0) then begin
    if SysTimer_Pulse(I7053.HostIsOkPeriod)>0 then begin
     I7053_EnableCmdId(cm_HostIsOk,true);
    end;
   end;
  end else if not IsPortOpened then Trouble('Port closed');
 end;
 //
 // Menu Initialize
 //
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuBaudrate;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Выберите Baudrate... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('1200');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7053.RS485.UnitId)+'4003'+HexB(I7053.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('2400');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7053.RS485.UnitId)+'4004'+HexB(I7053.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('4800');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7053.RS485.UnitId)+'4005'+HexB(I7053.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('9600');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7053.RS485.UnitId)+'4006'+HexB(I7053.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('19200');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7053.RS485.UnitId)+'4007'+HexB(I7053.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('38400');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7053.RS485.UnitId)+'4008'+HexB(I7053.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('57600');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7053.RS485.UnitId)+'4009'+HexB(I7053.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('115200');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7053.RS485.UnitId)+'400A'+HexB(I7053.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_BAUDRATE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure EditMenuCustomHandler(id,msg:String;tag:integer;value:string); //
 begin
  if EditStateDone then
  if not IsEmptyStr(id) then begin
   // Menu handler (before confirmation).
   if EditTestResultName(id) then begin
    if EditTestResultCode(mr_OK) then begin
     if LooksLikeCommand(EditGetMenuListSelectedCommand) then
     if IsEmptyStr(EditGetMenuListSelectedConfirm) then begin
      DevPostCmdLocal(EditGetMenuListSelectedCommand);
     end else begin
      EditStartConfirmCommand('Вы действительно хотите выполнить:'+LineEnding+
                              LineEnding+UpCaseStr(EditGetMenuListSelectedConfirm)+' ?'+
                              LineEnding+LineEnding+'Эта операция требует вашего подтверждения!'+
                              LineEnding+LineEnding+msg,
                              id+'::Confirm',EditGetMenuListSelectedCommand,EditGetSettingText);
     end;
    if tag<>0 then begin
     if typetag(tag)=1 then bNul(iSetTag(tag,val(value)));
     if typetag(tag)=2 then bNul(rSetTag(tag,rval(value)));
     if typetag(tag)=3 then bNul(sSetTag(tag,value));
    end;
    end else
    if EditTestResultCode(mr_Cancel) or EditTestResultCode(mr_Close) then begin
     if tag<>0 then begin
      if typetag(tag)=1 then bNul(iSetTag(tag,val(value)));
      if typetag(tag)=2 then bNul(rSetTag(tag,rval(value)));
      if typetag(tag)=3 then bNul(sSetTag(tag,value));
     end;
    end;
    if not EditStateBusy then EditReset;
   end;
   // Menu handler (after confirmation).
   EditMessageBoxDialogExDefaultHandler(id+'::Confirm');
  end;
 end;
 {
 Start Edit Data
 }
 procedure StartEditDataStrEx(Name,Caption,Data,Params:String);
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Введите '+Name);
   n:=n+EditAddInputLn(Caption+'|'+Data);
   if (StdEditTagFont<>'') then n:=n+EditAddSetting('@set StringGrid.Font '+StdEditTagFont);
   if (Length(Params)>0) then n:=n+EditAddText(Params,'','@>!');
   n:=n+EditAddClosing('StringGridEdit',EditGetUID(Name),'');
   if (n>0) then Problem('Error starting edit '+Name);
  end else Problem('Could not start edit tag '+Name);
  Data:='';
 end;
 {
 Check if data editing done.
 }
 function CheckEditData(Name:String; var newData:String):Boolean;
 var s:String;
 begin
  s:='';
  CheckEditData:=False;
  if EditStateDone then
   if EditTestResultName(EditGetUID(Name)) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=ExtractWordDelims(2,Edit('?ans 1'),Dump('|'));
     newData:=s;
     CheckEditData:=True;
     EditReset;
    end;
   end;
  s:='';
 end;
 {
 Handle Enableng poll menu
 }
 function HandlePollEnable(act:boolean):boolean;
 var pollen:Integer; handle:boolean;
 begin
  handle:=false;
  if act then begin
   pollen:=iGetTag(I7053.POLL.tag);
   if iGetTag(I7053.POLL_NOTIFY.tag)=1 then begin
    DevPostCmdLocal('@Poll '+str(iGetTag(I7053.POLL.tag)));
    bNul(iSetTag(I7053.POLL_NOTIFY.tag,0));
    handle:=true;
   end else 
   if iGetTag(I7053.POLL_NOTIFY.tag)=2 then begin
    bNul(iSetTag(I7053.POLL_NOTIFY.tag,0));
    bNul(iSetTag(I7053.POLL.tag,pollen));
    handle:=true;
   end;
  end;
  pollen:=0;
  HandlePollEnable:=handle;
 end;
 {
 GUI Handler to process user input...
 }
 procedure I7053_GUI_Poll;
 var s:String; ClickCurve,i:Integer;
 begin
  s:='';
  DIM_GuiClickBuff:='';
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   //
   // Copy GUI click to DIM buffer for remote execution.
   //
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Click is local
     }
     if ClickIsLocal then begin
      {
      Click Tags
      }
      if ClickTag<>0 then begin
       if ClickTag=I7053.ADDRESS.tag then begin
        StartEditDataStrEx('адрес_устройства','Адрес',str(iGetTag(I7053.ADDRESS.tag)),SetFormUnderSensorLeftBottom(ClickParams('')));
       end else
       if ClickTag=I7053.BAUDRATE.tag then begin
        MenuBaudrate;
       end else
       if ClickTag=I7053.NAME.tag then begin
        StartEditDataStrEx('имя_устройства','Имя',sGetTag(I7053.NAME.tag),SetFormUnderSensorLeftBottom(ClickParams('')));
       end else
       if ClickTag=I7053.CHECKSUM.tag then begin
        if iGetTag(I7053.CHECKSUM.tag)=0 
        then EditStartConfirmCommand('Включить Checksum?'+LineEnding+LineEnding+
        'Для изменения необходимо соединить контакты *INIT и GND, в противном случае - '+
        'дальнейшее подтверждение приведет к ошибке',EditGetUID('Enable_CHK'),'@SetCfg '+
        HexB(iGetTag(I7053.ADDRESS.tag))+'40'+HexB(iGetTag(I7053.BAUDRATE.tag))+
        '40',SetFormUnderSensorLeftBottom(ClickParams('')));
        if iGetTag(I7053.CHECKSUM.tag)=1
        then EditStartConfirmCommand('Выключить Checksum?'+LineEnding+LineEnding+
        'Для изменения необходимо соединить контакты *INIT и GND, в противном случае - '+
        'дальнейшее подтверждение приведет к ошибке',EditGetUID('Disable_CHK'),'@SetCfg '+
        HexB(iGetTag(I7053.ADDRESS.tag))+'40'+HexB(iGetTag(I7053.BAUDRATE.tag))+
        '00',SetFormUnderSensorLeftBottom(ClickParams('')));
       end;
       if ClickTag=I7053.POLL.tag then begin
        I7053.PollConfirm:=action('&'+ReadIni('tagPrefix')+'.POLL.ENABLE');
       end else
       if ClickTag=I7053.WDTIMEOUT.tag then begin
        StartEditTagEx(I7053.WDTIMEOUT.tag,'Введите Watchdog Timeout:',SetFormUnderSensorLeftBottom(ClickParams('')));
       end else
       if ClickTag=I7053.WDENDIS.tag then begin
        if iGetTag(I7053.WDENDIS.tag)=0 
        then DevPostCmdLocal('@SetWDStatus '+str(rGetTag(I7053.WDTIMEOUT.tag))+' 1')
        else DevPostCmdLocal('@SetWDStatus '+str(rGetTag(I7053.WDTIMEOUT.tag))+' 0');
       end else
       if ClickTag=I7053.WDSTATUS.tag then begin
        I7053_EnableCmdId(cm_RstWDTStatus,True);
       end else
       if ClickTag=I7053.INVERT.tag then begin
        DevPostCmdLocal('@InvertDIData');
       end;
       for i:=1 to MaxChannelNum do begin
        if ClickTag=I7053.CNT.DI[i].tag then DevPostCmdLocal('@ReadCntDI '+str(i));
       end;
      end;
     end;
     {
     Handle sensor clicks...
     }
     if IsSameText(ClickSensor,'HELP') then begin
      Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
      bNul(Voice(snd_Click));
     end;
     if (ClickSensor='I7053.LABEL') then begin
      DevPostCmdLocal('@MenuTools');
     end;
     for i:=1 to MaxChannelNum do begin
      if (ClickSensor='I7053.CNT.DI'+str(i)+'.RST') then DevPostCmdLocal('@RstCntDi '+str(i));
     end;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Handle remote clicks comes from DIM via @DimGuiClick message.
     // @DimGuiClick default handler decode and write events to FIFO,
     // so we can find it as clicks and can handle it in usual way.
     //
     if ClickIsRemote then begin
      //
      // Show time difference.
      //
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      //
      // Handle remote console commands...
      //
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
   EditMenuCustomHandler(EditGetUID('MENU_BAUDRATE'),'Для изменения необходимо '+
   'соединить контакты *INIT и GND, в противном случае - '+
   'дальнейшее подтверждение приведет к ошибке',0,'');
   //EditMenuCustomHandler(EditGetUID('MENU_DO'),'',I7053.DOALL.tag,'00');
   EditMessageBoxDialogExDefaultHandler(EditGetUID('Enable_CHK'));
   EditMessageBoxDialogExDefaultHandler(EditGetUID('Disable_CHK'));
   if CheckEditData('адрес_устройства',s) then begin
    if not IsNan(rVal(s))
    then DevPostCmdLocal('@SetCfg '+HexB(val(s))+'40'+HexB(iGetTag(I7053.BAUDRATE.tag))+HexB(I7053.DataFormat))
    else Warning('Invalid input!');
   end;
   if CheckEditData('имя_устройства',s) then begin
    DevPostCmdLocal('@SetName '+s);
   end;
   if CheckEditTag(I7053.WDTIMEOUT.tag,s) then begin
    UpdateTag(I7053.WDTIMEOUT.tag,s,0,25.5);
    DevPostCmdLocal('@SetWDStatus '+str(rGetTag(I7053.WDTIMEOUT.tag))+' '+str(iGetTag(I7053.WDENDIS.tag)));
   end;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle Polling Enable
  }
  if HandlePollEnable(I7053.PollConfirm) then I7053.PollConfirm:=False;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))<>0 then iNul(CustomIniRW('W','',2));
  I7053_ClearStrings;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitNetRS485;
  I7053_Init;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
  I7053.StartPoll:=iGetTag(I7053.Poll.tag);
  DevSendCmdLocal('@Poll '+str(255));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  I7053_Clear;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  I7053_GUI_Poll;
  if I7053.CmdTab.PollCnt=1 then begin
   bNul(iSetTag(I7053.POLL.tag,I7053.StartPoll));
   I7053.CmdTab.PollCnt:=2;
  end else
  if I7053.CmdTab.PollCnt=maxint then I7053.CmdTab.PollCnt:=2;
  if mSecNow-FixmSecNow>I7053.RS485.DelayOnStart then
  if not DIM_IsClientMode then begin
   if not I7053.Simulator then begin
    I7053_Poll;
    UpdateState;
   end;
  end;
  I7053_DIM_UpdateTag;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,cdm_arg_nocode,s,dat:String; cmdid,i,tag,ref,cid,tim,port,uid:Integer; r:Real;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  s:='';cmd:='';arg:='';cdm_arg_nocode:='';dat:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @RS485.Reply
   }
   if (cmdid = cmd_RsReply) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then I7053_OnReply(ref,cid,tim,port,uid,dat)
    else Trouble(GotBug('Bad '+cmd+' format'));
    ClearRS485Poll;
    Data:='';
   end else
   {
   @RS485.Refuse
   }
   if (cmdid = cmd_RsRefuse) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then Trouble(GotBug(RS485_proxy_nice(cmd,ref,cid,tim,port,uid,dat,0)))
    else Trouble(GotBug(cmd+' '+arg));
    UpdateDo(do_state,time,stt_Refused); bNul(iSetTag(I7053.STATE.tag,stt_Refused));
    ClearRS485Poll;
    Data:='';
   end else
   {
   @RS485.Timeout
   }
   if (cmdid = cmd_RsTimeout) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then Problem(GotBug(RS485_proxy_nice(cmd,ref,cid,tim,port,uid,dat,64)))
    else Trouble(GotBug(cmd+' '+arg));
    UpdateDo(do_state,time,stt_TimeOut); bNul(iSetTag(I7053.STATE.tag,stt_TimeOut));
    ClearRS485Poll;
    Data:='';
   end else
   {
   @DimTagUpdate tag
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    if DIM_IsClientMode and not DIM_IsServerMode then begin
     tag:=FindTag(Trim(arg));
     if tag=I7053.STATE.tag      then UpdateDo(do_state   ,  time,iGetTag(tag));
     if tag=I7053.DIDATA.tag     then UpdateDo(do_didata  ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[1].tag  then UpdateDo(do_cnt_di1 ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[2].tag  then UpdateDo(do_cnt_di2 ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[3].tag  then UpdateDo(do_cnt_di3 ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[4].tag  then UpdateDo(do_cnt_di4 ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[5].tag  then UpdateDo(do_cnt_di5 ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[6].tag  then UpdateDo(do_cnt_di6 ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[7].tag  then UpdateDo(do_cnt_di7 ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[8].tag  then UpdateDo(do_cnt_di8 ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[9].tag  then UpdateDo(do_cnt_di9 ,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[10].tag then UpdateDo(do_cnt_di10,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[11].tag then UpdateDo(do_cnt_di11,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[12].tag then UpdateDo(do_cnt_di12,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[13].tag then UpdateDo(do_cnt_di13,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[14].tag then UpdateDo(do_cnt_di14,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[15].tag then UpdateDo(do_cnt_di15,  time,iGetTag(tag));
     if tag=I7053.CNT.DI[16].tag then UpdateDo(do_cnt_di16,  time,iGetTag(tag));
     if tag=I7053.RX.tag         then UpdateDo(do_rx      ,  time,iGetTag(tag));
     if tag=I7053.TX.tag         then UpdateDo(do_tx      ,  time,iGetTag(tag));
    end;
   end else
   {
   @DIMCMDMY
   }
   if (cmdid=cmd_DimCmdMy) then begin
    //декодируем из base64
    cdm_arg_nocode:=base64_decode(arg);
    // Избавляемся от символ NUL (\x00).
    cdm_arg_nocode:=Trim(cdm_arg_nocode);
    if LooksLikeCommand(cdm_arg_nocode) then DevPostCmdLocal(cdm_arg_nocode);
    Success('@DIMCMDMY='+cmd+' arg<'+cdm_arg_nocode+'>');
   end else
   {
   @Poll flags (flags)
   }
   if (cmdid = cmd_Poll) then begin
    i:=val(arg);
    if i<=4194303 then begin
     if not DIM_IsClientMode then begin
      bNul(iSetTag(I7053.POLL.tag,i));
      I7053_EnablePoll(i);
     end else if DIM_IsClientMode then begin
      DevPostCmdLocal('@Remote @Poll '+arg);
     end;
    end else Trouble('Unrecognize parametr in command @Poll');
   end else
   {
   @InvertDIData
   }
   if (cmdid = cmd_InvertDIData) then begin
    if not DIM_IsClientMode then begin
     if iGetTag(I7053.INVERT.tag)=0 then bNul(iSetTag(I7053.INVERT.tag,1)) else
     if iGetTag(I7053.INVERT.tag)=1 then bNul(iSetTag(I7053.INVERT.tag,0)) else
     if iGetTagBitState(I7053.INVERT.tag,0) then bNul(iSetTag(I7053.INVERT.tag,0)) else bNul(iSetTag(I7053.INVERT.tag,1));
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @InvertDIData');
    end;
   end else
   {
   @SetCfg NNTTCCFF
   }
   if (cmdid = cmd_SetCfg) then begin
    if length(arg)=8 then begin
     s:='$'+copy(arg,1,2);
     if not isNan(rval(s)) then begin
      s:=copy(arg,3,2);
      if isValidTypeCode(val('$'+s)) then begin
       s:='$'+copy(arg,5,2);
       if isValidBaudrate(val(s)) then begin
        s:=copy(arg,7,2);
        if isValidDataFormat(Val('$'+s)) then begin
         if not DIM_IsClientMode then begin
           if I7053.Simulator then begin
            s:=Copy(arg,1,2);
            s:='$'+s;
            I7053.RS485.UnitId:=val(s);
            bNul(iSetTag(I7053.ADDRESS.tag,I7053.RS485.UnitId));
            s:='$'+Copy(arg,5,2);
            bNul(iSetTag(I7053.BAUDRATE.tag,val(s)));
            s:='$'+Copy(arg,7,2);
            bNul(iSetTagBitState(I7053.CHECKSUM.tag,0,isbit(val(s),6)));
           end else begin
            I7053.CmdTab.OpData[cm_SetModuleConf]:=arg;
            I7053_EnableCmdId(cm_SetModuleConf,true);
           end;
         end else if DIM_IsClientMode then begin
          DevPostCmdLocal('@Remote @SetCfg '+arg);
         end;
        end else Trouble('Unrecognize "Data Format" in command @SetCfg');
       end else Trouble('Unrecognize "Baudrate" in command @SetCfg');
      end else Trouble('Unrecognize "Type" in command @SetCfg');
     end else Trouble('Unrecognize "Address" in command @SetCfg');
    end else Trouble('Unrecognize parametr in command @SetCfg');
   end else
   {
   @ReadCfg
   }
   if (cmdid = cmd_ReadCfg) then begin
    if not DIM_IsClientMode then begin
     if I7053.Simulator 
     then Success('Command @ReadCfg complete in simulator mode')
     else I7053_EnableCmdId(cm_ReadModuleConf,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadCfg');
    end;
   end else
   {
   @ReadVer
   }
   if (cmdid = cmd_ReadVer) then begin
    if not DIM_IsClientMode then begin
     if I7053.Simulator
     then bNul(sSetTag(I7053.VERSION.tag,'SimVer'))
     else I7053_EnableCmdId(cm_ReadFirmwarVer,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadVer');
    end;
   end else
   {
   @ReadName
   }
   if (cmdid = cmd_ReadName) then begin
    if not DIM_IsClientMode then begin
     if I7053.Simulator
     then Success('Command @ReadName complete in simulator mode')
     else I7053_EnableCmdId(cm_ReadModuleName,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadName');
    end;
   end else
   {
   @SetName
   }
   if (cmdid = cmd_SetName) then begin
    if length(arg)>6 then arg:=copy(arg,1,6);
    if not DIM_IsClientMode then begin
     if I7053.Simulator
     then bNul(sSetTag(I7053.NAME.tag,arg))
     else begin
      I7053.CmdTab.OpData[cm_SetModuleName]:=arg;
      I7053_EnableCmdId(cm_SetModuleName,true);
     end;
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @SetName '+arg);
    end;
   end else
   {
   @ReadDI
   }
   if (cmdid = cmd_ReadDI) then begin
    if not DIM_IsClientMode then begin
     if I7053.Simulator
     then Success('Command @ReadDI complete in simulator mode')
     else I7053_EnableCmdId(cm_ReadDigitalInp,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadDI');
    end;
   end else
   {
   @ReadCntDI channel_number
   }
   if (cmdid = cmd_ReadCntDI) then begin
    if not IsEmptyStr(arg) then begin
     if not isNan(val(arg)) then begin
      if ((val(arg)>0) and (val(arg)<=MaxChannelNum)) then begin
       if not DIM_IsClientMode then begin
        if I7053.Simulator
        then Success('Command @ReadCntDI complete in simulator mode')
        else begin 
         if val(arg)=1  then I7053_EnableCmdId(cm_ReadCntDigitInp1 ,true);
         if val(arg)=2  then I7053_EnableCmdId(cm_ReadCntDigitInp2 ,true);
         if val(arg)=3  then I7053_EnableCmdId(cm_ReadCntDigitInp3 ,true);
         if val(arg)=4  then I7053_EnableCmdId(cm_ReadCntDigitInp4 ,true);
         if val(arg)=5  then I7053_EnableCmdId(cm_ReadCntDigitInp5 ,true);
         if val(arg)=6  then I7053_EnableCmdId(cm_ReadCntDigitInp6 ,true);
         if val(arg)=7  then I7053_EnableCmdId(cm_ReadCntDigitInp7 ,true);
         if val(arg)=8  then I7053_EnableCmdId(cm_ReadCntDigitInp8 ,true);
         if val(arg)=9  then I7053_EnableCmdId(cm_ReadCntDigitInp9 ,true);
         if val(arg)=10 then I7053_EnableCmdId(cm_ReadCntDigitInp10,true);
         if val(arg)=11 then I7053_EnableCmdId(cm_ReadCntDigitInp11,true);
         if val(arg)=12 then I7053_EnableCmdId(cm_ReadCntDigitInp12,true);
         if val(arg)=13 then I7053_EnableCmdId(cm_ReadCntDigitInp13,true);
         if val(arg)=14 then I7053_EnableCmdId(cm_ReadCntDigitInp14,true);
         if val(arg)=15 then I7053_EnableCmdId(cm_ReadCntDigitInp15,true);
         if val(arg)=16 then I7053_EnableCmdId(cm_ReadCntDigitInp16,true);
        end;
       end else if DIM_IsClientMode then begin
        DevPostCmdLocal('@Remote @ReadCntDI '+arg);
       end;
      end else Trouble('ICPCON i7053 is 16-channels device, please enter number from 1 to 16');
     end else Trouble('Unrecognize parameter in command @ReadCntDI');
    end else Trouble('Empty parameter in command @ReadCntDI');
   end else
   {
   @RstCntDI channel_number
   }
   if (cmdid = cmd_RstCntDI) then begin
    if not IsEmptyStr(arg) then begin
     if not isNan(val(arg)) then begin
      if ((val(arg)>0) and (val(arg)<=MaxChannelNum)) then begin
       if not DIM_IsClientMode then begin
        if I7053.Simulator
        then bNul(iSetTag(I7053.DI[val(arg)].tag,0))
        else begin
         I7053.ChNumber:=val(arg);
         I7053_EnableCmdId(cm_RstCntDigitInp,true);
        end;
       end else if DIM_IsClientMode then begin
        DevPostCmdLocal('@Remote @RstCntDI '+arg);
       end;
      end else Trouble('ICPCON i7053 is 16-channels device, please enter number from 1 to 16');
     end else Trouble('Unrecognize parameter in command @RstCntDI');
    end else Trouble('Empty parameter in command @RstCntDI');
   end else
   {
   @ReadWDStatus
   }
   if (cmdid = cmd_ReadWDStatus) then begin
    if not DIM_IsClientMode then begin
     if I7053.Simulator
     then Success('Command @ReadWDStatus complete in simulator mode')
     else I7053_EnableCmdId(cm_ReadWDTStatus,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadWDStatus');
    end;
   end else
   {
   @ReadWDTimeout
   }
   if (cmdid = cmd_ReadWDTimeout) then begin
    if not DIM_IsClientMode then begin
     if I7053.Simulator
     then Success('Command @ReadWDTimeout complete in simulator mode')
     else I7053_EnableCmdId(cm_ReadWDTimeOut,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadWDTimeout');
    end;
   end else
   {
   @SetWDStatus TimeOut Enabled (Timeout - time in 0 - 25.5 s, Enabled - 0 or 1)
   }
   if (cmdid = cmd_SetWDStatus) then begin
    if WordCount(arg)=2 then begin
     if not isNan(rVal(extractword(1,arg))) then begin
      if length(str(frac(rVal(extractword(1,arg)))))>3
      then arg:=copy(extractword(1,arg),1,(pos('.',extractword(1,arg))+1))+' '+extractword(2,arg);
      if rVal(extractword(1,arg))>25.5 then arg:='25.5 '+extractword(2,arg);
      if rVal(extractword(1,arg))<0    then arg:='0 '+extractword(2,arg);
      if not isNan(rval(extractword(2,arg))) then begin
       arg:=extractword(1,arg)+' '+str(trunc(rval(extractword(2,arg))));
       if val(extractword(2,arg))>=1 then arg:=extractword(1,arg)+' 1';
       if val(extractword(2,arg))<=0 then arg:=extractword(1,arg)+' 0';
        if not DIM_IsClientMode then begin
         bNul(iSetTag(I7053.WDENDIS.tag,val(extractword(2,arg))));
         I7053.EnableWD:=val(extractword(2,arg));
         bNul(rSetTag(I7053.WDTIMEOUT.tag,rval(extractword(1,arg))));
         I7053.TimeoutWD:=rval(extractword(1,arg));
         if I7053.Simulator
         then bNul(iSetTag(I7053.WDSTATUS.tag,val(extractword(2,arg))))
         else begin
          I7053.CmdTab.OpData[cm_SetWDTStatus]:=str(I7053.EnableWD)+HexB(trunc(I7053.TimeoutWD*10));
          I7053_EnableCmdId(cm_SetWDTStatus,true);
         end;
        end else if DIM_IsClientMode then begin
         DevPostCmdLocal('@Remote @SetWDStatus '+arg);
        end;
      end else Trouble('Unrecognize "Enabled" in command @SetWDStatus');
     end else Trouble('Unrecognize "Timeout" in command @SetWDStatus');
    end else Trouble('Unrecognize parameter in command @SetWDStatus');
   end else
   {
   @RstWDStatus
   }
   if (cmdid = cmd_RstWDStatus) then begin
    if not DIM_IsClientMode then begin
     bNul(iSetTag(I7053.WDENDIS.tag,0));
     if I7053.Simulator
     then bNul(iSetTag(I7053.WDSTATUS.tag,0))
     else I7053_EnableCmdId(cm_RstWDTStatus,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @RstWDStatus');
    end;
   end else
   {
   @MenuTools
   }
   if (cmdid=cmd_MenuTools) then begin
    MenuToolsStarter;
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  s:='';cmd:='';arg:='';cdm_arg_nocode:='';dat:='';
  Data:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{<== Please never change this code ***}
{***************************************************}
