//Property Dialog for single elements of the mockup
usemockups.views.PropertyDialog = Backbone.View.extend({
    el: "aside form",
    template: $("#property-form-template").html(),
    events: {
        'submit': 'submit',
        'change': 'change',
		'click .add-item': 'add_item',
    },
    initialize: function () {
        this.on("update_for_attribute", this.update_for_attribute);
    },
    render: function () {
        
        this.$el.html(_.template(this.template, {
            "attributes": this.get_attributes()
        }));
        $('#id_name_label').html('Компонент:');
        $('#id_top_label').html('Сверху:');
        $('#id_left_label').html('Слева:');
		$('#id_width_label').html('Ширина:');
        $('#id_height_label').html('Высота:');
        
        $('#id_items_label').html('Элементы списка:');
        $('#id_tag_label').html('Тег:');
        $('#id_caption_label').html('Надпись:');
        this.$el.find("a.delete").click(function () {
            this.destroy();
            return false;
        }.bind(this));
        
        this.$el.find("a.copy").click(function () {
            var copy = this.model.clone();
            copy.attributes.top = copy.attributes.top + 5;
            copy.attributes.left = copy.attributes.left + 5;
            console.log(this.model.collection.add(copy));
            return copy;
        }.bind(this));
		
		this.$el.find("a.delete-item").click(function (ui) {
            console.log('items['+[$(ui.target).attr("id-attribute")]+']');
            if (this.model.get('items').length != 1) {
                this.model.remove('items['+[$(ui.target).attr("id-attribute")]+']');
                this.model.set('count', this.model.get('items').length);
            };
            this.render();
            return false;
        }.bind(this));

        $(document).tooltip();
		
        return this;
    },
    set_measuredSizes: function (measuredSizes){
      this.measuredSizes = measuredSizes;
      return this;
    },
    update_for_attribute: function (field) {
        this.$el.find("#id_"  + field.data("attribute")).val(field.val());
    },

    get_attributes: function () {
        return _.map(this.model.tool.get("attributes"), function (attribute) {
            var value = this.model.get(attribute.name);
            // makes sure the input is escaped if it's a string
            if (typeof value === 'string' || value instanceof String) {
                value = value.replace(/"/g, '&quot;');
            }
            return _.extend({
                "value": value
            }, attribute);
        },this)
    },
    submit: function () {
        return false;
    },
    change: function (ui) {
        var input = $(ui.target);
        var value;
        if (input.is(":checkbox")) {
            value = input.is(":checked");
        } else {
            if (input[0].id === "id_left" || input[0].id === "id_top") {
                value = Number(input.val())
            } else {
                value = input.val()
            }
        }
        if (!input.attr("data-attribute")) {
            this.model.set(input.attr("name"), value);
        } else {
            var data = JSON.parse(JSON.stringify(this.model.get(input.attr("data-attribute"))));
            data[input.attr("id-attribute")][input.attr("name")] = value;
            this.model.set({[input.attr("data-attribute")]: data});
        }
        return false;
    },
    destroy: function () {
        this.model.destroy();
        return false;
    },
    add_item: function () {
        var items = this.model.get('items');
		newItem = JSON.parse(JSON.stringify(items));
		newItem[0].id = items.length;
        this.model.add('items', newItem[0]);
        this.model.set('count', items.length+1);
		this.render();
        return false;
	}
});
