@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:SetCodePageUtf8
chcp 65001 >nul

:Comment
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright (c) 2025 Alexey Kuryakin daqgroup@mail.ru
:: Log roller for crwdaq: roll (rotate) crwdaq log files
:: located in crwdaq log directory $CRW_DAQ_VAR_TMP_DIR.
:: Notes: this script work properly only as crwdaq child
:: process and only while parent crwdaq process running.
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Identification
set "scriptfile=%~f0"
set "scriptbase=%~n0"
set "scriptname=%~nx0"
for %%i in ( "%~dp0\." ) do set "scripthome=%%~fi"
call :save_arguments %*

:CrwDaqEnvironment
set "crwpid=%CRW_DAQ_SYS_EXE_PID%"
set "logdir=%CRW_DAQ_VAR_TMP_DIR%"
set "log=%logdir%\%scriptbase%.log"
set "defloglimit=32MB"
set "defnmaxkeep=9"
set "defcompress=gz"

:CheckEnvironment
unix.exe >nul || ( call :fatal 1 "Error: unix.exe not found." & exit /b 1 )
if not defined crwpid ( call :fatal 1 "Error: crwdaq environ (PID)." & exit /b 1 )
if not defined logdir ( call :fatal 1 "Error: crwdaq environ (dir)." & exit /b 1 )
if not exist "%logdir%" ( call :fatal 1 "Error: crwdaq log directory." & exit /b 1 )
call :cmd_pid_running crwdaq.exe %crwpid% || ( call fatal 1 "Error: crwdaq PID %crwpid% is not running." & exit /b 1 )
call :check_log & set /a numroll=0 & set "logs= " & set /a nloop=0
set "loglimit=%~1" & if not defined loglimit set "loglimit=%defloglimit%"
set "nmaxkeep=%~2" & if not defined nmaxkeep set "nmaxkeep=%defnmaxkeep%"
set "compress=%~3" & if not defined compress set "compress=%defcompress%"
call :calc_size loglimit "%loglimit%"
pushd "%logdir%" > nul || goto :PopDir
for /f "tokens=* delims=" %%i in ('unix find . -maxdepth 1 -type f -and -name "*.log" -and "(" -size %loglimit%c -or -size +%loglimit%c ")"') do (
 set "file=%%~i" & set "file=!file:/=\!" & set "logs=!logs! !file!"
 unix logroll -t !file! %nmaxkeep% %compress% && set /a numroll+=1
 set /a nloop+=1
)
if not "%nloop%" == "0" (
 call :add_log "SizeLimit: %loglimit% byte(s)"
 call :add_log "Directory: %logdir:\=/%"
 call :add_log "RollFiles: %logs:\=/%"
 call :add_log "NumRolled: %numroll%"
)
:PopDir
popd
if not "%numroll%" == "0" call :SetErrorLevel 0
:Done
echo Done %scriptname%.
exit /b %ErrorLevel%
goto :EOF

::::::::::::::::::::::::::::::::::::::::::
:: check command $1 with PID $2 is running
::::::::::::::::::::::::::::::::::::::::::
:cmd_pid_running
if "%~1" == "" exit /b 1
if "%~2" == "" exit /b 1
for /f "tokens=1,2,* delims= " %%i in ( 'tasklist /nh /fi "imagename eq %~1" 2^>nul ^| findstr /c:" %~2 "' ) do exit /b 0
exit /b 1
goto :EOF

:add_log
call :getdatetime
set "prog=%CRW_DAQ_SYS_TITLE%"
<nul set /p "_=%datetime% %prog%: %~1 %~2 %~3 %~4 %~5 %~6 %~7 %~8 %~9" | unix xargs | unix tee -a "%log%"
goto :EOF

:check_log
unix touch "%log%"
call :add_log "%scriptname% %arguments%"
goto :EOF

:::::::::::::::::::::::::::::::::::::::::::::
:: calculate size with KB,MB,GB,TB substitute
:: use KiloByte=1024 as power of 2 (not 1000)
:::::::::::::::::::::::::::::::::::::::::::::
:calc_size
set /a kb=1024                           & :: kilobyte factor
set "args=%~2 %~3 %~4 %~5 %~6 %~7 %~8"   & :: fetch arguments
set "args=%args:b=%"                     & :: remove 'b' char
set "args=%args:k=*!kb!%"                & :: apply kilobytes
set "args=%args:m=*!kb!*!kb!%"           & :: apply megabytes
set "args=%args:g=*!kb!*!kb!*!kb!%"      & :: apply gigabytes
set "args=%args:t=*!kb!*!kb!*!kb!*!kb!%" & :: apply terabytes
set /a "value=0"                         & :: result value:
set /a "value=%args%"                    & :: calculate
set /a "%~1=%value%"                     & :: assign
goto :EOF

:langstr
call :langstr_loop %*
set "langstr=%langstr_en%"
set "lng=%CRW_DAQ_SYS_LANG:~0,2%"
if /i "%lng%" == "ru" if defined langstr_ru set "langstr=%langstr_ru%"
if /i "%lng%" == "en" if defined langstr_en set "langstr=%langstr_en%"
goto :EOF
:langstr_loop
if /i "%~1" == "" goto :EOF
if /i "%~1" == "ru" set "langstr_ru=%~2"
if /i "%~1" == "en" set "langstr_en=%~2"
shift /1 & shift /1 & goto :langstr_loop
goto :EOF

:save_arguments
shift & set arguments=%*
goto :EOF

:SetErrorLevel
exit /b %~1
goto :EOF

:print
<nul set /p "_=%~1"
goto :EOF

:println
<nul set /p "_=%~1"
echo.
goto :EOF

:print_stderr
<nul 1>&2 set /p "_=%~1"
goto :EOF

:println_stderr
1>&2 <nul set /p "_=%~1"
1>&2 echo.
goto :EOF

:getdatetime
set datetime=%date%-%time%
set datetime=%datetime: =0%
set datetime=%datetime:~6,4%.%datetime:~3,2%.%datetime:~0,2%-%datetime:~11,8%
goto :EOF

:succeed
call :getdatetime
set /a delay=1000*60
call :println_stderr "%~2"
set "prog=%CRW_DAQ_SYS_TITLE%"
unix tooltip-notifier text "%datetime% %prog%: %~2" preset stdSuccess delay %delay%
exit /b %1
goto :EOF

:warning
call :getdatetime
set /a delay=1000*60*60
call :println_stderr "%~2"
set "prog=%CRW_DAQ_SYS_TITLE%"
unix tooltip-notifier text "%datetime% %prog%: %~2" preset stdWarning delay %delay%
exit /b %1
goto :EOF

:fatal
call :getdatetime
set /a delay=1000*60*60*24
call :println_stderr "%~2"
set "prog=%CRW_DAQ_SYS_TITLE%"
unix tooltip-notifier text "%datetime% %prog%: %~2" preset stdError delay %delay%
exit /b %1
goto :EOF

::::::::::::::
:: END OF FILE
::::::::::::::
