#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################
# CRW-DAQ script to call on create integrity checksum.
##########################################################

function print_comment(){
 echo "*****************************************************";
 echo "CRW-DAQ checksum secure script. Run on CRW-DAQ setup.";
 echo "*****************************************************";
};

################################
# Current script identification.
################################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

readonly target="secure";

function fatal(){
 1>&2 echo "$2";
 exit $1;
};

function check_environ(){
 if [ -z "$CRW_DAQ_VAR_TMP_DIR" ]; then
  fatal 1 "Error: script should be called from CRW-DAQ system only.";
 fi;
};

function call_checksum(){
 rm -f $target.md5;
 local exclude="";
 ###########################################
 # all executable files (without extensions)
 ###########################################
 exclude=""; # files to exclude from list
 exclude+=" ./demo/ ./data/ ./settings/ ./source/";
 exclude+=" /remedy/ /handbook/ /manual/ /dcc32/ /tools/";
 unix checksum -r -m "*" -e $exclude "*.[a-zA-Z_0-9]*" | tee $target.md5;
 #########################################
 # all files with extensions except listed
 #########################################
 # exclude=""; # files to exclude from list
 # exclude+=" ./demo/ ./data/ ./settings/ ./source/";
 # exclude+=" /remedy/ /handbook/ /manual/ /dcc32/ /tools/";
 # exclude+=" .ini .log .htm .html .url .md .pdf .djv .djvu";
 # exclude+=" .bmp .ico .png .jpg .jpeg .gif .pcx .avi .wav";
 # exclude+=" .txt .doc .odt .rtf .hlp .hpj .man .chm .cnt";
 # exclude+=" .lst .con .out .zip .gz .xz .7z .zip .ttf .md5";
 # unix checksum -r -m "*.*" -e $exclude | tee -a $target.md5;
 #########################################
 # exe files with extensions except listed
 #########################################
 exclude=""; # files to exclude from list
 exclude+=" ./demo/ ./data/ ./temp/ ./settings/ ./source/";
 exclude+=" /dcc32/ /gpl/ /plugins/ /templates/ /opcsite/";
 exclude+=" /remedy/ /handbook/ /manual/ /modbus/ /tools/";
 exclude+=" /delphi5/ /publicpascal/ /dim_test/ /www.*/ /tinyweb/";
 unix checksum -r -m "*.exe" "*.dll" "*.bat" "*.cmd" "*.sh" \
                     "*.manifest" "*.pas" "*.inc" \
                  -e $exclude | tee -a $target.md5;
 #########################################
 # cfg files with extensions except listed
 #########################################
 exclude=""; # files to exclude from list
 exclude+=" ./demo/ ./data/ ./temp/ ./settings/ ./source/";
 exclude+=" /dcc32/ /gpl/ /plugins/ /templates/ /opcsite/";
 exclude+=" /remedy/ /handbook/ /manual/ /modbus/ /tools/";
 exclude+=" /delphi5/ /publicpascal/ /dim_test/ /www.*/";
 exclude+=" /tinyweb/ /uniheat/data/";
 exclude+=" dimtree.ini cfgconfigurator.ini vspe.ini winkeylock.ini";
 unix checksum -r -m "*.ini" "*.cal" "*.cfg" "*.crc" \
                  -e $exclude | tee -a $target.md5;
};

function secure_checksum(){
 if pushd $scriptHOME/.. >/dev/null 2>&1; then
  call_checksum;
 fi;
 popd >/dev/null 2>&1;
};

function make_checksum(){
 if [ "$1" = "--secure-checksum" ]; then
  secure_checksum;
 fi;
};

function main(){
 print_comment;
 check_environ;
 make_checksum "$@";
};

main "$@";

#############
# END OF FILE
#############
