#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################
# CRW-DAQ script to view $scriptbase.log.
##########################################################

################################
# Current script identification.
################################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

function fatal(){
 1>&2 echo "$2";
 exit $1;
};

function check_environ(){
 if [ -z "$CRW_DAQ_VAR_TMP_DIR" ]; then
  fatal 1 "Error: script should be called from CRW-DAQ system only.";
 fi;
};

function view_logfile(){
 if [ -e "$1" ]; then
  unix wintail "$1";
 else
  fatal 2 "Error: not found $1";
 fi;
};

function main(){
 check_environ;
 local logfile="$CRW_DAQ_VAR_TMP_DIR/$scriptbase.log";
 view_logfile "$logfile";
};

main "$@";

#############
# END OF FILE
#############
