@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion
:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright(c) 2022 Alexey Kuryakin kouriakine@mail.ru
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Installer find Firefox and call him to install XPI.
:: Also he associates files (*.xpi,*.md) with Firefox.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

call :InstallMarkdownViewerAddon    "%~dp0."    daqgroup_markdown_viewer-1.0.0.xpi
exit /b %errorlevel%
goto :EOF

:InstallMarkdownViewerAddon
if "%~1" == "" ( 1>&2 echo Error: Path not specified. & exit /b 1 )
if "%~2" == "" ( 1>&2 echo Error: File not specified. & exit /b 1 )
if not exist "%~f1\%~2" ( 1>&2 echo Error: File not found "%~f1\%~2". & exit /b 1 )
set "addon=%~f1\%~2"

:FindFirefox
set "firefox="
for /f "tokens=* delims=" %%i in ('unix getapppath firefox.exe') do set "firefox=%%i"
if not defined firefox   ( 1>&2 echo Error: Firefox not found. & exit /b 1 )
if not exist "%firefox%" ( 1>&2 echo Error: Firefox not found. & exit /b 1 )

:AssociateXpiFilesToFirefox
ftype FirefoxXPI="%firefox%" -url "%%1"
assoc .xpi=FirefoxXPI

:AssociateMarkdownFilesToFirefox
ftype MarkdownFile="%firefox%" -osint -url "%%1"
assoc .markdown=MarkdownFile
assoc .mdown=MarkdownFile
assoc .mdwn=MarkdownFile
assoc .mkdn=MarkdownFile
assoc .mkd=MarkdownFile
assoc .md=MarkdownFile

:StartFirefoxToInstallAddon
start "%~n0" "%firefox%" -osint -url "%addon%"
exit /b %errorlevel%
goto :EOF
