@echo off
@SetLocal EnableExtensions EnableDelayedExpansion
:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright(c) 2018 Alexey Kuryakin kouriakine@mail.ru
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Handle (install and uninstall) OpenWith context menu
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Main
:CheckOptions
@if "%~1" == ""          ( call :Help %~n0 & goto :EOF )
@if "%~1" == "/?"        ( call :Help %~n0 & goto :EOF )
@if "%~1" == "-h"        ( call :Help %~n0 & goto :EOF )
@if "%~1" == "--help"    ( call :Help %~n0 & goto :EOF )
@if "%~1" == "--version" ( call :Version %~n0 & goto :EOF )
:MainProcessing
@call :SetErrorLevel 0
:CheckAccessRights
@call net session 1>nul 2>nul || ( call :ErrorFound "Access denied to %UserName%." & goto :EOF )
@set "Operation="
@set "AppliesTo="
@set "FileExtList="
@set "OpenWithPrompt="
@set "ApplicationName="
@set "ApplicationFile="
@set "ApplicationOpts="
@set "ApplicationArgs="
::
:: Process command line arguments and options
::
:ProcessArgumentsCycle
@if /I "%~1" == "" goto :ProcessArgumentsBreak
::
:: option -i --install
::
:CheckOptInstall
@if /I "%~1" == "-i" goto :ExecOptInstall
@if /I "%~1" == "--install" goto :ExecOptInstall
@goto :DoneOptInstall
:ExecOptInstall
@shift /1
@set "ApplicationName=%~1"
@set "Operation=--install"
@shift /1
@goto :ProcessArgumentsCycle
:DoneOptInstall
::
:: option -u --uninstall
::
:CheckOptUninstall
@if /I "%~1" == "-u" goto :ExecOptUninstall
@if /I "%~1" == "--uninstall" goto :ExecOptUninstall
@goto :DoneOptUninstall
:ExecOptUninstall
@shift /1
@set "ApplicationName=%~1"
@set "Operation=--uninstall"
@shift /1
@goto :ProcessArgumentsCycle
:DoneOptUninstall
::
:: option -c --command
::
:CheckOptCommand
@if /I "%~1" == "-c" goto :ExecOptCommand
@if /I "%~1" == "--command" goto :ExecOptCommand
@goto :DoneOptCommand
:ExecOptCommand
@shift /1
@set "ApplicationFile=%~1"
@shift /1
@goto :ProcessArgumentsCycle
:DoneOptCommand
::
:: option -o --options
::
:CheckOptOptions
@if /I "%~1" == "-o" goto :ExecOptOptions
@if /I "%~1" == "--options" goto :ExecOptOptions
@goto :DoneOptOptions
:ExecOptOptions
@shift /1
@set "ApplicationOpts=%~1"
@shift /1
@goto :ProcessArgumentsCycle
:DoneOptOptions
::
:: option -a --arguments
::
:CheckOptArguments
@if /I "%~1" == "-a" goto :ExecOptArguments
@if /I "%~1" == "--arguments" goto :ExecOptArguments
@goto :DoneOptArguments
:ExecOptArguments
@shift /1
@set "ApplicationArgs=%~1"
@shift /1
@goto :ProcessArgumentsCycle
:DoneOptArguments
::
:: option -p --prompt
::
:CheckOptPrompt
@if /I "%~1" == "-p" goto :ExecOptPrompt
@if /I "%~1" == "--prompt" goto :ExecOptPrompt
@goto :DoneOptPrompt
:ExecOptPrompt
@shift /1
@set "OpenWithPrompt=%~1"
@shift /1
@goto :ProcessArgumentsCycle
:DoneOptPrompt
::
:: option -e --extlist
::
:CheckOptExtList
@if /I "%~1" == "-e" goto :ExecOptExtList
@if /I "%~1" == "--extlist" goto :ExecOptExtList
@goto :DoneOptExtList
:ExecOptExtList
@shift /1
@set "FileExtList=%~1"
@shift /1
@goto :ProcessArgumentsCycle
:DoneOptExtList
::
:: option -l --list
::
:CheckOptList
@if /I "%~1" == "-l" goto :ExecOptList
@if /I "%~1" == "--list" goto :ExecOptList
@goto :DoneOptList
:ExecOptList
@shift /1
@set "ApplicationName=%~1"
@set "Operation=--list"
@shift /1
@goto :ProcessArgumentsCycle
:DoneOptList
::
:: other argiments unknown, skip it
::
:ExecArgUnknown
@shift /1
@goto :ProcessArgumentsCycle
::
:: break process arguments
::
:ProcessArgumentsBreak
::
:: after cmdline parsing
::
@if not defined Operation          ( call :ErrorFound "Invalid arguments, see --help." & goto :EOF )
@if "%Operation%" == "--install"   ( call :InstallOpenWithMenu   & goto :EOF )
@if "%Operation%" == "--uninstall" ( call :UninstallOpenWithMenu & goto :EOF )
@if "%Operation%" == "--list"      ( call :ListOpenWithMenu      & goto :EOF )
@call :ErrorFound "Invalid options, see --help."
@goto :EOF

:GetAppliesToByFileExtList
@if not defined FileExtList goto :EOF
@for %%i in ( %FileExtList:;= % ) do @set AppliesTo=!AppliesTo! OR System.FileName:\"*%%i\"
@if defined AppliesTo set AppliesTo=%AppliesTo:~4%
@goto :EOF

:InstallOpenWithMenu
@if not defined ApplicationName   ( call :ErrorFound "Missed --install argument" & goto :EOF )
@if not defined ApplicationFile   ( call :ErrorFound "Missed --command argument" & goto :EOF )
@if not exist "%ApplicationFile%" if "%ApplicationFile:\=%" == "%ApplicationFile%" for %%i in ( "%ApplicationFile%" ) do @set "ApplicationFile=%%~$PATH:i"
@if not exist "%ApplicationFile%" ( call :ErrorFound "Invalid %ApplicationFile%" & goto :EOF )
@if not defined OpenWithPrompt set "OpenWithPrompt=Open with %ApplicationName%..."
@if defined FileExtList call :GetAppliesToByFileExtList
@set "RegFile=%TEMP%\%ApplicationName%-%UserName%-%Random%.reg"
@call :WriteInstallOpenWith   > "%RegFile%"
@call :ImportAndDeleteRegFile   "%RegFile%"
@goto :EOF

:ListOpenWithMenu
@if not defined ApplicationName   ( call :ErrorFound "Missed --list argument" & goto :EOF )
@set "RegFile=%TEMP%\%ApplicationName%-%UserName%-%Random%.reg"
@call reg export "HKEY_CLASSES_ROOT\*\shell\%ApplicationName%" "%RegFile%" 1>nul 2>nul || ( call :ErrorFound "Could not find %ApplicationName%" & goto :EOF )
@call type "%RegFile%"                   || call :ErrorFound "Could not print: %RegFile%"
@call del /f /q  "%RegFile%" 1>nul 2>nul || call :ErrorFound "Could not delete %RegFile%"
@goto :EOF

:WriteInstallOpenWith
@echo REGEDIT4
@echo.
@echo [HKEY_CLASSES_ROOT\*\shell\%ApplicationName%]
@echo @="%OpenWithPrompt%"
@echo "icon"="%ApplicationFile:\=\\%"
@if defined AppliesTo echo "AppliesTo"="%AppliesTo%"
:: see https://stackoverflow.com/questions/21362892/
::@echo "AppliesTo"="System.FileName:\"*.com\" OR System.FileName:\"*.exe\""
::@echo "AppliesTo"=".exe"
@echo.
@echo [HKEY_CLASSES_ROOT\*\shell\%ApplicationName%\command]
@if not defined ApplicationArgs if not defined ApplicationOpts echo @="\"%ApplicationFile:\=\\%\" \"%%1\""
@if not defined ApplicationArgs if     defined ApplicationOpts echo @="\"%ApplicationFile:\=\\%\" %ApplicationOpts:\=\\% \"%%1\""
@if     defined ApplicationArgs if not defined ApplicationOpts echo @="\"%ApplicationFile:\=\\%\" \"%%1\" %ApplicationArgs:\=\\%"
@if     defined ApplicationArgs if     defined ApplicationOpts echo @="\"%ApplicationFile:\=\\%\" %ApplicationOpts:\=\\% \"%%1\" %ApplicationArgs:\=\\%"
:DoneWriteInstallOpenWith
@echo.
@goto :EOF

:UninstallOpenWithMenu
@if not defined ApplicationName ( call :ErrorFound "Missed --uninstall argument" & goto :EOF )
@set "RegFile=%TEMP%\%ApplicationName%-%UserName%-%Random%.reg"
@call :WriteUninstallOpenWith > "%RegFile%"
@call :ImportAndDeleteRegFile   "%RegFile%"
@goto :EOF

:WriteUninstallOpenWith
@echo REGEDIT4
@echo.
@echo [-HKEY_CLASSES_ROOT\*\shell\%ApplicationName%]
@echo.
@goto :EOF

:ImportAndDeleteRegFile
@if "%~1" == "" goto :EOF
@if not exist "%~1" call :ErrorFound "Could not write temporary reg file %~1"
@if not exist "%~1" goto :EOF
@call type "%~1"                   || call :ErrorFound "Could not print: %~1"
@call reg import "%~1" 1>nul 2>nul || call :ErrorFound "Could not import %~1"
@call del /f /q  "%~1" 1>nul 2>nul || call :ErrorFound "Could not delete %~1"
@goto :EOF

:ErrorFound
@call :PrintToStdErr %*
@call :SetErrorLevel 1 
@goto :EOF

:PrintToStdErr
@if not "%~1" == "" echo %~1 1>&2
@goto :EOF

:Version
@echo %~1 version 1.0
@goto :EOF

:Help
@echo.
@call :Version %1
@echo Copyright^(c^) 2018 Alexey Kuryakin kouriakine@mail.ru
@echo Handle ^(install/uninstall^) "Open With"  context menu
@echo Usage :
@echo  call %1 --install   app     add    "OpenWith app" context menu
@echo  call %1 --uninstall app     delete "OpenWith app" context menu
@echo  call %1 --command cmd       set cmd command = executable file
@echo  call %1 --options opt       set options for command
@echo  call %1 --arguments arg     set arguments for command
@echo  call %1 --prompt "..."      set prompt like "Open with app"
@echo  call %1 --extlist ext       set extensions as ".txt;.log;.ini"
@echo  call %1 --list app          list "Open With" registry content
@echo  call %1 --version           get version
@echo  call %1 --help              get help
@echo  Note: short options -i, -u, -c, -o, -a, -e, -l, -h also uses as shortcut of long options
@echo        --install, --uninstall --command, --options, --arguments, --extlist, --list, --help
@echo Examples:
@echo  call %1 --install Notepad --command "notepad.exe" --prompt "Edit with Notepad" --extlist ".txt;.log;.ini"
@echo  call %1 -i Cmd -c "%%ComSpec%%" -o "/c" -a "%%*" -p "Open with Cmd" -e "%%PATHEXT%%"
@echo  call %1 --uninstall Cmd
@echo  call %1 --list Cmd
@echo  call %1 -l Notepad
@echo  call %1 -u Notepad
@echo  call %1 --version
@echo  call %1 --help
@echo.
@goto :EOF

:SetErrorLevel
@exit /b %1
@goto :EOF
