 {
 ***********************************************************************
 AdamTraffic control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Reset      - Reset counters.
|********************************************************
[]
 }
program AdamTrafficCtrl;         { Adam Traffic control program     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 do_AdamTraf_BrRx  = 0;          { Adam byte rate  receiver         }
 do_AdamTraf_BrTx  = 1;          { Adam byte rate  transmit         }
 do_AdamTraf_PrRx  = 2;          { Adam poll rate  receiver         }
 do_AdamTraf_PrTx  = 3;          { Adam poll rate  transmit         }
 do_AdamTraf_BcRx  = 4;          { Adam byte count receiver         }
 do_AdamTraf_BcTx  = 5;          { Adam byte count transmit         }
 do_AdamTraf_PcRx  = 6;          { Adam poll count receiver         }
 do_AdamTraf_PcTx  = 7;          { Adam poll count transmit         }
 AdamItemsPerPort  = 8;          { Number of ADAM items per port    }
 AdamMaxNumPorts   = 32;         { Max number of ports              }
 AdamRatePeriod    = 1000;       { Poll rate calculation period, ms }

type
 TComPortRec       = record      { COM port data record             }
  BR,PR,BC,PC      : record      { Byte/Poll Rate/Counter           }
   RX,TX           : Real;       { RX/TX = Receiver/Transmitter     }
  end;                           {                                  }
  LastRate         : Real;       { Time of last rate                }
  Name             : String;     { COM port name                    }
 end;                            {                                  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 AdamTraffic       : record      { AdamTraffic data                 }
  ComPort          : array [0..AdamMaxNumPorts] of TComPortRec; {   }
 end;                            {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Clear TComPortRec record.
 }
 procedure TComPortRec_Clear(var Rec:TComPortRec; Name:String);
 begin
  Rec.BR.RX:=0; Rec.BR.TX:=0; Rec.PR.RX:=0; Rec.PR.TX:=0;
  Rec.BC.RX:=0; Rec.BC.TX:=0; Rec.PC.RX:=0; Rec.PC.TX:=0;
  Rec.LastRate:=0; Rec.Name:=Name;
 end;
 {
 Calculate adam traffic for given port.
 }
 procedure CalcAdamTraffic(var Rec:TComPortRec);
 var data:String; ms,pctx,bctx,pcrx,bcrx,dt:Real;
  procedure CalcRate(var rate,count:Real; val,dt:Real);
  begin
   rate:=1000*(val-count)/dt;
   count:=val;
  end;
 begin
  data:='';
  if Length(Rec.Name)>0 then begin
   data:=ParamStr('AdamTraffic '+Rec.Name);
   if Length(data)>0 then begin
    ms:=mSecNow;
    dt:=ms-Rec.LastRate;
    if dt>0 then begin
     pctx:=rValDef(ExtractWord(1,data),0);
     bctx:=rValDef(ExtractWord(2,data),0);
     pcrx:=rValDef(ExtractWord(3,data),0);
     bcrx:=rValDef(ExtractWord(4,data),0);
     CalcRate(Rec.PR.TX,Rec.PC.TX,pctx,dt);
     CalcRate(Rec.BR.TX,Rec.BC.TX,bctx,dt);
     CalcRate(Rec.PR.RX,Rec.PC.RX,pcrx,dt);
     CalcRate(Rec.BR.RX,Rec.BC.RX,bcrx,dt);
    end;
    Rec.LastRate:=ms;
   end;
  end;
  data:='';
 end;
 {
 AdamTraffic calculate poll rate
 }
 procedure AdamTraffic_Calc;
 var i:Integer;
 begin
  if SysTimer_Pulse(AdamRatePeriod)>0 then
  for i:=0 to AdamMaxNumPorts do if Length(AdamTraffic.ComPort[i].Name)>0 then begin
   CalcAdamTraffic(AdamTraffic.ComPort[i]);
   UpdateDo(AdamItemsPerPort*i+do_AdamTraf_BrRx,time,AdamTraffic.ComPort[i].BR.RX);
   UpdateDo(AdamItemsPerPort*i+do_AdamTraf_BrTx,time,AdamTraffic.ComPort[i].BR.TX);
   UpdateDo(AdamItemsPerPort*i+do_AdamTraf_PrRx,time,AdamTraffic.ComPort[i].PR.RX);
   UpdateDo(AdamItemsPerPort*i+do_AdamTraf_PrTx,time,AdamTraffic.ComPort[i].PR.TX);
   UpdateDo(AdamItemsPerPort*i+do_AdamTraf_BcRx,time,AdamTraffic.ComPort[i].BC.RX);
   UpdateDo(AdamItemsPerPort*i+do_AdamTraf_BcTx,time,AdamTraffic.ComPort[i].BC.TX);
   UpdateDo(AdamItemsPerPort*i+do_AdamTraf_PcRx,time,AdamTraffic.ComPort[i].PC.RX);
   UpdateDo(AdamItemsPerPort*i+do_AdamTraf_PcTx,time,AdamTraffic.ComPort[i].PC.TX);
   if iAnd(DebugFlags,dfViewExp)<>0 then ViewExp('Port'+Str(i)+' '+AdamTraffic.ComPort[i].Name
    +': '+StrFix(AdamTraffic.ComPort[i].PR.RX,1,3)+', '+StrFix(AdamTraffic.ComPort[i].PR.TX,1,3));
  end;
 end;
 {
 AdamTraffic reset
 }
 procedure AdamTraffic_RESET;
 var i:Integer;
 begin  
  for i:=0 to AdamMaxNumPorts do TComPortRec_Clear(AdamTraffic.ComPort[i],AdamTraffic.ComPort[i].Name);
 end;
 {
 AdamTraffic clear strings
 }
 procedure AdamTraffic_CLEAR;
 var i:Integer;
 begin
  for i:=0 to AdamMaxNumPorts do TComPortRec_Clear(AdamTraffic.ComPort[i],'');
 end;
 {
 AdamTraffic initialization
 }
 procedure AdamTraffic_INIT;
 var i:Integer;
 begin  
  AdamTraffic_RESET;
  for i:=0 to AdamMaxNumPorts do begin
   AdamTraffic.ComPort[i].Name:=ReadIni('Port'+Str(i));
   if not IsSameText(AdamTraffic.ComPort[i].Name,'*') then
   if WordIndex(AdamTraffic.ComPort[i].Name,ParamStr('COMPORTLIST'))=0
   then AdamTraffic.ComPort[i].Name:='';
   if not IsEmptyStr(AdamTraffic.ComPort[i].Name)
   then Success('Port'+Str(i)+' found: '+AdamTraffic.ComPort[i].Name);
  end;
 end;
 {
 AdamTraffic finalization
 }
 procedure AdamTraffic_FREE;
 begin
 end;
 {
 AdamTraffic polling
 }
 procedure AdamTraffic_POLL;
 begin
  AdamTraffic_Calc;
 end;
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  AdamTraffic_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  AdamTraffic_INIT;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  AdamTraffic_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  AdamTraffic_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Reset
   }
   if IsSameText(cmd,'@Reset') then begin
    AdamTraffic_RESET;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
