@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem ****************************
rem UART Configuration generator
rem ****************************

:Main
call :InitializeVariables
pushd "%~dp0" && call :ComPort
popd
goto :EOF

:InitializeVariables
set uart_cfg=%~n0.cfg
goto :EOF

:ComPort
call :DeleteFiles %uart_cfg%
call :AddHeader %* > %uart_cfg%
rem              Port  BdRate Parity DataBits StopBits
call :AddComPort COM1  9600   NONE   8        1
call :AddComPort COM2  9600   NONE   8        1
call :AddComPort COM3  9600   NONE   8        1
call :AddComPort COM4  9600   NONE   8        1
call :AddComPort COM5  9600   NONE   8        1
rem call :AddComPort COM6  115200 NONE   8        1
rem call :AddComPort COM7  115200 NONE   8        1
rem call :AddComPort COM8  115200 NONE   8        1
rem call :AddComPort COM9  115200 NONE   8        1
rem call :AddComPort COM10 115200 NONE   8        1
rem call :AddComPort COM11 115200 NONE   8        1
rem call :AddComPort COM12 115200 NONE   8        1
rem call :AddComPort COM13 115200 NONE   8        1
rem call :AddComPort COM14 115200 NONE   8        1
rem call :AddComPort COM15 115200 NONE   8        1
rem call :AddComPort COM16 115200 NONE   8        1
rem call :AddComPort COM17 115200 NONE   8        1
rem call :AddComPort COM18 115200 NONE   8        1
rem call :AddComPort COM19 115200 NONE   8        1
rem call :AddComPort COM20 115200 NONE   8        1
rem call :AddComPort COM21 115200 NONE   8        1
rem call :AddComPort COM22 115200 NONE   8        1
rem call :AddComPort COM23 115200 NONE   8        1
rem call :AddComPort COM24 115200 NONE   8        1
rem call :AddComPort COM25 115200 NONE   8        1
rem call :AddComPort COM26 115200 NONE   8        1
rem call :AddComPort COM27 115200 NONE   8        1
rem call :AddComPort COM28 115200 NONE   8        1
rem call :AddComPort COM29 115200 NONE   8        1
rem call :AddComPort COM30 115200 NONE   8        1
rem call :AddComPort COM31 115200 NONE   8        1
rem call :AddComPort COM32 115200 NONE   8        1
goto :EOF

:AddHeader
echo ;**************
echo ; UART Settings
echo ;**************
goto :EOF

:AddComPort
call :AddPort %* >> %uart_cfg%
goto :EOF

:AddPort
set Port=%~1&shift
set BaudRate=%~1&shift
set Parity=%~1&shift
set DataBits=%~1&shift
set StopBits=%~1&shift
echo [SerialPort-%Port%]
echo Port     = %Port%
echo BaudRate = %BaudRate%
echo Parity   = %Parity%
echo DataBits = %DataBits%
echo StopBits = %StopBits%
echo []
echo.
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
