 {
 ***********************************************************************
 Daq Pascal application program ddim.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @DimTagUpdate  - Update tag from DIM
| @AssignTag t v - Assign tag t to value v
|********************************************************
[]
 }
program ddim;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 DimDeadline = 5000;             { Detect DIM server is dead        }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 DDIM    : record                { All DDIM data...                 }
  SERVID : TTagRef;              { Server Identifier pid@hostname   }
  CLOCK  : TTagRef;              { Server Date-Time                 }
  SelfId : String;               { Self pid@hostname                }
  BTN1   : TTagRef;              { }
  DIMCMDTEST : TTagRef;          { }
 end;                            {                                  }
 ColorNorm        : Integer;     { Color in normal state: lime,aqua }
 ColorWarn        : Integer;     { Color in warning state: yellow   }
 cmd_DimTagUpdate : Integer;     { @DimTagUpdate                    }
 cmd_AssignTag    : Integer;     { @AssignTag                       }
 cmd_DimCmdTest   : Integer;     { @DimCmdTest                      }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Prefix for DIM @remote commands.
 }
 function DimRemote:String;
 var CanRemote:Boolean;
 begin
  CanRemote:=DIM_IsServerMode or DIM_IsClientMode;
  if (DIM_GuiClickTag=0) then CanRemote:=false;
  if (devDimSrv=0) then CanRemote:=false;
  if CanRemote
  then DimRemote:='@remote '
  else DimRemote:='';
 end;
 {
 Xor bit on click (local version).
 }
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Xor bit on click (remote version).
 }
 procedure ClickTagXorRemote(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(tag)+' '+Str(iXor(iGetTag(tag),XorMask)));
  end;
 end;
 {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   n:=n+EditAddInputLn('Сохранить параметры в  ini-файл  на локальной машине');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@SaveIni');
   n:=n+EditAddInputLn('Загрузить параметры из ini-файла на локальной машине');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@LoadIni');
   if DIM_IsClientMode then begin
    n:=n+EditAddInputLn('Сохранить параметры в  ini-файл  на удаленной машине');
    n:=n+EditAddConfirm('');
    n:=n+EditAddCommand(DimRemote+'@SaveIni');
    n:=n+EditAddInputLn('Загрузить параметры из ini-файла на удаленной машине');
    n:=n+EditAddConfirm('');
    n:=n+EditAddCommand(DimRemote+'@LoadIni');
   end;
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   n:=n+EditAddInputLn('Режим отладки консоли: детальный (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   n:=n+EditAddInputLn('Перезапустить устройство '+DevName);
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SysEval @Daq Compile '+DevName);
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Tools Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Poll DIM Client
 }
 procedure DDIM_Poll_Client;
 begin
  if DIM_IsClientMode then begin
   if (ShouldRefresh(DDIM.CLOCK.dat,GetStampOfTag(DDIM.CLOCK.tag,0))>0) then begin
    bNul(SetTagColor(DDIM.SERVID.tag,ColorNorm));
    bNul(SetTagColor(DDIM.CLOCK.tag,ColorNorm));
    DDIM.CLOCK.tim:=mSecNow;
   end;
   if (SysTimer_Pulse(1000)>0) then if (mSecNow-DDIM.CLOCK.tim>DimDeadline) then begin
    bNul(sSetTag(DDIM.SERVID.tag,'Server Disconnected'));
    bNul(SetTagColor(DDIM.SERVID.tag,ColorWarn));
    bNul(SetTagColor(DDIM.CLOCK.tag,ColorWarn));
   end;
  end;
 end;
 {
 Update Host Date-Time
 }
 procedure DDIM_Poll_Logic;
 begin
  if (SysTimer_Pulse(1000)>0) then begin
   bNul(sSetTag(DDIM.SERVID.tag,DDIM.SelfId));
   bNul(sSetTag(DDIM.CLOCK.tag,GetDateTime(mSecNow)));
   bNul(SetTagColor(DDIM.SERVID.tag,ColorNorm));
   bNul(SetTagColor(DDIM.CLOCK.tag,ColorNorm));
  end;
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var ClickCurve:Integer; s:String;
 begin
  DIM_GuiClickBuff:=''; s:='';
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Copy GUI click to DIM buffer for remote execution.
   }
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle local clicks
     }
     if ClickIsLocal then begin
      {
      Handle tag clicks...
      }
      if ClickTag=DDIM.BTN1.tag then begin
       // Test on "-1" DIM transmit
       if iGetTag(ClickTag)=0
       then bNul(iSetTag(ClickTag,-1))
       else bNul(iSetTag(ClickTag,0));
      end;
      {
      Handle sensor clicks...
      }
      if IsSameText(ClickSensor,'DDIM.TITLE') then MenuToolsStarter;
      if IsSameText(ClickSensor,'HELP') then begin
       Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
       bNul(Voice(snd_Click));
      end;
      {
      Select Plot & Tab windows by curve...
      }
      ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
      if IsRefCurve(ClickCurve) then begin
       iNul(WinSelectByCurve(ClickCurve,ClickCurve));
       bNul(Voice(snd_Wheel));
      end;
      {
      Console commands: @url_encoded_sensor ...
      }
      if LooksLikeCommand(ClickSensor) then begin
       DevSendCmdLocal(url_decode(ClickSensor));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Handle remote clicks comes from DIM via @DimGuiClick message.
     @DimGuiClick default handler decode and write events to FIFO,
     so we can find it as clicks and can handle it in usual way.
     }
     if ClickIsRemote then begin
      //
      // Show time difference.
      //
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      //
      // Handle remote console commands...
      //
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
      //
      // Handle remote sensor clicks...
      //
      if TypeTag(ClickTag)>0 then begin
       s:=ClickParams('NewValue');
       if Length(s)>0 then begin
       end;
      end;
     end;
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   MenuToolsHandler; // Menu TOOLS
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  DIM_GuiClickBuff:=''; s:='';
 end;
 {
 Handle message @AssignTag arg
 }
 procedure DDIM_OnAssignTag(arg:String);
 var tag:Integer; w1,w2:String;
  procedure Cleanup;
  begin
   w1:=''; w2:='';
  end;
 begin
  Cleanup;
  if (arg<>'') then begin
   w1:=ExtractWord(1,arg);
   tag:=FindTag(w1);
   if (tag<>0) then begin
    w2:=ExtractWord(2,arg);
    if tag=DDIM.BTN1.tag then UpdateTag(tag,w2,0,MaxInt);
   end;
  end;
  Cleanup;
 end;
 {
 Handle message @DimUpdateTag arg
 }
 procedure DDIM_OnDimUpdateTag(arg:String);
 var tag,typ:Integer; x,y:Real;
 begin
  if (arg<>'') then begin
   if DIM_IsClientMode and not DIM_IsServerMode then begin
    tag:=FindTag(ExtractWord(1,arg));
    if (tag<>0) then begin
     typ:=TypeTag(tag);
     if (typ=1) then y:=iGetTag(tag) else
     if (typ=2) then y:=rGetTag(tag) else y:=_Nan;
     x:=time;
     if not IsNan(y) then begin
      //if tag=DDIM.R.tag then UpdateAo(ao_Real,x,y);
      //if tag=DDIM.I.tag then UpdateDo(do_Int,x,y);
     end;
    end;
   end;
  end;
 end;
 //
 // DDIM tags filling.
 //
 procedure DDIM_FillTags(InitVal:Real);
 begin
  DDIM.BTN1.val:=InitVal;
  DDIM.CLOCK.val:=InitVal;
  DDIM.SERVID.val:=InitVal;
 end;
 {
 Update DIM services
 }
 procedure DimUpdateState;
 begin
  if DIM_IsServerMode then begin
   // Enforce update each 10 sec
   if SysTimer_Pulse(10000)>0 then DDIM_FillTags(-MaxReal);
   if ShouldRefresh(DDIM.CLOCK.val, GetStampOfTag(DDIM.CLOCK.tag,0))>0  then DIM_UpdateTag(DDIM.CLOCK.tag, '');
   if ShouldRefresh(DDIM.SERVID.val,GetStampOfTag(DDIM.SERVID.tag,0))>0 then DIM_UpdateTag(DDIM.SERVID.tag,'');
   if ShouldRefresh(DDIM.BTN1.val,  GetStampOfTag(DDIM.BTN1.tag,0))>0   then DIM_UpdateTag(DDIM.BTN1.tag,  '');
  end;
 end;
 {
 DDIM Initialization...
 }
 procedure DDIM_Init(TagPrefix:String);
 begin
  {
  Initialize tags
  }
  if not IsEmptyStr(TagPrefix) then begin
   DIM_GuiClickInit(TagPrefix+'.DIMGUICLICK');
   InitTag(DDIM.SERVID.tag,TagPrefix+'.SERVID',3);
   InitTag(DDIM.CLOCK.tag, TagPrefix+'.CLOCK', 3);
   InitTag(DDIM.BTN1.tag,  TagPrefix+'.BTN1',  1);
   InitTag(DDIM.DIMCMDTEST.tag, TagPrefix+'.DIMCMDTEST', 3);
  end;
  if DIM_IsServerMode then Success('Run as Server') else if DIM_IsClientMode then Success('Run as Client');
  {
  Server Identifier
  }
  if DIM_IsServerMode
  then DDIM.SelfId:=Str(getpid)+'@'+ParamStr('HostName')
  else DDIM.SelfId:=Str(getpid)+'@'+ParamStr('ComputerName');
  {
  Colors
  }
  ColorNorm:=clAqua;
  ColorWarn:=clYellow;
  if DIM_IsServerMode then ColorNorm:=clLime;
  if DIM_IsClientMode then ColorNorm:=clLime;
  bNul(SetTagColor(DDIM.SERVID.tag,ColorNorm));
  bNul(SetTagColor(DDIM.CLOCK.tag,ColorNorm));
  {
  Initialize timers
  }
  DDIM.CLOCK.tim:=mSecNow;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  DDIM_FillTags(-MaxReal);
  DDIM.SERVID.tag:=0;
  DDIM.CLOCK.tag:=0;
  DDIM.SelfId:='';
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  DDIM_Init(ReadIni('tagDDIM'));
  cmd_DimTagUpdate:=RegisterStdInCmd('@DimTagUpdate','');
  cmd_AssignTag:=RegisterStdInCmd('@AssignTag','');
  cmd_DimCmdTest:=RegisterStdInCmd('@DimCmdTest','');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  GUIHandler;
  if DIM_IsClientMode
  then DDIM_Poll_Client
  else DDIM_Poll_Logic;
  DimUpdateState;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid,tag:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @DimTagUpdate tag
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    DDIM_OnDimUpdateTag(arg);
    Data:='';
   end else
   {
   @AssignTag DDIM.DEMO 10
   }
   if (cmdid=cmd_AssignTag) then begin
    Success('AssignTag');
    DDIM_OnAssignTag(arg);
    Data:='';
   end else
   {
   @DimCmdTest
   }
   if (cmdid=cmd_DimCmdTest) then begin
    Success('DimCmdTest: '+Data+'/'+cmd+'/'+base64_decode(Trim(arg)));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{<== Please never change this code ***}
{***************************************************}
