@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem ****************************
rem DIM DIC/DIS config generator
rem ****************************

:Main
call :InitializeVariables
pushd "%~dp0" && call :DIMServices
popd
goto :EOF

:InitializeVariables
set "fname=%~n0"
set "fname=%fname:_dim=%"
set diccfg=%fname%_dic.cfg
set discfg=%fname%_dis.cfg
set devmsg=devPostMsg
set "FN=DDIM"     :: Facility name
set "FP=%FN:.=/%" :: Facility DIM  path, i.e. FN name with . to / replacement
set "FF=%FN:.=_%" :: Facility file name, i.e. FN name with . to _ replacement
goto :EOF

:DIMServices
call :DeleteFiles %diccfg% %discfg%
call :DIM_DIS  %* >> %discfg%
call :DIM_DIC  %* >> %diccfg%
call :DIM_CTRL %* >> %diccfg%
goto :EOF

:DIM_DIS
unix dimcfg ^
  -n section  "[&%FN%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd %FP%/DIMGUICLICK ^
  -n tag      %FN%.DIMGUICLICK ^
  -n %devmsg% "&%FN%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dic_cmnd %FP%/DIMGUICLICK ^
  -n tag      %FN%.DIMGUICLICK ^
  -n end ^
  -n dis_cmnd %FP%/DIMCMDTEST ^
  -n tag      %FN%.DIMCMDTEST ^
  -n %devmsg% "&%FN%.CTRL @DIMCMDTEST=%%**" ^
  -n end ^
  -n dis_info %FP%/BTN1 ^
  -n tag      %FN%.BTN1 ^
  -n end ^
  -n dis_info %FP%/CLOCK ^
  -n tag      %FN%.CLOCK ^
  -n end ^
  -n dis_info %FP%/SERVID ^
  -n tag      %FN%.SERVID ^
  -n end ^
  -n
goto :EOF

:DIM_DIC
unix dimcfg ^
  -n section  "[&%FN%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd %FP%/DIMGUICLICK ^
  -n tag      %FN%.DIMGUICLICK ^
  -n end ^
  -n dic_cmnd %FP%/DIMCMDTEST ^
  -n tag      %FN%.DIMCMDTEST ^
  -n end ^
  -n dic_info %FP%/BTN1 ^
  -n tag      %FN%.BTN1 ^
  -n %devmsg% "&%FN%.CTRL @DimTagUpdate=%FN%.BTN1" ^
  -n end ^
  -n dic_info %FP%/CLOCK ^
  -n tag      %FN%.CLOCK ^
  -n %devmsg% "&%FN%.CTRL @DimTagUpdate=%FN%.CLOCK" ^
  -n print    "filling  T0ZG  ////  &DDIM.MAIN.CTRL" ^
  -n end ^
  -n dic_info %FP%/SERVID ^
  -n tag      %FN%.SERVID ^
  -n %devmsg% "&%FN%.CTRL @DimTagUpdate=%FN%.SERVID" ^
  -n end ^
  -n
goto :EOF

:DIM_CTRL
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
