////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq plugin for demo_dll_min DAQ config - how to use plugins in DAQ.     //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 202411120 - Sample created by A.K.                                         //
////////////////////////////////////////////////////////////////////////////////

library e140_dll;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics,
 _crw_crwapi;

/////////////////////////////////////////////////////////
{$I _crw_plugin_declare.inc} // Declare CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:ICrwApi):Integer;     //
/////////////////////////////////////////////////////////
 ////////////////////////////
 // Comment on TDaqDataSheet:
 // Hold all DAQ data there!!
 // Init all on DAQ_CMD_INIT.
 // Free all on DAQ_CMD_FREE.
 // Use data on DAQ_CMD_POLL.
 ////////////////////////////
type ////////////////////////
 TDaqDataSheet = packed record
  Sinus    : Double;
  Omega    : Double;
  timeSec  : Double;
  dllName  : LongString;
 end; //// TDaqDataSheet /////
 ////////////////////////////
begin
 Result:=0;
 with CrwApi,SysApi,GuiApi,DaqApi do
 try
  VerifyPluginDate(CrwApiEdition,Version);
  VerifyPluginType(Target,ForDataAcquisition);
  ///////////////////////////////////////////////////////////////
  // Nota Bene: all driver data must be located in DaqDataSheet!!
  ///////////////////////////////////////////////////////////////
  with TDaqDataSheet(DaqDataSheet(SizeOf(TDaqDataSheet))^) do begin
   case DaqCommand of
    ////////////////////
    // Initialize driver
    ////////////////////
    DAQ_CMD_INIT: begin
     RedirectStdIn(Input);
     RedirectStdOut(Output);
     //////////////////////////////////////////////////
     // Initialize USER data located in DaqDataSheet //
     //////////////////////////////////////////////////
     dllName:=ExtractFileNameExt(PluginBinaryFileName);
     GuiApi.Echo(Format('Starting %s …',[dllName]));
     Sinus:=0;
     Omega:=1;
     timeSec:=0;
     //////////////////
     GuiApi.Echo('Ok');
    end;
    //////////////////
    // Finalize driver
    //////////////////
    DAQ_CMD_FREE: begin
     GuiApi.Echo(Format('Stopping %s …',[dllName]));
     //////////////////
     // Don`t forget to
     // Clear all data:
     //////////////////
     Sinus:=0;
     Omega:=0;
     timeSec:=0;
     dllName:='';
     //////////////////
     // Free DataSheet:
     //////////////////
     DaqDataSheet(0);//
     //////////////////
     GuiApi.Echo('Ok');
    end;
    ////////////////////
    // Main polling loop
    ////////////////////
    DAQ_CMD_POLL: begin
     /////////////////////////////
     // USER data processing code:
     /////////////////////////////
     timeSec:=time*timeunits*1e-3;
     Sinus:=sin(Omega*timeSec);
     Echo(Format('RunCount = %g',[RunCount]));
     writeln(Format('sin(%11.4f)=%10.6f',[timeSec,Sinus]));
     /////////////////////////////
     // USER data processing done.
     /////////////////////////////
    end;
   end; // case
  end; // with
 except
  on E:Exception do begin
   Echo(PluginName+RusEng(': ОШИБКА!',': ERROR!')); 
   if UsesBlaster then Voice('EXCEPTION');
   Echo(E.Message);
   Result:=-1;
  end;
 end;
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_exports.inc} // Exports CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID;        //
/////////////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
