---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Справка по WIKA

<b class="memo">WIKA</b> - система датчиков давления и температуры
 **[wika.com](https://www.wika.com)**,
 **[wika.ru](https://wika.ru/)**
с подключением по **RS-232**.
Питание датчика берется из **COM** порта.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Документация

Документация здесь: **[worksheet/](worksheet/)**.

Спецификация **DIM**-сервера: **[dim-spec-wika.pdf](worksheet/dim-spec-wika.pdf)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Возможности системы

1. Удаленное (по **RS-232**) измерение давления и температуры датчиками **WIKA** - до **9** штук;  
2. Публикация данных в сети по протоколу **DIM**;  
3. Протоколирование результатов измерений.  
4. Отображение измеренных данных на мнемосхемах и графиках.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Схема подключения и питания

![Схема подключения](worksheet/wika_doc/wika-d-10-wiring.png){ width="800" }


Для питания датчика **WIKA D-10-P** используются сигналы **RTS**, **DTR**,
которые надо программно устанавливать (активизировать).  
Для установки сигналов **RTS**, **DTR** используются флаги **DCB**:
``` bash
[SerialPort-COM1]
Port     = COM1
BaudRate = 9600
Parity   = NONE
DataBits = 8
StopBits = 1
DcbFlags = $1010 ; RTS=$1000 + DTR=$10
[]
```

Использование сигналов **RTS**, **DTR** в качестве источника питания - это, конечно,
некоторое злоупотребление стандартом **RS-232**,
потому что линии **RTS**, **DTR** являются сигнальными, а не силовыми.
Но тем не менее, такая практика (нестандартного использования сигналов) существует, и с этим приходится работать.
Согласно стандарту (например, в редакции **CCITT-V.28-1988**), сигналы **RS-232** биполярны,
имеют уровень **"1"=(-25..-3) V**, уровень **"0"=(+3..+25) V**.
Диапазон напряжений **(-3..+3) V** считается "неопределенным" или "переходным".
При этом, согласно стандарту, ток при коротком замыкании сигналов на землю не должен превышать **0.5 A**.
В реальности источник сигналов может иметь напряжение в широком диапазоне **(5..25) V**,
а ток может ограничиваться величинами от нескольких миллиАмпер до 500 миллиАмпер.
Для **COM**-портов **PC** часто используется питание **12 V** и токо-ограничивающий резистор порядка **1 кОм**,
что достаточно для питания устройств током **10-15 мА**.
При параллельном подключении двух линий **RTS**, **DTR** ток для питания подключаемых устройств удваивается.
Следует добавить, что стандарт допускает широкий диапазон напряжений и токов сигналов, что может привести
к недостатку питающего напряжения и тока в конкретном исполнении **COM**-порта.

Экспериментально было установлено, что при подключении на **COM**-порт **Prom-PC**
напряжение на **RTS**+**DTR** относительно земли составило **7.5 V** (в точке подключения датчика).
Питание датчиков можно сделать более стабильным, если "оторвать" сигналы **RTS**, **DTR**,
подавая вместо них внешнее питание **12 V** прямо на датчик.
Для этого надо оторвать провод питания (коричневый) от контактов (**4,7**) на разъеме
и подать на него **+12 V** относительно земли (зеленый, контакт **5**).

Из-за того, что питание датчика берется с **COM** порта, длине линии ограничена (по документации не более **3 м**).
Вероятно, работа на более длинных линиях возможна, но менее истойчива и требует хорошего кабеля,
чтобы на нем не происходило потери напряжения питания.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Список сокращений и аббревиатур

Для именования кривых, тегов, сенсоров, окон и других программных объектов
используются следующие **соглашения о наименовании**:

```
Система:
 WIKA      - Название серии
Подсистема:
 WIK1       - Датчик WIKA номер 1
 ....       - ................................
 WIK9       - Датчик WIKA номер 9
Параметры:
 .POLL_RATE - Частота опроса, Гц                ( POLLing RATE                      )
 .ERROR_CNT - Счетчик ошибок                    ( ERROR CouNTer                     )
 .PAR_MA    - Нижний диапазон                   ( MBA lower range                   )
 .PAR_ME    - Верхний диапазон                  ( MBE upper range                   )
 .PAR_PZ    - Измеренное давление в физ.ед.     ( Pressure in Physical Units        )
 .PAR_PZMU  - Строка метода и единиц измерения  ( Measuring method/units            )
 .PAR_PZM   - Метод измерения (rel/abs)         ( 0/1=rel/abs measuring method      )
 .PAR_PZU   - Единицы измерения                 ( 0..5=bar/psi/mmHg/inHg/mWs/inWs   )
 .PAR_PK    - Измеренное давление в кодах       ( Pressure in digits                )
 .PAR_PKS   - Статус питания                    ( Status of power 0/1=Ok/Fail       )
 .PAR_KN    - Инструментальный номер датчика    ( Instrument number of sensor       )
 .PAR_AZ    - Задание времени отклика           ( Response time                     )
Например:
 WIKA.WIK1.PAR_PZ - измеренное давление датчика WIK1 в системе WIKA
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

**Желаем успешного использовния датчиков Wika!**

---

> CRW-DAQ Copyright (c) 2001-2024 Alexey Kuryakin <kouriakine@mail.ru>.

---
