 {
 ***********************************************************************
 WIKA main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
 [@Help]
 |StdIn Command list: "@cmd=arg" or "@cmd arg"
 |********************************************************
 | @MenuCloseConfirmation - for internal use.
 | @MenuToolsConfirmation - for internal use.
 |********************************************************
 []
 }
program wika_main_ctrl;          { WIKA main control program        }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod = 1000;             { Polling period for smile face    }
 AwakePeriod = 100;              { Period of checks to awake DatSrv }

type
 TTagRef = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 TWIKAMainRec = record        { Main control & GUI               }
  CMD      : record              { CoMmandDs to control GUI         }
   HELP    : TTagRef;            { Open Help                        }
   HOME    : TTagRef;            { Exec Home                        }
   OPEN    : TTagRef;            { Open DAT file(s)                 }
   SAVE    : TTagRef;            { Save DAT file(s)                 }
   LOADINI : TTagRef;            { Load INI file                    }
   SAVEINI : TTagRef;            { Save INI file                    }
   TOOLS   : TTagRef;            { Tools menu                       }
   SOUND   : TTagRef;            { Sound menu                       }
   SMILE   : TTagRef;            { Smile menu                       }
   CLOSE   : TTagRef;            { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;                            {                                  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 WIKA        : record            { All WIKA data                    }
  MAIN       : TWIKAMainRec;     { Main control & GUI               }
  AwokeTime  : Real;             { Time when DatSrv last awoke      }
  DatSrvGate : TTagRef;          { Save data to DatSrv              }
 end;                            {                                  }
 cmd_MenuCloseConfirmation:Integer;{ Command @MenuCloseConfirmation }
 cmd_MenuToolsConfirmation:Integer;{ Command @MenuToolsConfirmation }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Initilize WIKA.MAIN record tags
 }
 procedure TWIKAMainRec_Init(var Rec:TWIKAMainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.HELP.tag,    TagPrefix+'.CMD.HELP',    1);
   InitTag(Rec.CMD.HOME.tag,    TagPrefix+'.CMD.HOME',    1);
   InitTag(Rec.CMD.OPEN.tag,    TagPrefix+'.CMD.OPEN',    1);
   InitTag(Rec.CMD.SAVE.tag,    TagPrefix+'.CMD.SAVE',    1);
   InitTag(Rec.CMD.LOADINI.tag, TagPrefix+'.CMD.LOADINI', 1);
   InitTag(Rec.CMD.SAVEINI.tag, TagPrefix+'.CMD.SAVEINI', 1);
   InitTag(Rec.CMD.TOOLS.tag,   TagPrefix+'.CMD.TOOLS',   1);
   InitTag(Rec.CMD.SOUND.tag,   TagPrefix+'.CMD.SOUND',   1);
   InitTag(Rec.CMD.SMILE.tag,   TagPrefix+'.CMD.SMILE',   1);
   InitTag(Rec.CMD.CLOSE.tag,   TagPrefix+'.CMD.CLOSE',   1);
   Rec.CMD.CLOSE.val:=-1;
   Rec.CMD.TOOLS.val:=-1;
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Nice tooltip notifier.
 }
 procedure NiceNotify(aText:String; aDelay:Integer);
 begin
  if Length(aText)>0 then begin
   ShowTooltip('text "'+aText+'" preset stdNotify delay '+Str(aDelay));
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Get text of Close menu items
 }
 function MenuCloseItem(MenuClose:Integer):String;
 begin
  if MenuClose=0 then MenuCloseItem:='Продолжить работу'                          else
  if MenuClose=1 then MenuCloseItem:='Перезапустить сервер '+DatSrv               else
  if MenuClose=2 then MenuCloseItem:='Перезапустить сервер '+CronSrv              else
  if MenuClose=3 then MenuCloseItem:='Перезапустить сервер '+SpeakSrv             else
  if MenuClose=4 then MenuCloseItem:='Перезапустить сеанс АСУ'                    else
  if MenuClose=5 then MenuCloseItem:='Завершить текущий сеанс АСУ'                else
  if MenuClose=6 then MenuCloseItem:='Завершить работу АСУ и выйти из программы'  else
  if MenuClose=7 then MenuCloseItem:='Завершить работу АСУ и выключить компьютер' else
  MenuCloseItem:='';
 end;
 {
 Execute Close menu commands
 }
 procedure MenuCloseCmnd(MenuClose:Integer);
 begin
  if MenuClose=0 then NiceNotify('Желаю успешной работы',10000);
  if MenuClose=1 then Cron('@Eval @System @Async @Daq Compile '+DatSrv);
  if MenuClose=2 then Cron('@Eval @System @Async @Daq Compile '+CronSrv);
  if MenuClose=3 then Cron('@Eval @System @Async @Daq Compile '+SpeakSrv);
  if MenuClose=4 then Cron('@Shutdown Daq Restart');
  if MenuClose=5 then Cron('@Shutdown Daq Exit');
  if MenuClose=6 then Cron('@Shutdown Crw Exit');
  if MenuClose=7 then Cron('@Shutdown Win Exit');
 end;
 {
 Get text of Tools menu items
 }
 function MenuToolsItem(MenuTools:Integer):String;
 begin
  if MenuTools=0 then MenuToolsItem:='Вызвать окно справочной информации (HELP)'    else
  if MenuTools=1 then MenuToolsItem:='Параметры Установки - Загрузить из INI файла' else
  if MenuTools=2 then MenuToolsItem:='Параметры Установки - Сохранить в  INI файле' else
  if MenuTools=3 then MenuToolsItem:='Пока не реализована'                          else
  if MenuTools=4 then MenuToolsItem:='Пока не реализована'                          else
  if MenuTools=5 then MenuToolsItem:='Пока не реализована'                          else
  if MenuTools=6 then MenuToolsItem:='Пока не реализована'                          else
  if MenuTools=7 then MenuToolsItem:='Пока не реализована'                          else
  MenuToolsItem:='';
 end;
 {
 Execute Tools menu commands
 }
 procedure MenuToolsCmnd(MenuTools:Integer);
 begin
  if MenuTools=0 then bNul(iSetTag(WIKA.MAIN.CMD.HELP.tag,1));
  if MenuTools=1 then bNul(iSetTag(WIKA.MAIN.CMD.LOADINI.tag,1));
  if MenuTools=2 then bNul(iSetTag(WIKA.MAIN.CMD.SAVEINI.tag,1));
  if MenuTools=3 then NiceNotify('Желаю успешной работы',10000);
  if MenuTools=4 then NiceNotify('Желаю успешной работы',10000);
  if MenuTools=5 then NiceNotify('Желаю успешной работы',10000);
  if MenuTools=6 then NiceNotify('Желаю успешной работы',10000);
  if MenuTools=7 then NiceNotify('Желаю успешной работы',10000);
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  WIKA.AwokeTime:=mSecNow;
  DevPostCmd(devDatSrv,'  ');
 end;
 {
 WIKA clear strings
 }
 procedure WIKA_CLEAR;
 begin
 end;
 {
 WIKA initialization
 }
 procedure WIKA_INIT;
 begin
  //
  // Initialize tags & devices...
  //
  TWIKAMainRec_Init(WIKA.MAIN,ReadIni('tagWIKA')+'.MAIN');
  InitTag(WIKA.DatSrvGate.tag,'DATSRV.GATE',-1);
  //
  // Initialize values...
  //
  WIKA.AwokeTime:=0;
 end;
 {
 WIKA finalization
 }
 procedure WIKA_FREE;
 begin
 end;
 {
 WIKA polling
 }
 procedure WIKA_POLL;
 var nerrors:Real; ClickCurve,i:Integer;
 begin
  {
  Awake DatSrv to enforce data save.
  }
  if SysTimer_Pulse(AwakePeriod)>0 then begin
   bNul(iSetTag(WIKA.DatSrvGate.tag,Ord(iGetTag(WIKA.MAIN.CMD.SAVE.tag)<>0)));
  end;
  {
  Execute GUI commands
  }
  if iGetTag(WIKA.MAIN.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
   bNul(iSetTag(WIKA.MAIN.CMD.HELP.tag,0));
  end;
  if iGetTag(WIKA.MAIN.CMD.HOME.tag)<>0 then begin
   Cron('@cron.run WIKA.MAIN.CTRL.HOME');
   bNul(iSetTag(WIKA.MAIN.CMD.HOME.tag,0));
  end;
  if iGetTag(WIKA.MAIN.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '
   +URL_Packed(AddBackSlash(DaqFileRef(AdaptFileName(ReadIni('['+DatSrv+'] DataPath')),''))+'*.dat;*.crw'));
   bNul(iSetTag(WIKA.MAIN.CMD.OPEN.tag,0));
  end;
  if iGetTag(WIKA.MAIN.CMD.LOADINI.tag)<>0 then begin
   DevPostCmd(devMySelf,'@LoadIni');
   bNul(iSetTag(WIKA.MAIN.CMD.LOADINI.tag,0));
  end;
  if iGetTag(WIKA.MAIN.CMD.SAVEINI.tag)<>0 then begin
   DevPostCmd(devMySelf,'@SaveIni');
   bNul(iSetTag(WIKA.MAIN.CMD.SAVEINI.tag,0));
  end;
  if iGetTag(WIKA.MAIN.CMD.TOOLS.tag)<>0 then begin
   if EditState=0 then begin
    if Pos('?',Edit('(Команда "Инструменты"... ')
              +Edit(' Что выбираете:')
              +Edit(' '+MenuToolsItem(0))
              +Edit(' '+MenuToolsItem(1))
              +Edit(' '+MenuToolsItem(2))
              +Edit(' '+MenuToolsItem(3))
              +Edit(' '+MenuToolsItem(4))
              +Edit(' '+MenuToolsItem(5))
              +Edit(' '+MenuToolsItem(6))
              +Edit(' '+MenuToolsItem(7))
              +Edit(')MenuList MENU_'+NameTag(WIKA.MAIN.CMD.TOOLS.tag)))>0
    then Warning('Error initializing MenuList!');
   end else Warning('Cannot edit right now!');
   bNul(iSetTag(WIKA.MAIN.CMD.TOOLS.tag,0));
   WIKA.MAIN.CMD.TOOLS.val:=-1;
  end;
  if iGetTag(WIKA.MAIN.CMD.CLOSE.tag)<>0 then begin
   if EditState=0 then begin
    if Pos('?',Edit('(Команда "Закрыть"... ')
              +Edit(' Что выбираете:')
              +Edit(' '+MenuCloseItem(0))
              +Edit(' '+MenuCloseItem(1))
              +Edit(' '+MenuCloseItem(2))
              +Edit(' '+MenuCloseItem(3))
              +Edit(' '+MenuCloseItem(4))
              +Edit(' '+MenuCloseItem(5))
              +Edit(' '+MenuCloseItem(6))
              +Edit(' '+MenuCloseItem(7))
              +Edit(')MenuList MENU_'+NameTag(WIKA.MAIN.CMD.CLOSE.tag)))>0
    then Warning('Error initializing MenuList!');
   end else Warning('Cannot edit right now!');
   bNul(iSetTag(WIKA.MAIN.CMD.CLOSE.tag,0));
   WIKA.MAIN.CMD.CLOSE.val:=-1;
  end;
  {
  Handle Smile button state
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   nerrors:=GetErrCount(-2);
   if nerrors>WIKA.MAIN.CMD.SMILE.val then bNul(iSetTag(WIKA.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(WIKA.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(WIKA.MAIN.CMD.SMILE.tag,1));
   WIKA.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Edit handling...
  }
  if EditState=ef_Done then begin
   {
   Warning, Information dialog completion.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Warning') then sNul(Edit(''));
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Information') then sNul(Edit(''));
   {
   CLOSE menu.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(WIKA.MAIN.CMD.CLOSE.tag)) then begin
    if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
     WIKA.MAIN.CMD.CLOSE.val:=Val(Edit('?ans 1'));
     if WIKA.MAIN.CMD.CLOSE.val>0 then begin
      DevPostCmd(devMySelf,'@MenuCloseConfirmation '+UpCaseStr(StrReplace(StrReplace(
                 MenuCloseItem(Round(WIKA.MAIN.CMD.CLOSE.val)),'  ',Dump(' '),3),'  ',Dump(' '),3)));
     end else begin
      MenuCloseCmnd(Round(WIKA.MAIN.CMD.CLOSE.val));
      WIKA.MAIN.CMD.CLOSE.val:=-1;
     end;
    end;
    sNul(Edit(''));
   end;
   {
   CLOSE menu (after confirmation).
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'YesNo_'+NameTag(WIKA.MAIN.CMD.CLOSE.tag)) then begin
    if WIKA.MAIN.CMD.CLOSE.val>=0 then
    if Val(ExtractWord(2,Edit('?ans 0')))=6 then MenuCloseCmnd(Round(WIKA.MAIN.CMD.CLOSE.val));
    WIKA.MAIN.CMD.CLOSE.val:=-1;
    sNul(Edit(''));
   end;
   {
   TOOLS menu.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(WIKA.MAIN.CMD.TOOLS.tag)) then begin
    if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
     WIKA.MAIN.CMD.TOOLS.val:=Val(Edit('?ans 1'));
     if (WIKA.MAIN.CMD.TOOLS.val>10) then begin
      DevPostCmd(devMySelf,'@MenuToolsConfirmation '+UpCaseStr(StrReplace(StrReplace(
                 MenuToolsItem(Round(WIKA.MAIN.CMD.TOOLS.val)),'  ',Dump(' '),3),'  ',Dump(' '),3)));
     end else begin
      MenuToolsCmnd(Round(WIKA.MAIN.CMD.TOOLS.val));
      WIKA.MAIN.CMD.TOOLS.val:=-1;
     end;
    end;
    sNul(Edit(''));
   end;
   {
   TOOLS menu (after confirmation).
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'YesNo_'+NameTag(WIKA.MAIN.CMD.TOOLS.tag)) then begin
    if WIKA.MAIN.CMD.TOOLS.val>=0 then
    if Val(ExtractWord(2,Edit('?ans 0')))=6 then MenuToolsCmnd(Round(WIKA.MAIN.CMD.TOOLS.val));
    WIKA.MAIN.CMD.TOOLS.val:=-1;
    sNul(Edit(''));
   end;
  end;
  if EditState=ef_Done then begin
   Problem('Uncompleted edit detected!');
   sNul(Edit(''));
  end else
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Edit error detected!');
   sNul(Edit(''));
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,KeyUp)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Toolbar buttons...
     //
     ClickBitXorLocal(WIKA.MAIN.CMD.HELP.tag,1);
     ClickBitXorLocal(WIKA.MAIN.CMD.HOME.tag,1);
     ClickBitXorLocal(WIKA.MAIN.CMD.OPEN.tag,1);
     ClickBitXorLocal(WIKA.MAIN.CMD.SAVE.tag,1);
     ClickBitXorLocal(WIKA.MAIN.CMD.LOADINI.tag,1);
     ClickBitXorLocal(WIKA.MAIN.CMD.SAVEINI.tag,1);
     ClickBitXorLocal(WIKA.MAIN.CMD.TOOLS.tag,1);
     ClickBitXorLocal(WIKA.MAIN.CMD.SOUND.tag,1);
     ClickBitXorLocal(WIKA.MAIN.CMD.CLOSE.tag,1);
     if ClickTag=WIKA.MAIN.CMD.SAVE.tag then begin
      bNul(iSetTag(WIKA.DatSrvGate.tag,Ord(iGetTag(WIKA.MAIN.CMD.SAVE.tag)<>0)));
      if iGetTag(WIKA.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
     end;
     //
     // Smile face button...
     //
     if ClickTag=WIKA.MAIN.CMD.SMILE.tag then begin
      bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      bNul(iSetTag(WIKA.MAIN.CMD.SMILE.tag,0));
      bNul(Voice(snd_Click));
     end;
     //
     // Select Plot & Tab windows by curve...
     //
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     //
     // Console commands: @url_encoded_sensor ...
     //
     if (strFetch(ClickSensor,1)='@') then begin
      DevSendCmd(devMySelf,url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Calibrations
     //
     if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
      bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
      bNul(Voice(snd_Click));
     end;
     //
     // WIKx.CTRL sensors
     //
     if IsSameText(Copy(ClickSensor,1,3),'WIK') then
     if IsSameText(ExtractFileExt(ClickSensor),'.CTRL') then begin
      i:=0;
      while i<MaxInt do begin
       if IsEmptyStr(ParamStr('CIRWINNAME '+Str(i))) then i:=MaxInt else
       if Pos(UpcaseStr(ClickSensor),UpcaseStr(ParamStr('CIRWINNAME '+Str(i))))>0 then begin
        Cron('@WinSelect '+ParamStr('CIRWINNAME '+Str(i)));
        bNul(Voice(snd_Wheel));
        i:=MaxInt;
       end else i:=i+1;
      end;
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  WIKA_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  WIKA_INIT;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmd(devMySelf,'@LoadIni');
  cmd_MenuCloseConfirmation:=RegisterStdInCmd('@MenuCloseConfirmation','@MenuCloseConfirmation - for internal use');
  cmd_MenuToolsConfirmation:=RegisterStdInCmd('@MenuToolsConfirmation','@MenuToolsConfirmation - for internal use');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then DevPostCmd(devMySelf,'@SaveIni');
  WIKA_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  WIKA_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @MenuCloseConfirmation
   }
   if (cmdid=cmd_MenuCloseConfirmation) then begin
    if WIKA.MAIN.CMD.CLOSE.val>=0 then
    if EditState=0 then begin
    if Pos('?',Edit('(Вы действительно хотите:')
              +Edit(' ')
              +Edit(' '+arg)
              +Edit(' ')
              +Edit(' Эта операция может вызвать проблемы!')
              +Edit(')YesNo YesNo_'+NameTag(WIKA.MAIN.CMD.CLOSE.tag)))>0
     then Problem('Could not initialize dialog!');
    end else Problem('Could not initialize dialog!');
    Data:='';
   end else
   {
   @MenuToolsConfirmation
   }
   if (cmdid=cmd_MenuToolsConfirmation) then begin
    if WIKA.MAIN.CMD.TOOLS.val>=0 then
    if EditState=0 then begin
    if Pos('?',Edit('(Вы действительно хотите:')
              +Edit(' ')
              +Edit(' '+arg)
              +Edit(' ')
              +Edit(' Эта операция может вызвать проблемы!')
              +Edit(')YesNo YesNo_'+NameTag(WIKA.MAIN.CMD.TOOLS.tag)))>0
     then Problem('Could not initialize dialog!');
    end else Problem('Could not initialize dialog!');
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
