﻿---

[[toc]]

---

# Справка по VTRD

---

**[worksheet/](worksheet/)**
**[Вакууметр ВТ-РЦ01 РЭ](worksheet/вакууметр_вт-рц01_рэ.djvu)** - Руководство по эксплуатации

---

<b class="maroon">VTRD</b> - Вакуумметр терморезистивный цифровой **ВЦ-РЦ01**.

Драйвер разработан с использованием библиотеки **[NetLibrary](../../../../crwdaq/resource/daqsite/stdlib/include/_man_netlibrary.htm)** 
и использует 
клиент **[&ModbusProxy](../../../../crwdaq/resource/daqsite/modbusserver/modbusproxy.htm)** в 
котором реализован протокол приемо-передачи **[MODBUS](../../../../crwdaq/resource/tools/modbus/reference/)**.

Вакууметр является средством технологического контроля и предназначено для преобразования
абсолютного давления негорючих газов в диапазоне от 1&times;10^-2^ до 1&times;10^-5^ Па в электрический
цифровой сигнал в автоматизированных вакуумных системах приборов и установок промышленного,
экспериментального и учебного значения.

---

## Интерфейс передачи данных

Вакууметр предназначен для работы в сети передачи данных RS-485 со следующими параметрами:

- Адрес устройства настраиваемый в диапазоне от _1_ до _254_
 (по умолчанию установлен адрес _10_);
- Скорость передачи данных может иметь следующие значения: _9600, 19200, 38400, 57600_ бод/с
 (по умолчанию _19200_ бод/с);
- Контроль четности - настраиваемый и может иметь следующие значения: _none, even, odd_
 (по умолчанию установлен _none_);
- Количество бит данных - _8_;
- Количество стоповых бит - _1_.

---

## Установка скорости передачи данных и контроля четности

В таблице ниже приведены значения регистра 1000 для хранения параметров последовательного порта
в зависимости от скорости передачи данных и контроля четности.

|             | NONE | ODD | EVEN |
|-------------|------|-----|------|
| 9600 бод/с  | 0    | 8   | 16   |
| 19200 бод/с | 1    | 9   | 17   |
| 38400 бод/с | 2    | 10  | 18   |
| 57600 бод/с | 3    | 11  | 19   |

---

## Калибровка вакууметра

При замене преобразователя вакууметр следует откалибровать.

Калибровка производится в следующем порядке:

1. Откалибруйте верхний предел измерений на атмосферном давлении командой **`@PARAM.ATMCALIB`**.
   Предварительно необходимо дать прогреться корпусу преобразователя на атмосферном давлении
   в течение 10 минут;
2. Откалибруйте нижний предел измерений при давлении менее 0,01 Па коммандой **`@PARAM.ZEROCALIB`**.
   Предварительно необходимо дать прогреться корпусу преобразователя на атмосферном давлении
   в течение 10 минут;

При обрыве нити преобразователя или нарушении работы вакууметра значение давления устанавливается
в _101000_, во избежание ошибочного прочтения значений давления системой автоматического управления.

---

## Команды управления

``` ini
@PARAM.ZEROCALIB - Калибровка нижнего предела измерений
@PARAM.ATMCALIB  - Калибровка верхнего предела измерений
@PARAM.ADDRESS n - Установка адреса n вакууметра
@PARAM.SERIAL n  - Установка скорости передачи данных и контроля четности (см. таблицу)
```

---

> **VTRD** Copyright (c) 2023 DaqGroup daqgroup@mail.ru.  
> **CRW-DAQ** Copyright (c) 2001-2023 Alexey Kuryakin <daqgroup@mail.ru>.

---
