﻿---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

#Справка по Demo_UniHeater

**Demo_UniHeater** - демонстрационная конфигурация для иллюстрации использования системы
универсальных нагревателей **[UniHeater](../../../resource/daqsite/uniheater/uniheater.htm)**.

Это прототип для создания новых измерительных систем, использующих **[UniHeater](../../../resource/daqsite/uniheater/uniheater.htm)**,
а также систем со стандартным графическим интерфейсом и некоторым начальным набором часто используемых команд, кнопок и возможностей,
таких как сохранение параметров в **INI** файлах, данных в **DAT** файлах.

**Demo_UniHeater** также предназначен для генерации конфигурационных файлов для включения подсистемы **UniHeater** в прикладные системы.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

##  Документация по UniHeater

1. **[uniheater.htm](../../../resource/daqsite/uniheater/uniheater.htm)**,  
2. **[uniheater.pdf](../../../resource/daqsite/uniheater/uniheater.pdf)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Утилита uniheater_make.lm9

Для генерации новых конфигураций **UniHeater** (с разными параметрами) используется
графическая утилита **[uniheater_make.lm9](../../../resource/daqsite/uniheater/uniheater_make.lm9)**
по кнопке
   <img src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAAJxJREFUSEvNkUEOgCAMBH06T/Nn2ojZrCiUAhUme5BtYQ5uhzN/CXYHwsW/gm0Q8TVHgTBbcP38lgCDAKgl9y0CIdcgwCDgawnJmgToguQjB2+2COpZT/DpKPc8qhLwBQFlTb+G4E2555EusLKqQDXxpk3AyZGsSYBBwOQaBLQI1JJ7g8AUMFvQzySBcM/7iE99CwbyEMSDB86CEE6zIv3XqBcHJAAAAABJRU5ErkJggg=="/>.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Генерация Конфигурации UniHeater

Конфигурации **UniHeater** (_поскольку они могут содержать разное число каналов_) генерируются командными файлами.
Генерируется три вида конфигурации - локальная (**ctrl**), **DIM** сервер (**dis**) и клиент (**dic**).
При генерации задается обязательный префикс подсистемы (в данном случае используется префикс **DEMO**,
но вместо него можно задать другой), а также число каналов нагревателей.


В результате генерируются такие файлы:

| **Файл** | **Назначение**                                                                                                            |
|----------|---------------------------------------------------------------------------------------------------------------------------|
| **config/demo_uniheater_bind.cfg** | Специальный файл для привязки (bind) датчиков температуры и давления к подсистеме **UniHeater**. \
  Этот файл включается в конфигурацию локальной системы или **DIM** сервера (но не клиента) и служит для того, чтобы подключить к входам \ селекторов каналов (**&DEMO.UNIHEATER.SELECT_T**, **&DEMO.UNIHEATER.SELECT_P**) кривые датчиков температур и давлений. \
  Для каждой системы этот файл индивидуален, т.к. датчики могут быть разными. |
| **config/demo_uniheater_ctrl.cfg** | Файл конфигурации для локальной (не распределенной) подсистемы **UniHeater**. |
| **config/demo_uniheater_dis.cfg** | Файл конфигурации для **DIM** сервера распределенной подсистемы **UniHeater**. |
| **config/demo_uniheater_dic.cfg** | Файл конфигурации для **DIM** клиента распределенной подсистемы **UniHeater**. |
| **circuits/demo_uniheater_ctrl.crc** | Мнемосхема панели управления подсистемой **UniHeater**. |
| **circuits/demo_uniheater_settings.crc** | Мнемосхема панели настройки каналов **UniHeater**. |
| **bitmaps/demo_uniheater_ctrl.bmp** | Изображение основного поля для панели управления подсистемой **UniHeater**. |
| **bitmaps/demo_uniheater_settings.bmp** | Изображение основного поля панели настройки каналов **UniHeater**. |
| **config/demo_uniheater_init.cmd** | Вспомогательный командный файл, нужный для генератора конфигураций. \
        Он служит для задания основных параметров **UniHeater** - префикса, числа каналов  и т.д. \
        Должен вызываться из дочернего процесса **CRW-DAQ**. |
| **config/demo_uniheater_make.cmd** | Вспомогательный командный файл - генератор конфигураций для задания параметров **UniHeater**. \
        При его вызове генерируется конфигурация **UniHeater**, описанная в файле параметров (init). \
        Должен вызываться из дочернего процесса **CRW-DAQ**. |
| **config/demo_uniheater_zero.cmd** | Вспомогательный командный файл, нужный для удаления файлов конфигурации **UniHeater**. \
        Например, если надо удалить **UniHeater** из прикладной системы. |

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Соглашения UniHeater

Все теги имеют префикс  **DEMO.UNIHEATER**, например,  **DEMO.UNIHEATER.TREAL_i** - реальная (измеренная) температура канала.


Нагреватель с номером **i** (в диапазоне 1..32) включается кнопкой в теге **BT_i**.
Целевая температура стабилизации температуры задается в теге  **TGOAL_i**.
Для регулирования температуры используются кривые температуры **TREAL_i**
и давления **PREAL_i**, которые получаются на выходе селектора каналов,
использующего номера датчиков температуры **TNUM_i** и давления **PNUM_i**.

Для включения нагревателей используется сигнал меандра **DEMO.UNIHEATER.GATE_i**,
который обычно подается на твердотельное реле, а также сигнал блокировки  **BLK_i**.
Обычно инвертированный сигнал блокировки **<span style="text-decoration:overline">BLK_i</span>**
подается на нормальноразомкнутое электромагнитное реле охранной блокировки.
Это обеспечивает безопасное управление нагревом даже в случае пробоя твердотельного реле
или отключения питания электронного блока управления нагревом.

Для блокировок используются пороги верхнего значения температуры **TBLK_i** и давления **PBLK_i**,
сторожевой таймер **WDT_i**, сигнал внешней блокировки **EBLK_i**,
а также сигнал контроля качества датчика **ICTRL_i**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

> CRW-DAQ Copyright (c) 2001-2024 Alexey Kuryakin <daqgroup@mail.ru>.

---
