program HDT_CTRL;
const
 snd_Click   = 'Click'; { Sound on button click            }
 snd_Fails   = 'Fails'; { Sound on operation failure       }
 dfTrouble   = 1;       { DebugFlags - Trouble             }
 dfSuccess   = 2;       { DebugFlags - Success             }
 dfViewExp   = 4;       { DebugFlags - ViewExp             }
 dfViewImp   = 8;       { DebugFlags - ViewImp             }
 {
 Identify molecular peaks of chromatograph
 }
 hrHe        = 0;
 hrHH        = 1;
 hrHD        = 2;
 hrHT        = 3;
 hrDD        = 4;
 hrDT        = 5;
 hrTT        = 6;
 {
 Identify molecular peaks of ion camera
 }
 ioHT        = 0;
 ioDT        = 1;
 ioTT        = 2;
 {
 Identify isotopes
 }
 atHe        = 0;
 atHH        = 1;
 atDD        = 2;
 atTT        = 3;
 {
 Use abbreviations:
 Hrm -> chromatograph
 Ion -> ion camera
 Atm -> atomic,isotope
 Btn -> buttons
 Ind -> indicators
 S   -> square
 C   -> coefficient
 }
var
 b           : Boolean; { Temporary                        }
 Ok          : Boolean; { Program initialization is Ok?    }
 errors      : Integer; { Program error counter            }
 errorcode   : Integer; { Error code for this device       }
 fixmaxavail : Integer; { String manager leak control      }
 DebugFlags  : Integer; { Debug bit flags                  }
 i           : integer; { Temporary                        }
 j           : integer; { Temporary                        }
 s           : String;  { Temporary                        }
 winConsole  : String;  { Console window                   }
 winHdtCtrl  : String;  { Control window                   }
 tagHdtCtrl  : integer;
 tagCalcBtn  : integer;
 tagSaveBtn  : integer;
 tagSaveInd  : integer;
 tagClearBtn : integer;
 tagSHrmBtn  : array[hrHe..hrTT] of integer;
 tagSHrmInd  : array[hrHe..hrTT] of integer;
 tagSIonBtn  : array[ioHT..ioTT] of integer;
 tagSIonInd  : array[ioHT..ioTT] of integer;
 tagNIonBtn  : array[ioHT..ioTT] of integer;
 tagCHrmInd  : array[hrHe..hrTT] of integer;
 tagMConInd  : array[hrHe..hrTT] of integer;
 tagAConInd  : array[atHe..atTT] of integer;
 HrmName     : array[hrHe..hrTT] of string;
 IonName     : array[ioHT..ioTT] of string;
 Ion2Hrm     : array[ioHT..ioTT] of integer;
 IonCoef     : array[ioHT..ioTT] of real;
 Atm2Hrm     : array[atHe..atTT] of integer;
 AtmName     : array[atHe..atTT] of string;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Dialog with warning message
 }
 procedure Warning(msg:string);
 var b:boolean;
 begin
  if editstate=0 
  then msg:=edit('('+msg)+edit(')Warning')
  else b:=Echo(msg);
 end;
 {
 Initialize dialog to edit tag
 }
 procedure StartEditTag(tag:integer; Caption:string);
 var s:string;
 begin
  s:='';
  if typetag(tag)>0 then begin
   if editstate=0 then begin
    if typetag(tag)=1 then s:=str(iGetTag(tag)) else
    if typetag(tag)=2 then s:=str(rGetTag(tag)) else
    if typetag(tag)=3 then s:=sGetTag(tag) else s:='';
    if pos('?',edit('(Редактировать тег '+nametag(tag))
              +edit(' '+Caption+'|'+s)
              +edit(')StringGridEdit EDIT_TAG_'+nametag(tag)))>0
    then Warning('Error starting edit tag "'+nametag(tag)+'"!');
   end else Warning('Could not edit tag "'+nametag(tag)+'" right now!');
  end;
  s:='';
 end;
 {
 Check if tag editing done.
 }
 function CheckEditTag(tag:integer; minval,maxval:real):Boolean;
 var s,d:string; r:real; b:boolean;
 begin
  s:='';
  d:='';
  r:=0;
  CheckEditTag:=False;
  if editstate=1 then
  if typetag(tag)>0 then begin
   s:=edit('?ans 0');
   if extractword(1,s)='EDIT_TAG_'+nametag(tag) then begin
    if extractword(2,s)='1' then begin
     s:=edit('?ans 1');
     d:=worddelims('|');
     s:=extractword(2,s);
     d:=worddelims(d);
     if typetag(tag)=1 then begin
      r:=eval(s);
      if (r<minval) or (r>maxval) then r:=_nan;
      if not isnan(r) then begin
       b:=iSetTag(tag,round(r));
       CheckEditTag:=True;
      end;
     end;
     if typetag(tag)=2 then begin
      r:=eval(s);
      if (r<minval) or (r>maxval) then r:=_nan;
      if not isnan(r) then begin
       b:=rSetTag(tag,r);
       CheckEditTag:=True;
      end;
     end;
     if typetag(tag)=3 then begin
      b:=sSetTag(tag,s);
      CheckEditTag:=True;
     end;
    end;
    s:=edit('');
   end;
   if isnan(r) then Warning('Invalid input!')
  end;
  s:='';
  d:='';
 end;
 {
 Get string like 2006.09.21-00:12:30
 }
 function GetDateTime(ms:Real):String;
 var s:String;
 begin
  s:='';
  s:=Str(ms2sec(ms))+s;   while Length(s)<2  do s:='0'+s; s:=':'+s;
  s:=Str(ms2min(ms))+s;   while Length(s)<5  do s:='0'+s; s:=':'+s;
  s:=Str(ms2hour(ms))+s;  while Length(s)<8  do s:='0'+s; s:='-'+s;
  s:=Str(ms2day(ms))+s;   while Length(s)<11 do s:='0'+s; s:='.'+s;
  s:=Str(ms2month(ms))+s; while Length(s)<14 do s:='0'+s; s:='.'+s;
  s:=Str(ms2year(ms))+s;  while Length(s)<19 do s:='0'+s;
  GetDateTime:=s;
  s:='';
 end;
 {
 Calculate H/D/T
 }
 procedure CalcHandler;
 var
  i           : integer;
  Norm        : real;
  MainPeak    : integer;
  BaseHrm     : array[hrHe..hrTT] of real;
  RealHrm     : array[hrHe..hrTT] of real;
  HrmCoef     : array[hrHe..hrTT] of real;
  PercRealHrm : array[hrHe..hrTT] of real;
  PercNormHrm : array[hrHe..hrTT] of real;
  NormHrm     : array[hrHe..hrTT] of real;
  BaseIon     : array[ioHT..ioTT] of real;
  RealIon     : array[ioHT..ioTT] of real;
  AtomHrm     : array[atHe..atTT] of real;
 begin
  {
  Move tags to array for simplicity, find MainPeak uses for normalization procedure
  }
  for i:=hrHe to hrTT do begin
   BaseHrm[i]:=rGetTag(tagSHrmInd[i]);
   HrmCoef[i]:=rGetTag(tagCHrmInd[i]);
  end;
  MainPeak:=-1;
  for i:=ioHT to ioTT do begin
   BaseIon[i]:=rGetTag(tagSIonInd[i]);
   if iGetTag(tagNIonBtn[i])>0 then MainPeak:=i;
  end;
  {
  Divide by sensitivity coefficients to calculate REAL peak square of chromatograph and ion camera
  }
  for i:=hrHe to hrTT do RealHrm[i] := BaseHrm[i]/HrmCoef[i];
  for i:=ioHT to ioTT do RealIon[i] := BaseIon[i]/IonCoef[i];
  {
  Calculate chromatography peaks in percents
  Assume that He+HH+HD+HT+DD+DT+TT = 100 % (no another gas in composition)
  }
  Norm:=0;
  for i:=hrHe to hrTT do Norm:=Norm+RealHrm[i];
  for i:=hrHe to hrTT do PercRealHrm[i]:=(RealHrm[i]/Norm)*100;
  {
  Normalization procedure: use ion camera peaks to correct chromatography peaks
  }
  for i:=hrHe to hrTT do NormHrm[i]:=RealHrm[i];
  if (MainPeak>=ioHT) and (MainPeak<=ioTT) then
  for i:=ioHT to ioTT do
  NormHrm[Ion2Hrm[i]]:=RealHrm[Ion2Hrm[MainPeak]]*RealIon[i]/RealIon[MainPeak];
  {
  Calculate corrected chromatography peaks in percents
  }
  Norm:=0;
  for i:=hrHe to hrTT do Norm:=Norm+NormHrm[i];
  for i:=hrHe to hrTT do PercNormHrm[i]:=(NormHrm[i]/Norm)*100;
  {
  Calculate isotopes
  }
  AtomHrm[atHe]:=PercNormHrm[hrHe];
  AtomHrm[atHH]:=PercNormHrm[hrHH]+0.5*(PercNormHrm[hrHD]+PercNormHrm[hrHT]);
  AtomHrm[atDD]:=PercNormHrm[hrDD]+0.5*(PercNormHrm[hrHD]+PercNormHrm[hrDT]);
  AtomHrm[atTT]:=PercNormHrm[hrTT]+0.5*(PercNormHrm[hrHT]+PercNormHrm[hrDT]);
  {
  Save result to tags
  }
  for i:=hrHe to hrTT do b:=rSetTag(tagMConInd[i],PercNormHrm[i]);
  for i:=atHe to atTT do b:=rSetTag(tagAConInd[i],AtomHrm[i]);
 end;
 {
 Save result to file
 }
 procedure SaveHandler;
 const
  w1=20; w2=20; w3=12; d3=4; w4=12; d4=4; w5=5; d5=2;
 var
  i     : integer;
  n     : integer;
  t     : real;
  fname : string;
  Main  : integer;
 begin
  {
  Calculate current date/time
  }
  t:=msecnow;
  b:=rSetTag(tagSaveInd,(ms2year(t)*100+ms2month(t))*100+ms2day(t));
  {
  Calculate file name 
  }
  fname:=paramstr('DAQDATAPATH')+'\'+Str(rGetTag(tagSaveInd))+'.HDT';
  {
  Save result to file and to console window too
  }
  for n:=0 to 1 do begin
   if fileexists(fname) then i:=append(fname) else i:=rewrite(fname);
   if i=0 then begin
    writeln('');
    writeln('****************************************************************************');
    writeln('H/D/T composition chromatography analysis done at '+GetDateTime(t));
    writeln('  ',' ','S peak,chromatograph'        :w1,
                 ' ','S peak,ion camera'           :w2,
                 ' ','Molecular,%'                 :w3,
                 ' ','Isotope,%'                   :w4,
                 ' ','КОЧ'                         );
    writeln('He',' ',str(rGetTag(tagSHrmInd[hrHe])):w1,
                 ' ','-'                           :w2,
                 ' ',    rGetTag(tagMConInd[hrHe]) :w3:d3,
                 ' ',    rGetTag(tagAConInd[atHe]) :w4:d4,
                 ' ',    rGetTag(tagCHrmInd[hrHe]) :w5:d5);
    writeln('H2',' ',str(rGetTag(tagSHrmInd[hrHH])):w1,
                 ' ','-'                           :w2,
                 ' ',    rGetTag(tagMConInd[hrHH]) :w3:d3,
                 ' ',    rGetTag(tagAConInd[atHH]) :w4:d4,
                 ' ',    rGetTag(tagCHrmInd[hrHH]) :w5:d5);
    writeln('HD',' ',str(rGetTag(tagSHrmInd[hrHD])):w1,
                 ' ','-'                           :w2,
                 ' ',    rGetTag(tagMConInd[hrHD]) :w3:d3,
                 ' ','-'                           :w4,
                 ' ',    rGetTag(tagCHrmInd[hrHD]) :w5:d5);
    writeln('HT',' ',str(rGetTag(tagSHrmInd[hrHT])):w1,
                 ' ',str(rGetTag(tagSIonInd[ioHT])):w2,
                 ' ',    rGetTag(tagMConInd[hrHT]) :w3:d3,
                 ' ','-'                           :w4,
                 ' ',    rGetTag(tagCHrmInd[hrHT]) :w5:d5);
    writeln('D2',' ',str(rGetTag(tagSHrmInd[hrDD])):w1,
                 ' ','-'                           :w2,
                 ' ',    rGetTag(tagMConInd[hrDD]) :w3:d3,
                 ' ',    rGetTag(tagAConInd[atDD]) :w4:d4,
                 ' ',    rGetTag(tagCHrmInd[hrDD]) :w5:d5);
    writeln('DT',' ',str(rGetTag(tagSHrmInd[hrDT])):w1,
                 ' ',str(rGetTag(tagSIonInd[ioDT])):w2,
                 ' ',    rGetTag(tagMConInd[hrDT]) :w3:d3,
                 ' ','-'                           :w4,
                 ' ',    rGetTag(tagCHrmInd[hrDT]) :w5:d5);
    writeln('T2',' ',str(rGetTag(tagSHrmInd[hrTT])):w1,
                 ' ',str(rGetTag(tagSIonInd[ioTT])):w2,
                 ' ',    rGetTag(tagMConInd[hrTT]) :w3:d3,
                 ' ',    rGetTag(tagAConInd[atTT]) :w4:d4,
                 ' ',    rGetTag(tagCHrmInd[hrTT]) :w5:d5);
    Main:=-1;
    for i:=ioHT to ioTT do if iGetTag(tagNIonBtn[i])>0 then Main:=i;
    if Main=ioHT then writeln('Normalization : peak HT') else
    if Main=ioDT then writeln('Normalization : peak DT') else
    if Main=ioTT then writeln('Normalization : peak T2') else writeln('Normalization : not used');
    writeln('****************************************************************************');
    writeln('');
    if ioresult<>0 then b:=fixerror(errorcode);
    {if rewrite('')<>0 then b:=fixerror(errorcode);}
   end else begin
    b:=fixerror(errorcode);
   end;
   if FileExists(fname) then begin
    i:=task_init(GetComSpec+' /c start notepad.exe '+fname);
    b:=task_run(i);
    b:=task_wait(i,1000);
    b:=task_free(i);
   end;
   fname:='';
  end;
  fname:='';
 end;
 {
 Clear all tags
 }
 procedure ClearHandler;
 begin
  b:=iSetTag(tagCalcBtn,0);
  b:=iSetTag(tagSaveBtn,0);
  b:=rSetTag(tagSaveInd,0);
  b:=iSetTag(tagClearBtn,0);
  for i:=hrHe to hrTT do begin
   b:=iSetTag(tagSHrmBtn[i],0);
   b:=rSetTag(tagSHrmInd[i],0);
   b:=rSetTag(tagMConInd[i],0);
  end;
  for i:=ioHT to ioTT do begin
   b:=iSetTag(tagSIonBtn[i],0);
   b:=rSetTag(tagSIonInd[i],0);
   b:=iSetTag(tagNIonBtn[i],0);
  end; 
  for i:=atHe to atTT do begin
   b:=rSetTag(tagAConInd[i],0);
  end; 
 end;
 {
 Handle tagSHrmBtn[],tagSIonBtn[] click
 }
 procedure HandleSHrmIonBtn(tagBtn,tagInd:Integer);
 var t,v:Real; b:Boolean;
 begin
  b:=voice(snd_Click);
  if iGetTag(tagBtn)>0 then v:=0 else begin
   v:=global('int_mean');
   if isNan(v) then begin
    b:=winhide(winHdtCtrl);
    t:=eval('@async @async @menu run FormDaqControlDialog.ActionDaqIntegral');
    t:=msecnow;
    while (msecnow-t<1000) and IsNan(global('int_mean')) do b:=Sleep(10);
    b:=winshow(winHdtCtrl);
    v:=global('int_mean');
   end;
   t:=global('int_mean=_nan');
  end;
  if not isNan(v) then begin
   b:=rSetTag(tagInd,v);
   b:=iSetTag(tagBtn,ord(iGetTag(tagBtn)=0));
  end;
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 var i:Integer;
 begin
  s:='';
  winConsole:='';
  winHdtCtrl:='';
  for i:=hrHe to hrTT do HrmName[i]:='';
  for i:=ioHT to ioTT do IonName[i]:='';
  for i:=atHe to atTT do AtmName[i]:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ)
  then Trouble('Could not init tag: '+name);
 end;
begin
 {
 Start actions
 }
 if runcount=1 then begin
  {
  Initialize errors...
  }
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  if rewrite('')<>0 then Trouble('Rewrite error!');
  if reset('')<>0 then Trouble('Reset error!');
  DebugFlags:=val(ReadIni('DebugFlags'));
  Success('Initialization:');
  {
  Initialize constant arrays
  }
  HrmName[hrHe]:='He';
  HrmName[hrHH]:='HH';
  HrmName[hrHD]:='HD';
  HrmName[hrHT]:='HT';
  HrmName[hrDD]:='DD';
  HrmName[hrDT]:='DT';
  HrmName[hrTT]:='TT';
  IonName[ioHT]:='HT';
  IonName[ioDT]:='DT';
  IonName[ioTT]:='TT';
  AtmName[atHe]:='He';
  AtmName[atHH]:='HH';
  AtmName[atDD]:='DD';
  AtmName[atTT]:='TT';
  Ion2Hrm[ioHT]:=hrHT;
  Ion2Hrm[ioDT]:=hrDT;
  Ion2Hrm[ioTT]:=hrTT;
  IonCoef[ioHT]:=0.5;
  IonCoef[ioDT]:=0.5;
  IonCoef[ioTT]:=1.0;
  Atm2Hrm[atHe]:=hrHe;
  Atm2Hrm[atHH]:=hrHH;
  Atm2Hrm[atDD]:=hrDD;
  Atm2Hrm[atTT]:=hrTT;
  {
  read & check tags
  }
  InitTag( tagHdtCtrl,   'HDT.MainWin',   3);
  InitTag( tagCalcBtn,   'HDT.CALC.BTN',  1);
  InitTag( tagSaveBtn,   'HDT.SAVE.BTN',  1);
  InitTag( tagSaveInd,   'HDT.SAVE.IND',  2);
  InitTag( tagClearBtn,  'HDT.CLEAR.BTN', 1);
  for i:=hrHe to hrTT do begin
   InitTag( tagSHrmBtn[i],  'HDT.'+HrmName[i]+'.SHRM.BTN', 1);
   InitTag( tagSHrmInd[i],  'HDT.'+HrmName[i]+'.SHRM.IND', 2);
   InitTag( tagCHrmInd[i],  'HDT.'+HrmName[i]+'.CHRM.IND', 2);
   InitTag( tagMConInd[i],  'HDT.'+HrmName[i]+'.MCON.IND', 2);
  end;
  for i:=ioHT to ioTT do begin
   InitTag( tagSIonBtn[i],  'HDT.'+IonName[i]+'.SION.BTN', 1);
   InitTag( tagSIonInd[i],  'HDT.'+IonName[i]+'.SION.IND', 2);
   InitTag( tagNIonBtn[i],  'HDT.'+IonName[i]+'.NION.BTN', 1);
  end; 
  for i:=atHe to atTT do begin
   InitTag( tagAConInd[i],  'HDT.'+AtmName[i]+'.ACON.IND', 2);
  end;
  ClearHandler;
  {
  Open control window...
  }
  winHdtCtrl:=sGetTag(tagHdtCtrl);
  b:=winshow(winHdtCtrl);
  b:=windraw(winHdtCtrl+'|top=0|left=167|Width=525|Height=317');
  b:=windraw(winHdtCtrl+'|Options=-Min,-Max,-Close,-Width,-Height,-HScroll,-VScroll');
  b:=winselect(winHdtCtrl);
  {
  Open console window...
  }
  if val(ReadIni('OpenConsole'))>0 then begin
   winConsole:=ParamStr('Console '+devname);
   b:=winshow(winConsole);
   b:=windraw(winConsole+'|top=317|left=0|Width=692|Height=317');
   b:=winselect(winConsole);
   if val(ReadIni('OpenConsole'))>1 then b:=winhide(winConsole);
  end;
  b:=windraw(ParamStr('MainConsole')+'|top=0|left=692');
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Stop actions
 }
 if isinf(runcount) then begin
  if rewrite('')<>0 then Trouble('Rewrite error!');
  if reset('')<>0 then Trouble('Reset error!');
  ClearStrings;
  ClearHandler;
 end else 
 {
 Main loop actions
 }
 if Ok then begin
  {
  Edit tags...
  }
  if editstate=1 then begin
   for i:=hrHe to hrTT do
   if CheckEditTag(tagSHrmInd[i],0,_PlusInf)
   then b:=iSetTag(tagSHrmBtn[i],1);
   for i:=ioHT to ioTT do
   if CheckEditTag(tagSIonInd[i],0,_PlusInf)
   then b:=iSetTag(tagSIonBtn[i],1);
  end;
  if editstate=1 then begin
   writeln('Unknown tag edition!');
   s:=edit('');
  end;
  if iand(editstate,9)<>0 then begin
   writeln('Dialog error detected!');
   s:=edit('');
  end;
  {
  Action on CALC click
  }
  if iGetTag(tagCalcBtn)>0 then begin
   b:=iSetTag(tagCalcBtn,0);
   CalcHandler;
  end;
  {
  Action on SAVE click
  }
  if iGetTag(tagSaveBtn)>0 then begin
   b:=iSetTag(tagSaveBtn,0);
   SaveHandler;
  end;
  {
  Action on CLEAR click
  }
  if iGetTag(tagClearBtn)>0 then begin
   b:=iSetTag(tagClearBtn,0);
   ClearHandler;
  end;
  {
  User interface handling
  }
  if clickbutton=1 then begin
   {
   Edit tags HDT.xx.SHRM.IND, xx=He,HH,HD,HT,DD,DT,TT...
   }
   for i:=hrHe to hrTT do
   if clicktag=tagSHrmInd[i]
   then StartEditTag(clicktag,'Площадь пика '+HrmName[i]+' катарометра');
   {
   Edit tags HDT.xx.SION.IND, xx=HT,DT,TT...
   }
   for i:=ioHT to ioTT do
   if clicktag=tagSIonInd[i]
   then StartEditTag(clicktag,'Площадь пика '+IonName[i]+' ионизационной камеры');
   {
   Click CALC,SAVE,CLEAR...
   }
   if (clicktag=tagCalcBtn)
   or (clicktag=tagSaveBtn)
   or (clicktag=tagClearBtn)
   then begin
    b:=iSetTag(clicktag,ord(iGetTag(clicktag)=0));
    b:=voice(snd_Click);
   end;
   {
   Click HDT.xx.SHRM.BTN, xx=He,HH,HD,HT,DD,DT,TT
   }
   for i:=hrHe to hrTT do
   if clicktag=tagSHrmBtn[i]
   then HandleSHrmIonBtn(tagSHrmBtn[i],tagSHrmInd[i]);
   {
   Click HDT.xx.SION.BTN, xx=HT,DT,TT
   }
   for i:=ioHT to ioTT do
   if clicktag=tagSIonBtn[i]
   then HandleSHrmIonBtn(tagSIonBtn[i],tagSIonInd[i]);
   {
   Click HDT.xx.NION.BTN, xx=HT,DT,TT
   }
   for i:=ioHT to ioTT do
   if clicktag=tagNIonBtn[i] then begin
    for j:=ioHT to ioTT do if i<>j then b:=iSetTag(tagNIonBtn[j],0);
    b:=iSetTag(clicktag,ord(iGetTag(clicktag)=0));
    b:=voice(snd_Click);
   end;
   {
   Click help
   }
   if IsSameText(ClickSensor,'HDT.HELP.BTN') then begin
    s:=AdaptFileName(ReadIni('HelpFile'));
    if Length(s)>0 then begin
     b:=Eval('@system @async @silent @getapppath '
       +AdaptFileName('firefox.exe')+' -a .htm --run '
       +DaqFileRef(s,'.htm'))>0;
     end;
    b:=voice(snd_Click);
   end;
  end;
 end;
end.
