 {
 ***********************************************************************
 SPVZK - main GUI program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Cmd.LoadIni           - Load tags from custom INI file.
| @Cmd.SaveIni           - Save tags to   custom INI file.
| @MenuCloseConfirmation - for internal use
| @DevMsg  &d m          - Send message m to device &d.
| @DevSend &d m          - Send message m to device &d.
|********************************************************
[]
 }
program spvzk_main_gui;          { SPVZK main GUI program           }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod       = 1000;       { Polling period for smile face    }
 AwakePeriod       = 100;        { Period of checks to awake DatSrv }
 NumChans          = 4;          { Number of F740/encoder channels  }
 ai_Encoders       = 0;          { AI base for encoders             }

type
 TTagRef           = record tag,nai,ndi,nao,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 SPVZK             : record      { All SPVZK data                   }
  CMD              : record      { CoMmandDs to control SPVZK GUI   }
   HELP            : TTagRef;    { Open Help                        }
   HOME            : TTagRef;    { Home all windows                 }
   OPEN            : TTagRef;    { Open DAT file(s)                 }
   SAVE            : TTagRef;    { Save DAT file(s)                 }
   SOUND           : TTagRef;    { Sound                            }
   TOOLS           : TTagRef;    { Tools menu                       }
   SMILE           : TTagRef;    { Smile menu                       }
   CLOSE           : TTagRef;    { Close DAQ/CRW/WIN                }
  end;                           {                                  }
  F740             : array[1..NumChans] of record { F740 devices    }
   devDrv          : Integer;    { Driver device reference          }
  end;                           {                                  }
  Encoder          : array[1..NumChans] of record { Encoders        }
   ZCN             : TTagRef;    { Zero encoder counter             }
   ZBT             : TTagRef;    { Zero encoder button              }
   ZMM             : TTagRef;    { Zero mm                          }
  end;
  DatSrvGate       : TTagRef;    { Save data to DatSrv              }
 end;                            {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Speak, i.e. send message to speech server.
 }
 procedure Speaker(msg:String);
 begin
  if iGetTag(SPVZK.CMD.SOUND.tag)>0 then Speak(msg);
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then begin
   UnixTooltipNotifier('text "'+s+'" ico information.ico delay 15000');
   if Pos(':',s)>0 then s:=Trim(Copy(s,Pos(':',s)+1));
   Speaker(s);
  end;
 end;
 {
 Get text of Close menu items
 }
 function MenuCloseItem(MenuClose:Integer):String;
 begin
  if MenuClose=0 then MenuCloseItem:='Завершить пакет CRW-DAQ' else
  if MenuClose=1 then MenuCloseItem:='Завершить     сеанс DAQ' else
  if MenuClose=2 then MenuCloseItem:='Перезагрузить сеанс DAQ' else
  if MenuClose=3 then MenuCloseItem:='Рестарт сервера '+DatSrv else
  if MenuClose=4 then MenuCloseItem:='Рестарт сервера '+CronSrv else
  if MenuClose=5 then MenuCloseItem:='Завершить сеанс Windows' else
  if MenuClose=6 then MenuCloseItem:='Перезагрузить компьютер' else
  if MenuClose=7 then MenuCloseItem:='Выключить     компьютер' else
  MenuCloseItem:='';
 end;
 {
 Execute Close menu commands
 }
 procedure MenuCloseCmnd(MenuClose:Integer);
 begin
  if MenuClose=0  then Cron('@Shutdown Crw Exit');
  if MenuClose=1  then Cron('@Shutdown Daq Exit');
  if MenuClose=2  then Cron('@Shutdown Daq Restart');
  if MenuClose=3  then Cron('@Eval @System @Async @Daq Compile '+DatSrv);
  if MenuClose=4  then Cron('@Eval @System @Async @Daq Compile '+CronSrv);
  if MenuClose=5  then Cron('@Shutdown Win Logout');
  if MenuClose=6  then Cron('@Shutdown Win Restart');
  if MenuClose=7  then Cron('@Shutdown Win Exit');
 end;
 {
 Get text of Tools menu items
 }
 function MenuToolsItem(MenuTools:Integer):String;
 begin
  if MenuTools=0  then MenuToolsItem:='Загрузить настройки из INI файла: @Cmd.LoadIni' else
  if MenuTools=1  then MenuToolsItem:='Сохранить настройки в  INI файле: @Cmd.SaveIni' else
  if MenuTools=2  then MenuToolsItem:='Сбросить энкодер B1 (Пер.Вер.)  : @DevSend &SPVZK.I7083.1.DRV @Preset 0 0'  else
  if MenuTools=3  then MenuToolsItem:='Сбросить энкодер B2 (Зад.Вер.)  : @DevSend &SPVZK.I7083.1.DRV @Preset 1 0'  else
  if MenuTools=4  then MenuToolsItem:='Сбросить энкодер B3 (Пер.Гор.)  : @DevSend &SPVZK.I7083.2.DRV @Preset 0 0'  else
  if MenuTools=5  then MenuToolsItem:='Сбросить энкодер B4 (Зад.Гор.)  : @DevSend &SPVZK.I7083.2.DRV @Preset 1 0'  else
  if MenuTools=6  then MenuToolsItem:='Задать режим --- B1 (Пер.Вер.)  : @DevSend &SPVZK.I7083.1.DRV @OpMode 0 $B' else
  if MenuTools=7  then MenuToolsItem:='Задать режим --- B2 (Зад.Вер.)  : @DevSend &SPVZK.I7083.1.DRV @OpMode 1 $B' else
  if MenuTools=8  then MenuToolsItem:='Задать режим --- B3 (Пер.Гор.)  : @DevSend &SPVZK.I7083.2.DRV @OpMode 0 $B' else
  if MenuTools=9  then MenuToolsItem:='Задать режим --- B4 (Зад.Гор.)  : @DevSend &SPVZK.I7083.2.DRV @OpMode 1 $B' else
  if MenuTools=10 then MenuToolsItem:='Открыть окно диагностики        : @DevSend &CRONSRV @WinShow SPVZK.MAIN.GUI' else
  MenuToolsItem:='';
 end;
 {
 Execute Tools menu commands
 }
 procedure MenuToolsCmnd(MenuTools:String);
 var p:Integer;
 begin
  p:=Pos(Dump('@'),MenuTools);
  if p>0 then DevSendCmd(devMySelf,Copy(MenuTools,p));
 end;
 {
 SPVZK initialization
 }
 procedure SPVZK_INIT;
 var i:Integer;
 begin
  {
  Initialize tags...
  }
  InitTag(SPVZK.DatSrvGate.tag,  'DATSRV.GATE',                         1);
  InitTag(SPVZK.CMD.HELP.tag,     ReadIni('tagSPVZK')+'.CMD.HELP',      1);
  InitTag(SPVZK.CMD.HOME.tag,     ReadIni('tagSPVZK')+'.CMD.HOME',      1);
  InitTag(SPVZK.CMD.OPEN.tag,     ReadIni('tagSPVZK')+'.CMD.OPEN',      1);
  InitTag(SPVZK.CMD.SAVE.tag,     ReadIni('tagSPVZK')+'.CMD.SAVE',      1);
  InitTag(SPVZK.CMD.SOUND.tag,    ReadIni('tagSPVZK')+'.CMD.SOUND',     1);
  InitTag(SPVZK.CMD.TOOLS.tag,    ReadIni('tagSPVZK')+'.CMD.TOOLS',     1);
  InitTag(SPVZK.CMD.SMILE.tag,    ReadIni('tagSPVZK')+'.CMD.SMILE',     1);
  InitTag(SPVZK.CMD.CLOSE.tag,    ReadIni('tagSPVZK')+'.CMD.CLOSE',     1);
  for i:=1 to NumChans do begin
   InitDevice(SPVZK.F740[i].devDrv, ReadIni('devF740.'+Str(i)+'.Drv'),  1);
  end;
  for i:=1 to NumChans do begin
   InitTag(SPVZK.Encoder[i].ZCN.tag, ReadIni('tagSPVZK')+'.ENCODER.B'+Str(i)+'.ZCN', 2);
   InitTag(SPVZK.Encoder[i].ZBT.tag, ReadIni('tagSPVZK')+'.ENCODER.B'+Str(i)+'.ZBT', 1);
   InitTag(SPVZK.Encoder[i].ZMM.tag, ReadIni('tagSPVZK')+'.ENCODER.B'+Str(i)+'.ZMM', 2);
  end;
  {
  Initialize values
  }
  SPVZK.CMD.CLOSE.val:=-1;
  SPVZK.CMD.TOOLS.val:=-1;
  SPVZK.CMD.SMILE.val:=GetErrCount(-2);
  {
  Load custom INI file tags on start
  }
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRW('R','',2));
 end;
 {
 SPVZK finalization
 }
 procedure SPVZK_FREE;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
 end;
 {
 SPVZK polling
 }
 procedure SPVZK_POLL;
 var errors,v:Real; i,ClickCurve:Integer;
 begin
  {
  Awake DatSrv to enforce data save.
  }
  if SysTimer_Pulse(AwakePeriod)>0 then begin
   bNul(iSetTag(SPVZK.DatSrvGate.tag,Ord(iGetTag(SPVZK.CMD.SAVE.tag)<>0)));
  end;
  {
  Execute GUI commands.
  }
  if iGetTag(SPVZK.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
   bNul(iSetTag(SPVZK.CMD.HELP.tag,0));
  end;
  if iGetTag(SPVZK.CMD.HOME.tag)<>0 then begin
   Cron('@cron.run SPVZK.MAIN.GUI.HOME');
   bNul(iSetTag(SPVZK.CMD.HOME.tag,0));
  end;
  if iGetTag(SPVZK.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '+
    URL_Packed(AddBackSlash(DaqFileRef(AdaptFileName(ReadIni('['+DatSrv+'] DataPath')),''))+'*.dat;*.crw'));
   bNul(iSetTag(SPVZK.CMD.OPEN.tag,0));
  end;
  if iGetTag(SPVZK.CMD.TOOLS.tag)<>0 then begin
   if EditState=0 then begin
    if Pos('?',Edit('(Вызвать утилиту...')
              +Edit(' Что выбираете:')
              +Edit(' '+MenuToolsItem(0))
              +Edit(' '+MenuToolsItem(1))
              +Edit(' '+MenuToolsItem(2))
              +Edit(' '+MenuToolsItem(3))
              +Edit(' '+MenuToolsItem(4))
              +Edit(' '+MenuToolsItem(5))
              +Edit(' '+MenuToolsItem(6))
              +Edit(' '+MenuToolsItem(7))
              +Edit(' '+MenuToolsItem(8))
              +Edit(' '+MenuToolsItem(9))
              +Edit(' '+MenuToolsItem(10))
              +Edit(')MenuList MENU_'+NameTag(SPVZK.CMD.TOOLS.tag)))>0
    then Warning('Error initializing MenuList!');
   end else Warning('Cannot edit right now!');
   bNul(iSetTag(SPVZK.CMD.TOOLS.tag,0));
  end;
  if iGetTag(SPVZK.CMD.CLOSE.tag)<>0 then begin
   if EditState=0 then begin
    if Pos('?',Edit('(Команда "Закрыть"... ')
              +Edit(' Что выбираете:')
              +Edit(' '+MenuCloseItem(0))
              +Edit(' '+MenuCloseItem(1))
              +Edit(' '+MenuCloseItem(2))
              +Edit(' '+MenuCloseItem(3))
              +Edit(' '+MenuCloseItem(4))
              +Edit(' '+MenuCloseItem(5))
              +Edit(' '+MenuCloseItem(6))
              +Edit(' '+MenuCloseItem(7))
              +Edit(')MenuList MENU_'+NameTag(SPVZK.CMD.CLOSE.tag)))>0
    then Warning('Error initializing MenuList!');
   end else Warning('Cannot edit right now!');
   bNul(iSetTag(SPVZK.CMD.CLOSE.tag,0));
   SPVZK.CMD.CLOSE.val:=-1;
  end;
  for i:=1 to NumChans do begin
   if iGetTag(SPVZK.Encoder[i].ZBT.tag)<>0 then begin
    bNul(rSetTag(SPVZK.Encoder[i].ZCN.tag,Round(GetAi_Yn(ai_Encoders+i-1))));
    bNul(iSetTag(SPVZK.Encoder[i].ZBT.tag,0));
   end;
   if rGetTag(SPVZK.Encoder[i].ZMM.tag)<>0 then begin
    v:=rGetTag(SPVZK.Encoder[i].ZMM.tag)*100000/(Calibr(i-1,100000,0)-Calibr(i-1,0,0));
    bNul(rSetTag(SPVZK.Encoder[i].ZCN.tag,Round(rGetTag(SPVZK.Encoder[i].ZCN.tag)+v)));
    bNul(rSetTag(SPVZK.Encoder[i].ZMM.tag,0));
   end;
   if Frac(rGetTag(SPVZK.Encoder[i].ZCN.tag))>0 then begin
    bNul(rSetTag(SPVZK.Encoder[i].ZCN.tag,Round(rGetTag(SPVZK.Encoder[i].ZCN.tag))));
   end;
  end;
  {
  Handle Smile
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   errors:=GetErrCount(-2);
   if errors>SPVZK.CMD.SMILE.val then bNul(iSetTag(SPVZK.CMD.SMILE.tag,2)) else
   if iGetTag(SPVZK.CMD.SMILE.tag)>1 then bNul(iSetTag(SPVZK.CMD.SMILE.tag,1));
   SPVZK.CMD.SMILE.val:=errors;
  end;
  {
  Edit tags...
  }
  if EditState=ef_Done then begin
   {
   Warning.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Warning') then begin
    sNul(Edit(''));
   end;
   {
   Information.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Information') then begin
    sNul(Edit(''));
   end;
   {
   TOOLS menu.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(SPVZK.CMD.TOOLS.tag)) then begin
    if Val(ExtractWord(2,edit('?ans 0')))=1 then begin
     MenuToolsCmnd(MenuToolsItem(Val(Edit('?ans 1'))));
    end;
    sNul(Edit(''));
   end;
   {
   CLOSE menu.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(SPVZK.CMD.CLOSE.tag)) then begin
    if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
     SPVZK.CMD.CLOSE.val:=Val(Edit('?ans 1'));
     if SPVZK.CMD.CLOSE.val>=0 then
     if (SPVZK.CMD.CLOSE.val>2) then begin
      DevSendCmd(devMySelf,'@MenuCloseConfirmation '+UpCaseStr(StrReplace(StrReplace(
                  MenuCloseItem(Round(SPVZK.CMD.CLOSE.val)),'  ',Dump(' '),3),'  ',Dump(' '),3)));
     end else begin
      MenuCloseCmnd(Round(SPVZK.CMD.CLOSE.val));
      SPVZK.CMD.CLOSE.val:=-1;
     end;
    end;
    sNul(Edit(''));
   end;
   {
   CLOSE menu (after confirmation).
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'YesNo_'+NameTag(SPVZK.CMD.CLOSE.tag)) then begin
    if SPVZK.CMD.CLOSE.val>=0 then
    if Val(ExtractWord(2,Edit('?ans 0')))=6 then MenuCloseCmnd(Round(SPVZK.CMD.CLOSE.val));
    SPVZK.CMD.CLOSE.val:=-1;
    sNul(Edit(''));
   end;
   {
   Accept tag edit
   }
   for i:=1 to NumChans do begin
    CheckEditTagUpdate(SPVZK.Encoder[i].ZCN.tag,_MinusInf,_PlusInf);
    CheckEditTagUpdate(SPVZK.Encoder[i].ZMM.tag,_MinusInf,_PlusInf);
   end;
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
  {
  Handle left button clicks...
  }
  if ClickButton=1 then begin
   {
   Toolbar buttons
   }
   ClickBitXorLocal(SPVZK.CMD.HELP.tag,1);
   ClickBitXorLocal(SPVZK.CMD.HOME.tag,1);
   ClickBitXorLocal(SPVZK.CMD.OPEN.tag,1);
   ClickBitXorLocal(SPVZK.CMD.SAVE.tag,1);
   ClickBitXorLocal(SPVZK.CMD.SOUND.tag,1);
   ClickBitXorLocal(SPVZK.CMD.TOOLS.tag,1);
   ClickBitXorLocal(SPVZK.CMD.CLOSE.tag,1);
   if ClickTag=SPVZK.CMD.SAVE.tag then DevSendCmd(devDatSrv,'  ');
   for i:=1 to NumChans do ClickBitXorLocal(SPVZK.Encoder[i].ZBT.tag,1);
   {
   Smile face button...
   }
   if ClickTag=SPVZK.CMD.SMILE.tag then begin
    bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
    bNul(iSetTag(SPVZK.CMD.SMILE.tag,0));
    bNul(Voice(snd_Click));
   end;
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then begin
    iNul(WinSelectByCurve(ClickCurve,ClickCurve));
    bNul(Voice(snd_Wheel));
   end;
   {
   Start edit tags
   }
   for i:=1 to NumChans do begin
    if ClickTag=SPVZK.Encoder[i].ZCN.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=SPVZK.Encoder[i].ZMM.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
   end;
  end;
  {
  Handle right button clicks...
  }
  if ClickButton=2 then begin
   SensorHelp(Url_Decode(ClickParams('Hint')));
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  SPVZK_INIT;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  SPVZK_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  SPVZK_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i,n:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Cmd.LoadIni
   }
   if IsSameText(cmd,'@Cmd.LoadIni') then begin
    iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @Cmd.SaveIni
   }
   if IsSameText(cmd,'@Cmd.SaveIni') then begin
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @MenuCloseConfirmation
   }
   if IsSameText(cmd,'@MenuCloseConfirmation') then begin
    if SPVZK.CMD.CLOSE.val>=0 then
    if EditState=0 then begin
    if Pos('?',Edit('(Вы действительно хотите:')
              +Edit(' ')
              +Edit(' '+arg)
              +Edit(' ')
              +Edit(' Эта операция может вызвать проблемы!')
              +Edit(')YesNo YesNo_'+NameTag(SPVZK.CMD.CLOSE.tag)))>0
     then Problem('Could not initialize dialog!');
    end else Problem('Could not initialize dialog!');
    Data:='';
   end else
   {
   Example: @DevMsg  &SpeakSrv @Speak=Hello
            @DevSend &SpeakSrv @Speak=Hello
   }
   if IsSameText(cmd,'@DevMsg')
   or IsSameText(cmd,'@DevSend') then begin
    i:=RefFind('Device '+ExtractWord(1,arg));
    if i=0 then n:=0 else n:=Round(DevSend(i,Trim(SkipWords(1,arg))+CRLF));
    Success(cmd+'='+Str(n));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
