 {
 ******************************************************
 GUI script for SPEG.
 ******************************************************
 [@Help]
 |Command list: StdIn "@cmd=arg" or "@cmd arg"
 |******************************************************
 | @Help          - This help.
 | @DebugFlags=n  - Set DebugFlags,1/2/4/8=!/:/>/< view
 | @Shutdown Daq Exit    - Exit    DAQ system
 | @Shutdown Daq Restart - Restart DAQ system
 | @Shutdown Crw Exit    - Exit    CRW-DAQ program
 | @Shutdown Win Exit    - Exit    Windows
 | @Shutdown Win Logout  - Logout  Windows
 | @Shutdown Win Restart - Restart Windows
 |******************************************************
 []
 }
program SPEG_GUI;
const
 dfTrouble         = 1;       { DebugFlags - Trouble             }
 dfSuccess         = 2;       { DebugFlags - Success             }
 dfViewExp         = 4;       { DebugFlags - ViewExp             }
 dfViewImp         = 8;       { DebugFlags - ViewImp             }

 snd_Click         = 'Click'; { Sound on button click            }
 snd_Fails         = 'Fails'; { Sound on operation failure       }
 snd_Wheel         = 'WinWheel'; { Sound on windows operations   }
 snd_Alert1        = 'Alert1';{ Sound on 1st alert level         }
 snd_Alert2        = 'Alert2';{ Sound on 2nd alert level         }
 winDevMsg         = '@DevMsg';    { Device message window       }
 senDevMsg         = '@DevMsg';    { Device message sensor       }
 AlertPeriod       = 7;       { Alert sound period               }
 PlotRefresh       = 10;      { Refresh time for Plot page       }
 nPs               = 2;      { Number of Pressure sensors       }
 nTs               = 1;       { Number of Temperature sensors    }
 nHeats            = 1;       { Number of heats                  }

var
 s                 : String;  { Temporary                        }
 i                 : Integer; { Temporary                        }
 b                 : Boolean; { Temporary                        }
 Ok                : Boolean; { Program initialization is Ok?    }
 errors            : Integer; { Program error counter            }
 errorcode         : Integer; { Error code for this device       }
 fixmaxavail       : Integer; { String manager leak control      }
 DebugFlags        : Integer; { Debug bit flags                  }
 StdIn_Line        : String;  { Temporary variable               }

 winGui        : String;  { GUI window              }
 winPlotT      : String;  { Tx plot window              }
 winPlotP      : String;  { Px plot window              }

 devCtrl       : Integer; { &SPEG.CTRL device reference  }
 devSpeakParams: Integer; { &SPEG.SPEAK.PARAMS device reference  }
 devBlkParams  : Integer; { &SPEG.BLK.PARAMS device reference  }
 devHeatsParams: Integer; { &SPEG.HEATS.PARAMS device reference  }

 tagD              : array[1..nPs] of Integer; {Pressure sensor    tags }
 tagDtyp           : array[1..nPs] of Integer; {Pressure sensor    tags }
 tagDshfbt         : array[1..nPs] of Integer; {Pressure sensor    tags }
 tagP              : array[1..nPs] of Integer; {Pressure    tags }

 tagT              : array[1..nTs] of Integer; {Temperature tags }
 tagTP             : array[1..nTs] of Integer; {Termocouple tags }
 tagTCJ            : integer;

 tagHeat           : array[1..nHeats] of record
  Ts               : Integer; { температура стабилизации         }
  BT               : Integer; { кнопка                           }
  ENB              : Integer; { Enabled                          }
  POW              : Integer; { Power on/off                     }
  SSR              : Integer; { SSR on/off                       }
  PER              : Integer; { period, ms                       }
  Q                : Integer; { Power, % of max                  }
  QMAX             : Integer; { max Power, %                     }
  BLK              : Integer; { блокировка-состояние             }
  BlkTenb          : Integer; { блокировка-разрешение            }
  BlkTmax          : Integer; { блокировка-значение              }
  BlkPenb          : Integer; { блокировка-разрешение            }
  BlkPmax          : Integer; { блокировка-значение              }
 end;

 tagSpeakParams    : Integer; { параметры сообщений              }
 tagBlkParams      : Integer; { параметры блокировок             }
 tagHeatsParams    : Integer; { параметры нагревателей              }

 tagLoadParams    : Integer; { Load control parameters          }
 tagSaveParams    : Integer; { Save control parameters          }
 tagOpen          : Integer; { Open               }
 tagHelp          : Integer; { Help               }
 tagClose         : Integer; { Close               }

 menu              : Integer; { Temporary                        }
 MainMenuOn        : Boolean; { Main menu state                  }
 ToolBarOn         : Boolean; { Toolbar state                    }
 StatusBarOn       : Boolean; { Statusbar state                  }
 DaqSystemOn       : Boolean; { DAQ SYSTEM window state          }

 r                 : real;
 dNumber           : integer; {номер датчика}
 dCalib            : integer; {калибруемый датчик}
 nCalib            : integer; {номер калибровки}
 nSHF              : integer;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iAnd(DebugFlags,dfTrouble)<>0 then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if RunCount=1 then errors:=errors+1 else b:=FixError(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iAnd(DebugFlags,dfSuccess)<>0 then
  if Length(msg)>0 then Writeln(DevName+' : '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iAnd(DebugFlags,dfViewExp)<>0 then
  if Length(msg)>0 then Writeln(DevName+' > '+msg);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iAnd(DebugFlags,dfViewImp)<>0 then
  if Length(msg)>0 then Writeln(DevName+' < '+msg);
 end;
 {
 Check I/O status.
 }
 function IoError:Boolean;
 begin
  IoError:=false;
  if IoResult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var Data:string):boolean;
 begin
  Data:='';
  if not IoError then
  if not Eof then Readln(Data);
  if IoError then Data:='';
  StdIn_Readln:=Length(Data)>0;
 end;
 {
 Процедура установки и сброса бита
 }
 procedure SetBitTag(tag,mask:integer; on:boolean);
 var
  b : boolean;
  k : integer;
 begin
  k:=iand(igettag(tag),inot(mask));
  k:=k+mask*ord(on);
  b:=isettag(tag,k);
 end;
 {
 Функция получения бита
 }
 function GetBitTag(tag,mask:integer): integer;
 var
  b:boolean;
 begin
  b:=iand(igettag(tag),mask)>0;
  GetBitTag:=ord(b);
 end;
 {
 Initialize and check tag.
 }      
 procedure InitTag(var tag:Integer; name:String; typ:Integer);
 begin
  tag:=FindTag(name);
  if (typ>0) and (TypeTag(tag)<>typ)
  then Trouble('Could not init tag: '+name);
 end;
 {
 Find index of word s in list of string items.
 For example, WordIndex('3','1 2 3 4 5')=3.
 }
 function WordIndex(s,list:String):Integer;
 var i,j,n:Integer;
 begin
  i:=1;
  j:=0;
  n:=WordCount(list);
  while i<=n do begin
   if IsSameText(s,ExtractWord(i,list)) then begin
    j:=i;
    i:=n;
   end;
   i:=i+1;
  end;
  WordIndex:=j;
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Show help in device console and echo to Main console if AllowEcho.
 Help text should be placed in program comment is [@Help] section.
 First symbol of help block should be | and will be ignored.
 }
 procedure ShowHelp(AllowEcho:Boolean);
 var i,p,sect:Integer; b:Boolean;
 begin
  sect:=ReadIniSection(text_New,12,DaqFileRef(AdaptFileName(ReadIni('ProgramSource')),'.pas'),'[@Help]');
  for i:=0 to text_NumLn(sect)-1 do begin
   if Copy(text_GetLn(sect,i),1,1)='|' then p:=2 else p:=1;
   if AllowEcho then b:=echo(devname+' : '+Copy(text_GetLn(sect,i),p));
   Success(Copy(text_GetLn(sect,i),p));
  end;
  b:=text_Free(sect);
  if AllowEcho then b:=WinSelect(ParamStr('MainConsole'));
 end;
 {
 Get string like 2006.09.21-00:12:30
 }
 function GetDateTime(ms:Real):String;
 var s:String;
 begin
  s:='';
  s:=Str(ms2sec(ms))+s;   while Length(s)<2  do s:='0'+s; s:=':'+s;
  s:=Str(ms2min(ms))+s;   while Length(s)<5  do s:='0'+s; s:=':'+s;
  s:=Str(ms2hour(ms))+s;  while Length(s)<8  do s:='0'+s; s:='-'+s;
  s:=Str(ms2day(ms))+s;   while Length(s)<11 do s:='0'+s; s:='.'+s;
  s:=Str(ms2month(ms))+s; while Length(s)<14 do s:='0'+s; s:='.'+s;
  s:=Str(ms2year(ms))+s;  while Length(s)<19 do s:='0'+s;
  GetDateTime:=s;
  s:='';
 end;
 {
 Replace all "a" to "b" in string "s".
 Flag = 1 - Replace All, 2 - Not Case sensitive
 }
 function StrReplace(s,a,b:String; Flags:Integer):String;
 var p:Integer;
 begin
  if iAnd(Flags,1)=0
  then p:=Pos(a,s)
  else p:=Pos(UpCaseStr(a),UpCaseStr(s));
  if p=0 then StrReplace:=s else begin
   if iAnd(Flags,2)=0
   then StrReplace:=Copy(s,1,p-1)+b+Copy(s,p+Length(a))
   else StrReplace:=Copy(s,1,p-1)+b+StrReplace(Copy(s,p+Length(a)),a,b,Flags);
  end;
 end;
 {
 Get string parameter by aName from aText list of "Name=Value" items.
 }
 function GetStringVar(aText:Integer; aName:String; var aValue:String):Boolean;
 var i,p:Integer; Name,Value:String;
 begin
  aValue:='';
  GetStringVar:=False;
  if Length(aName)>0 then
  for i:=0 to text_NumLn(aText)-1 do begin
   Value:='';
   Name:=text_GetLn(aText,i);
   p:=Pos('=',Name);
   if p>0 then begin
    Value:=Copy(Name,p+1);
    Name:=Copy(Name,1,p-1);
   end;
   if IsSameText(Name,aName) then begin
    GetStringVar:=True;
    aValue:=Value;
   end;
  end;
  Name:='';
  Value:='';
 end;
 {
 Clear text: remove all lines, but do not free text instance.
 }
 procedure ClearText(aText:Integer);
 var i,N:Integer; b:Boolean;
 begin
  N:=text_NumLn(aText);
  for i:=N-1 downto 0 do b:=text_DelLn(aText,i);
 end; 
 {
 Dialog with warning message
 }
 procedure Warning(msg:string);
 var b:boolean;
 begin
  if editstate=0 
  then msg:=edit('('+msg)+edit(')Warning')
  else b:=Echo(msg);
 end;
 {
 Initialize dialog to edit tag
 }
 procedure StartEditTag(tag:integer; Caption:string);
 var s:string;
 begin
  s:='';
  if typetag(tag)>0 then begin
   if editstate=0 then begin
    if typetag(tag)=1 then s:=str(igettag(tag)) else
    if typetag(tag)=2 then s:=str(rgettag(tag)) else
    if typetag(tag)=3 then s:=sgettag(tag) else s:='';
    if pos('?',edit('(Редактировать тег '+nametag(tag))
              +edit(' '+Caption+'|'+s)
              +edit(')StringGridEdit EDIT_TAG_'+nametag(tag)))>0
    then Warning('Error starting edit tag "'+nametag(tag)+'"!');
   end else Warning('Could not edit tag "'+nametag(tag)+'" right now!');
  end;
  s:='';
 end;
 {
 Check if tag editing done.
 }
 function CheckEditTag(tag:integer; var newValue:String):Boolean;
 var s,d:string; r:real; b:boolean;
 begin
  r:=0;
  s:='';
  d:='';
  CheckEditTag:=false;
  if editstate=1 then
  if typetag(tag)>0 then begin
   s:=edit('?ans 0');
   if extractword(1,s)='EDIT_TAG_'+nametag(tag) then begin
    if extractword(2,s)='1' then begin
     s:=edit('?ans 1');
     d:=worddelims('|');
     s:=extractword(2,s);
     d:=worddelims(d);
     if typetag(tag)=1 then begin
      r:=eval(s);
      if not isnan(r) then begin
       r:=Round(r);
       newValue:=Str(r);
       CheckEditTag:=true;
      end;
     end;
     if typetag(tag)=2 then begin
      r:=eval(s);
      if not isnan(r) then begin
       newValue:=Str(r);
       CheckEditTag:=true;
      end;
     end;
     if typetag(tag)=3 then begin
      newValue:=s;
      CheckEditTag:=true;
     end;
    end;
    s:=edit('');
   end;
   if isnan(r) then Warning('Invalid input!')
  end;
  s:='';
  d:='';
 end;
 {
 Update tag with new value and with range checking.
 }
 procedure UpdateTag(tag:Integer; newValue:String; min,max:Real);
 var rValue:Real;
 begin
  rValue:=0;
  if TypeTag(tag)=1 then begin
   rValue:=rVal(newValue);
   if rValue<min then rValue:=_Nan;
   if rValue>max then rValue:=_Nan;
   if not IsNan(rValue) then b:=iSetTag(tag,Round(rValue));
  end else
  if TypeTag(tag)=2 then begin
   rValue:=rVal(newValue);
   if rValue<min then rValue:=_Nan;
   if rValue>max then rValue:=_Nan;
   if not IsNan(rValue) then b:=rSetTag(tag,rValue);
  end else
  if TypeTag(tag)=3 then begin
   b:=sSetTag(tag,newValue);
  end;
 end;
 {
 Send local device message...
 }
 procedure LocalDevMsg(Device,Msg:String);
 var b:Boolean;
 begin
  b:=DevMsg(Device+' '+Msg+CRLF)>0;
 end;
 {
 Speak, i.e. send message to speech server.
 }
 procedure Speak(msg:String);
 var b:Boolean; ref:Integer;
 begin
  msg:=Trim(msg);
  if Length(msg)>0 then begin
   ref:=RefFind('Device &SpeakSrv');
   if ref<>0 then b:=DevSend(ref,'@speak='+msg+CRLF)>0;
  end;
 end;
 {
 Спрятать\показать основное меню
 }
 procedure DoMainMenu;
 var r:Real;
 begin
  if MainMenuOn
  then r:=eval('@system @async @view show FormCrw32.MainMenu')
  else r:=eval('@system @async @view hide FormCrw32.MainMenu');
  MainMenuOn:=not MainMenuOn;
  b:=voice(snd_Click);
 end;
 {
 Спрятать\показать панель инструментов
 }
 procedure DoToolBar;
 var r:Real;
 begin
  if ToolBarOn
  then r:=eval('@system @async @view show FormCrw32.ToolBar')
  else r:=eval('@system @async @view hide FormCrw32.ToolBar');
  ToolBarOn:=not ToolBarOn;
  b:=voice(snd_Click);
 end;
 {
 Спрятать\показать статусную строку
 }
 procedure DoStatusBar;
 var r:Real;
 begin
  if StatusBarOn
  then r:=eval('@system @async @view show FormCrw32.StatusBar')
  else r:=eval('@system @async @view hide FormCrw32.StatusBar');
  StatusBarOn:=not StatusBarOn;
  b:=voice(snd_Click);
 end;
 {
 Спрятать\показать DAQ SYSTEM
 }
 procedure DoDaqSystem;
 var r:Real;
 begin
  if DaqSystemOn
  then r:=eval('@system @async @view norm FormDaqControlDialog')
  else r:=eval('@system @async @view min  FormDaqControlDialog');
  DaqSystemOn:=not DaqSystemOn;
  b:=voice(snd_Click);
 end;
 {
 Выход из DAQ
 }
 procedure DoExitDaq;
 var r:Real;
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async @guard %SaveGuard');
  r:=eval('@system @async SaveGuard=');
  b:=voice(snd_Click);
 end;
 {
 Выход из CRW
 }
 procedure DoExitCrw;
 var r:Real;
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async _Crw_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @menu run FormCrw32.ActionFileExit');
  r:=eval('@system @async @guard %SaveGuard');
  r:=eval('@system @async SaveGuard=');
  b:=voice(snd_Click);
 end;
 {
 Выход из Windows через 15 сек
 How = l/s/r = logout/stop/restart
 }
 procedure DoExitWin(How:Char);
 var r:Real;
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async @run /Hide '+GetComSpec+' /c '
         +AddBackSlash(ExtractFilePath(GetComSpec))+'shutdown.exe -'+How+' -t 15');
  r:=eval('@system @async _Crw_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @menu run FormCrw32.ActionFileExit');
  r:=eval('@system @async @guard %SaveGuard');
  r:=eval('@system @async SaveGuard=');
  b:=voice(snd_Click);
 end;
 {
 Перезагрузка DAQ
 Принудительный старт при ForceStart=true
 }
 procedure DoRestartDaq(cfg:String;ForceStart:Boolean);
 var r:Real;
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async _Daq_Force_Start_='+str(ord(ForceStart)));
  r:=eval('@system @async @run '+ParamStr('ProgName')+' '+cfg);
  r:=eval('@system @async @sleep 100');
  r:=eval('@system @async @async @guard %SaveGuard');
  r:=eval('@system @async @async SaveGuard=');
  b:=voice(snd_Click);
 end;
 {
 Перезагрузка DAQ, другая версия
 Принудительный старт при ForceStart=true
 }
 procedure DoReloadDaq(cfg:String;ForceStart:Boolean);
 var r:Real;
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  if ForceStart then begin
   r:=eval('@system @async @run '+ParamStr('ProgName')+' '+cfg);
   r:=eval('@system @async @sleep 100');
   r:=eval('@system @async @async @view max FormCrw32');
   r:=eval('@system @async @async @view norm FormDaqControlDialog');
   r:=eval('@system @async @async @menu run FormDaqControlDialog.ActionDaqStart');
  end;
  r:=eval('@system @async @async @guard %SaveGuard');
  r:=eval('@system @async @async SaveGuard=');
  b:=voice(snd_Click);
 end;
 {
 Finalize GUI system.
 }
 procedure GUI_Free;
 begin
 end;
 {
 Initialize GUI system.
 }
 procedure GUI_Init;
 begin
  {
  Initialize tags...
  }
  for i:=1 to nPs do begin
   InitTag(tagD[i],StrReplace(ReadIni('tagD'),'##',Str(i),3),1);
   InitTag(tagDtyp[i],StrReplace(ReadIni('tagDtyp'),'##',Str(i),3),1);
   InitTag(tagDshfbt[i],StrReplace(ReadIni('tagDshfbt'),'##',Str(i),3),1);
   InitTag(tagP[i],StrReplace(ReadIni('tagP'),'##',Str(i),3),2);
  end;

  for i:=1 to nTs do begin
   InitTag(tagTP[i],StrReplace(ReadIni('tagTP'),'##',Str(i),3),1);
   InitTag(tagT[i],StrReplace(ReadIni('tagT'),'##',Str(i),3),2);
  end;

  for i:=1 to nHeats do begin
   InitTag(tagHeat[i].Ts,  StrReplace(ReadIni('tagHeatTs'),  '##',Str(i),3), 2);
   InitTag(tagHeat[i].BT,  StrReplace(ReadIni('tagHeatBT'),  '##',Str(i),3), 1);
   InitTag(tagHeat[i].ENB, StrReplace(ReadIni('tagHeatENB'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].POW, StrReplace(ReadIni('tagHeatPOW'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].SSR, StrReplace(ReadIni('tagHeatSSR'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].PER, StrReplace(ReadIni('tagHeatPER'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].Q,   StrReplace(ReadIni('tagHeatQ'),   '##',Str(i),3), 2);
   InitTag(tagHeat[i].QMAX,StrReplace(ReadIni('tagHeatQMAX'),'##',Str(i),3), 2);

   InitTag(tagHeat[i].BLK,     StrReplace(ReadIni('tagHeatBLK'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].BlkTenb, StrReplace(ReadIni('tagHeatBlkTenb'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].BlkTmax, StrReplace(ReadIni('tagHeatBlkTmax'), '##',Str(i),3), 2);
   InitTag(tagHeat[i].BlkPenb, StrReplace(ReadIni('tagHeatBlkPenb'), '##',Str(i),3), 1);
   InitTag(tagHeat[i].BlkPmax, StrReplace(ReadIni('tagHeatBlkPmax'), '##',Str(i),3), 2);
  end;

  InitTag(tagSpeakParams, ReadIni('tagSpeakParams'),1);
  InitTag(tagBlkParams,   ReadIni('tagBlkParams'),  1);
  InitTag(tagHeatsParams, ReadIni('tagHeatsParams'),1);

  InitTag(tagSaveParams,  ReadIni('tagSaveParams'), 1);
  InitTag(tagLoadParams,  ReadIni('tagLoadParams'), 1);
  InitTag(tagHelp,        ReadIni('tagHelp'),     1);
  InitTag(tagOpen,        ReadIni('tagOpen'),     1);
  InitTag(tagClose,       ReadIni('tagClose'),      1);
  {
  Initialize device reference...
  }
  devCtrl:=RefFind('Device '+ReadIni('devCtrl'));
  if devCtrl<>0 then Success('devCtrl='+RefInfo(devCtrl,'Name'));

  devSpeakParams:=RefFind('Device '+ReadIni('devSpeakParams'));
  if devSpeakParams<>0 then Success('devSpeakParams='+RefInfo(devSpeakParams,'Name'));
  devBlkParams:=RefFind('Device '+ReadIni('devBlkParams'));
  if devBlkParams<>0 then Success('devBlkParams='+RefInfo(devBlkParams,'Name'));
  devHeatsParams:=RefFind('Device '+ReadIni('devHeatsParams'));
  if devHeatsParams<>0 then Success('devHeatsParams='+RefInfo(devHeatsParams,'Name'));

  {
  Initialize windows
  }
  winGui:=ReadIni('winGui');
  if Length(winGui)>0
  then Success('winGui='+winGui)
  else Trouble('winGui=?');
  if RefFind('Window '+winGui)<>0 then begin
   b:=winshow(winGui);
   b:=windraw(winGui+'|top=0|left=0|Width=525|Height=540');
   b:=WinDraw(winGui+'|Options=-Min,-Max,-Close,-Width,-Height,-HScroll,-VScroll');
   b:=winselect(winGui);
//   b:=winhide(winGui);
  end;

  winPlotP:=ReadIni('winPlotP');
  if Length(winPlotP)>0
  then Success('winPlotP='+winPlotP)
  else Trouble('winPlotP=?');
  if RefFind('Window '+winPlotP)<>0 then begin
   b:=winshow(winPlotP);
   b:=windraw(winPlotP+'|top=217|left=0|Width=600|Height=400');
   b:=Windraw(winPlotP+'|Options=-Min,-Max');
   b:=windraw(winPlotP+'|Options=+Close,-HScroll,+VScroll,+StatusBar');
   b:=winselect(winPlotP);
   b:=winhide(winPlotP);
  end;

  winPlotT:=ReadIni('winPlotT');
  if Length(winPlotT)>0
  then Success('winPlotT='+winPlotT)
  else Trouble('winPlotT=?');
  if RefFind('Window '+winPlotT)<>0 then begin
   b:=winshow(winPlotT);
   b:=windraw(winPlotT+'|top=217|left=0|Width=600|Height=400');
   b:=WinDraw(winPlotT+'|Options=-Min,-Max,+Close');
   b:=windraw(winPlotT+'|Options=+Close,-HScroll,+VScroll,+StatusBar');
   b:=winselect(winPlotT);
   b:=winhide(winPlotT);
  end;

  //DoStatusBar;
  //DoToolBar; 
  //DoDaqSystem;
  //b:=winhide('ГЛАВНАЯ КОНСОЛЬ');
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  StdIn_Line:='';
  winGui:='';
  winPlotT:='';
  winPlotP:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Dialog with information message
 }
 procedure InfoBox(msg:string);
 var b:boolean;
 begin
  if editstate=0 
  then msg:=edit('('+msg)+edit(')Information')
  else b:=Echo(devname+' : '+msg);
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then InfoBox(s);
 end;
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var b:Boolean; nv:Integer;
 begin
  if ClickTag=tag then begin
   b:=iSetTag(tag,iXor(iGetTag(tag),XorMask));
   b:=Voice(snd_Click);
  end;
 end;
 {
 Процедура вызова окна по нажатию сенсора
 }
 procedure ClickWinSelect(Sen,WinList:String);
 var b:Boolean; i:Integer;
 begin
  if IsSameText(ClickSensor,Sen) then begin
   for i:=1 to WordCount(WinList) do begin
    b:=WinHide(ExtractWord(i,WinList));
    b:=WinShow(ExtractWord(i,WinList));
    b:=WinSelect(ExtractWord(i,WinList));
    s:=ClickParams('Curve');
    if Length(s)>0 then begin
     b:=WinDraw(ExtractWord(i,WinList)+'|SelectCurve='+s);
    end;
   end;
   b:=Voice(snd_Click);
  end;
 end;
 {
 GUI polling actions
 }
 procedure GUI_Polling;
 var i,n:Integer; q:Real;
 begin
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(Data:string);
 var cmd,arg:String; b:Boolean; tag:Integer;
 begin
  if iAnd(DebugFlags,dfViewImp)<>0 then ViewImp('CON: '+Data);
  {
  "@cmd=arg" or "@cmd args" commands:
  }
  cmd:='';
  arg:='';
  if Length(Data)>0 then
  if Data[1]='@' then begin
   cmd:=ExtractWord(1,Data);
   arg:=Copy(Data,Pos(cmd,Data)+Length(cmd)+1);
   {}
   if IsSameText(cmd,'@Help') then begin
    ShowHelp(true);
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@DebugFlags') then begin
    if not IsNan(rVal(arg)) then DebugFlags:=Round(rVal(arg));
    Success(cmd+'='+Str(DebugFlags));
    Data:='';
   end;
   {}
   if IsSameText('@Shutdown',cmd) then begin
    if IsSameText('Daq',ExtractWord(1,arg)) then begin
     if IsSameText('Exit',    ExtractWord(2,arg)) then DoExitDaq;
     if IsSameText('Restart', ExtractWord(2,arg)) then DoRestartDaq(ParamStr('DaqConfigFile'),true);
    end;
    if IsSameText('Crw',ExtractWord(1,arg)) then begin
     if IsSameText('Exit',    ExtractWord(2,arg)) then DoExitCrw;
    end;
    if IsSameText('Win',ExtractWord(1,arg)) then begin
     if IsSameText('Exit',    ExtractWord(2,arg)) then DoExitWin('s');
     if IsSameText('Logout',  ExtractWord(2,arg)) then DoExitWin('l');
     if IsSameText('Restart', ExtractWord(2,arg)) then DoExitWin('r');
    end;
    Data:='';
   end;
   {}
   if Length(Data)>0 then begin
    Trouble(' Unrecognized command "'+Data+'".');
    Data:='';
   end;
  end;
  cmd:='';
  arg:='';
 end;
 {
 HELP
 }
 procedure Help;
 var f:String; i:Integer;
 begin
  f:=AdaptFileName(ReadIni('HelpFile'));
  if Length(f)>0 then i:=shellexecute('open | '+DaqFileRef(f,''));
 end;
 {
 Main
 }
begin
 {
 Initialization actions on Start...
 }
 if runcount=1 then begin
  {
  Initialize errors...
  }
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  DebugFlags:=val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));
  Success('Start at '+GetDateTime(msecnow));
  {
  Initialize GUI, Web server and connect to tags.
  }
  GUI_Init;
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop...
 }
 if isinf(runcount) then begin
  GUI_Free;
  ClearStrings;
  Success('Stop.');
 end else
 {
 Основной цикл опроса
 }
 if Ok then begin
  {
  Process standard input...
  }
  while StdIn_Readln(StdIn_Line) do StdIn_Process(StdIn_Line);
  {
  GUI polling actions
  }
  GUI_Polling;
  {
  Close menu command
  }
  {
  Edit tags...
  }
  if editstate=1 then begin
   if IsSameText(edit('?ans 0'),'CLOSE=6')then DoExitCrw;
   {
    выбор типа датчика
   }
   if IsSameText(edit('?ans 0'),'DTYP=1') then begin
    s:=edit('?ans 1');
    b:=isettag(tagDtyp[dNumber],val(s));
    s:=edit('');
   end;
   {
    калибровка датчиков Д
   }
   if IsSameText(edit('?ans 0'),'FCALIBD=6')then begin
    b:=Voice(snd_Wheel);
    if igettag(tagDtyp[dCalib])=1 then begin
     if dCalib=1 then nCalib:=0;
     if dCalib=2 then nCalib:=1;
     r:=eval('@system @async @open DAQ:\DeviceList\&SPEG.MV2PU.AR\Calibration#'+str(nCalib));
    end;
    s:=edit('');
   end;
   {
    калибровка термопар ТП
   }
   if IsSameText(edit('?ans 0'),'FCALIBTP=6')then begin
    r:=eval('@system @async @open DAQ:\DeviceList\&SPEG.T\Calibration#'+str(dCalib-1));
    b:=Voice(snd_Wheel);
    s:=edit('');
   end;
   {
    смещения
   }
   if IsSameText(edit('?ans 0'),'SHFMV=6')then if igettag(tagDtyp[nSHF])=1 then begin  
    if DevSend(devCtrl,'@D'+str(nSHF)+'SHFMV'+CRLF)=0 then Trouble('xxxx');
    s:=edit('');
   end;
   {
    установки температур
   }
   for i:=1 to nHeats do begin
    if CheckEditTag(tagHeat[i].Ts,s)then UpdateTag(tagHeat[i].Ts, s, 0,1000);
    if CheckEditTag(tagHeat[i].BlkTmax,s)then UpdateTag(tagHeat[i].BlkTmax, s, 0,1500);
    if CheckEditTag(tagHeat[i].BlkPmax,s)then UpdateTag(tagHeat[i].BlkPmax, s, 0,3000);
   end;
  end;

  if editstate=1 then begin
   writeln('Unknown tag edition!');
   s:=edit('');
  end;

  if iand(editstate,9)<>0 then begin
   writeln('Dialog error detected!');
   s:=edit('');
  end;
  {
  Handle left button clicks...
  }
  if (clickbutton=1)  then begin
   {
    ---------------- Common
   }
   if IsSameText(clicksensor,'CLOSE') then begin
    b:=voice(snd_Click);
    if editstate=0 then begin
     if pos('?',edit('(Вы действительно хотите завершить сеанс?')
               +edit(')YesNo CLOSE'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
    Help
   }
   if ClickTag=tagHelp then begin
    b:=Voice(snd_Wheel);
    Help;
   end;

   if ClickTag=tagOpen then begin
    b:=Voice(snd_Wheel);
    s:='';
    s:=AddBackSlash(AdaptFileName(ReadIni('DataPath')));
    b:=Eval('@system @async @open -d '+DaqFileRef(s,'.dat'))>0;
    s:='';
   end;

   {
    Калибровки датчиков давления
   }
   for i:=1 to nPs do if ClickTag=tagD[i] then begin
    b:=voice(snd_Click);
    dCalib:=i;
    if editstate=0 then begin
     if pos('?',edit('(Вы действительно хотите открыть калибровку Д'+str(dCalib)+'?')
               +edit(')YesNo FCALIBD'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
   Калибровки термопар ТП
   }
   for i:=1 to nTs do if ClickTag=tagTP[i] then begin
    b:=voice(snd_Click);
    dcalib:=i;
    if editstate=0 then begin
     if pos('?',edit('(Вы действительно хотите открыть калибровку ТП'+str(dCalib)+'?')
               +edit(')YesNo FCALIBTP'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   {
    SHF
   }
   for i:=1 to nPs do if ClickTag=tagDshfbt[i] then begin
    b:=Voice(snd_Click);
    nSHF:=i;
    if igettag(tagDtyp[nSHF])=1 then begin
     if editstate=0 then begin
      if pos('?',edit('(Внимание! Давление должно быть атмосферным. Продолжать?')
                +edit(')YesNo SHFMV'))>0
      then writeln('Ошибка инициирования диалога!');
     end else writeln('Cannot edit right now!');
    end;
 
   end;
   {
   Рисование
   }
   for i:=1 to nPs do if ClickTag=tagP[i] then begin
    b:=WinShow(winPlotP);
    b:=WinDraw(winPlotP+'|SelectCurve='+NameTag(ClickTag));
    b:=WinSelect(winPlotP);
    b:=Voice(snd_Wheel);
   end;

   for i:=1 to nTs do if ClickTag=tagT[i] then begin
    b:=WinShow(winPlotT);
    b:=WinDraw(winPlotT+'|SelectCurve='+NameTag(ClickTag));
    b:=WinSelect(winPlotT);
    b:=Voice(snd_Wheel);
   end;

   if ClickTag=tagTCJ then begin
    b:=WinShow(winPlotT);
    b:=WinDraw(winPlotT+'|SelectCurve='+NameTag(ClickTag));
    b:=WinSelect(winPlotT);
    b:=Voice(snd_Wheel);
   end;
   {
   Commands
   }
   if ClickTag=tagSaveParams then begin
    if DevSend(devCtrl,'@SAVEPARAMS'+CRLF)=0 then Trouble('xxxx');
    b:=Voice(snd_Click);
   end;
   if ClickTag=tagLoadParams then begin
    if DevSend(devCtrl,'@LOADPARAMS'+CRLF)=0 then Trouble('xxxx');
    b:=Voice(snd_Click);
   end;
   {
    SPEAK
   }
   if ClickTag=tagSpeakParams then begin
    b:=devsend(devSpeakParams,' Confirm=2')>0;
    b:=action(RefInfo(devSpeakParams,'Name')); 
    b:=Voice(snd_Wheel);
   end;
   {
    ---------- Handle clicks in SPEG.GUI window.
   }
//   if IsSameText(ClickParams('Window'),winGui) then begin
    {
     Установка температур Ts
    }
    for i:=1 to nHeats do if clicktag=tagHeat[i].Ts then begin
     StartEditTag(tagHeat[i].Ts,'Температура');
     b:=Voice(snd_Click);
    end;
    {
     Heats
    }
    for i:=1 to nHeats do begin
     if ClickTag=tagHeat[i].BT then begin
      if GetBitTag(tagHeat[i].BT,1)=0 then s:='@HEATON=' else s:='@HEATOFF=';
      if DevSend(devCtrl,s+str(i)+CRLF)=0 then Trouble('xxxx');
      b:=Voice(snd_Click);
     end;
    end;
    {
     BLK
    }
    if ClickTag=tagBlkParams then begin
     b:=devsend(devBlkParams,' Confirm=2')>0;
     b:=action(RefInfo(devBlkParams,'Name')); 
     b:=Voice(snd_Wheel);
    end;
    {
     HEATS
    }
    if ClickTag=tagHeatsParams then begin
     b:=devsend(devHeatsParams,' Confirm=2')>0;
     b:=action(RefInfo(devHeatsParams,'Name')); 
     b:=Voice(snd_Wheel);
    end;
//   end;
  end;
  {
  Handle right button clicks...
  }
  if ClickButton=2 then begin
   SensorHelp(Url_Decode(ClickParams('Hint')));
  end;
 end;
end.
