---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Справка по демонстрационной системе DEMO_SPEAK1.

---

Демонстрационная конфигурация **DEMO_SPEAK** служит для иллюстрации того,
как в системе **CRW-DAQ** можно организовывать речевые сообщения при помощи
речевого синтезатора - далее называемый _движок_ или _engine_.
Под **Windows** речевой синтезатор - это пакет **Speech API**,
под **Linux** - это пакет **RHVoice**.

Надо заметить - системный речевой синтезатор работает в основном потоке,
поэтому для его вызова всегда используется префикс **@system @async**.

Далее, речевой синтезатор не работает, пока не установлен движок.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Установка движка под Windows

Под **Windows** надо установить **Speech API**. Нужно установить два компонента:

1. Библиотеку **[spchapi.exe](..\..\resource\tools\speechapi\spchapi.exe)** и  
2. Голоса
   **[lhttsrur.exe](..\..\resource\tools\speechapi\lhttsrur.exe)** (русский) и
   **[lhttseng.exe](..\..\resource\tools\speechapi\lhttseng.exe)** (английский).  
Это можно сделать через меню **Web\Home**.

Эти компоненты доступны в Интернете:  
1. **[spchapi.exe](http://activex.microsoft.com/activex/controls/sapi/spchapi.exe)**,  
2. **[lhttsrur.exe](http://activex.microsoft.com/activex/controls/agent2/lhttsrur.exe)** и  
3. **[lhttseng.exe](http://activex.microsoft.com/activex/controls/agent2/lhttseng.exe)**.

Установка **spchapi.exe** происходит "молча", никаких диалогов.
Установка **lhttsrur.exe**, **lhttseng.exe** происходит через стандартный диалог инсталляции.
Больше настроек не требуется.

После установки движков они доступны по именам:

- Adult Female #1 Russian (L&H)  
- Adult Male #1 Russian (L&H)  
- Adult Female #1 British English (L&H)  
- Adult Male #1 British English (L&H)  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Установка движка под Linux

Под **Linux** устанавливается пакет **daqgroup-rhvoice**, входящий в состав
репозитория **DaqGroup**:

``` bash
sudo qapt-deb-installer /srv/public/mirror/addons/daqgroupkit/install-daqgroup-rhvoice.deb
```
Также необходимо установить пакет **daqgroup-crwkit**:

``` bash
/srv/public/mirror/addons/daqgroupkit/install-daqgroup-crwkit.run
```

Для проверки работы:

``` bash
crwkit speak "Привет, друг."
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Инициализация синтезатора

В стартовой части программы **[demo_speak.pas](demo_speak.pas)** стоит вызов:

``` pascal
t:=eval('@system @async @speech engine 1');
  или (Windows)
t:=eval('@system @async @speech engine Adult Female #1 Russian (L&H)');
t:=eval('@system @async @speech engine Adult Male #1 Russian (L&H)');
  или (Linux)
t:=eval('@system @async @speech engine Elena');
t:=eval('@system @async @speech engine Aleksandr');
```

Этот вызов разрешает речевой синтезатор и устанавливает нужный речевой движок.  
Список движков получается камандой главной нонсоли **`@speech engines`**.  
После задания движка становятся доступны речевые сообщения.

Рекомендуется также сделать вызов:

``` pascal
t:=eval('@system @async @speech wait 1');
```

Это нужно для того, чтобы синтезатор работал синхронно, т.е. ожидал завершения
предыдущей фразы, прежде чем начать новую.
Надо, однако, отметить, что синхронный режим блокирует (на время произнесения
фразы) системную консоль, поэтому должен использоваться с осторожностью.


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Вызов речевых сообщений

Собственно сообщения делаются так:

``` pascal
t:=eval('@system @async @speak Привет, Мир!');
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Завершение работы синтезатора

В завершающей части программы **[demo_speak.pas](demo_speak.pas)** стоит вызов:

``` pascal
t:=eval('@system @async @speech engine 0');
```

Этот вызов запрещает речевой синтезатор.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Успехов!

---

> CRW-DAQ Copyright (c) 2002-2024 Alexey Kuryakin <daqgroup@mail.ru>

---
