@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem ****************************
rem DIM DIC/DIS config generator
rem ****************************

:Main
call :InitializeVariables
pushd "%~dp0" && call :DIMServices
popd
echo Done
goto :EOF

:InitializeVariables
set "fname=%~n0"
set "fname=%fname:_dim=%"
set diccfg=%fname%_dic.cfg
set discfg=%fname%_dis.cfg
set devmsg=devPostMsg
set "FN=SCE.BACC.BSTR" :: Facility name
set "SS=VACS"          :: Device identifier name
set "FP=%FN:.=/%"      :: Facility DIM  path, i.e. FN name with . to / replacement
set "FF=%FN:.=_%"      :: Facility file name, i.e. FN name with . to _ replacement
goto :EOF

:DIMServices
call :DeleteFiles %diccfg% %discfg%
call :DIM_DIS  %* >> %discfg%
call :DIM_DIC  %* >> %diccfg%
call :DIM_CTRL %* >> %diccfg%
goto :EOF

:DIM_DIS
unix dimcfg ^
  -n section  "[&%FN%.%SS%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd %FP%/%SS%/DIMGUICLICK ^
  -n tag      %FN%.%SS%.DIMGUICLICK ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dic_cmnd %FP%/%SS%/DIMGUICLICK ^
  -n tag      %FN%.%SS%.DIMGUICLICK ^
  -n end ^
  -n dis_info %FP%/%SS%/CLOCK ^
  -n tag      %FN%.%SS%.CLOCK ^
  -n end ^
  -n dis_info %FP%/%SS%/SERVID ^
  -n tag      %FN%.%SS%.SERVID ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC1/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC1.VP1.BT ^
  -n tag      %FN%.%SS%.SEC1.VP2.BT ^
  -n tag      %FN%.%SS%.SEC1.NG1.BT ^
  -n tag      %FN%.%SS%.SEC1.NG2.BT ^
  -n tag      %FN%.%SS%.SEC1.NG3.BT ^
  -n tag      %FN%.%SS%.SEC1.NM1.BT ^
  -n tag      %FN%.%SS%.SEC1.NM2.BT ^
  -n tag      %FN%.%SS%.SEC1.NM3.BT ^
  -n tag      %FN%.%SS%.SEC1.NM4.BT ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC1/PS1/MBAR ^
  -n tag      %FN%.%SS%.SEC1.PS1.MBAR ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC2/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC2.VP3.BT ^
  -n tag      %FN%.%SS%.SEC2.VP4.BT ^
  -n tag      %FN%.%SS%.SEC2.NG4.BT ^
  -n tag      %FN%.%SS%.SEC2.NG5.BT ^
  -n tag      %FN%.%SS%.SEC2.NG6.BT ^
  -n tag      %FN%.%SS%.SEC2.NG7.BT ^
  -n tag      %FN%.%SS%.SEC2.NM5.BT ^
  -n tag      %FN%.%SS%.SEC2.NM6.BT ^
  -n tag      %FN%.%SS%.SEC2.NM7.BT ^
  -n tag      %FN%.%SS%.SEC2.NM8.BT ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC2/PS2/MBAR ^
  -n tag      %FN%.%SS%.SEC2.PS2.MBAR ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC3/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC3.VP5.BT  ^
  -n tag      %FN%.%SS%.SEC3.VP6.BT  ^
  -n tag      %FN%.%SS%.SEC3.NG8.BT  ^
  -n tag      %FN%.%SS%.SEC3.NG9.BT  ^
  -n tag      %FN%.%SS%.SEC3.NG10.BT ^
  -n tag      %FN%.%SS%.SEC3.NM9.BT  ^
  -n tag      %FN%.%SS%.SEC3.NM10.BT ^
  -n tag      %FN%.%SS%.SEC3.NM11.BT ^
  -n tag      %FN%.%SS%.SEC3.NM12.BT ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC3/PS3/MBAR ^
  -n tag      %FN%.%SS%.SEC3.PS3.MBAR ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC4/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC4.VP8.BT  ^
  -n tag      %FN%.%SS%.SEC4.VP9.BT  ^
  -n tag      %FN%.%SS%.SEC4.NG11.BT ^
  -n tag      %FN%.%SS%.SEC4.NG12.BT ^
  -n tag      %FN%.%SS%.SEC4.NG13.BT ^
  -n tag      %FN%.%SS%.SEC4.NM13.BT ^
  -n tag      %FN%.%SS%.SEC4.NM14.BT ^
  -n tag      %FN%.%SS%.SEC4.NM15.BT ^
  -n tag      %FN%.%SS%.SEC4.NM16.BT ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC4/PS4/MBAR ^
  -n tag      %FN%.%SS%.SEC4.PS4.MBAR ^
  -n end ^
  -n
unix dimcfg ^
  -n dis_info %FP%/%SS%/SEC5/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC5.VP10.BT ^
  -n tag      %FN%.%SS%.SEC5.VP11.BT ^
  -n tag      %FN%.%SS%.SEC5.NG14.BT ^
  -n tag      %FN%.%SS%.SEC5.NG15.BT ^
  -n tag      %FN%.%SS%.SEC5.NG16.BT ^
  -n tag      %FN%.%SS%.SEC5.NG17.BT ^
  -n tag      %FN%.%SS%.SEC5.NM17.BT ^
  -n tag      %FN%.%SS%.SEC5.NM18.BT ^
  -n tag      %FN%.%SS%.SEC5.NM19.BT ^
  -n tag      %FN%.%SS%.SEC5.NM20.BT ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC5/PS5/MBAR ^
  -n tag      %FN%.%SS%.SEC5.PS5.MBAR ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC6/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC6.VP12.BT ^
  -n tag      %FN%.%SS%.SEC6.VP13.BT ^
  -n tag      %FN%.%SS%.SEC6.NG18.BT ^
  -n tag      %FN%.%SS%.SEC6.NG19.BT ^
  -n tag      %FN%.%SS%.SEC6.NG20.BT ^
  -n tag      %FN%.%SS%.SEC6.NM21.BT ^
  -n tag      %FN%.%SS%.SEC6.NM22.BT ^
  -n tag      %FN%.%SS%.SEC6.NM23.BT ^
  -n tag      %FN%.%SS%.SEC6.NM24.BT ^
  -n end ^
  -n dis_info %FP%/%SS%/SEC6/PS6/MBAR ^
  -n tag      %FN%.%SS%.SEC6.PS6.MBAR ^
  -n end ^
  -n dis_info %FP%/%SS%/ECOL/VP7/BT ^
  -n tag      %FN%.%SS%.ECOL.VP7.BT ^
  -n end ^
  -n dis_info %FP%/%SS%/SECN/NORMPS ^
  -n tag      %FN%.%SS%.SEC1.NORMPS ^
  -n tag      %FN%.%SS%.SEC2.NORMPS ^
  -n tag      %FN%.%SS%.SEC3.NORMPS ^
  -n tag      %FN%.%SS%.SEC4.NORMPS ^
  -n tag      %FN%.%SS%.SEC5.NORMPS ^
  -n tag      %FN%.%SS%.SEC6.NORMPS ^
  -n end ^
  -n dis_info %FP%/%SS%/SECN/WARNPS ^
  -n tag      %FN%.%SS%.SEC1.WARNPS ^
  -n tag      %FN%.%SS%.SEC2.WARNPS ^
  -n tag      %FN%.%SS%.SEC3.WARNPS ^
  -n tag      %FN%.%SS%.SEC4.WARNPS ^
  -n tag      %FN%.%SS%.SEC5.WARNPS ^
  -n tag      %FN%.%SS%.SEC6.WARNPS ^
  -n end ^
  -n dis_info %FP%/%SS%/SECN/FAILPS ^
  -n tag      %FN%.%SS%.SEC1.FAILPS ^
  -n tag      %FN%.%SS%.SEC2.FAILPS ^
  -n tag      %FN%.%SS%.SEC3.FAILPS ^
  -n tag      %FN%.%SS%.SEC4.FAILPS ^
  -n tag      %FN%.%SS%.SEC5.FAILPS ^
  -n tag      %FN%.%SS%.SEC6.FAILPS ^
  -n end ^
  -n
goto :EOF

:DIM_DIC
unix dimcfg ^
  -n section  "[&%FN%.%SS%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd %FP%/%SS%/DIMGUICLICK ^
  -n tag      %FN%.%SS%.DIMGUICLICK ^
  -n end ^
  -n dic_info %FP%/%SS%/CLOCK ^
  -n tag      %FN%.%SS%.CLOCK ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.CLOCK" ^
  -n end ^
  -n dic_info %FP%/%SS%/SERVID ^
  -n tag      %FN%.%SS%.SERVID ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SERVID" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC1/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC1.VP1.BT ^
  -n tag      %FN%.%SS%.SEC1.VP2.BT ^
  -n tag      %FN%.%SS%.SEC1.NG1.BT ^
  -n tag      %FN%.%SS%.SEC1.NG2.BT ^
  -n tag      %FN%.%SS%.SEC1.NG3.BT ^
  -n tag      %FN%.%SS%.SEC1.NM1.BT ^
  -n tag      %FN%.%SS%.SEC1.NM2.BT ^
  -n tag      %FN%.%SS%.SEC1.NM3.BT ^
  -n tag      %FN%.%SS%.SEC1.NM4.BT ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.VP1.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.VP2.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.NG1.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.NG2.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.NG3.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.NM1.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.NM2.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.NM3.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.NM4.BT" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC1/PS1/MBAR ^
  -n tag      %FN%.%SS%.SEC1.PS1.MBAR ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.PS1.MBAR" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC2/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC2.VP3.BT ^
  -n tag      %FN%.%SS%.SEC2.VP4.BT ^
  -n tag      %FN%.%SS%.SEC2.NG4.BT ^
  -n tag      %FN%.%SS%.SEC2.NG5.BT ^
  -n tag      %FN%.%SS%.SEC2.NG6.BT ^
  -n tag      %FN%.%SS%.SEC2.NG7.BT ^
  -n tag      %FN%.%SS%.SEC2.NM5.BT ^
  -n tag      %FN%.%SS%.SEC2.NM6.BT ^
  -n tag      %FN%.%SS%.SEC2.NM7.BT ^
  -n tag      %FN%.%SS%.SEC2.NM8.BT ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.VP3.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.VP4.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.NG4.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.NG5.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.NG6.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.NG7.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.NM5.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.NM6.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.NM7.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.NM8.BT" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC2/PS2/MBAR ^
  -n tag      %FN%.%SS%.SEC2.PS2.MBAR ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.PS2.MBAR" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC3/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC3.VP5.BT  ^
  -n tag      %FN%.%SS%.SEC3.VP6.BT  ^
  -n tag      %FN%.%SS%.SEC3.NG8.BT  ^
  -n tag      %FN%.%SS%.SEC3.NG9.BT  ^
  -n tag      %FN%.%SS%.SEC3.NG10.BT ^
  -n tag      %FN%.%SS%.SEC3.NM9.BT  ^
  -n tag      %FN%.%SS%.SEC3.NM10.BT ^
  -n tag      %FN%.%SS%.SEC3.NM11.BT ^
  -n tag      %FN%.%SS%.SEC3.NM12.BT ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.VP5.BT"  ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.VP6.BT"  ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.NG8.BT"  ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.NG9.BT"  ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.NG10.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.NM9.BT"  ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.NM10.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.NM11.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.NM12.BT" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC3/PS3/MBAR ^
  -n tag      %FN%.%SS%.SEC3.PS3.MBAR ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.PS3.MBAR" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC4/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC4.VP8.BT  ^
  -n tag      %FN%.%SS%.SEC4.VP9.BT  ^
  -n tag      %FN%.%SS%.SEC4.NG11.BT ^
  -n tag      %FN%.%SS%.SEC4.NG12.BT ^
  -n tag      %FN%.%SS%.SEC4.NG13.BT ^
  -n tag      %FN%.%SS%.SEC4.NM13.BT ^
  -n tag      %FN%.%SS%.SEC4.NM14.BT ^
  -n tag      %FN%.%SS%.SEC4.NM15.BT ^
  -n tag      %FN%.%SS%.SEC4.NM16.BT ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.VP8.BT"  ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.VP9.BT"  ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.NG11.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.NG12.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.NG13.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.NM13.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.NM14.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.NM15.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.NM16.BT" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC4/PS4/MBAR ^
  -n tag      %FN%.%SS%.SEC4.PS4.MBAR ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.PS4.MBAR" ^
  -n end ^
  -n
unix dimcfg ^
  -n dic_info %FP%/%SS%/SEC5/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC5.VP10.BT ^
  -n tag      %FN%.%SS%.SEC5.VP11.BT ^
  -n tag      %FN%.%SS%.SEC5.NG14.BT ^
  -n tag      %FN%.%SS%.SEC5.NG15.BT ^
  -n tag      %FN%.%SS%.SEC5.NG16.BT ^
  -n tag      %FN%.%SS%.SEC5.NG17.BT ^
  -n tag      %FN%.%SS%.SEC5.NM17.BT ^
  -n tag      %FN%.%SS%.SEC5.NM18.BT ^
  -n tag      %FN%.%SS%.SEC5.NM19.BT ^
  -n tag      %FN%.%SS%.SEC5.NM20.BT ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.VP10.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.VP11.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.NG14.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.NG15.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.NG16.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.NG17.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.NM17.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.NM18.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.NM19.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.NM20.BT" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC5/PS5/MBAR ^
  -n tag      %FN%.%SS%.SEC5.PS5.MBAR ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.PS5.MBAR" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC6/VPX+NGX+NMX/BT ^
  -n tag      %FN%.%SS%.SEC6.VP12.BT ^
  -n tag      %FN%.%SS%.SEC6.VP13.BT ^
  -n tag      %FN%.%SS%.SEC6.NG18.BT ^
  -n tag      %FN%.%SS%.SEC6.NG19.BT ^
  -n tag      %FN%.%SS%.SEC6.NG20.BT ^
  -n tag      %FN%.%SS%.SEC6.NM21.BT ^
  -n tag      %FN%.%SS%.SEC6.NM22.BT ^
  -n tag      %FN%.%SS%.SEC6.NM23.BT ^
  -n tag      %FN%.%SS%.SEC6.NM24.BT ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.VP12.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.VP13.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.NG18.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.NG19.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.NG20.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.NM21.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.NM22.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.NM23.BT" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.NM24.BT" ^
  -n end ^
  -n dic_info %FP%/%SS%/SEC6/PS6/MBAR ^
  -n tag      %FN%.%SS%.SEC6.PS6.MBAR ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.PS6.MBAR" ^
  -n end ^
  -n dic_info %FP%/%SS%/ECOL/VP7/BT ^
  -n tag      %FN%.%SS%.ECOL.VP7.BT ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.ECOL.VP7.BT" ^
  -n end ^
  -n dic_info %FP%/%SS%/SECN/NORMPS ^
  -n tag      %FN%.%SS%.SEC1.NORMPS ^
  -n tag      %FN%.%SS%.SEC2.NORMPS ^
  -n tag      %FN%.%SS%.SEC3.NORMPS ^
  -n tag      %FN%.%SS%.SEC4.NORMPS ^
  -n tag      %FN%.%SS%.SEC5.NORMPS ^
  -n tag      %FN%.%SS%.SEC6.NORMPS ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.NORMPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.NORMPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.NORMPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.NORMPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.NORMPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.NORMPS" ^
  -n end ^
  -n dic_info %FP%/%SS%/SECN/WARNPS ^
  -n tag      %FN%.%SS%.SEC1.WARNPS ^
  -n tag      %FN%.%SS%.SEC2.WARNPS ^
  -n tag      %FN%.%SS%.SEC3.WARNPS ^
  -n tag      %FN%.%SS%.SEC4.WARNPS ^
  -n tag      %FN%.%SS%.SEC5.WARNPS ^
  -n tag      %FN%.%SS%.SEC6.WARNPS ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.WARNPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.WARNPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.WARNPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.WARNPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.WARNPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.WARNPS" ^
  -n end ^
  -n dic_info %FP%/%SS%/SECN/FAILPS ^
  -n tag      %FN%.%SS%.SEC1.FAILPS ^
  -n tag      %FN%.%SS%.SEC2.FAILPS ^
  -n tag      %FN%.%SS%.SEC3.FAILPS ^
  -n tag      %FN%.%SS%.SEC4.FAILPS ^
  -n tag      %FN%.%SS%.SEC5.FAILPS ^
  -n tag      %FN%.%SS%.SEC6.FAILPS ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC1.FAILPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC2.FAILPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC3.FAILPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC4.FAILPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC5.FAILPS" ^
  -n %devmsg% "&%FN%.%SS%.CTRL @DimTagUpdate=%FN%.%SS%.SEC6.FAILPS" ^
  -n end ^
  -n
goto :EOF

:DIM_CTRL
echo [DataStorage]
echo []
echo [TagList]
echo []
echo [^&%FN%.%SS%.CTRL]
echo []
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
