@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem **************************************
rem Birger devices config generator
rem **************************************

chcp 65001 >nul & rem  set UTF-8

:Main
call :InitializeVariables
pushd "%~dp0" && call :I7053Devices
popd
goto :EOF

:SetUnixPath
for /f "tokens=* delims=" %%a in ('unix path') do set "%%a"
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set proxycfg=%~n0_proxy.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set devmsg=devPostMsg
set tabcrc=..\Circuits\%~n0_link.crc
set /a numhdwcfg=0
set /a numdev=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=650
set /a CTRL_TOP_STEP=70
set /a TABCRC_TOP=0
set /a TABCRC_STEP=80
set /a TABCRC_LEFT=0
set fileprefix=
set mainprefix=DEMO
set lastport=0
goto :EOF

:I7053Devices
call :DeleteFiles %hdwcfg% %simcfg% %proxycfg% %tabcrc% %diccfg% %discfg%
call :I7053_PROXY_INIT %* >> %proxycfg%
REM ============================================COM PORT CONNECTION============================================================
rem      Device Connect DevLabel         Facility    ID    ComPort ComBaudrate     RS485Port UnitId Polling CheckSum WDReconnect DelayOnStart InvertedData
rem call :I7053  COM     Камера_1         DEMO       P1    2       115200          1          1      10       1        1         0            1
rem call :I7053  COM     Ионопровод_1     DEMO       P2    1       115200          2          2      10       1        1         0            1
rem call :I7053  COM     Ионопровод_2     DEMO       P2    1       115200          2          2      10       1        1         0            1
REM ============================================TCP CONNECTION============================================================
rem      Device Connect DevLabel         Facility    ID    TcpPort TcpClient    RS485Port  UnitId Polling   CheckSum WDReconnect DelayOnStart InvertedData
rem call :I7053  TCP     Объем_1         DEMO        P1    5000    192.168.0.1  2          2      10        1        1           20000        1
rem call :I7053  TCP     Объем_2         DEMO        P1    5000    192.168.0.1  2          2      10        1        1           20000        1
rem call :I7053  TCP     Камера_2        DEMO        P2    5000    192.168.0.1  2          2      10        1        1           20000        1
rem call :I7053  TCP     Камера_3        DEMO        P3    5000    192.168.0.1  2          2      10        1        1           20000        1
REM ==============================================TCP CONNECTION===============================================================
rem      Device Connect DevLabel         Facility   ID           TCPPort TCPClient       RS485Port  UnitId Polling  CheckSum WDReconnect DelayOnStart InvertedData
    call :I7053 TCP     I7053_1          DEMO       I7053.P1     5305    172.21.4.210    1          3      10       1        1           20000        1
rem call :I7053 TCP     I7053_2          DEMO       I7053.P2     5305    172.21.4.210    1          4      10       1        1           20000        1
rem call :I7053 TCP     I7053_3          DEMO       I7053.P3     5305    172.21.4.210    1          5      10       1        1           20000        1
rem ============================================COM PORT CONNECTION======================================================================================
rem      Device  Connect DevLabel       Facility ID       ComPort ComBaudrate     RS485Port UnitId Polling CheckSum WDReconnect DelayOnStart InvertedData
rem call :I7053  COM     I7053_1        DEMO     I7053.P1 1       115200          1         1      10      1        1           0            1            
REM ===========================================================================================================================
call :I7053_PROXY_END %* >> %proxycfg%
goto :EOF

:I7053
call :I7053_SET %*
call :I7053_HDW %*   >> %hdwcfg%
call :I7053_SIM %*   >> %simcfg%
call :I7053_DIC %*   >> %diccfg%
call :I7053_DIS %*   >> %discfg%
if not %lastport% == %RS485Port% (call :I7053_PROXY)
call :I7053_TABCRC   >> %tabcrc%
set /a numdev=numdev+1
set /a CTRL_TOP+=CTRL_TOP_STEP
set /a CTRL_TOP_IO+=CTRL_TOP_STEP
if "%numdev%" == "10" ( set /a CTRL_LEFT=CTRL_LEFT+465 )
if "%numdev%" == "10" ( set /a CTRL_TOP=0 )
goto :EOF


:I7053_PROXY
if "%ConnectionType%" == "COM" (call :I7053_PROXY_COM %* >> %proxycfg%)
if "%ConnectionType%" == "TCP" (call :I7053_PROXY_TCP %* >> %proxycfg%)
goto :EOF

:I7053_SET
set "ConnectionType=%~1" & shift &
set "DevLabel=%~1"       & shift &
set "FACN=%~1"           & shift & :: FACN - Facility name
set "IDEN=%~1"           & shift & :: IDEN - Identifier
set "ComPort=%~1"        & set "TCPPort=%~1"    & shift & :: Physical COM Port number
set "ComBaudrate=%~1"    & set "TCPClient=%~1"      & shift & :: Physical COM Port baudrate or IP
set "RS485Port=%~1"      & shift & :: Logical RS485 Port number
set "RS485UnitId=%~1"    & shift & :: RS485 Unit Id
set "RS485Polling=%~1"   & shift & :: RS485 Polling period, ms
set "CheckSum=%~1"       & shift & :: Use CheckSum
set "WDReconnect=%~1"    & shift & :: Do Reset State WD if WD event
set "DelayOnStart=%~1"   & shift & :: Wait time that device connected
set "InvertedData=%~1"   & shift & :: Invert Data
set "FACP=%FACN:.=/%"            & :: Facility   DIM  path, i.e. FACN name with . to / replacement
set "FACF=%FACN:.=_%"            & :: Facility   file name, i.e. FACN name with . to _ replacement
set "IDNP=%IDEN:.=/%"            & :: Identifier file name, i.e. IDEN name with . to / replacement
set "IDNF=%IDEN:.=_%"            & :: Identifier file name, i.e. IDEN name with . to _ replacement
set "SpDevLabel=%DevLabel:_= %"  & :: Device label with _ to space replacement
goto :EOF

:I7053_PROXY_INIT
echo [TagList]
echo RS485PROXY.BYTERATE.RX  = Real 0
echo RS485PROXY.BYTERATE.TX  = Real 0
echo RS485PROXY.POLLRATE.RX  = Real 0
echo RS485PROXY.POLLRATE.TX  = Real 0
echo RS485PROXY.BUGSRATE.RX  = Real 0
echo RS485PROXY.BUGSRATE.TX  = Real 0
echo RS485PROXY.BUGSRATE.EX  = Real 0
echo RS485PROXY.BYTECOUNT.RX = Real 0
echo RS485PROXY.BYTECOUNT.TX = Real 0
echo RS485PROXY.POLLCOUNT.RX = Real 0
echo RS485PROXY.POLLCOUNT.TX = Real 0
echo RS485PROXY.BUGSCOUNT.RX = Real 0
echo RS485PROXY.BUGSCOUNT.TX = Real 0
echo RS485PROXY.BUGSCOUNT.EX = Real 0
echo []
echo.
echo [^&RS485Proxy.StartupScript]
echo @Reset
echo ;--- Задание таблицы портов (порт,протокол,описание)
echo ;--- Задание счетчиков приема/передачи/ошибок
goto :EOF

:I7053_PROXY_COM
echo ;--- Логический порт %RS485Port%
echo @Port %RS485Port% com port %ComPort% baudrate %ComBaudrate% parity none databits 8 stopbits 1
echo @PortByteCounters %RS485Port% RS485PROXY.BYTECOUNT.RX, RS485PROXY.BYTECOUNT.TX
echo @PortPollCounters %RS485Port% RS485PROXY.POLLCOUNT.RX, RS485PROXY.POLLCOUNT.TX
echo @PortErrorCounters %RS485Port% RS485PROXY.BUGSCOUNT.RX, RS485PROXY.BUGSCOUNT.TX, RS485PROXY.BUGSCOUNT.EX
echo @PortByteRates %RS485Port% RS485PROXY.BYTERATE.RX, RS485PROXY.BYTERATE.TX
echo @PortPollRates %RS485Port% RS485PROXY.POLLRATE.RX, RS485PROXY.POLLRATE.TX
echo @PortErrorRates %RS485Port% RS485PROXY.BUGSRATE.RX, RS485PROXY.BUGSRATE.TX, RS485PROXY.BUGSRATE.EX
echo @TimeGap %RS485Port% 0
set "lastport=%RS485Port%"
goto :EOF

:I7053_PROXY_TCP
echo ;--- Логический порт %RS485Port%
echo @Port %RS485Port% tcp port %TCPPort% client %TCPClient%
echo @PortByteCounters %RS485Port% RS485PROXY.BYTECOUNT.RX, RS485PROXY.BYTECOUNT.TX
echo @PortPollCounters %RS485Port% RS485PROXY.POLLCOUNT.RX, RS485PROXY.POLLCOUNT.TX
echo @PortErrorCounters %RS485Port% RS485PROXY.BUGSCOUNT.RX, RS485PROXY.BUGSCOUNT.TX, RS485PROXY.BUGSCOUNT.EX
echo @PortByteRates %RS485Port% RS485PROXY.BYTERATE.RX, RS485PROXY.BYTERATE.TX
echo @PortPollRates %RS485Port% RS485PROXY.POLLRATE.RX, RS485PROXY.POLLRATE.TX
echo @PortErrorRates %RS485Port% RS485PROXY.BUGSRATE.RX, RS485PROXY.BUGSRATE.TX, RS485PROXY.BUGSRATE.EX
echo @TimeGap %RS485Port% 0
set "lastport=%RS485Port%"
goto :EOF

:I7053_PROXY_END
echo ;--- 
echo @ZeroPortCounters
echo @View
echo @CpuProfiler start 1 60 7
echo []
goto :EOF

:I7053_HDW
echo ;***************************
echo ;*****Driver for I7053******
echo ;***************************
echo [DeviceList]
echo ^&%FACN%.%IDEN%.CTRL = device software Program
echo [^&%FACN%.%IDEN%.CTRL]
echo Comment = Driver for IcpCon i-7053
echo InquiryPeriod = 0
echo DevicePolling = 1, tpNormal
echo DigitalFifo   = 1024
echo AnalogFifo    = 1024
echo ProgramSource    = ../daqpas/i7053_drv.pas
echo ProgramSource    = ~~/resource/daqsite/rs485proxy/drivers/icp-das/i7053_drv.pas
echo tagPrefix        = %FACN%.%IDEN%
echo OpenConsole      = 2         ; 0/1/2=Close/Show/Hide
echo DebugFlags       = 3         ; 1/2/4/8=Trouble/Success/Export/Import
echo EncryptMethod    = RC6
echo TrustedUsers     = [TrustedUsers]
echo DIM_GuiClickTag  = %FACN%.%IDEN%.DIMGUICLICK
echo RS485Port        = %RS485Port%
echo RS485UnitId      = %RS485UnitId%
echo RS485Timeout     = 250
echo RS485Deadline    = 60000
echo RS485Polling     = %RS485Polling%
echo Simulator        = 0         ; Must be 0 for driver
echo Checksum         = %CheckSum%         ; Checksum 0/1
echo WDReconnect      = %WDReconnect%         ; Watchdog Reconnect
echo DelayOnStart     = %DelayOnStart%     ;
echo InvertedData     = %InvertedData%     ; 0 - состояние цифровых входов, как есть/ 1 - инвертированные данные
echo DigitalOutputs   = 20        ; Количество кривых
echo Link DigitalOutput 0  with curve %FACN%.%IDEN%.STATE    history 1024 ; Состояние устройства
echo Link DigitalOutput 1  with curve %FACN%.%IDEN%.DIDATA   history 1024 ; Данные состояния цифровых входов
echo Link DigitalOutput 2  with curve %FACN%.%IDEN%.CNT.DI1  history 1024 ; Счетчик цифрового входа 1
echo Link DigitalOutput 3  with curve %FACN%.%IDEN%.CNT.DI2  history 1024 ; Счетчик цифрового входа 2
echo Link DigitalOutput 4  with curve %FACN%.%IDEN%.CNT.DI3  history 1024 ; Счетчик цифрового входа 3
echo Link DigitalOutput 5  with curve %FACN%.%IDEN%.CNT.DI4  history 1024 ; Счетчик цифрового входа 4
echo Link DigitalOutput 6  with curve %FACN%.%IDEN%.CNT.DI5  history 1024 ; Счетчик цифрового входа 5
echo Link DigitalOutput 7  with curve %FACN%.%IDEN%.CNT.DI6  history 1024 ; Счетчик цифрового входа 6
echo Link DigitalOutput 8  with curve %FACN%.%IDEN%.CNT.DI7  history 1024 ; Счетчик цифрового входа 7
echo Link DigitalOutput 9  with curve %FACN%.%IDEN%.CNT.DI8  history 1024 ; Счетчик цифрового входа 8
echo Link DigitalOutput 10 with curve %FACN%.%IDEN%.CNT.DI9  history 1024 ; Счетчик цифрового входа 9
echo Link DigitalOutput 11 with curve %FACN%.%IDEN%.CNT.DI10 history 1024 ; Счетчик цифрового входа 10
echo Link DigitalOutput 12 with curve %FACN%.%IDEN%.CNT.DI11 history 1024 ; Счетчик цифрового входа 11
echo Link DigitalOutput 13 with curve %FACN%.%IDEN%.CNT.DI12 history 1024 ; Счетчик цифрового входа 12
echo Link DigitalOutput 14 with curve %FACN%.%IDEN%.CNT.DI13 history 1024 ; Счетчик цифрового входа 13
echo Link DigitalOutput 15 with curve %FACN%.%IDEN%.CNT.DI14 history 1024 ; Счетчик цифрового входа 14
echo Link DigitalOutput 16 with curve %FACN%.%IDEN%.CNT.DI15 history 1024 ; Счетчик цифрового входа 15
echo Link DigitalOutput 17 with curve %FACN%.%IDEN%.CNT.DI16 history 1024 ; Счетчик цифрового входа 16
echo Link DigitalOutput 18 with curve %FACN%.%IDEN%.RX       history 1024 ; Rx
echo Link DigitalOutput 19 with curve %FACN%.%IDEN%.TX       history 1024 ; Tx
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ../../demo_data/i7053/%IDNF%_custom.ini
echo CustomIniSection  = [%IDEN%.CustomParameters]
echo CustomIniBackups  = ../../demo_data/i7053/custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 0
echo []
echo [ConfigFileList]
echo ConfigFile = ../../demo_data/i7053/%IDNF%_custom.ini
echo []
echo [%IDEN%.CustomParameters.TagList]
echo TagList = DEMO.%IDEN%.POLL
echo []
echo [DataStorage]
echo %FACN%.%IDEN%.STATE    = Curve 0 1000 Black 0  1 ; Состояние устройства
echo %FACN%.%IDEN%.DIDATA   = Curve 0 1000 Black 0  1 ; Данные состояния цифровых входов
echo %FACN%.%IDEN%.CNT.DI1  = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 1
echo %FACN%.%IDEN%.CNT.DI2  = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 2
echo %FACN%.%IDEN%.CNT.DI3  = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 3
echo %FACN%.%IDEN%.CNT.DI4  = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 4
echo %FACN%.%IDEN%.CNT.DI5  = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 5
echo %FACN%.%IDEN%.CNT.DI6  = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 6
echo %FACN%.%IDEN%.CNT.DI7  = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 7
echo %FACN%.%IDEN%.CNT.DI8  = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 8
echo %FACN%.%IDEN%.CNT.DI9  = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 9
echo %FACN%.%IDEN%.CNT.DI10 = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 10
echo %FACN%.%IDEN%.CNT.DI11 = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 11
echo %FACN%.%IDEN%.CNT.DI12 = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 12
echo %FACN%.%IDEN%.CNT.DI13 = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 13
echo %FACN%.%IDEN%.CNT.DI14 = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 14
echo %FACN%.%IDEN%.CNT.DI15 = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 15
echo %FACN%.%IDEN%.CNT.DI16 = Curve 0 1000 Black 0  1 ; Счетчик цифрового входа 16
echo %FACN%.%IDEN%.RX       = Curve 0 1000 Black 0  1 ; ; Rx
echo %FACN%.%IDEN%.TX       = Curve 0 1000 Black 0  1 ; ; Tx
echo []
echo [TagList]
echo %FACN%.%IDEN%.DIMGUICLICK = string  ? ; Обрабочик "кликов" по DIM-серверу ( The DIM click sensor data )
echo %FACN%.%IDEN%.DIMCMDMY    = string  ? ; Обработчик команд от клиента      ( The DIM command handler   )
echo %FACN%.%IDEN%.SERVMODE    = Integer 2 ; Режим работы запущенной системы
echo %FACN%.%IDEN%.POLL        = Integer 1 ; Активация окна для выбора команд для опроса
echo %FACN%.%IDEN%.POLL.NOTIFY = Integer 0 ; Тег подтверждения выбора команд для опроса
echo %FACN%.%IDEN%.RX          = Integer 0 ; Скорость получения данных
echo %FACN%.%IDEN%.TX          = Integer 0 ; Скорость отправки данных
echo %FACN%.%IDEN%.STATE       = Integer 0 ; Состояние устройства
echo %FACN%.%IDEN%.DIDATA      = Integer 0 ; Значение цифровых входов
echo %FACN%.%IDEN%.INVERT      = Integer 0 ; Инвертировать значение цифровых входов
echo %FACN%.%IDEN%.DI1         = Integer 0 ; Значение цифрового входа 1
echo %FACN%.%IDEN%.DI2         = Integer 0 ; Значение цифрового входа 2
echo %FACN%.%IDEN%.DI3         = Integer 0 ; Значение цифрового входа 3
echo %FACN%.%IDEN%.DI4         = Integer 0 ; Значение цифрового входа 4
echo %FACN%.%IDEN%.DI5         = Integer 0 ; Значение цифрового входа 5
echo %FACN%.%IDEN%.DI6         = Integer 0 ; Значение цифрового входа 6
echo %FACN%.%IDEN%.DI7         = Integer 0 ; Значение цифрового входа 7
echo %FACN%.%IDEN%.DI8         = Integer 0 ; Значение цифрового входа 8
echo %FACN%.%IDEN%.DI9         = Integer 0 ; Значение цифрового входа 9
echo %FACN%.%IDEN%.DI10        = Integer 0 ; Значение цифрового входа 10
echo %FACN%.%IDEN%.DI11        = Integer 0 ; Значение цифрового входа 11
echo %FACN%.%IDEN%.DI12        = Integer 0 ; Значение цифрового входа 12
echo %FACN%.%IDEN%.DI13        = Integer 0 ; Значение цифрового входа 13
echo %FACN%.%IDEN%.DI14        = Integer 0 ; Значение цифрового входа 14
echo %FACN%.%IDEN%.DI15        = Integer 0 ; Значение цифрового входа 15
echo %FACN%.%IDEN%.DI16        = Integer 0 ; Значение цифрового входа 16
echo %FACN%.%IDEN%.CNT.DI1     = Integer 0 ; Значение счетчика входа 1
echo %FACN%.%IDEN%.CNT.DI2     = Integer 0 ; Значение счетчика входа 2
echo %FACN%.%IDEN%.CNT.DI3     = Integer 0 ; Значение счетчика входа 3
echo %FACN%.%IDEN%.CNT.DI4     = Integer 0 ; Значение счетчика входа 4
echo %FACN%.%IDEN%.CNT.DI5     = Integer 0 ; Значение счетчика входа 5
echo %FACN%.%IDEN%.CNT.DI6     = Integer 0 ; Значение счетчика входа 6
echo %FACN%.%IDEN%.CNT.DI7     = Integer 0 ; Значение счетчика входа 7
echo %FACN%.%IDEN%.CNT.DI8     = Integer 0 ; Значение счетчика входа 8
echo %FACN%.%IDEN%.CNT.DI9     = Integer 0 ; Значение счетчика входа 9
echo %FACN%.%IDEN%.CNT.DI10    = Integer 0 ; Значение счетчика входа 10
echo %FACN%.%IDEN%.CNT.DI11    = Integer 0 ; Значение счетчика входа 11
echo %FACN%.%IDEN%.CNT.DI12    = Integer 0 ; Значение счетчика входа 12
echo %FACN%.%IDEN%.CNT.DI13    = Integer 0 ; Значение счетчика входа 13
echo %FACN%.%IDEN%.CNT.DI14    = Integer 0 ; Значение счетчика входа 14
echo %FACN%.%IDEN%.CNT.DI15    = Integer 0 ; Значение счетчика входа 15
echo %FACN%.%IDEN%.CNT.DI16    = Integer 0 ; Значение счетчика входа 16
echo %FACN%.%IDEN%.NAME        = String  Null ; Имя устройства
echo %FACN%.%IDEN%.VERSION     = String  Null ; Версия устройства
echo %FACN%.%IDEN%.ADDRESS     = Integer 0 ; Адрес устройства
echo %FACN%.%IDEN%.BAUDRATE    = Integer 0 ; Скорость бод устройства
echo %FACN%.%IDEN%.CHECKSUM    = Integer 0 ; Производить контроль CHECKSUM?
echo %FACN%.%IDEN%.PARITY      = Integer 0 ; Параметры PARITY
echo %FACN%.%IDEN%.WDTIMEOUT   = Real 0    ; Значение WatchDog TimeOut
echo %FACN%.%IDEN%.WDSTATUS    = Integer 0 ; Состояние WatcDog
echo %FACN%.%IDEN%.WDENDIS     = Integer 0 ; Вкл./выкл. WatchDog
echo []
echo [Windows]
echo %FACN%.%IDEN%.CTRL = Circuit_Window
echo [%FACN%.%IDEN%.CTRL]
echo Circuit = ../circuits/i7053_ctrl.crc
echo Link sensor I7053.POLL          with tag   %FACN%.%IDEN%.POLL          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.NAME          with tag   %FACN%.%IDEN%.NAME          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.VERSION       with tag   %FACN%.%IDEN%.VERSION       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.RX            with curve %FACN%.%IDEN%.RX            device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.TX            with curve %FACN%.%IDEN%.TX            device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.ADDRESS       with tag   %FACN%.%IDEN%.ADDRESS       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.BAUDRATE      with tag   %FACN%.%IDEN%.BAUDRATE      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CHECKSUM      with tag   %FACN%.%IDEN%.CHECKSUM      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.PARITY        with tag   %FACN%.%IDEN%.PARITY        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI1           with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI2           with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI3           with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI4           with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI5           with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI6           with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI7           with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI8           with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI9           with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI10          with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI11          with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI12          with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI13          with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI14          with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI15          with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DI16          with tag   %FACN%.%IDEN%.DIDATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI1       with tag   %FACN%.%IDEN%.CNT.DI1       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI2       with tag   %FACN%.%IDEN%.CNT.DI2       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI3       with tag   %FACN%.%IDEN%.CNT.DI3       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI4       with tag   %FACN%.%IDEN%.CNT.DI4       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI5       with tag   %FACN%.%IDEN%.CNT.DI5       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI6       with tag   %FACN%.%IDEN%.CNT.DI6       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI7       with tag   %FACN%.%IDEN%.CNT.DI7       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI8       with tag   %FACN%.%IDEN%.CNT.DI8       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI9       with tag   %FACN%.%IDEN%.CNT.DI9       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI10      with tag   %FACN%.%IDEN%.CNT.DI10      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI11      with tag   %FACN%.%IDEN%.CNT.DI11      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI12      with tag   %FACN%.%IDEN%.CNT.DI12      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI13      with tag   %FACN%.%IDEN%.CNT.DI13      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI14      with tag   %FACN%.%IDEN%.CNT.DI14      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI15      with tag   %FACN%.%IDEN%.CNT.DI15      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI16      with tag   %FACN%.%IDEN%.CNT.DI16      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI1.RST   with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI2.RST   with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI3.RST   with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI4.RST   with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI5.RST   with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI6.RST   with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI7.RST   with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI8.RST   with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI9.RST   with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI10.RST  with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI11.RST  with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI12.RST  with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI13.RST  with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI14.RST  with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI15.RST  with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.CNT.DI16.RST  with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.LABEL         with                                       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.WDTIMEOUT     with tag   %FACN%.%IDEN%.WDTIMEOUT     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.WDENDIS       with tag   %FACN%.%IDEN%.WDENDIS       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.WDSTATUS      with tag   %FACN%.%IDEN%.WDSTATUS      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.DIDATA.INV    with tag   %FACN%.%IDEN%.INVERT        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7053.STATE         with curve %FACN%.%IDEN%.STATE         device ^&%FACN%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FACN%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinShow %FACN%.%IDEN%.CTRL
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=465^|Height=402^|Options=+Top,+Left,-Width,-Height
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=-ViewScrollLeft,-ViewScrollRight,-ViewScrollUp,-ViewScrollDown
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.tab %FACN%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SHOW @WinShow %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HIDE @WinHide %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SELECT @WinSelect %FACN%.%IDEN%.CTRL
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FACN%.%IDEN%.CTRL.HOME
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FACN%.%IDEN%.CTRL.HIDE
echo []
echo [%mainprefix%.MAIN.CTRL]
echo Link sensor @cron+@cron.run+%FACN%.%IDEN%.CTRL.SELECT with device ^&%mainprefix%.MAIN.CTRL
echo Link Sensor SYSTEMMODE               with tag   %FACN%.%IDEN%.SERVMODE  device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.STATE  with curve %FACN%.%IDEN%.STATE  device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI1    with tag   %FACN%.%IDEN%.DI1    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI2    with tag   %FACN%.%IDEN%.DI2    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI3    with tag   %FACN%.%IDEN%.DI3    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI4    with tag   %FACN%.%IDEN%.DI4    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI5    with tag   %FACN%.%IDEN%.DI5    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI6    with tag   %FACN%.%IDEN%.DI6    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI7    with tag   %FACN%.%IDEN%.DI7    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI8    with tag   %FACN%.%IDEN%.DI8    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI9    with tag   %FACN%.%IDEN%.DI9    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI10   with tag   %FACN%.%IDEN%.DI10   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI11   with tag   %FACN%.%IDEN%.DI11   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI12   with tag   %FACN%.%IDEN%.DI12   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI13   with tag   %FACN%.%IDEN%.DI13   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI14   with tag   %FACN%.%IDEN%.DI14   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI15   with tag   %FACN%.%IDEN%.DI15   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DI16   with tag   %FACN%.%IDEN%.DI16   device ^&%FACN%.%IDEN%.CTRL
echo []
echo [Windows]
echo %FACN%.%IDEN%.PARAM.PLOT = Curve_Window
echo [%FACN%.%IDEN%.PARAM.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.25
echo AxisY = ^^CState channel^^N^^L___{Status}, 0, 1000
echo CurveList = %FACN%.%IDEN%.STATE     ; Состояние устройства
echo CurveList = %FACN%.%IDEN%.DIDATA    ; Данные состояния цифровых входов
echo CurveList = %FACN%.%IDEN%.CNT.DI1   ; Счетчик цифрового входа 1
echo CurveList = %FACN%.%IDEN%.CNT.DI2   ; Счетчик цифрового входа 2
echo CurveList = %FACN%.%IDEN%.CNT.DI3   ; Счетчик цифрового входа 3
echo CurveList = %FACN%.%IDEN%.CNT.DI4   ; Счетчик цифрового входа 4
echo CurveList = %FACN%.%IDEN%.CNT.DI5   ; Счетчик цифрового входа 5
echo CurveList = %FACN%.%IDEN%.CNT.DI6   ; Счетчик цифрового входа 6
echo CurveList = %FACN%.%IDEN%.CNT.DI7   ; Счетчик цифрового входа 7
echo CurveList = %FACN%.%IDEN%.CNT.DI8   ; Счетчик цифрового входа 8
echo CurveList = %FACN%.%IDEN%.CNT.DI9   ; Счетчик цифрового входа 9
echo CurveList = %FACN%.%IDEN%.CNT.DI10  ; Счетчик цифрового входа 10
echo CurveList = %FACN%.%IDEN%.CNT.DI11  ; Счетчик цифрового входа 11
echo CurveList = %FACN%.%IDEN%.CNT.DI12  ; Счетчик цифрового входа 12
echo CurveList = %FACN%.%IDEN%.CNT.DI13  ; Счетчик цифрового входа 13
echo CurveList = %FACN%.%IDEN%.CNT.DI14  ; Счетчик цифрового входа 14
echo CurveList = %FACN%.%IDEN%.CNT.DI15  ; Счетчик цифрового входа 15
echo CurveList = %FACN%.%IDEN%.CNT.DI16  ; Счетчик цифрового входа 16
echo CurveList = %FACN%.%IDEN%.RX        ; Rx
echo CurveList = %FACN%.%IDEN%.TX        ; Tx
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.HOME 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinShow %FACN%.%IDEN%.PARAM.PLOT
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FACN%.%IDEN%.PARAM.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000^|Options=+Top,+Left,-Width,-Height
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FACN%.%IDEN%.PARAM.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.SHOW 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.SHOW @WinShow %FACN%.%IDEN%.PARAM.PLOT
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.HIDE 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HIDE @WinHide %FACN%.%IDEN%.PARAM.PLOT
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.SELECT 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.SELECT @WinSelect %FACN%.%IDEN%.PARAM.PLOT
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FACN%.%IDEN%.PARAM.PLOT.HOME
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FACN%.%IDEN%.PARAM.PLOT.HIDE
echo []
echo [^&DATSRV]
echo CurveList = %FACN%.%IDEN%.STATE    ; Состояние устройства
echo CurveList = %FACN%.%IDEN%.DIDATA   ; Данные состояния цифровых входов
echo CurveList = %FACN%.%IDEN%.CNT.DI1  ; Счетчик цифрового входа 1
echo CurveList = %FACN%.%IDEN%.CNT.DI2  ; Счетчик цифрового входа 2
echo CurveList = %FACN%.%IDEN%.CNT.DI3  ; Счетчик цифрового входа 3
echo CurveList = %FACN%.%IDEN%.CNT.DI4  ; Счетчик цифрового входа 4
echo CurveList = %FACN%.%IDEN%.CNT.DI5  ; Счетчик цифрового входа 5
echo CurveList = %FACN%.%IDEN%.CNT.DI6  ; Счетчик цифрового входа 6
echo CurveList = %FACN%.%IDEN%.CNT.DI7  ; Счетчик цифрового входа 7
echo CurveList = %FACN%.%IDEN%.CNT.DI8  ; Счетчик цифрового входа 8
echo CurveList = %FACN%.%IDEN%.CNT.DI9  ; Счетчик цифрового входа 9
echo CurveList = %FACN%.%IDEN%.CNT.DI10 ; Счетчик цифрового входа 10
echo CurveList = %FACN%.%IDEN%.CNT.DI11 ; Счетчик цифрового входа 11
echo CurveList = %FACN%.%IDEN%.CNT.DI12 ; Счетчик цифрового входа 12
echo CurveList = %FACN%.%IDEN%.CNT.DI13 ; Счетчик цифрового входа 13
echo CurveList = %FACN%.%IDEN%.CNT.DI14 ; Счетчик цифрового входа 14
echo CurveList = %FACN%.%IDEN%.CNT.DI15 ; Счетчик цифрового входа 15
echo CurveList = %FACN%.%IDEN%.CNT.DI16 ; Счетчик цифрового входа 16
echo CurveList = %FACN%.%IDEN%.RX       ; Rx
echo CurveList = %FACN%.%IDEN%.TX       ; Tx
echo CurveList = 
echo []
echo [DeviceList]
echo ^&%FACN%.%IDEN%.POLL.ENABLE = device software dialog
echo [^&%FACN%.%IDEN%.POLL.ENABLE]
echo DialogSection = ^&%FACN%.%IDEN%.POLL.ENABLE.Section ; Имя секции с описанием диалога
echo CloseOnEnter = 1                 ; Закрывать диалог по Enter,Esc?
echo DebugMode = 0                    ; Выводить сообщения в файл отладки?
echo Adjustment = 1                   ; Диалог при открытии выравнивать по положению мыши?
echo NotifyTag = %FACN%.%IDEN%.POLL.NOTIFY ; Уведомление о нажатии 1=Ok,2=Cancel
echo []
echo [^&%FACN%.%IDEN%.POLL.ENABLE.Section]
echo Dialog       0   0   295 200 Выбор команд для опроса
echo CheckBoxes   5   35  285 160 %FACN%.%IDEN%.POLL 22
echo  Состояние цифровых входов
echo  Cтатус WatchDog
echo  Значение WatchDog TimeOut
echo  Конфигурация устройства
echo  Версия устройства
echo  Имя устройства
echo  Счетчик цифрового входа 1
echo  Счетчик цифрового входа 2
echo  Счетчик цифрового входа 3
echo  Счетчик цифрового входа 4
echo  Счетчик цифрового входа 5
echo  Счетчик цифрового входа 6
echo  Счетчик цифрового входа 7
echo  Счетчик цифрового входа 8
echo  Счетчик цифрового входа 9
echo  Счетчик цифрового входа 10
echo  Счетчик цифрового входа 11
echo  Счетчик цифрового входа 12
echo  Счетчик цифрового входа 13
echo  Счетчик цифрового входа 14
echo  Счетчик цифрового входа 15
echo  Счетчик цифрового входа 16
echo []
goto :EOF

:I7053_SIM
echo [^&%FACN%.%IDEN%.CTRL]
echo Simulator = 1
echo []
rem Include hardware config if one not done yet
if "%numhdwcfg%" == "0" ( set /a numhdwcfg=numhdwcfg+1 ) else ( goto :EOF )
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
echo.
goto :EOF

:I7053_DIS
unix dimcfg ^
  -n section "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd   %FACP%/%IDNP%/DIMGUICLICK ^
  -n tag        %FACN%.%IDEN%.DIMGUICLICK ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dis_cmnd   %FACP%/%IDNP%/DIMCMDMY ^
  -n tag        %FACN%.%IDEN%.DIMCMDMY ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DIMCMDMY=%%**" ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMGUICLICK ^
  -n tag        %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMCMDMY ^
  -n tag        %FACN%.%IDEN%.DIMCMDMY ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/POLL ^
  -n tag        %FACN%.%IDEN%.POLL ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/STATE ^
  -n tag        %FACN%.%IDEN%.STATE ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/RX+TX ^
  -n tag        %FACN%.%IDEN%.RX ^
  -n tag        %FACN%.%IDEN%.TX ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/INVERT ^
  -n tag        %FACN%.%IDEN%.INVERT ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/DIDATA+DI1+DI2+DI3+DI4+DI5+DI6+DI7+DI8+DI9+DI10+DI11+DI12+DI13+DI14+DI15+DI16 ^
  -n tag        %FACN%.%IDEN%.DIDATA ^
  -n tag        %FACN%.%IDEN%.DI1 ^
  -n tag        %FACN%.%IDEN%.DI2 ^
  -n tag        %FACN%.%IDEN%.DI3 ^
  -n tag        %FACN%.%IDEN%.DI4 ^
  -n tag        %FACN%.%IDEN%.DI5 ^
  -n tag        %FACN%.%IDEN%.DI6 ^
  -n tag        %FACN%.%IDEN%.DI7 ^
  -n tag        %FACN%.%IDEN%.DI8 ^
  -n tag        %FACN%.%IDEN%.DI9 ^
  -n tag        %FACN%.%IDEN%.DI10 ^
  -n tag        %FACN%.%IDEN%.DI11 ^
  -n tag        %FACN%.%IDEN%.DI12 ^
  -n tag        %FACN%.%IDEN%.DI13 ^
  -n tag        %FACN%.%IDEN%.DI14 ^
  -n tag        %FACN%.%IDEN%.DI15 ^
  -n tag        %FACN%.%IDEN%.DI16 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI1 ^
  -n tag        %FACN%.%IDEN%.CNT.DI1 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI2 ^
  -n tag        %FACN%.%IDEN%.CNT.DI2 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI3 ^
  -n tag        %FACN%.%IDEN%.CNT.DI3 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI4 ^
  -n tag        %FACN%.%IDEN%.CNT.DI4 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI5 ^
  -n tag        %FACN%.%IDEN%.CNT.DI5 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI6 ^
  -n tag        %FACN%.%IDEN%.CNT.DI6 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI7 ^
  -n tag        %FACN%.%IDEN%.CNT.DI7 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI8 ^
  -n tag        %FACN%.%IDEN%.CNT.DI8 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI9 ^
  -n tag        %FACN%.%IDEN%.CNT.DI9 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI10 ^
  -n tag        %FACN%.%IDEN%.CNT.DI10 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI11 ^
  -n tag        %FACN%.%IDEN%.CNT.DI11 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI12 ^
  -n tag        %FACN%.%IDEN%.CNT.DI12 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI13 ^
  -n tag        %FACN%.%IDEN%.CNT.DI13 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI14 ^
  -n tag        %FACN%.%IDEN%.CNT.DI14 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI15 ^
  -n tag        %FACN%.%IDEN%.CNT.DI15 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CNT_DI16 ^
  -n tag        %FACN%.%IDEN%.CNT.DI16 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/NAME ^
  -n tag        %FACN%.%IDEN%.NAME ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/VERSION ^
  -n tag        %FACN%.%IDEN%.VERSION ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/ADDRESS ^
  -n tag        %FACN%.%IDEN%.ADDRESS ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/BAUDRATE ^
  -n tag        %FACN%.%IDEN%.BAUDRATE ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CHECKSUM ^
  -n tag        %FACN%.%IDEN%.CHECKSUM ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/PARITY ^
  -n tag        %FACN%.%IDEN%.PARITY ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WDTIMEOUT ^
  -n tag        %FACN%.%IDEN%.WDTIMEOUT ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WDSTATUS ^
  -n tag        %FACN%.%IDEN%.WDSTATUS ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WDENDIS ^
  -n tag        %FACN%.%IDEN%.WDENDIS ^
  -n end ^
echo.
goto :EOF

:I7053_DIC
unix dimcfg ^
  -n section "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMGUICLICK ^
  -n tag        %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMCMDMY ^
  -n tag        %FACN%.%IDEN%.DIMCMDMY ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/POLL ^
  -n tag        %FACN%.%IDEN%.POLL ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/STATE ^
  -n tag        %FACN%.%IDEN%.STATE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.STATE" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/RX+TX ^
  -n tag        %FACN%.%IDEN%.RX ^
  -n tag        %FACN%.%IDEN%.TX ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.RX" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.TX" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/INVERT ^
  -n tag        %FACN%.%IDEN%.INVERT ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/DIDATA+DI1+DI2+DI3+DI4+DI5+DI6+DI7+DI8+DI9+DI10+DI11+DI12+DI13+DI14+DI15+DI16 ^
  -n tag        %FACN%.%IDEN%.DIDATA ^
  -n tag        %FACN%.%IDEN%.DI1 ^
  -n tag        %FACN%.%IDEN%.DI2 ^
  -n tag        %FACN%.%IDEN%.DI3 ^
  -n tag        %FACN%.%IDEN%.DI4 ^
  -n tag        %FACN%.%IDEN%.DI5 ^
  -n tag        %FACN%.%IDEN%.DI6 ^
  -n tag        %FACN%.%IDEN%.DI7 ^
  -n tag        %FACN%.%IDEN%.DI8 ^
  -n tag        %FACN%.%IDEN%.DI9 ^
  -n tag        %FACN%.%IDEN%.DI10 ^
  -n tag        %FACN%.%IDEN%.DI11 ^
  -n tag        %FACN%.%IDEN%.DI12 ^
  -n tag        %FACN%.%IDEN%.DI13 ^
  -n tag        %FACN%.%IDEN%.DI14 ^
  -n tag        %FACN%.%IDEN%.DI15 ^
  -n tag        %FACN%.%IDEN%.DI16 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DIDATA" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI1" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI2" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI3" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI4" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI5" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI6" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI7" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI8" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI9" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI10" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI11" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI12" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI13" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI14" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI15" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DI16" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI1 ^
  -n tag        %FACN%.%IDEN%.CNT.DI1 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI1" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI2 ^
  -n tag        %FACN%.%IDEN%.CNT.DI2 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI2" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI3 ^
  -n tag        %FACN%.%IDEN%.CNT.DI3 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI3" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI4 ^
  -n tag        %FACN%.%IDEN%.CNT.DI4 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI4" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI5 ^
  -n tag        %FACN%.%IDEN%.CNT.DI5 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI5" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI6 ^
  -n tag        %FACN%.%IDEN%.CNT.DI6 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI6" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI7 ^
  -n tag        %FACN%.%IDEN%.CNT.DI7 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI7" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI8 ^
  -n tag        %FACN%.%IDEN%.CNT.DI8 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI8" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI9 ^
  -n tag        %FACN%.%IDEN%.CNT.DI9 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI9" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI10 ^
  -n tag        %FACN%.%IDEN%.CNT.DI10 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI10" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI11 ^
  -n tag        %FACN%.%IDEN%.CNT.DI11 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI11" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI12 ^
  -n tag        %FACN%.%IDEN%.CNT.DI12 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI12" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI13 ^
  -n tag        %FACN%.%IDEN%.CNT.DI13 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI13" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI14 ^
  -n tag        %FACN%.%IDEN%.CNT.DI14 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI14" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI15 ^
  -n tag        %FACN%.%IDEN%.CNT.DI15 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI15" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CNT_DI16 ^
  -n tag        %FACN%.%IDEN%.CNT.DI16 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.CNT.DI16" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/NAME ^
  -n tag        %FACN%.%IDEN%.NAME ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/VERSION ^
  -n tag        %FACN%.%IDEN%.VERSION ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/ADDRESS ^
  -n tag        %FACN%.%IDEN%.ADDRESS ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/BAUDRATE ^
  -n tag        %FACN%.%IDEN%.BAUDRATE ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CHECKSUM ^
  -n tag        %FACN%.%IDEN%.CHECKSUM ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/PARITY ^
  -n tag        %FACN%.%IDEN%.PARITY ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WDTIMEOUT ^
  -n tag        %FACN%.%IDEN%.WDTIMEOUT ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WDSTATUS ^
  -n tag        %FACN%.%IDEN%.WDSTATUS ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WDENDIS ^
  -n tag        %FACN%.%IDEN%.WDENDIS ^
  -n end ^
echo.
goto :EOF

:I7053_TABCRC
set LedFont=PT_Mono
set LedFont=PT_Sans_Caption
set /a YPOS=TABCRC_TOP+90
set /a DIPOS=YPOS+35
echo [SensorList]
echo Sensor = @cron+@cron.run+%FACN%.%IDEN%.CTRL.SELECT
echo [@cron+@cron.run+%FACN%.%IDEN%.CTRL.SELECT]
echo Pos = 10, %YPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:18\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_12_20_24_lightsteelblue1_ptmono.bmp "%SpDevLabel%"
echo Hint = %FACN%.%IDEN%.CTRL: Открыть окно управления %IDEN%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI1
echo [%FACN%.%IDEN%.DI1]
echo Pos = 10, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 1
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 1
echo Hint = Состояние канала 1 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI2
echo [%FACN%.%IDEN%.DI2]
echo Pos = 40, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 2
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 2
echo Hint = Состояние канала 2 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI3
echo [%FACN%.%IDEN%.DI3]
echo Pos = 70, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 3
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 3
echo Hint = %FACN%.%IDEN%.DI3: Состояние канала 3 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI4
echo [%FACN%.%IDEN%.DI4]
echo Pos = 100, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 4
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 4
echo Hint = %FACN%.%IDEN%.DI4: Состояние канала 4 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI5
echo [%FACN%.%IDEN%.DI5]
echo Pos = 130, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 5
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 5
echo Hint = %FACN%.%IDEN%.DI5: Состояние канала 5 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI6
echo [%FACN%.%IDEN%.DI6]
echo Pos = 160, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 6
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 6
echo Hint = %FACN%.%IDEN%.DI6: Состояние канала 6 %SpDevLabel%
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI7
echo [%FACN%.%IDEN%.DI7]
echo Pos = 190, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 7
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 7
echo Hint = %FACN%.%IDEN%.DI7: Состояние канала 7 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI8
echo [%FACN%.%IDEN%.DI8]
echo Pos = 220, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 8
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 8
echo Hint = %FACN%.%IDEN%.DI8: Состояние канала 8 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI9
echo [%FACN%.%IDEN%.DI9]
echo Pos = 250, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 9
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 9
echo Hint = %FACN%.%IDEN%.DI9: Состояние канала 9 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI10
echo [%FACN%.%IDEN%.DI10]
echo Pos = 280, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 10
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 10
echo Hint = %FACN%.%IDEN%.DI10: Состояние канала 10 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI11
echo [%FACN%.%IDEN%.DI11]
echo Pos = 310, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 11
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 11
echo Hint = %FACN%.%IDEN%.DI11: Состояние канала 11 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI12
echo [%FACN%.%IDEN%.DI12]
echo Pos = 340, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 12
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 12
echo Hint = %FACN%.%IDEN%.DI12: Состояние канала 12 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI13
echo [%FACN%.%IDEN%.DI13]
echo Pos = 370, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 13
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 13
echo Hint = %FACN%.%IDEN%.DI13: Состояние канала 13 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI14
echo [%FACN%.%IDEN%.DI14]
echo Pos = 400, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 14
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 14
echo Hint = %FACN%.%IDEN%.DI14: Состояние канала 14 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI15
echo [%FACN%.%IDEN%.DI15]
echo Pos = 430, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 15
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 15
echo Hint = %FACN%.%IDEN%.DI15: Состояние канала 15 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.DI16
echo [%FACN%.%IDEN%.DI16]
echo Pos = 460, %DIPOS%
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 16
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 16
echo Hint = %FACN%.%IDEN%.DI16: Состояние канала 16 %SpDevLabel%
echo []
echo [SensorList]
echo Sensor = %FACN%.%IDEN%.STATE
echo [%FACN%.%IDEN%.STATE]
echo Pos = 220, %YPOS%
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo LED = 0, 0, 0, *, Name:%LedFont%\Style:[Bold]\Size:18
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_silver_ptmono.bmp Выключен
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_lime_ptmono.bmp   Работает
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_red_ptmono.bmp    Timeout
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_red_ptmono.bmp    Refused
echo Tag#5 = 4, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_red_ptmono.bmp    WatchDog
echo Tag#6 = 5, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_yellow_ptmono.bmp Simulator
echo Hint = Состояние устройства %SpDevLabel%
echo []
set /a TABCRC_TOP+=TABCRC_STEP
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
