 {
 Формулятор 1 для вычисления газовой смеси установки 'TRITON'.
 Перевод давление - объем для идеального газа PV=RT
  Объем    = Давление*Емкость*273/Температура
  Давление = Объем*Температура/Емкость/273
 Ищется Объем газа в стандартных условиях (273 K, 1 атм.) в литрах по известному Давлению газа 
 в объеме Емкость при известной температуре.
 Вывод : из уравнения PV=RT следует P0V0/PV=T0/T, откуда V0=PVT0/P0/T, при P0=1 атм., T0=273 
         имеем V0=PVT0/T
 IdealGaz(Pressure,Volume,Capacity,TemperatureK,PressureToVolume) переводит давление газа
 в емкости Capacity при температуре TemperatureK Кельвин в объем газа в стандартных условиях
 IdealGaz(Pressure,Volume,Capacity,TemperatureK,VolumeToPressure) переводит объем газа в стандартных условиях
 в давление газа в емкости Capacity при температуре TemperatureK Кельвин 
 }

library triton1;

uses _Huge, _Str, _crwdll, WinAPI, DOS, _lsqpoly, _dpmi;

const
 T0K               = 273.15; { Температура 0 градусов по Кельвину }
 Imax              = 19.7;   { Максимальный ток 'Сапфира', мА     }

 {
 Перевод давление <-> ток для 'Сапфира'
 Sapfir(Pressure,Current,PressureToCurrent) переводит давление Pressure в ток Current
 Sapfir(Pressure,Current,CurrentToPressure) переводит ток Current в давление Pressure
 }
const
 PressureToCurrent = true;
 CurrentToPressure = false;
procedure Sapfir(var Pressure,Current:double; PressureToCurrent:boolean);
const
 TableLength  = 11;    
 PI_Table : array[0..1] of array[0..TableLength-1] of double =
 ((0,    1,    2,    3,    4,     5,     6,     7,     8,     9,     10   ), {давление}
  (3.99, 5.56, 7.15, 8.74, 10.34, 11.94, 13.54, 15.14, 16.74, 18.35, 19.96));{ток}
var  Poly:TPolynom;
begin
 Poly.Init(2,0,1);               
 if PressureToCurrent then begin
  Poly.Find(PI_Table[0],PI_Table[1],TableLength);
  Current:=Poly.Get(Pressure-1);
 end else begin
  Poly.Find(PI_Table[1],PI_Table[0],TableLength);
  Pressure:=Poly.Get(Current)+1;
 end;
end;

procedure InputLine(Buff:PChar; var x,y,w1,w2:integer; Msg,Format:string);
begin
 StrPCat(Buff,
  'Label '+d2s(x)+' '+d2s(y)+' '+d2s(x+w1)+' '+d2s(y+20)+' '+Msg+CR+
  'Input '+d2s(x+w1)+' '+d2s(y)+' '+d2s(x+w2)+' '+d2s(y+20)+' '+Format+CR);
 inc(y,30);
end;

const
 NumCapacitys=4;
 Capacitys:record
  Name : array[0..NumCapacitys-1] of String[2];
  Vol  : array[0..NumCapacitys-1] of double;
 end = (
  Name : (    'V1',    'V2',    'V3', 'Vx' );
  Vol  : ( 0.06986, 1.99034, 0.43181,    0 )
 );
 idV1 = 0;
 idV2 = 1;
 idV3 = 2;
 idVx = 3;

procedure User_Defined_Script;export;
label
 ReDraw;
var
 DlgData:Record
  Capacity    : word;     { емкость  }
  Temperature : double;   { температура}
  Vx          : double;   { свободный объем }
  Volume      : double;   { объем    }
  Pressure    : double;   { давление }
  Current     : double;   { ток      }
  Direction   : word;     { тип (направление) вычисления   }
 end;
 CapacityValue,VPerP: double;   
 Buff          : PChar;
 i,x,y,w1,w2   : integer;
begin
 Buff:=AllocateMemory($8000);
 with DlgData do begin
  Capacity:=1;
  Temperature:=20; 
  Vx:=0;
  Pressure:=0;
  Volume:=0;
  Current:=0;
  Direction:=0;
 end;
ReDraw:
 StrCopy(Buff,
  'Dialog 0   0   360  310  Расчет газовой накачки для ТРИТОНА'+CR );
 StrPCat(Buff,
  'Label  10 30  120  50   Емкость,[л]'+CR+
  'Check  10 50  120 '+d2s(50+NumCapacitys*16+4)+' '+d2s(NumCapacitys)+CR);
 for i:=0 to NumCapacitys-1 do 
 StrPCat(Buff,Capacitys.Name[i]+'='+f2s(Capacitys.Vol[i])+CR);
 x:=130;
 y:=50;
 w1:=50;
 w2:=220;
 InputLine(Buff,x,y,w1,w2,'T,[°C]','%f');
 InputLine(Buff,x,y,w1,w2,'Vx,[л]','%f');
 x:=10;
 y:=120;
 w1:=130;
 w2:=340;
 InputLine(Buff,x,y,w1,w2,'Объем,[л]','%f');
 InputLine(Buff,x,y,w1,w2,'Давление,[атм]','%f');
 InputLine(Buff,x,y,w1,w2,'Ток Сапфира,[мА]','%f');
 StrPCat(Buff,
  'Label   95  208 250 218 Перевод из'+CR+
  'Radio   85  225 255 274 3'+CR+
    'Обьема в давление'+CR+
    'Давления в обьем'+CR+
    'Тока в обьем'+CR);
 StrPCat(Buff,
  'Button 10  250 75  275 '+d2s(cm_Cancel)+'Закрыть'+CR+
  'Button 265 250 330 275 '+d2s(cm_Yes)+'Перевод'+CR);
 StrPCat(Buff,  'Text   10  290 350 305 Объем=(V1+V2+V3+Vx)*Давление*273/(T+273)');
 {
 Вызов диалога
 }
 if DialogBox(Buff,@DlgData)<>cm_Cancel then with DlgData do begin
  Capacitys.Vol[idVx]:=Vx;
  CapacityValue:=0;
  for i:=idV1 to idVx do if Capacity and GetBitMaskW(i)<>0 then CapacityValue:=CapacityValue+Capacitys.Vol[i];
  VperP:=CapacityValue*T0K/(Temperature+T0K);
  case Direction of
   0:{ Обьем -> Давление }
    begin
     Pressure:=Volume/VPerP;
     Sapfir(Pressure,Current,PressureToCurrent);
    end;
   1,2:{ Давление -> Обьем, Ток -> Обьем }
    begin
     case Direction of 
      1:Sapfir(Pressure,Current,PressureToCurrent);    
      2:Sapfir(Pressure,Current,CurrentToPressure);    
     end;
     Volume:=Pressure*VPerP;
    end;
  end;
  Trouble(Current>IMax,^C'Слишком велико давление,'+CR+^C'ломаем "Сапфир" ? ');
  goto ReDraw;
 end;
 {
 Не забудем освободить память
 }
 DeallocateMemory(Buff);
end;


exports User_Defined_Script resident;
begin
end.