program HDT_CTRL;
const
 SndClick    = 'нажато';
 {
 Identify molecular peaks of chromatograph
 }
 hrHH        = 0;
 hrHD        = 1;
 hrHT        = 2;
 hrDD        = 3;
 hrDT        = 4;
 hrTT        = 5;
 {
 Identify molecular peaks of ion camera
 }
 ioHT        = 0;
 ioDT        = 1;
 ioTT        = 2;
 {
 Identify isotopes
 }
 atHH        = 0;
 atDD        = 1;
 atTT        = 2;
 {
 Use abbreviations:
 Hrm -> chromatograph
 Ion -> ion camera
 Atm -> atomic,isotope
 Btn -> buttons
 Ind -> indicators
 S   -> square
 C   -> coefficient
 }
var
 Ok          : boolean;
 errors      : integer;
 errorcode   : integer;
 b           : boolean;
 i           : integer;
 j           : integer;
 v           : real;
 tagCalcBtn  : integer;
 tagSaveBtn  : integer;
 tagSaveInd  : integer;
 tagClearBtn : integer;
 tagSHrmBtn  : array[hrHH..hrTT] of integer;
 tagSHrmInd  : array[hrHH..hrTT] of integer;
 tagSIonBtn  : array[ioHT..ioTT] of integer;
 tagSIonInd  : array[ioHT..ioTT] of integer;
 tagNIonBtn  : array[ioHT..ioTT] of integer;
 tagCHrmInd  : array[hrHH..hrTT] of integer;
 tagMConInd  : array[hrHH..hrTT] of integer;
 tagAConInd  : array[atHH..atTT] of integer;
 HrmName     : array[hrHH..hrTT] of string;
 IonName     : array[ioHT..ioTT] of string;
 Ion2Hrm     : array[ioHT..ioTT] of integer;
 IonCoef     : array[ioHT..ioTT] of real;
 Atm2Hrm     : array[atHH..atTT] of integer;
 AtmName     : array[atHH..atTT] of string;
 {
 Procedure to fix error
 }
 procedure errorfound;
 begin
  errors:=errors+1;
 end;
 {
 Calculate H/D/T
 }
 procedure CalcHandler;
 var
  i           : integer;
  Norm        : real;
  MainPeak    : integer;
  BaseHrm     : array[hrHH..hrTT] of real;
  RealHrm     : array[hrHH..hrTT] of real;
  HrmCoef     : array[hrHH..hrTT] of real;
  PercRealHrm : array[hrHH..hrTT] of real;
  PercNormHrm : array[hrHH..hrTT] of real;
  NormHrm     : array[hrHH..hrTT] of real;
  BaseIon     : array[ioHT..ioTT] of real;
  RealIon     : array[ioHT..ioTT] of real;
  AtomHrm     : array[atHH..atTT] of real;
 begin
  {
  Move tags to array for simplicity, find MainPeak uses for normalization procedure
  }
  for i:=hrHH to hrTT do begin
   BaseHrm[i]:=rgettag(tagSHrmInd[i]);
   HrmCoef[i]:=rgettag(tagCHrmInd[i]);
  end;
  MainPeak:=-1;
  for i:=ioHT to ioTT do begin
   BaseIon[i]:=rgettag(tagSIonInd[i]);
   if igettag(tagNIonBtn[i])>0 then MainPeak:=i;
  end;
  {
  Divide by sensitivity coefficients to calculate REAL peak square of chromatograph and ion camera
  }
  for i:=hrHH to hrTT do RealHrm[i] := BaseHrm[i]/HrmCoef[i];
  for i:=ioHT to ioTT do RealIon[i] := BaseIon[i]/IonCoef[i];
  {
  Calculate chromatography peaks in percents
  Assume that HH+HD+HT+DD+DT+TT = 100 % (no another gas in composition)
  }
  Norm:=0;
  for i:=hrHH to hrTT do Norm:=Norm+RealHrm[i];
  for i:=hrHH to hrTT do PercRealHrm[i]:=(RealHrm[i]/Norm)*100;
  {
  Normalization procedure: use ion camera peaks to correct chromatography peaks
  }
  for i:=hrHH to hrTT do NormHrm[i]:=RealHrm[i];
  if (MainPeak>=ioHT) and (MainPeak<=ioTT) then
  for i:=ioHT to ioTT do
  NormHrm[Ion2Hrm[i]]:=RealHrm[Ion2Hrm[MainPeak]]*RealIon[i]/RealIon[MainPeak];
  {
  Calculate corrected chromatography peaks in percents
  }
  Norm:=0;
  for i:=hrHH to hrTT do Norm:=Norm+NormHrm[i];
  for i:=hrHH to hrTT do PercNormHrm[i]:=(NormHrm[i]/Norm)*100;
  {
  Calculate isotopes
  }
  AtomHrm[atHH]:=PercNormHrm[hrHH]+0.5*(PercNormHrm[hrHD]+PercNormHrm[hrHT]);
  AtomHrm[atDD]:=PercNormHrm[hrDD]+0.5*(PercNormHrm[hrHD]+PercNormHrm[hrDT]);
  AtomHrm[atTT]:=PercNormHrm[hrTT]+0.5*(PercNormHrm[hrHT]+PercNormHrm[hrDT]);
  {
  Save result to tags
  }
  for i:=hrHH to hrTT do b:=rsettag(tagMConInd[i],PercNormHrm[i]);
  for i:=atHH to atTT do b:=rsettag(tagAConInd[i],AtomHrm[i]);
 end;
 {
 Fill string with zeros like this one: LeadZeros('12',5)='00012'
 }
 procedure LeadZeros(var s:string; n:integer);
 begin
  while length(s)<n do s:='0'+s;
 end;
 {
 Save result to file
 }
 procedure SaveHandler;
 const
  w1 = 20; 
  w2 = 20;
  w3 = 12;  d3 = 4;
  w4 = 12;  d4 = 4;
 var
  i     : integer;
  n     : integer;
  t     : real;
  fname : string;
  year  : string;
  month : string;
  day   : string;
  hour  : string;
  minut : string;
  sec   : string;
  Main  : integer;
 begin
  {
  Calculate current date/time
  }
  t:=msecnow;
  year:=str(ms2year(t));   LeadZeros(year,  4);
  month:=str(ms2month(t)); LeadZeros(month, 2);
  day:=str(ms2day(t));     LeadZeros(day,   2);
  hour:=str(ms2hour(t));   LeadZeros(hour,  2);
  minut:=str(ms2min(t));   LeadZeros(minut, 2);
  sec:=str(ms2sec(t));     LeadZeros(sec,   2);
  {
  Calculate file name 
  }
  fname:=paramstr('DAQDATAPATH')+'\'+year+month+day+'.HDT';
  b:=rsettag(tagSaveInd,rval(year+month+day));
  {
  Save result to file and to console window too
  }
  for n:=0 to 1 do begin
   if n>0 then fname:='';
   if fileexists(fname) then i:=append(fname) else i:=rewrite(fname);
   if i=0 then begin
    writeln('');
    writeln('**********************************************************************');
    writeln('H/D/T composition chromatography analysis done at ',year,'.',month,'.',day,'-',hour,':',minut,':',sec);
    writeln('  ',' ','S peak,chromatograph'        :w1,
                 ' ','S peak,ion camera'           :w2,
                 ' ','Molecular,%'                 :w3,
                 ' ','Isotope,%'                   :w4);
    writeln('H2',' ',str(rgettag(tagSHrmInd[hrHH])):w1,
                 ' ','-'                           :w2,
                 ' ',    rgettag(tagMConInd[hrHH]) :w3:d3,
                 ' ',    rgettag(tagAConInd[atHH]) :w4:d4);
    writeln('HD',' ',str(rgettag(tagSHrmInd[hrHD])):w1,
                 ' ','-'                           :w2,
                 ' ',    rgettag(tagMConInd[hrHD]) :w3:d3,
                 ' ','-'                           :w4);
    writeln('HT',' ',str(rgettag(tagSHrmInd[hrHT])):w1,
                 ' ',str(rgettag(tagSIonInd[ioHT])):w2,
                 ' ',    rgettag(tagMConInd[hrHT]) :w3:d3,
                 ' ','-'                           :w4);
    writeln('D2',' ',str(rgettag(tagSHrmInd[hrDD])):w1,
                 ' ','-'                           :w2,
                 ' ',    rgettag(tagMConInd[hrDD]) :w3:d3,
                 ' ',    rgettag(tagAConInd[atDD]) :w4:d4);
    writeln('DT',' ',str(rgettag(tagSHrmInd[hrDT])):w1,
                 ' ',str(rgettag(tagSIonInd[ioDT])):w2,
                 ' ',    rgettag(tagMConInd[hrDT]) :w3:d3,
                 ' ','-'                           :w4);
    writeln('T2',' ',str(rgettag(tagSHrmInd[hrTT])):w1,
                 ' ',str(rgettag(tagSIonInd[ioTT])):w2,
                 ' ',    rgettag(tagMConInd[hrTT]) :w3:d3,
                 ' ',    rgettag(tagAConInd[atTT]) :w4:d4);
    Main:=-1;
    for i:=ioHT to ioTT do if igettag(tagNIonBtn[i])>0 then Main:=i;
    if Main=ioHT then writeln('Normalization : peak HT') else
    if Main=ioDT then writeln('Normalization : peak DT') else
    if Main=ioTT then writeln('Normalization : peak T2') else writeln('Normalization : not used');
    writeln('**********************************************************************');
    writeln('');
    if ioresult<>0 then b:=fixerror(errorcode);
    {if rewrite('')<>0 then b:=fixerror(errorcode);}
   end else begin
    b:=fixerror(errorcode);
   end;
  end;
  year:='';
  month:='';
  day:='';
  hour:='';
  minut:='';
  sec:='';
  fname:='';
 end;
 {
 Clear all tags
 }
 procedure ClearHandler;
 begin
  b:=isettag(tagCalcBtn,0);
  b:=isettag(tagSaveBtn,0);
  b:=rsettag(tagSaveInd,0);
  b:=isettag(tagClearBtn,0);
  for i:=hrHH to hrTT do begin
   b:=isettag(tagSHrmBtn[i],0);
   b:=rsettag(tagSHrmInd[i],0);
   v:=devmsg('&'+nametag(tagSHrmInd[i])+' constvalue=0');
   b:=rsettag(tagMConInd[i],0);
  end;
  for i:=ioHT to ioTT do begin
   b:=isettag(tagSIonBtn[i],0);
   b:=rsettag(tagSIonInd[i],0);
   v:=devmsg('&'+nametag(tagSIonInd[i])+' constvalue=0');
   b:=isettag(tagNIonBtn[i],0);
  end; 
  for i:=atHH to atTT do begin
   b:=rsettag(tagAConInd[i],0);
  end; 
 end;
 {
 Procedure to initialize and test tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 {
 Start actions
 }
 if runcount=1 then begin
  errors:=0;
  errorcode:=registererr('ERROR IN HDT_CTRL.PAS');
  if reset('')<>0 then errorfound;
  if rewrite('')<>0 then errorfound;
  {
  Initialize constant arrays
  }
  HrmName[hrHH]:='HH';
  HrmName[hrHD]:='HD';
  HrmName[hrHT]:='HT';
  HrmName[hrDD]:='DD';
  HrmName[hrDT]:='DT';
  HrmName[hrTT]:='TT';
  IonName[ioHT]:='HT';
  IonName[ioDT]:='DT';
  IonName[ioTT]:='TT';
  AtmName[atHH]:='HH';
  AtmName[atDD]:='DD';
  AtmName[atTT]:='TT';
  Ion2Hrm[ioHT]:=hrHT;
  Ion2Hrm[ioDT]:=hrDT;
  Ion2Hrm[ioTT]:=hrTT;
  IonCoef[ioHT]:=0.5;
  IonCoef[ioDT]:=0.5;
  IonCoef[ioTT]:=1.0;
  Atm2Hrm[atHH]:=hrHH;
  Atm2Hrm[atDD]:=hrDD;
  Atm2Hrm[atTT]:=hrTT;
  {
  read & check tags
  }
  InitTag( tagCalcBtn,   'HDT.CALC.BTN',  1);
  InitTag( tagSaveBtn,   'HDT.SAVE.BTN',  1);
  InitTag( tagSaveInd,   'HDT.SAVE.IND',  2);
  InitTag( tagClearBtn,  'HDT.CLEAR.BTN', 1);
  for i:=hrHH to hrTT do begin
   InitTag( tagSHrmBtn[i],  'HDT.'+HrmName[i]+'.SHRM.BTN', 1);
   InitTag( tagSHrmInd[i],  'HDT.'+HrmName[i]+'.SHRM.IND', 2);
   InitTag( tagCHrmInd[i],  'HDT.'+HrmName[i]+'.CHRM.IND', 2);
   InitTag( tagMConInd[i],  'HDT.'+HrmName[i]+'.MCON.IND', 2);
  end;
  for i:=ioHT to ioTT do begin
   InitTag( tagSIonBtn[i],  'HDT.'+IonName[i]+'.SION.BTN', 1);
   InitTag( tagSIonInd[i],  'HDT.'+IonName[i]+'.SION.IND', 2);
   InitTag( tagNIonBtn[i],  'HDT.'+IonName[i]+'.NION.BTN', 1);
  end; 
  for i:=atHH to atTT do begin
   InitTag( tagAConInd[i],  'HDT.'+AtmName[i]+'.ACON.IND', 2);
  end;
  ClearHandler;
  {
  Is it Ok?
  }
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Stop actions
 }
 if isinf(runcount) then begin
  errors:=0;
  if reset('')<>0 then errorfound;
  if rewrite('')<>0 then errorfound;
  for i:=hrHH to hrTT do HrmName[i]:='';
  for i:=ioHT to ioTT do IonName[i]:='';
  for i:=atHH to atTT do AtmName[i]:='';
  ClearHandler;
  if errors<>0 then b:=fixerror(errorcode);
 end else 
 {
 Main loop actions
 }
 if Ok then begin
  {
  Action on CALC click
  }
  if igettag(tagCalcBtn)>0 then begin
   b:=isettag(tagCalcBtn,0);
   CalcHandler;
  end;
  {
  Action on SAVE click
  }
  if igettag(tagSaveBtn)>0 then begin
   b:=isettag(tagSaveBtn,0);
   SaveHandler;
  end;
  {
  Action on CLEAR click
  }
  if igettag(tagClearBtn)>0 then begin
   b:=isettag(tagClearBtn,0);
   ClearHandler;
  end;
  {
  User interface handling
  }
  if clickbutton=1 then begin
   {
   Click CALC,SAVE,CLEAR...
   }
   if (clicktag=tagCalcBtn)
   or (clicktag=tagSaveBtn)
   or (clicktag=tagClearBtn)
   then begin
    b:=isettag(clicktag,ord(igettag(clicktag)=0));
    b:=voice(SndClick);
   end;
   {
   Click HDT.xx.SHRM.BTN, xx=HH,HD,HT,DD,DT,TT
   }
   for i:=hrHH to hrTT do
   if clicktag=tagSHrmBtn[i] then begin
    if igettag(tagSHrmBtn[i])>0 then v:=0 else v:=global('int_mean');
    v:=devmsg('&'+nametag(tagSHrmInd[i])+' constvalue='+str(v));
    b:=isettag(clicktag,ord(igettag(clicktag)=0));
   end;
   {
   Click HDT.xx.SION.BTN, xx=HT,DT,TT
   }
   for i:=ioHT to ioTT do
   if clicktag=tagSIonBtn[i] then begin
    if igettag(tagSIonBtn[i])>0 then v:=0 else v:=global('int_mean');
    v:=devmsg('&'+nametag(tagSIonInd[i])+' constvalue='+str(v));
    b:=isettag(clicktag,ord(igettag(clicktag)=0));
   end;
   {
   Click HDT.xx.NION.BTN, xx=HT,DT,TT
   }
   for i:=ioHT to ioTT do
   if clicktag=tagNIonBtn[i] then begin
    for j:=ioHT to ioTT do if i<>j then b:=isettag(tagNIonBtn[j],0);
    b:=isettag(clicktag,ord(igettag(clicktag)=0));
   end;
  end;
 end;
end.
