 {
 Стандартная программа для сглаживания данных.
 Берет кривые с аналоговых входов, передает на выходы сглаженные
 данные. Введена задержка, чтобы сглаживание было устойчивым.
 Рекомендуется делать Delay равным окну smoothing.
 Во избежание артефактов длина истории входных данных должна быть
 достаточной для вмещения данных предыстории, равной ширине окна
 + задержка. Артефакт заключается в появлении разрывов в момент 
 чистки истории входных кривых.
 [DeviceList]
 &SMOOTWD.EXAMPLE = device software program
 [&SMOOTWD.EXAMPLE]
 Comment = Сглаживание с задержкой
 InquiryPeriod = 50
 AnalogInputs = 2
 AnalogOutputs = 2
 Delay#0 = 0.1
 Delay#1 = 0.1
 Link AnalogInput  0  with curve С1 smoothing 0.1 -1 2 2
 Link AnalogInput  1  with curve С2 smoothing 0.1 -1 2 2
 Link AnalogOutput 0  with curve S1 tolerance 0 0.001 history 2000
 Link AnalogOutput 1  with curve S2 tolerance 0 0.001 history 2000
 ProgramSource = ..\daqpas\_smootwd.pas
 }
program _smootwd; { SMOOThing With Delay}
const
 nmax      =  127;
var
 b         : boolean;
 Ok        : boolean;
 errors    : integer;
 errorcode : integer;
 i         : integer;
 n         : integer;
 x         : real;
 delay     : array[0..nmax] of real;
 lastx     : array[0..nmax] of real;
 s         : string;
begin
 {
 Действия при старте программы
 }
 if runcount=1 then begin
  {}
  errors:=0;
  errorcode:=registererr('Ошибка _smootwd.pas');
  s:='';
  for i:=0 to nmax do delay[i]:=0;
  for i:=0 to nmax do lastx[i]:=0;
  {}
  n:=numaos-1;
  if n>nmax then n:=nmax;
  {}
  for i:=0 to n do begin
   s:=readini('Delay#'+str(i));
   if s='' then delay[i]:=0 else delay[i]:=rval(s);
   if isnan(delay[i]) then errors:=errors+1;
  end;
  s:='';
  {}
  if errors>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 if isinf(runcount) then begin
  s:='';
  for i:=0 to nmax do delay[i]:=0;
  for i:=0 to nmax do lastx[i]:=0;
 end else
 {
 Основной цикл
 }
 if Ok then begin
  for i:=0 to n do begin
   if getai_n(i)>0 then begin
    x:=getai_xn(i)-delay[i];
    if (x>0) and (x<>lastx[i]) then begin
     lastx[i]:=x;
     b:=putao(i,x,getai(i,x));
    end;
   end;
  end;
 end;
end.
