 {
 ***********************************************************************
 DEMO_PYCON main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @MenuToolsOpen - open Menu Tools dialog.
|********************************************************
[]
 }
program demo_pycon_main_ctrl;    { DEMO_PYCON main control program  }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_StdPyApp}              { <-- Standard Python Application  }
 SmilePeriod = 1000;             { Polling period for smile face    }
 AwakePeriod = 100;              { Period of checks to awake DatSrv }
 ao_wave_sin = 0;                { AnalogOutput - sin               }
 ao_wave_cos = 1;                { AnalogOutput - cos               }
 ao_pollrate = 2;                { AnalogOutput - pollrate          }
 ao_pingtime = 3;                { AnalogOutput - pingtime          }
 ao_ram_rss  = 4;                { AnalogOutput - RAM RSS           }
 ao_ram_vms  = 5;                { AnalogOutput - RAM VMS           }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 TDEMO_PYCONMainRec = record     { Main control & GUI               }
  CMD    : record                { Commands to control GUI          }
   OPEN  : TTagRef;              { Open DAT file(s)                 }
   SAVE  : TTagRef;              { Save DAT file(s)                 }
   SOUND : TTagRef;              { Sound menu                       }
   SMILE : TTagRef;              { Smile menu                       }
   CLOSE : TTagRef;              { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;                            {                                  }
 TDEMO_PYCONWaveRec = record     { Wave simulator                   }
  STARTED   : TTagRef;           {                                  }
  FREQUENCY : TTagRef;           {                                  }
  AMPLITUDE : TTagRef;           {                                  }
  NOISE     : TTagRef;           {                                  }
  SIN       : TTagRef;           {                                  }
  COS       : TTagRef;           {                                  }
 end;                            {                                  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_StdPyApp}              { <-- Standard Python Application  }
 DEMO_PYCON  : record            { All DEMO_PYCON data              }
  MAIN       : TDEMO_PYCONMainRec; { Main control & GUI             }
  WAVE       : TDEMO_PYCONWaveRec; { Wave simulator                 }
  AwokeTime  : Real;             { Time when DatSrv last awoke      }
  DatSrvGate : TTagRef;          { Save data to DatSrv              }
 end;                            {                                  }
 cmd_Help          : Integer;    { @Help                            }
 cmd_Exit          : Integer;    { @Exit                            }
 cmd_MenuToolsOpen : Integer;    { @MenuToolsOpen                   }
 PollRate,PingTime : Real;       {                                  }
 RamRss,RamVms     : Real;       {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_StdPyApp}              { <-- Standard Python Application  }


 {
 Send parameters to PyApp.
 }
 procedure SendParaToPyApp(Sure:Boolean);
 var a,f,n:Real;
 begin
  a:=rGetTag(DEMO_PYCON.WAVE.AMPLITUDE.tag);
  f:=rGetTag(DEMO_PYCON.WAVE.FREQUENCY.tag);
  n:=rGetTag(DEMO_PYCON.WAVE.NOISE.tag);
  if ShouldRefresh(DEMO_PYCON.WAVE.AMPLITUDE.val,a)
    +ShouldRefresh(DEMO_PYCON.WAVE.FREQUENCY.val,f)
    +ShouldRefresh(DEMO_PYCON.WAVE.NOISE.val,n)>0
  then Sure:=True;
  if Sure then DevPostCmdLocal('@PyAsk @Para '+Str(a)+' '+Str(f)+' '+Str(n));
 end;
 {
 Update PollRate and PingTime.
 }
 procedure UpdatePollRatePingTime;
 var ramfact:Real;
 begin
  ramfact:=1.0/1024/1024;
  if ShouldRefresh(PollRate,StdPyApp.PollRate)>0 then UpdateAo(ao_pollrate,time,PollRate);
  if ShouldRefresh(PingTime,StdPyApp.PingTime)>0 then UpdateAo(ao_pingtime,time,PingTime);
  if ShouldRefresh(RamRss,StdPyApp.RamRss)>0 then UpdateAo(ao_ram_rss,time,RamRss*ramfact);
  if ShouldRefresh(RamVms,StdPyApp.RamVms)>0 then UpdateAo(ao_ram_vms,time,RamVms*ramfact);
  if SysTimer_Pulse(5000)>0 then begin RamRss:=-1; RamVms:=-1; end;
 end;
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Initilize DEMO_PYCON.MAIN record tags
 }
 procedure TDEMO_PYCONMainRec_Init(var Rec:TDEMO_PYCONMainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.OPEN.tag,  TagPrefix+'.CMD.OPEN',  1);
   InitTag(Rec.CMD.SAVE.tag,  TagPrefix+'.CMD.SAVE',  1);
   InitTag(Rec.CMD.SOUND.tag, TagPrefix+'.CMD.SOUND', 1);
   InitTag(Rec.CMD.SMILE.tag, TagPrefix+'.CMD.SMILE', 1);
   InitTag(Rec.CMD.CLOSE.tag, TagPrefix+'.CMD.CLOSE', 1);
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Initilize DEMO_PYCON.WAVE record tags
 }
 procedure TDEMO_PYCONWaveRec_Init(var Rec:TDEMO_PYCONWaveRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.STARTED.tag,   TagPrefix+'.STARTED',   1);
   InitTag(Rec.FREQUENCY.tag, TagPrefix+'.FREQUENCY', 2);
   InitTag(Rec.AMPLITUDE.tag, TagPrefix+'.AMPLITUDE', 2);
   InitTag(Rec.NOISE.tag,     TagPrefix+'.NOISE',     2);
   InitTag(Rec.SIN.tag,       TagPrefix+'.SIN',       2);
   InitTag(Rec.COS.tag,       TagPrefix+'.COS',       2);
   Rec.STARTED.val:=MaxReal;
   Rec.FREQUENCY.val:=MaxReal;
   Rec.AMPLITUDE.val:=MaxReal;
   Rec.NOISE.val:=MaxReal;
   Rec.SIN.val:=0;
   Rec.COS.val:=0;
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then ShowTooltip('guid '+Str(getpid)+'@'+ProgName+' text "'+s+'" preset stdHelp delay 15000'
                                 +' btn1 Справка cmd1 "unix getapppath firefox firefox.exe -t htmlfile -t text/html -a .html --run '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm')+'"');
 end;
 {
 Menu CLOSE Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@SysEval @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 530 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu CLOSE Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Menu TOOLS Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu TOOLS Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  DEMO_PYCON.AwokeTime:=mSecNow;
  DevPostCmd(devDatSrv,'  ');
 end;
 {
 DEMO_PYCON clear strings
 }
 procedure DEMO_PYCON_CLEAR;
 begin
 end;
 {
 DEMO_PYCON initialization
 }
 procedure DEMO_PYCON_INIT;
 begin
  //
  // Initialize tags & devices...
  //
  TDEMO_PYCONMainRec_Init(DEMO_PYCON.MAIN,ReadIni('tagDEMO_PYCON')+'.MAIN');
  TDEMO_PYCONWaveRec_Init(DEMO_PYCON.WAVE,ReadIni('tagDEMO_PYCON')+'.WAVE');
  InitTag(DEMO_PYCON.DatSrvGate.tag,'DATSRV.GATE',-1);
  //
  // Initialize values...
  //
  DEMO_PYCON.AwokeTime:=0;
 end;
 {
 DEMO_PYCON finalization
 }
 procedure DEMO_PYCON_FREE;
 begin
 end;
 {
 DEMO_PYCON polling
 }
 procedure DEMO_PYCON_POLL;
 var s:String; ClickCurve:Integer; nerrors,t:Real;
  procedure Cleanup;
  begin
   s:=''; ClickCurve:=0;
  end;
 begin
  Cleanup;
  {
  Send "@PyAsk @Wave t" to PyApp server to generate Wave.
  Then update parameters if needed.
  }
  if iGetTag(DEMO_PYCON.WAVE.STARTED.tag)<>0 then begin
   t:=time*timeunits*1e-3; // Time in seconds
   DevPostCmdLocal('@PyAsk @Wave '+Str(t));
  end;
  SendParaToPyApp(False);
  UpdatePollRatePingTime;
  {
  Awake DatSrv to enforce data save.
  }
  if (SysTimer_Pulse(AwakePeriod)>0) then bNul(iSetTag(DEMO_PYCON.DatSrvGate.tag,Ord(iGetTag(DEMO_PYCON.MAIN.CMD.SAVE.tag)<>0)));
  {
  Execute GUI commands
  }
  if (iGetTag(DEMO_PYCON.MAIN.CMD.OPEN.tag)<>0) then begin
   Cron('@FileOpenDialog '+URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.dat;*.crw'));
   bNul(iSetTag(DEMO_PYCON.MAIN.CMD.OPEN.tag,0));
  end;
  if (iGetTag(DEMO_PYCON.MAIN.CMD.CLOSE.tag)<>0) then begin
   bNul(iSetTag(DEMO_PYCON.MAIN.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Handle Smile button state
  }
  if (SysTimer_Pulse(SmilePeriod)>0) then begin
   nerrors:=GetErrCount(-2);
   if nerrors>DEMO_PYCON.MAIN.CMD.SMILE.val then bNul(iSetTag(DEMO_PYCON.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(DEMO_PYCON.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(DEMO_PYCON.MAIN.CMD.SMILE.tag,1));
   DEMO_PYCON.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Menu CLOSE.
   }
   MenuCloseHandler;
   {
   Menu TOOLS.
   }
   MenuToolsHandler;
   {
   Warning, Information dialog completion.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   {
   Accept edit tags.
   }
   CheckEditTagUpdate(DEMO_PYCON.WAVE.AMPLITUDE.tag,-100,100);
   CheckEditTagUpdate(DEMO_PYCON.WAVE.FREQUENCY.tag,1e-6,100);
   CheckEditTagUpdate(DEMO_PYCON.WAVE.NOISE.tag,-100,100);
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Toolbar buttons...
     //
     ClickBitXorLocal(DEMO_PYCON.MAIN.CMD.OPEN.tag,1);
     ClickBitXorLocal(DEMO_PYCON.MAIN.CMD.SAVE.tag,1);
     ClickBitXorLocal(DEMO_PYCON.MAIN.CMD.SOUND.tag,1);
     ClickBitXorLocal(DEMO_PYCON.MAIN.CMD.CLOSE.tag,1);
     if (ClickTag=DEMO_PYCON.MAIN.CMD.SAVE.tag) then begin
      bNul(iSetTag(DEMO_PYCON.DatSrvGate.tag,Ord(iGetTag(DEMO_PYCON.MAIN.CMD.SAVE.tag)<>0)));
      if iGetTag(DEMO_PYCON.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
     end;
     if IsSameText(ClickSensor,'DEMO_PYCON.MAIN.CMD.HOME') then begin
      DevPostCmdLocal('@Cron @Cron.Run DEMO_PYCON.MAIN.CTRL.HOME');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'DEMO_PYCON.MAIN.CMD.HELP') then begin
      DevPostCmdLocal('@BrowseHelp');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'DEMO_PYCON.MAIN.CMD.TOOLS') then begin
      DevPostCmdLocal('@MenuToolsOpen');
      bNul(Voice(snd_Click));
     end;
     ClickBitXorLocal(DEMO_PYCON.WAVE.STARTED.tag,1);
     //
     // Start edit tags...
     //
     if (ClickTag=DEMO_PYCON.WAVE.AMPLITUDE.tag) then begin
      StartEditTag(ClickTag,'Wave Amplitude');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_PYCON.WAVE.FREQUENCY.tag) then begin
      StartEditTag(ClickTag,'Wave Frequency, Hz');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_PYCON.WAVE.NOISE.tag) then begin
      StartEditTag(ClickTag,'Wave Noise');
      bNul(Voice(snd_Click));
     end;     //
     // Smile face button...
     //
     if (ClickTag=DEMO_PYCON.MAIN.CMD.SMILE.tag) then begin
      bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      bNul(iSetTag(DEMO_PYCON.MAIN.CMD.SMILE.tag,0));
      bNul(Voice(snd_Click));
     end;
     //
     // Select Plot & Tab windows by curve...
     //
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     //
     // Console commands: @url_encoded_sensor ...
     //
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Calibrations
     //
     if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
      bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
      bNul(Voice(snd_Click));
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  Cleanup;
 end;
 {
 StdPyApp - User specific Hook for StdIn commands.
 Handle only @PyAns, @PyInf for Application specific stuff.
 }
 function StdPyApp_UserHookStdIn(var Data:String):Boolean;
 var cmd,arg:String; cmdid:Integer; Hook:Boolean; ts,tm,si,co:Real;
 begin
  cmd:=''; arg:='';
  Hook:=False; cmdid:=0;
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   if (cmdid=cmd_Std_PyAns) then begin
    if IsSameText(ExtractWord(1,arg),'@Para') then begin
     Success(arg);
     Hook:=True;
    end;
    if IsSameText(ExtractWord(1,arg),'@Wave') then begin
     ts:=rVal(ExtractWord(2,arg));
     si:=rVal(ExtractWord(3,arg));
     co:=rVal(ExtractWord(4,arg));
     tm:=1e3*ts/timeunits;
     UpdateAo(ao_wave_sin,tm,si);
     UpdateAo(ao_wave_cos,tm,co);
     Hook:=True;
    end;
   end else
   if (cmdid=cmd_Std_PyInf) then begin
    // On (started,stopped) show tooltip
    // After start send parameters to server
    if WordIndex(ExtractWord(1,arg),'Started,Stopped')>0 then begin
     if IsSameText(ExtractWord(1,arg),'Started') then begin
      SendParaToPyApp(True);
     end;
     ShowTooltip('text "PyApp: '+arg+'" preset stdNotify delay 15000');
     Success('PyApp: '+arg);
     Hook:=True;
    end;
   end;
  end;
  StdPyApp_UserHookStdIn:=Hook;
  cmd:=''; arg:='';
 end;
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearStdPyApp;
  DEMO_PYCON_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('@StartupScript','@FinallyScript');
  StdIn_SetTimeouts(1000,1000,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitStdPyApp;
  DEMO_PYCON_INIT;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmdLocal('@LoadIni');
  cmd_Help          := RegisterStdInCmd('@Help',          '');
  cmd_Exit          := RegisterStdInCmd('@Exit',          '');
  cmd_MenuToolsOpen := RegisterStdInCmd('@MenuToolsOpen', '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then DevPostCmdLocal('@SaveIni');
  DEMO_PYCON_FREE;
  FreeStdPyApp;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  DEMO_PYCON_POLL;
  PollStdPyApp;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
  procedure Cleanup;
  begin
   cmd:=''; arg:='';
  end;
 begin
  Cleanup;
  ViewImp('CON: '+Data);
  {
  User PyApp Hook to handle:
  @PyApp Start
  @PyAsk @PollCount
  @PyAns @PollCount 123
  @PyInf Started ...
  }
  if StdPyApp_UserHookStdIn(Data) then begin
   Data:=''; // Data was hooked and handled
  end else
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @MenuToolsOpen
   }
   if (cmdid=cmd_MenuToolsOpen) then begin
    MenuToolsStarter;
    Data:='';
   end else
   {
   Default PyApp Hook to handle:
   @PyApp Start
   @PyAsk @PollCount
   @PyAns @PollCount 123
   @PyInf Started ...
   }
   if StdPyApp_DefaultHookStdIn(Data) then begin
    Data:=''; // Data was hooked and handled
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  Cleanup;
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
