 {
 ***********************************************************************
 Daq Pascal application program PID_PULSE.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Demo ex1 ex2  - Evaluate 2 expressions, just for demo.
|********************************************************
[]
 }
program PID_PULSE;
const
 ai_pid_0 = 0;
 do_pid_0 = 0;
 do_pid_6 = 6;
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }

type
 TTagRef = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 PID           : record          { Система ПИД                      }
  CTRL         : record          { Подсистема, реализующая ПИД закон}
   PER         : TTagRef;        { Период ШИМ генератора            }
   ENB         : TTagRef;        { Режим работы регулятора Вкл/Выкл }
  end;
  PidOut       : Real;           { Выход регулятора(скважность)     }
  PulserState  : Real;           { ШИМ сигнал                       }
  PulserTStart : Real;           { Время старта импульсов           }
  PULSE        : record          { Подсистема, реализующая ШИМ      }
   BLK         : TTagRef;        { Сигнал блокировки                }
  end;
 end;
 blk           : Boolean;
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Чтение аналоговых/дискретных входов
 }
 procedure ReadAiDiState;
  {
  Чтение аналоговых входов
  }
  procedure ReadAiState;
  var Crv:Integer;
  begin
   if NumAis<>0 then begin
    Crv:=RefAi(ai_pid_0);
    if IsRefCurve(Crv) then PID.PidOut:=crvGetLastY(Crv);
   end;
  end;
 begin
  ReadAiState;
 end;
 //
 // Генератор, формирующий ШИМ сигнал,скважность определяется ПИД регулятором
 //
 procedure LogicControl;
 var PulserPower,PulserDelta:Real;
 begin
  if RefDo(do_pid_0)>0 then begin
   blk:=iGetTag(PID.PULSE.BLK.tag)>0;
   PulserPower:=Max(0,Min(100,Ord(not blk)*(PID.PidOut)*Ord(iGetTag(PID.CTRL.ENB.tag)>0)));
   PulserDelta:=(mSecNow-PID.PulserTStart)/rGetTag(PID.CTRL.PER.tag);
   PID.PulserState:=Ord((PulserPower>0) and (Frac(PulserDelta)*100<=PulserPower));
   if Int(PulserDelta)>1000 then PID.PulserTStart:=PID.PulserTStart+Int(PulserDelta)*rGetTag(PID.CTRL.PER.tag);
  end;
 end;
 {
 Запись аналоговых/дискретных выходов
 }
 procedure WriteAoDoState;
  {
  Запись дискретных выходов
  }
  procedure WriteDoState;
  begin
   UpdateDo(do_pid_0,time,PID.PulserState);
   UpdateDo(do_pid_6,time,Ord(blk));
  end;
 begin
  WriteDoState;
 end;
 {
 Tags initialization
 }
 procedure Init_PID(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(PID.CTRL.PER.tag,  Prefix+'.CTRL.PER',  2);
   InitTag(PID.CTRL.ENB.tag,  Prefix+'.CTRL.ENB',  1);
   InitTag(PID.PULSE.BLK.tag, Prefix+'.PULSE.BLK', 1);
  end;
  {
  Initialization values
  }
  PID.PulserTStart:=mSecNow;
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var ClickCurve:Integer;
 begin
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle sensor clicks...
     }
     if IsSameText(ClickSensor,'HELP') then begin
      Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
      bNul(Voice(snd_Click));
     end;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Warning, Information dialog completion.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Uncompleted edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  Init_PID(ReadIni('tagPID'));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  ReadAiDiState;
  GUIHandler;
  LogicControl;
  WriteAoDoState;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{<== Please never change this code ***}
{***************************************************}